/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.common;

import io.camunda.zeebe.el.Expression;
import io.camunda.zeebe.engine.processing.bpmn.BpmnElementContext;
import io.camunda.zeebe.engine.processing.common.ExpressionProcessor;
import io.camunda.zeebe.engine.processing.common.Failure;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableCatchEvent;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableCatchEventSupplier;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableMessage;
import io.camunda.zeebe.engine.processing.message.MessageCorrelationKeyException;
import io.camunda.zeebe.engine.processing.message.MessageNameException;
import io.camunda.zeebe.engine.processing.message.command.SubscriptionCommandSender;
import io.camunda.zeebe.engine.processing.streamprocessor.MigratedStreamProcessors;
import io.camunda.zeebe.engine.processing.streamprocessor.sideeffect.SideEffects;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedCommandWriter;
import io.camunda.zeebe.engine.processing.timer.DueDateTimerChecker;
import io.camunda.zeebe.engine.state.KeyGenerator;
import io.camunda.zeebe.engine.state.immutable.ProcessMessageSubscriptionState;
import io.camunda.zeebe.engine.state.immutable.TimerInstanceState;
import io.camunda.zeebe.engine.state.instance.TimerInstance;
import io.camunda.zeebe.engine.state.message.ProcessMessageSubscription;
import io.camunda.zeebe.engine.state.mutable.MutableEventScopeInstanceState;
import io.camunda.zeebe.engine.state.mutable.MutableZeebeState;
import io.camunda.zeebe.model.bpmn.util.time.Timer;
import io.camunda.zeebe.protocol.impl.SubscriptionUtil;
import io.camunda.zeebe.protocol.impl.record.value.message.ProcessMessageSubscriptionRecord;
import io.camunda.zeebe.protocol.impl.record.value.timer.TimerRecord;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ProcessMessageSubscriptionIntent;
import io.camunda.zeebe.protocol.record.intent.TimerIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.util.Either;
import io.camunda.zeebe.util.buffer.BufferUtil;
import io.camunda.zeebe.util.sched.clock.ActorClock;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.agrona.DirectBuffer;

public final class CatchEventBehavior {
    private final ExpressionProcessor expressionProcessor;
    private final SubscriptionCommandSender subscriptionCommandSender;
    private final int partitionsCount;
    private final StateWriter stateWriter;
    private final MutableEventScopeInstanceState eventScopeInstanceState;
    private final ProcessMessageSubscriptionState processMessageSubscriptionState;
    private final TimerInstanceState timerInstanceState;
    private final ProcessMessageSubscriptionRecord subscription = new ProcessMessageSubscriptionRecord();
    private final TimerRecord timerRecord = new TimerRecord();
    private final Map<DirectBuffer, DirectBuffer> extractedCorrelationKeys = new HashMap<DirectBuffer, DirectBuffer>();
    private final Map<DirectBuffer, Timer> evaluatedTimers = new HashMap<DirectBuffer, Timer>();
    private final DueDateTimerChecker timerChecker;
    private final KeyGenerator keyGenerator;

    public CatchEventBehavior(MutableZeebeState zeebeState, ExpressionProcessor expressionProcessor, SubscriptionCommandSender subscriptionCommandSender, StateWriter stateWriter, DueDateTimerChecker timerChecker, int partitionsCount) {
        this.expressionProcessor = expressionProcessor;
        this.subscriptionCommandSender = subscriptionCommandSender;
        this.stateWriter = stateWriter;
        this.partitionsCount = partitionsCount;
        this.eventScopeInstanceState = zeebeState.getEventScopeInstanceState();
        this.timerInstanceState = zeebeState.getTimerState();
        this.processMessageSubscriptionState = zeebeState.getProcessMessageSubscriptionState();
        this.keyGenerator = zeebeState.getKeyGenerator();
        this.timerChecker = timerChecker;
    }

    public void unsubscribeFromEvents(BpmnElementContext context, TypedCommandWriter commandWriter, SideEffects sideEffects) {
        this.unsubscribeFromTimerEvents(context, commandWriter);
        this.unsubscribeFromMessageEvents(context, sideEffects);
        if (!MigratedStreamProcessors.isMigrated(context.getBpmnElementType())) {
            this.eventScopeInstanceState.deleteInstance(context.getElementInstanceKey());
        }
    }

    public void subscribeToEvents(BpmnElementContext context, ExecutableCatchEventSupplier supplier, SideEffects sideEffects, TypedCommandWriter commandWriter) throws MessageCorrelationKeyException {
        List<ExecutableCatchEvent> events = supplier.getEvents();
        Map<DirectBuffer, DirectBuffer> extractedMessageNames = this.extractMessageNames(events, context);
        Map<DirectBuffer, DirectBuffer> extractedCorrelationKeys = this.extractMessageCorrelationKeys(events, context);
        Map<DirectBuffer, Timer> evaluatedTimers = this.evaluateTimers(events, context.getElementInstanceKey());
        for (ExecutableCatchEvent event : events) {
            if (event.isTimer()) {
                this.subscribeToTimerEvent(context.getElementInstanceKey(), context.getProcessInstanceKey(), context.getProcessDefinitionKey(), event.getId(), evaluatedTimers.get(event.getId()), commandWriter, sideEffects);
                continue;
            }
            if (!event.isMessage()) continue;
            this.subscribeToMessageEvent(context, event, extractedCorrelationKeys.get(event.getId()), extractedMessageNames.get(event.getId()), sideEffects);
        }
        if (!MigratedStreamProcessors.isMigrated(context.getBpmnElementType()) && !events.isEmpty()) {
            this.eventScopeInstanceState.createIfNotExists(context.getElementInstanceKey(), supplier.getInterruptingElementIds());
        }
    }

    public void subscribeToTimerEvent(long elementInstanceKey, long processInstanceKey, long processDefinitionKey, DirectBuffer handlerNodeId, Timer timer, TypedCommandWriter commandWriter, SideEffects sideEffects) {
        long dueDate = timer.getDueDate(ActorClock.currentTimeMillis());
        this.timerRecord.reset();
        this.timerRecord.setRepetitions(timer.getRepetitions()).setDueDate(dueDate).setElementInstanceKey(elementInstanceKey).setProcessInstanceKey(processInstanceKey).setTargetElementId(handlerNodeId).setProcessDefinitionKey(processDefinitionKey);
        sideEffects.add(() -> {
            this.timerChecker.scheduleTimer(dueDate);
            return true;
        });
        this.stateWriter.appendFollowUpEvent(this.keyGenerator.nextKey(), (Intent)TimerIntent.CREATED, (RecordValue)this.timerRecord);
    }

    private void unsubscribeFromTimerEvents(BpmnElementContext context, TypedCommandWriter commandWriter) {
        this.timerInstanceState.forEachTimerForElementInstance(context.getElementInstanceKey(), t -> this.unsubscribeFromTimerEvent((TimerInstance)((Object)t), commandWriter));
    }

    public void unsubscribeFromTimerEvent(TimerInstance timer, TypedCommandWriter commandWriter) {
        this.timerRecord.reset();
        this.timerRecord.setElementInstanceKey(timer.getElementInstanceKey()).setProcessInstanceKey(timer.getProcessInstanceKey()).setDueDate(timer.getDueDate()).setRepetitions(timer.getRepetitions()).setTargetElementId(timer.getHandlerNodeId()).setProcessDefinitionKey(timer.getProcessDefinitionKey());
        commandWriter.appendFollowUpCommand(timer.getKey(), (Intent)TimerIntent.CANCEL, (RecordValue)this.timerRecord);
    }

    private void subscribeToMessageEvent(BpmnElementContext context, ExecutableCatchEvent catchEvent, DirectBuffer correlationKey, DirectBuffer messageName, SideEffects sideEffects) {
        long processInstanceKey = context.getProcessInstanceKey();
        DirectBuffer bpmnProcessId = BufferUtil.cloneBuffer((DirectBuffer)context.getBpmnProcessId());
        long elementInstanceKey = context.getElementInstanceKey();
        int subscriptionPartitionId = SubscriptionUtil.getSubscriptionPartitionId((DirectBuffer)correlationKey, (int)this.partitionsCount);
        this.subscription.setSubscriptionPartitionId(subscriptionPartitionId);
        this.subscription.setMessageName(messageName);
        this.subscription.setElementInstanceKey(elementInstanceKey);
        this.subscription.setProcessInstanceKey(processInstanceKey);
        this.subscription.setBpmnProcessId(bpmnProcessId);
        this.subscription.setCorrelationKey(correlationKey);
        this.subscription.setElementId(catchEvent.getId());
        this.subscription.setInterrupting(catchEvent.isInterrupting());
        long subscriptionKey = this.keyGenerator.nextKey();
        this.stateWriter.appendFollowUpEvent(subscriptionKey, (Intent)ProcessMessageSubscriptionIntent.CREATING, (RecordValue)this.subscription);
        sideEffects.add(() -> this.sendOpenMessageSubscription(subscriptionPartitionId, processInstanceKey, elementInstanceKey, bpmnProcessId, messageName, correlationKey, catchEvent.isInterrupting()));
    }

    private void unsubscribeFromMessageEvents(BpmnElementContext context, SideEffects sideEffects) {
        this.processMessageSubscriptionState.visitElementSubscriptions(context.getElementInstanceKey(), subscription -> this.unsubscribeFromMessageEvent(subscription, sideEffects));
    }

    private boolean unsubscribeFromMessageEvent(ProcessMessageSubscription subscription, SideEffects sideEffects) {
        DirectBuffer messageName = BufferUtil.cloneBuffer((DirectBuffer)subscription.getRecord().getMessageNameBuffer());
        int subscriptionPartitionId = subscription.getRecord().getSubscriptionPartitionId();
        long processInstanceKey = subscription.getRecord().getProcessInstanceKey();
        long elementInstanceKey = subscription.getRecord().getElementInstanceKey();
        this.stateWriter.appendFollowUpEvent(subscription.getKey(), (Intent)ProcessMessageSubscriptionIntent.DELETING, (RecordValue)subscription.getRecord());
        sideEffects.add(() -> this.sendCloseMessageSubscriptionCommand(subscriptionPartitionId, processInstanceKey, elementInstanceKey, messageName));
        return true;
    }

    private String extractCorrelationKey(ExecutableMessage message, long variableScopeKey) {
        Expression correlationKeyExpression = message.getCorrelationKeyExpression();
        return this.expressionProcessor.evaluateMessageCorrelationKeyExpression(correlationKeyExpression, variableScopeKey);
    }

    private Either<Failure, String> extractMessageName(ExecutableMessage message, long scopeKey) {
        Expression messageNameExpression = message.getMessageNameExpression();
        return this.expressionProcessor.evaluateStringExpression(messageNameExpression, scopeKey);
    }

    private boolean sendCloseMessageSubscriptionCommand(int subscriptionPartitionId, long processInstanceKey, long elementInstanceKey, DirectBuffer messageName) {
        return this.subscriptionCommandSender.closeMessageSubscription(subscriptionPartitionId, processInstanceKey, elementInstanceKey, messageName);
    }

    private boolean sendOpenMessageSubscription(int subscriptionPartitionId, long processInstanceKey, long elementInstanceKey, DirectBuffer bpmnProcessId, DirectBuffer messageName, DirectBuffer correlationKey, boolean closeOnCorrelate) {
        return this.subscriptionCommandSender.openMessageSubscription(subscriptionPartitionId, processInstanceKey, elementInstanceKey, bpmnProcessId, messageName, correlationKey, closeOnCorrelate);
    }

    private Map<DirectBuffer, DirectBuffer> extractMessageCorrelationKeys(List<ExecutableCatchEvent> events, BpmnElementContext context) {
        this.extractedCorrelationKeys.clear();
        for (ExecutableCatchEvent event : events) {
            if (!event.isMessage()) continue;
            long variableScopeKey = event.getElementType() == BpmnElementType.BOUNDARY_EVENT ? context.getFlowScopeKey() : context.getElementInstanceKey();
            String correlationKey = this.extractCorrelationKey(event.getMessage(), variableScopeKey);
            this.extractedCorrelationKeys.put(event.getId(), BufferUtil.wrapString((String)correlationKey));
        }
        return this.extractedCorrelationKeys;
    }

    private Map<DirectBuffer, Timer> evaluateTimers(List<ExecutableCatchEvent> events, long key) {
        this.evaluatedTimers.clear();
        for (ExecutableCatchEvent event : events) {
            if (!event.isTimer()) continue;
            Either<Failure, Timer> timerOrError = event.getTimerFactory().apply(this.expressionProcessor, key);
            if (timerOrError.isLeft()) {
                throw new ExpressionProcessor.EvaluationException(((Failure)timerOrError.getLeft()).getMessage());
            }
            this.evaluatedTimers.put(event.getId(), (Timer)timerOrError.get());
        }
        return this.evaluatedTimers;
    }

    private Map<DirectBuffer, DirectBuffer> extractMessageNames(List<ExecutableCatchEvent> events, BpmnElementContext context) {
        HashMap<DirectBuffer, DirectBuffer> extractedMessageNames = new HashMap<DirectBuffer, DirectBuffer>();
        long scopeKey = context.getElementInstanceKey();
        for (ExecutableCatchEvent event : events) {
            if (!event.isMessage()) continue;
            Either<Failure, String> messageNameOrFailure = this.extractMessageName(event.getMessage(), scopeKey);
            messageNameOrFailure.ifRightOrLeft(messageName -> extractedMessageNames.put(event.getId(), BufferUtil.wrapString((String)messageName)), failure -> {
                throw new MessageNameException((Failure)failure, event.getId());
            });
        }
        return extractedMessageNames;
    }
}

