/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.common;

import io.camunda.zeebe.engine.processing.bpmn.BpmnElementContext;
import io.camunda.zeebe.engine.processing.bpmn.BpmnElementContextImpl;
import io.camunda.zeebe.engine.processing.bpmn.BpmnProcessingException;
import io.camunda.zeebe.engine.processing.bpmn.ProcessInstanceLifecycle;
import io.camunda.zeebe.engine.processing.common.CatchEventBehavior;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableFlowElement;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableStartEvent;
import io.camunda.zeebe.engine.processing.streamprocessor.MigratedStreamProcessors;
import io.camunda.zeebe.engine.processing.streamprocessor.sideeffect.SideEffectQueue;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedCommandWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.processing.variable.VariableBehavior;
import io.camunda.zeebe.engine.state.KeyGenerator;
import io.camunda.zeebe.engine.state.instance.ElementInstance;
import io.camunda.zeebe.engine.state.instance.EventTrigger;
import io.camunda.zeebe.engine.state.mutable.MutableElementInstanceState;
import io.camunda.zeebe.engine.state.mutable.MutableEventScopeInstanceState;
import io.camunda.zeebe.engine.state.mutable.MutableZeebeState;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessEventRecord;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ProcessEventIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import java.util.List;
import java.util.stream.Collectors;
import org.agrona.DirectBuffer;

public class EventTriggerBehavior {
    private static final String ERROR_MSG_EXPECTED_START_EVENT = "Expected an start event to be triggered on EventSubProcess scope, but was %s";
    private final ProcessInstanceRecord eventRecord = new ProcessInstanceRecord();
    private final ProcessEventRecord processEventRecord = new ProcessEventRecord();
    private final KeyGenerator keyGenerator;
    private final CatchEventBehavior catchEventBehavior;
    private final TypedCommandWriter commandWriter;
    private final StateWriter stateWriter;
    private final MutableElementInstanceState elementInstanceState;
    private final MutableEventScopeInstanceState eventScopeInstanceState;
    private final VariableBehavior variableBehavior;

    public EventTriggerBehavior(KeyGenerator keyGenerator, CatchEventBehavior catchEventBehavior, Writers writers, MutableZeebeState zeebeState) {
        this.keyGenerator = keyGenerator;
        this.catchEventBehavior = catchEventBehavior;
        this.commandWriter = writers.command();
        this.stateWriter = writers.state();
        this.elementInstanceState = zeebeState.getElementInstanceState();
        this.eventScopeInstanceState = zeebeState.getEventScopeInstanceState();
        this.variableBehavior = new VariableBehavior(zeebeState.getVariableState(), writers.state(), keyGenerator);
    }

    public void unsubscribeFromEvents(BpmnElementContext context) {
        SideEffectQueue sideEffectQueue = new SideEffectQueue();
        this.catchEventBehavior.unsubscribeFromEvents(context, this.commandWriter, sideEffectQueue);
        sideEffectQueue.flush();
    }

    public void triggerEventSubProcess(ExecutableStartEvent startEvent, long flowScopeElementInstanceKey, ProcessInstanceRecord recordValue, DirectBuffer variables) {
        ElementInstance flowScopeElementInstance = this.elementInstanceState.getInstance(flowScopeElementInstanceKey);
        if (flowScopeElementInstance.isInterrupted() && !flowScopeElementInstance.getInterruptingElementId().equals(startEvent.getEventSubProcess())) {
            return;
        }
        BpmnElementContext flowScopeContext = new BpmnElementContextImpl().copy(flowScopeElementInstanceKey, flowScopeElementInstance.getValue(), flowScopeElementInstance.getState());
        EventTrigger eventTrigger = this.eventScopeInstanceState.peekEventTrigger(flowScopeElementInstanceKey);
        if (eventTrigger == null) {
            return;
        }
        if (startEvent.interrupting()) {
            this.unsubscribeFromEvents(flowScopeContext);
            boolean noActiveChildInstances = this.terminateChildInstances(flowScopeContext);
            if (!noActiveChildInstances) {
                return;
            }
        }
        this.activateTriggeredEvent(eventTrigger.getEventKey(), startEvent, flowScopeElementInstanceKey, flowScopeElementInstanceKey, recordValue, variables);
    }

    private boolean terminateChildInstances(BpmnElementContext flowScopeContext) {
        List childInstances = this.elementInstanceState.getChildren(flowScopeContext.getElementInstanceKey()).stream().map(childInstance -> flowScopeContext.copy(childInstance.getKey(), childInstance.getValue(), childInstance.getState())).collect(Collectors.toList());
        for (BpmnElementContext childInstanceContext : childInstances) {
            if (ProcessInstanceLifecycle.canTerminate(childInstanceContext.getIntent())) {
                if (!MigratedStreamProcessors.isMigrated(childInstanceContext.getBpmnElementType())) {
                    this.transitionToTerminating(childInstanceContext);
                    continue;
                }
                this.commandWriter.appendFollowUpCommand(childInstanceContext.getElementInstanceKey(), (Intent)ProcessInstanceIntent.TERMINATE_ELEMENT, (RecordValue)childInstanceContext.getRecordValue());
                continue;
            }
            if (MigratedStreamProcessors.isMigrated(childInstanceContext.getBpmnElementType()) || childInstanceContext.getIntent() != ProcessInstanceIntent.ELEMENT_COMPLETED) continue;
            this.eventScopeInstanceState.deleteInstance(childInstanceContext.getElementInstanceKey());
            this.elementInstanceState.removeInstance(childInstanceContext.getElementInstanceKey());
        }
        ElementInstance elementInstance = this.elementInstanceState.getInstance(flowScopeContext.getElementInstanceKey());
        int activeChildInstances = elementInstance.getNumberOfActiveElementInstances();
        return activeChildInstances == 0;
    }

    public BpmnElementContext transitionToTerminating(BpmnElementContext context) {
        BpmnElementContext transitionedContext = this.transitionTo(context, ProcessInstanceIntent.ELEMENT_TERMINATING);
        if (!MigratedStreamProcessors.isMigrated(context.getBpmnElementType())) {
            this.registerStateTransition(context, ProcessInstanceIntent.ELEMENT_TERMINATING);
        }
        return transitionedContext;
    }

    public void registerStateTransition(BpmnElementContext context, ProcessInstanceIntent newState) {
        switch (newState) {
            case ELEMENT_ACTIVATING: 
            case ELEMENT_ACTIVATED: 
            case ELEMENT_COMPLETING: 
            case ELEMENT_COMPLETED: 
            case ELEMENT_TERMINATING: 
            case ELEMENT_TERMINATED: {
                this.updateElementInstanceState(context, newState);
                break;
            }
        }
    }

    private void updateElementInstanceState(BpmnElementContext context, ProcessInstanceIntent newState) {
        this.elementInstanceState.updateInstance(context.getElementInstanceKey(), elementInstance -> elementInstance.setState(newState));
    }

    private void verifyTransition(BpmnElementContext context, ProcessInstanceIntent transition) {
        if (!ProcessInstanceLifecycle.canTransition(context.getIntent(), transition)) {
            throw new BpmnProcessingException(context, String.format("Expected to take transition to '%s' but element instance is in state '%s'.", transition, context.getIntent()));
        }
    }

    private BpmnElementContext transitionTo(BpmnElementContext context, ProcessInstanceIntent transition) {
        long key = context.getElementInstanceKey();
        ProcessInstanceRecord value = context.getRecordValue();
        if (!MigratedStreamProcessors.isMigrated(context.getBpmnElementType())) {
            this.verifyTransition(context, transition);
            this.stateWriter.appendFollowUpEvent(key, (Intent)transition, (RecordValue)value);
        } else {
            this.stateWriter.appendFollowUpEvent(key, (Intent)transition, (RecordValue)value);
        }
        return context.copy(key, value, transition);
    }

    public long triggeringProcessEvent(long processDefinitionKey, long processInstanceKey, long eventScopeKey, DirectBuffer catchEventId, DirectBuffer variables) {
        long eventKey = this.keyGenerator.nextKey();
        this.processEventRecord.reset();
        this.processEventRecord.setScopeKey(eventScopeKey).setTargetElementIdBuffer(catchEventId).setVariablesBuffer(variables).setProcessDefinitionKey(processDefinitionKey).setProcessInstanceKey(processInstanceKey);
        this.stateWriter.appendFollowUpEvent(eventKey, (Intent)ProcessEventIntent.TRIGGERING, (RecordValue)this.processEventRecord);
        return eventKey;
    }

    public void processEventTriggered(long eventTriggerKey, long processDefinitionKey, long processInstanceKey, long eventScopeKey, DirectBuffer catchEventId) {
        this.processEventRecord.reset();
        this.processEventRecord.setScopeKey(eventScopeKey).setTargetElementIdBuffer(catchEventId).setProcessDefinitionKey(processDefinitionKey).setProcessInstanceKey(processInstanceKey);
        this.stateWriter.appendFollowUpEvent(eventTriggerKey, (Intent)ProcessEventIntent.TRIGGERED, (RecordValue)this.processEventRecord);
    }

    public void activateTriggeredEvent(long processEventKey, ExecutableFlowElement triggeredEvent, long eventScopeKey, long flowScopeKey, ProcessInstanceRecord elementRecord, DirectBuffer variables) {
        this.eventRecord.reset();
        this.eventRecord.wrap(elementRecord);
        this.eventRecord.setFlowScopeKey(flowScopeKey);
        ExecutableFlowElement flowScope = triggeredEvent.getFlowScope();
        if (flowScope == null) {
            throw new IllegalStateException("Expected to activate triggered event, but flow scope is null");
        }
        this.processEventTriggered(processEventKey, elementRecord.getProcessDefinitionKey(), elementRecord.getProcessInstanceKey(), eventScopeKey, triggeredEvent.getId());
        if (flowScope.getElementType() == BpmnElementType.EVENT_SUB_PROCESS && triggeredEvent.getElementType() == BpmnElementType.START_EVENT) {
            this.activateEventSubProcess((ExecutableStartEvent)triggeredEvent, flowScope);
            return;
        }
        this.eventRecord.setBpmnElementType(triggeredEvent.getElementType()).setElementId(triggeredEvent.getId());
        long eventInstanceKey = this.keyGenerator.nextKey();
        this.stateWriter.appendFollowUpEvent(eventInstanceKey, (Intent)ProcessInstanceIntent.ELEMENT_ACTIVATING, (RecordValue)this.eventRecord);
        this.stateWriter.appendFollowUpEvent(eventInstanceKey, (Intent)ProcessInstanceIntent.ELEMENT_ACTIVATED, (RecordValue)this.eventRecord);
        if (variables.capacity() > 0) {
            this.variableBehavior.mergeLocalDocument(eventInstanceKey, elementRecord.getProcessDefinitionKey(), elementRecord.getProcessInstanceKey(), variables);
        }
        this.commandWriter.appendFollowUpCommand(eventInstanceKey, (Intent)ProcessInstanceIntent.COMPLETE_ELEMENT, (RecordValue)this.eventRecord);
    }

    private void activateEventSubProcess(ExecutableStartEvent triggeredStartEvent, ExecutableFlowElement flowScope) {
        this.eventRecord.setBpmnElementType(BpmnElementType.EVENT_SUB_PROCESS).setElementId(flowScope.getId());
        long eventSubProcessKey = this.keyGenerator.nextKey();
        this.stateWriter.appendFollowUpEvent(eventSubProcessKey, (Intent)ProcessInstanceIntent.ELEMENT_ACTIVATING, (RecordValue)this.eventRecord);
        this.stateWriter.appendFollowUpEvent(eventSubProcessKey, (Intent)ProcessInstanceIntent.ELEMENT_ACTIVATED, (RecordValue)this.eventRecord);
        this.eventRecord.setFlowScopeKey(eventSubProcessKey).setBpmnElementType(triggeredStartEvent.getElementType()).setElementId(triggeredStartEvent.getId());
        this.commandWriter.appendNewCommand((Intent)ProcessInstanceIntent.ACTIVATE_ELEMENT, (RecordValue)this.eventRecord);
    }
}

