/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.deployment.model.transformer;

import io.camunda.zeebe.el.Expression;
import io.camunda.zeebe.el.impl.StaticExpression;
import io.camunda.zeebe.engine.Loggers;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableJobWorkerTask;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableProcess;
import io.camunda.zeebe.engine.processing.deployment.model.transformation.ModelElementTransformer;
import io.camunda.zeebe.engine.processing.deployment.model.transformation.TransformContext;
import io.camunda.zeebe.model.bpmn.instance.UserTask;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeFormDefinition;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeHeader;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeTaskHeaders;
import io.camunda.zeebe.msgpack.spec.MsgPackWriter;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.agrona.DirectBuffer;
import org.agrona.ExpandableArrayBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.slf4j.Logger;

public final class UserTaskTransformer
implements ModelElementTransformer<UserTask> {
    private static final Logger LOG = Loggers.STREAM_PROCESSING;
    private static final int INITIAL_SIZE_KEY_VALUE_PAIR = 128;
    private final MsgPackWriter msgPackWriter = new MsgPackWriter();

    @Override
    public Class<UserTask> getType() {
        return UserTask.class;
    }

    @Override
    public void transform(UserTask element, TransformContext context) {
        ExecutableProcess process = context.getCurrentProcess();
        ExecutableJobWorkerTask userTask = process.getElementById(element.getId(), ExecutableJobWorkerTask.class);
        this.transformTaskDefinition(userTask);
        this.transformTaskHeaders(element, userTask);
    }

    private void transformTaskDefinition(ExecutableJobWorkerTask userTask) {
        userTask.setType((Expression)new StaticExpression("io.camunda.zeebe:userTask"));
        userTask.setRetries((Expression)new StaticExpression("1"));
    }

    private void transformTaskHeaders(UserTask element, ExecutableJobWorkerTask userTask) {
        HashMap<String, String> taskHeaders = new HashMap<String, String>();
        this.collectModelTaskHeaders(element, taskHeaders);
        this.addZeebeUserTaskFormKeyHeader(element, taskHeaders);
        if (!taskHeaders.isEmpty()) {
            DirectBuffer encodedHeaders = this.encode(taskHeaders);
            userTask.setEncodedHeaders(encodedHeaders);
        }
    }

    private DirectBuffer encode(Map<String, String> taskHeaders) {
        UnsafeBuffer buffer = new UnsafeBuffer(0L, 0);
        ExpandableArrayBuffer expandableBuffer = new ExpandableArrayBuffer(128 * taskHeaders.size());
        this.msgPackWriter.wrap((MutableDirectBuffer)expandableBuffer, 0);
        this.msgPackWriter.writeMapHeader(taskHeaders.size());
        taskHeaders.forEach((k, v) -> {
            if (this.isValidHeader((String)k, (String)v)) {
                DirectBuffer key = BufferUtil.wrapString((String)k);
                this.msgPackWriter.writeString(key);
                DirectBuffer value = BufferUtil.wrapString((String)v);
                this.msgPackWriter.writeString(value);
            }
        });
        buffer.wrap(expandableBuffer.byteArray(), 0, this.msgPackWriter.getOffset());
        return buffer;
    }

    private void addZeebeUserTaskFormKeyHeader(UserTask element, Map<String, String> taskHeaders) {
        ZeebeFormDefinition formDefinition = (ZeebeFormDefinition)element.getSingleExtensionElement(ZeebeFormDefinition.class);
        if (formDefinition != null) {
            taskHeaders.put("io.camunda.zeebe:formKey", formDefinition.getFormKey());
        }
    }

    private void collectModelTaskHeaders(UserTask element, Map<String, String> taskHeaders) {
        ZeebeTaskHeaders modelTaskHeaders = (ZeebeTaskHeaders)element.getSingleExtensionElement(ZeebeTaskHeaders.class);
        if (modelTaskHeaders != null) {
            List<ZeebeHeader> validHeaders = modelTaskHeaders.getHeaders().stream().filter(this::isValidHeader).collect(Collectors.toList());
            if (validHeaders.size() < modelTaskHeaders.getHeaders().size()) {
                LOG.warn("Ignoring invalid headers for task '{}'. Must have non-empty key and value.", (Object)element.getName());
            }
            validHeaders.forEach(h -> taskHeaders.put(h.getKey(), h.getValue()));
        }
    }

    private boolean isValidHeader(ZeebeHeader header) {
        return header != null && this.isValidHeader(header.getKey(), header.getValue());
    }

    private boolean isValidHeader(String key, String value) {
        return key != null && !key.isEmpty() && value != null && !value.isEmpty();
    }
}

