/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.deployment.transform;

import io.camunda.zeebe.engine.Loggers;
import io.camunda.zeebe.engine.processing.common.ExpressionProcessor;
import io.camunda.zeebe.engine.processing.deployment.model.BpmnFactory;
import io.camunda.zeebe.engine.processing.deployment.model.transformation.BpmnTransformer;
import io.camunda.zeebe.engine.processing.deployment.transform.BpmnValidator;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.camunda.zeebe.engine.state.KeyGenerator;
import io.camunda.zeebe.engine.state.deployment.DeployedProcess;
import io.camunda.zeebe.engine.state.immutable.ProcessState;
import io.camunda.zeebe.engine.state.immutable.ZeebeState;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.instance.Process;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DeploymentRecord;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DeploymentResource;
import io.camunda.zeebe.protocol.impl.record.value.deployment.ProcessMetadata;
import io.camunda.zeebe.protocol.impl.record.value.deployment.ProcessRecord;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ProcessIntent;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.io.DirectBufferInputStream;
import org.slf4j.Logger;

public final class DeploymentTransformer {
    private static final Logger LOG = Loggers.PROCESS_PROCESSOR_LOGGER;
    private final ProcessRecord processRecord = new ProcessRecord();
    private final BpmnTransformer bpmnTransformer = BpmnFactory.createTransformer();
    private final BpmnValidator validator;
    private final ProcessState processState;
    private final KeyGenerator keyGenerator;
    private final MessageDigest digestGenerator;
    private final Map<String, String> processIdToResourceName = new HashMap<String, String>();
    private RejectionType rejectionType;
    private String rejectionReason;
    private final StateWriter stateWriter;

    public DeploymentTransformer(StateWriter stateWriter, ZeebeState zeebeState, ExpressionProcessor expressionProcessor, KeyGenerator keyGenerator) {
        this.stateWriter = stateWriter;
        this.processState = zeebeState.getProcessState();
        this.keyGenerator = keyGenerator;
        this.validator = BpmnFactory.createValidator(expressionProcessor);
        try {
            this.digestGenerator = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    public boolean transform(DeploymentRecord deploymentEvent) {
        StringBuilder errors = new StringBuilder();
        boolean success = true;
        this.processIdToResourceName.clear();
        Iterator resourceIterator = deploymentEvent.resources().iterator();
        if (!resourceIterator.hasNext()) {
            this.rejectionType = RejectionType.INVALID_ARGUMENT;
            this.rejectionReason = "Expected to deploy at least one resource, but none given";
            return false;
        }
        while (resourceIterator.hasNext()) {
            DeploymentResource deploymentResource = (DeploymentResource)resourceIterator.next();
            success &= this.transformResource(deploymentEvent, errors, deploymentResource);
        }
        if (!success) {
            this.rejectionType = RejectionType.INVALID_ARGUMENT;
            this.rejectionReason = String.format("Expected to deploy new resources, but encountered the following errors:%s", errors.toString());
        }
        return success;
    }

    private boolean transformResource(DeploymentRecord deploymentEvent, StringBuilder errors, DeploymentResource deploymentResource) {
        boolean success = false;
        String resourceName = deploymentResource.getResourceName();
        try {
            BpmnModelInstance definition = this.readProcessDefinition(deploymentResource);
            String validationError = this.validator.validate(definition);
            if (validationError == null) {
                this.bpmnTransformer.transformDefinitions(definition);
                String bpmnIdDuplicateError = this.checkForDuplicateBpmnId(definition, resourceName);
                if (bpmnIdDuplicateError == null) {
                    this.transformProcessResource(deploymentEvent, deploymentResource, definition);
                    success = true;
                } else {
                    errors.append("\n").append(bpmnIdDuplicateError);
                }
            } else {
                errors.append("\n'").append(resourceName).append("': ").append(validationError);
            }
        }
        catch (RuntimeException e) {
            LOG.error("Unexpected error while processing resource '{}'", (Object)resourceName, (Object)e);
            errors.append("\n'").append(resourceName).append("': ").append(e.getMessage());
        }
        return success;
    }

    private String checkForDuplicateBpmnId(BpmnModelInstance model, String currentResource) {
        Collection processes = model.getDefinitions().getChildElementsByType(Process.class);
        for (Process process : processes) {
            String previousResource = this.processIdToResourceName.get(process.getId());
            if (previousResource != null) {
                return String.format("Duplicated process id in resources '%s' and '%s'", previousResource, currentResource);
            }
            this.processIdToResourceName.put(process.getId(), currentResource);
        }
        return null;
    }

    private void transformProcessResource(DeploymentRecord deploymentEvent, DeploymentResource deploymentResource, BpmnModelInstance definition) {
        Collection processes = definition.getDefinitions().getChildElementsByType(Process.class);
        for (Process process : processes) {
            if (!process.isExecutable()) continue;
            String bpmnProcessId = process.getId();
            DeployedProcess lastProcess = this.processState.getLatestProcessVersionByProcessId(BufferUtil.wrapString((String)bpmnProcessId));
            DirectBuffer lastDigest = this.processState.getLatestVersionDigest(BufferUtil.wrapString((String)bpmnProcessId));
            UnsafeBuffer resourceDigest = new UnsafeBuffer(this.digestGenerator.digest(deploymentResource.getResource()));
            ProcessMetadata processMetadata = (ProcessMetadata)deploymentEvent.processesMetadata().add();
            processMetadata.setBpmnProcessId(BufferUtil.wrapString((String)process.getId())).setChecksum((DirectBuffer)resourceDigest).setResourceName(deploymentResource.getResourceNameBuffer());
            boolean isDuplicate = this.isDuplicateOfLatest(deploymentResource, (DirectBuffer)resourceDigest, lastProcess, lastDigest);
            if (isDuplicate) {
                processMetadata.setVersion(lastProcess.getVersion()).setKey(lastProcess.getKey()).markAsDuplicate();
                continue;
            }
            long key = this.keyGenerator.nextKey();
            processMetadata.setKey(key).setVersion(this.processState.getProcessVersion(bpmnProcessId) + 1);
            this.processRecord.reset();
            this.processRecord.wrap(processMetadata, deploymentResource.getResource());
            this.stateWriter.appendFollowUpEvent(key, (Intent)ProcessIntent.CREATED, (RecordValue)this.processRecord);
        }
    }

    private boolean isDuplicateOfLatest(DeploymentResource deploymentResource, DirectBuffer resourceDigest, DeployedProcess lastProcess, DirectBuffer lastVersionDigest) {
        return lastVersionDigest != null && lastProcess != null && lastVersionDigest.equals(resourceDigest) && lastProcess.getResourceName().equals(deploymentResource.getResourceNameBuffer());
    }

    private BpmnModelInstance readProcessDefinition(DeploymentResource deploymentResource) {
        DirectBuffer resource = deploymentResource.getResourceBuffer();
        DirectBufferInputStream resourceStream = new DirectBufferInputStream(resource);
        return Bpmn.readModelFromStream((InputStream)resourceStream);
    }

    public RejectionType getRejectionType() {
        return this.rejectionType;
    }

    public String getRejectionReason() {
        return this.rejectionReason;
    }
}

