/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.job;

import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnEventPublicationBehavior;
import io.camunda.zeebe.engine.processing.job.DefaultJobCommandPreconditionGuard;
import io.camunda.zeebe.engine.processing.streamprocessor.CommandProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecord;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedCommandWriter;
import io.camunda.zeebe.engine.state.KeyGenerator;
import io.camunda.zeebe.engine.state.analyzers.CatchEventAnalyzer;
import io.camunda.zeebe.engine.state.immutable.ElementInstanceState;
import io.camunda.zeebe.engine.state.immutable.EventScopeInstanceState;
import io.camunda.zeebe.engine.state.immutable.JobState;
import io.camunda.zeebe.engine.state.immutable.ZeebeState;
import io.camunda.zeebe.engine.state.instance.ElementInstance;
import io.camunda.zeebe.protocol.impl.record.value.incident.IncidentRecord;
import io.camunda.zeebe.protocol.impl.record.value.job.JobRecord;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.IncidentIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.protocol.record.value.ErrorType;
import io.camunda.zeebe.util.buffer.BufferUtil;
import org.agrona.DirectBuffer;

public class JobThrowErrorProcessor
implements CommandProcessor<JobRecord> {
    public static final String NO_CATCH_EVENT_FOUND = "NO_CATCH_EVENT_FOUND";
    private final IncidentRecord incidentEvent = new IncidentRecord();
    private final JobState jobState;
    private final ElementInstanceState elementInstanceState;
    private final DefaultJobCommandPreconditionGuard<JobRecord> defaultProcessor;
    private final CatchEventAnalyzer stateAnalyzer;
    private final KeyGenerator keyGenerator;
    private final EventScopeInstanceState eventScopeInstanceState;
    private final BpmnEventPublicationBehavior eventPublicationBehavior;

    public JobThrowErrorProcessor(ZeebeState state, BpmnEventPublicationBehavior eventPublicationBehavior, KeyGenerator keyGenerator) {
        this.keyGenerator = keyGenerator;
        this.jobState = state.getJobState();
        this.elementInstanceState = state.getElementInstanceState();
        this.eventScopeInstanceState = state.getEventScopeInstanceState();
        this.defaultProcessor = new DefaultJobCommandPreconditionGuard("throw an error for", this.jobState, this::acceptCommand);
        this.stateAnalyzer = new CatchEventAnalyzer(state.getProcessState(), this.elementInstanceState);
        this.eventPublicationBehavior = eventPublicationBehavior;
    }

    @Override
    public boolean onCommand(TypedRecord<JobRecord> command, CommandProcessor.CommandControl<JobRecord> commandControl) {
        return this.defaultProcessor.onCommand(command, commandControl);
    }

    @Override
    public void afterAccept(TypedCommandWriter commandWriter, StateWriter stateWriter, long jobKey, Intent intent, JobRecord job) {
        String serviceTaskInstanceKey = job.getElementId();
        if (NO_CATCH_EVENT_FOUND.equals(serviceTaskInstanceKey)) {
            this.raiseIncident(jobKey, job, stateWriter);
            return;
        }
        ElementInstance serviceTaskInstance = this.elementInstanceState.getInstance(job.getElementInstanceKey());
        DirectBuffer errorCode = job.getErrorCodeBuffer();
        CatchEventAnalyzer.CatchEventTuple foundCatchEvent = this.stateAnalyzer.findCatchEvent(errorCode, serviceTaskInstance);
        this.eventPublicationBehavior.throwErrorEvent(foundCatchEvent);
    }

    private void acceptCommand(TypedRecord<JobRecord> command, CommandProcessor.CommandControl<JobRecord> commandControl) {
        long jobKey = command.getKey();
        JobRecord job = this.jobState.getJob(jobKey);
        job.setErrorCode(command.getValue().getErrorCodeBuffer());
        job.setErrorMessage(command.getValue().getErrorMessageBuffer());
        long serviceTaskInstanceKey = job.getElementInstanceKey();
        ElementInstance serviceTaskInstance = this.elementInstanceState.getInstance(serviceTaskInstanceKey);
        DirectBuffer errorCode = job.getErrorCodeBuffer();
        CatchEventAnalyzer.CatchEventTuple foundCatchEvent = this.stateAnalyzer.findCatchEvent(errorCode, serviceTaskInstance);
        if (foundCatchEvent == null) {
            job.setElementId(NO_CATCH_EVENT_FOUND);
            commandControl.accept((Intent)JobIntent.ERROR_THROWN, job);
        } else if (!this.serviceTaskInstanceIsActive(serviceTaskInstance)) {
            commandControl.reject(RejectionType.INVALID_STATE, "Expected to find active service task, but was " + serviceTaskInstance);
        } else if (!this.eventScopeInstanceState.isAcceptingEvent(foundCatchEvent.getElementInstance().getKey())) {
            commandControl.reject(RejectionType.INVALID_STATE, "Expected to find event scope that is accepting events, but was " + foundCatchEvent.getElementInstance());
        } else {
            commandControl.accept((Intent)JobIntent.ERROR_THROWN, job);
        }
    }

    private boolean serviceTaskInstanceIsActive(ElementInstance serviceTaskInstance) {
        return serviceTaskInstance != null && serviceTaskInstance.isActive();
    }

    private void raiseIncident(long key, JobRecord job, StateWriter stateWriter) {
        DirectBuffer jobErrorMessage = job.getErrorMessageBuffer();
        DirectBuffer incidentErrorMessage = BufferUtil.wrapString((String)String.format("An error was thrown with the code '%s' but not caught.", job.getErrorCode()));
        if (jobErrorMessage.capacity() > 0) {
            incidentErrorMessage = jobErrorMessage;
        }
        this.incidentEvent.reset();
        this.incidentEvent.setErrorType(ErrorType.UNHANDLED_ERROR_EVENT).setErrorMessage(incidentErrorMessage).setBpmnProcessId(job.getBpmnProcessIdBuffer()).setProcessDefinitionKey(job.getProcessDefinitionKey()).setProcessInstanceKey(job.getProcessInstanceKey()).setElementId(job.getElementIdBuffer()).setElementInstanceKey(job.getElementInstanceKey()).setJobKey(key).setVariableScopeKey(job.getElementInstanceKey());
        stateWriter.appendFollowUpEvent(this.keyGenerator.nextKey(), (Intent)IncidentIntent.CREATED, (RecordValue)this.incidentEvent);
    }
}

