/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.streamprocessor.writers;

import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecord;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.ReprocessingRecord;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedStreamWriter;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import java.util.ArrayList;
import java.util.List;

public final class ReprocessingStreamWriter
implements TypedStreamWriter {
    private final List<ReprocessingRecord> records = new ArrayList<ReprocessingRecord>();
    private long sourceRecordPosition = -1L;

    @Override
    public void appendRejection(TypedRecord<? extends RecordValue> command, RejectionType type, String reason) {
        ReprocessingRecord record = new ReprocessingRecord(command.getKey(), this.sourceRecordPosition, command.getIntent(), RecordType.COMMAND_REJECTION);
        this.records.add(record);
    }

    @Override
    public void configureSourceContext(long sourceRecordPosition) {
        this.sourceRecordPosition = sourceRecordPosition;
    }

    @Override
    public void appendFollowUpEvent(long key, Intent intent, RecordValue value) {
        ReprocessingRecord record = new ReprocessingRecord(key, this.sourceRecordPosition, intent, RecordType.EVENT);
        this.records.add(record);
    }

    @Override
    public void appendNewCommand(Intent intent, RecordValue value) {
        ReprocessingRecord record = new ReprocessingRecord(-1L, this.sourceRecordPosition, intent, RecordType.COMMAND);
        this.records.add(record);
    }

    @Override
    public void appendFollowUpCommand(long key, Intent intent, RecordValue value) {
        ReprocessingRecord record = new ReprocessingRecord(key, this.sourceRecordPosition, intent, RecordType.COMMAND);
        this.records.add(record);
    }

    @Override
    public void reset() {
        this.sourceRecordPosition = -1L;
    }

    @Override
    public long flush() {
        return 0L;
    }

    public List<ReprocessingRecord> getRecords() {
        return this.records;
    }

    public void removeRecord(long recordKey, long sourceRecordPosition) {
        this.records.removeIf(record -> record.getKey() == recordKey && record.getSourceRecordPosition() == sourceRecordPosition);
    }
}

