/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.analyzers;

import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableActivity;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableCatchEvent;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableProcess;
import io.camunda.zeebe.engine.state.deployment.DeployedProcess;
import io.camunda.zeebe.engine.state.immutable.ElementInstanceState;
import io.camunda.zeebe.engine.state.immutable.ProcessState;
import io.camunda.zeebe.engine.state.instance.ElementInstance;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import org.agrona.DirectBuffer;

public final class CatchEventAnalyzer {
    private final CatchEventTuple catchEventTuple = new CatchEventTuple();
    private final ProcessState processState;
    private final ElementInstanceState elementInstanceState;

    public CatchEventAnalyzer(ProcessState processState, ElementInstanceState elementInstanceState) {
        this.processState = processState;
        this.elementInstanceState = elementInstanceState;
    }

    public boolean hasCatchEvent(DirectBuffer errorCode, ElementInstance instance) {
        return this.findCatchEvent(errorCode, instance) != null;
    }

    public CatchEventTuple findCatchEvent(DirectBuffer errorCode, ElementInstance instance) {
        while (instance != null && instance.isActive()) {
            ProcessInstanceRecord instanceRecord = instance.getValue();
            ExecutableProcess process = this.getProcess(instanceRecord.getProcessDefinitionKey());
            CatchEventTuple found = this.findCatchEventInProcess(errorCode, process, instance);
            if (found != null) {
                return found;
            }
            long parentElementInstanceKey = instanceRecord.getParentElementInstanceKey();
            instance = this.elementInstanceState.getInstance(parentElementInstanceKey);
        }
        return null;
    }

    private CatchEventTuple findCatchEventInProcess(DirectBuffer errorCode, ExecutableProcess process, ElementInstance instance) {
        while (instance != null && instance.isActive() && !instance.isInterrupted()) {
            CatchEventTuple found = this.findCatchEventInScope(errorCode, process, instance);
            if (found != null) {
                return found;
            }
            long instanceParentKey = instance.getParentKey();
            instance = this.elementInstanceState.getInstance(instanceParentKey);
        }
        return null;
    }

    private CatchEventTuple findCatchEventInScope(DirectBuffer errorCode, ExecutableProcess process, ElementInstance instance) {
        ProcessInstanceRecord processInstanceRecord = instance.getValue();
        DirectBuffer elementId = processInstanceRecord.getElementIdBuffer();
        BpmnElementType elementType = processInstanceRecord.getBpmnElementType();
        ExecutableActivity element = process.getElementById(elementId, elementType, ExecutableActivity.class);
        for (ExecutableCatchEvent catchEvent : element.getEvents()) {
            if (!this.hasErrorCode(catchEvent, errorCode)) continue;
            this.catchEventTuple.instance = instance;
            this.catchEventTuple.catchEvent = catchEvent;
            return this.catchEventTuple;
        }
        return null;
    }

    private boolean hasErrorCode(ExecutableCatchEvent catchEvent, DirectBuffer errorCode) {
        return catchEvent.isError() && catchEvent.getError().getErrorCode().equals(errorCode);
    }

    private ExecutableProcess getProcess(long processDefinitionKey) {
        DeployedProcess deployedProcess = this.processState.getProcessByKey(processDefinitionKey);
        if (deployedProcess == null) {
            throw new IllegalStateException(String.format("Expected process with key '%d' to be deployed but not found", processDefinitionKey));
        }
        return deployedProcess.getProcess();
    }

    public static final class CatchEventTuple {
        private ExecutableCatchEvent catchEvent;
        private ElementInstance instance;

        public ExecutableCatchEvent getCatchEvent() {
            return this.catchEvent;
        }

        public ElementInstance getElementInstance() {
            return this.instance;
        }
    }
}

