/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.appliers;

import io.camunda.zeebe.engine.state.TypedEventApplier;
import io.camunda.zeebe.engine.state.immutable.ElementInstanceState;
import io.camunda.zeebe.engine.state.immutable.JobState;
import io.camunda.zeebe.engine.state.instance.ElementInstance;
import io.camunda.zeebe.engine.state.mutable.MutableIncidentState;
import io.camunda.zeebe.engine.state.mutable.MutableJobState;
import io.camunda.zeebe.protocol.impl.record.value.incident.IncidentRecord;
import io.camunda.zeebe.protocol.impl.record.value.job.JobRecord;
import io.camunda.zeebe.protocol.record.intent.IncidentIntent;
import java.util.EnumSet;
import java.util.Set;

final class IncidentResolvedApplier
implements TypedEventApplier<IncidentIntent, IncidentRecord> {
    private static final Set<JobState.State> RESOLVABLE_JOB_STATES = EnumSet.of(JobState.State.FAILED, JobState.State.ERROR_THROWN);
    private final MutableIncidentState incidentState;
    private final MutableJobState jobState;
    private final ElementInstanceState elementInstanceState;

    public IncidentResolvedApplier(MutableIncidentState incidentState, MutableJobState jobState, ElementInstanceState elementInstanceState) {
        this.incidentState = incidentState;
        this.jobState = jobState;
        this.elementInstanceState = elementInstanceState;
    }

    @Override
    public void applyState(long incidentKey, IncidentRecord value) {
        JobState.State stateOfJob;
        long jobKey = value.getJobKey();
        if (jobKey > 0L && RESOLVABLE_JOB_STATES.contains((Object)(stateOfJob = this.jobState.getState(jobKey)))) {
            JobRecord job = this.jobState.getJob(jobKey);
            this.resetElementId(job);
            this.jobState.resolve(jobKey, job);
        }
        this.incidentState.deleteIncident(incidentKey);
    }

    private void resetElementId(JobRecord job) {
        ElementInstance elementInstance;
        if ("NO_CATCH_EVENT_FOUND".equals(job.getElementId()) && (elementInstance = this.elementInstanceState.getInstance(job.getElementInstanceKey())) != null) {
            job.setElementId(elementInstance.getValue().getElementId());
        }
    }
}

