/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.appliers;

import io.camunda.zeebe.engine.state.TypedEventApplier;
import io.camunda.zeebe.engine.state.instance.ElementInstance;
import io.camunda.zeebe.engine.state.mutable.MutableElementInstanceState;
import io.camunda.zeebe.engine.state.mutable.MutableEventScopeInstanceState;
import io.camunda.zeebe.engine.state.mutable.MutableJobState;
import io.camunda.zeebe.engine.state.mutable.MutableVariableState;
import io.camunda.zeebe.engine.state.mutable.MutableZeebeState;
import io.camunda.zeebe.protocol.impl.record.value.job.JobRecord;
import io.camunda.zeebe.protocol.record.intent.JobIntent;

class JobCompletedApplier
implements TypedEventApplier<JobIntent, JobRecord> {
    private final MutableJobState jobState;
    private final MutableElementInstanceState elementInstanceState;
    private final MutableEventScopeInstanceState eventScopeInstanceState;
    private final MutableVariableState variableState;

    JobCompletedApplier(MutableZeebeState state) {
        this.jobState = state.getJobState();
        this.elementInstanceState = state.getElementInstanceState();
        this.eventScopeInstanceState = state.getEventScopeInstanceState();
        this.variableState = state.getVariableState();
    }

    @Override
    public void applyState(long key, JobRecord value) {
        long scopeKey;
        ElementInstance scopeInstance;
        this.jobState.complete(key, value);
        long elementInstanceKey = value.getElementInstanceKey();
        ElementInstance elementInstance = this.elementInstanceState.getInstance(elementInstanceKey);
        if (elementInstance != null && (scopeInstance = this.elementInstanceState.getInstance(scopeKey = elementInstance.getValue().getFlowScopeKey())) != null && scopeInstance.isActive()) {
            elementInstance.setJobKey(-1L);
            this.elementInstanceState.updateInstance(elementInstance);
            this.eventScopeInstanceState.shutdownInstance(elementInstanceKey);
            this.variableState.setTemporaryVariables(elementInstanceKey, value.getVariablesBuffer());
        }
    }
}

