/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.instance;

import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.DbKey;
import io.camunda.zeebe.db.DbValue;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.impl.DbCompositeKey;
import io.camunda.zeebe.db.impl.DbInt;
import io.camunda.zeebe.db.impl.DbLong;
import io.camunda.zeebe.db.impl.DbNil;
import io.camunda.zeebe.db.impl.DbString;
import io.camunda.zeebe.engine.processing.streamprocessor.MigratedStreamProcessors;
import io.camunda.zeebe.engine.state.ZbColumnFamilies;
import io.camunda.zeebe.engine.state.instance.AwaitProcessInstanceResultMetadata;
import io.camunda.zeebe.engine.state.instance.ElementInstance;
import io.camunda.zeebe.engine.state.instance.IndexedRecord;
import io.camunda.zeebe.engine.state.mutable.MutableElementInstanceState;
import io.camunda.zeebe.engine.state.mutable.MutableVariableState;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.MutableInteger;
import org.agrona.concurrent.UnsafeBuffer;

public final class DbElementInstanceState
implements MutableElementInstanceState {
    private final ColumnFamily<DbCompositeKey<DbLong, DbLong>, DbNil> parentChildColumnFamily;
    private final DbCompositeKey<DbLong, DbLong> parentChildKey;
    private final DbLong parentKey;
    private final DbLong elementInstanceKey;
    private final ElementInstance elementInstance;
    private final ColumnFamily<DbLong, ElementInstance> elementInstanceColumnFamily;
    private final AwaitProcessInstanceResultMetadata awaitResultMetadata;
    private final ColumnFamily<DbLong, AwaitProcessInstanceResultMetadata> awaitProcessInstanceResultMetadataColumnFamily;
    private final DbLong flowScopeKey = new DbLong();
    private final DbString gatewayElementId = new DbString();
    private final DbString sequenceFlowElementId = new DbString();
    private final DbInt numberOfTakenSequenceFlows = new DbInt();
    private final DbCompositeKey<DbLong, DbString> flowScopeKeyAndElementId;
    private final DbCompositeKey<DbCompositeKey<DbLong, DbString>, DbString> numberOfTakenSequenceFlowsKey;
    private final ColumnFamily<DbCompositeKey<DbCompositeKey<DbLong, DbString>, DbString>, DbInt> numberOfTakenSequenceFlowsColumnFamily;
    private final MutableVariableState variableState;

    public DbElementInstanceState(ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext, MutableVariableState variableState) {
        this.variableState = variableState;
        this.elementInstanceKey = new DbLong();
        this.parentKey = new DbLong();
        this.parentChildKey = new DbCompositeKey((DbKey)this.parentKey, (DbKey)this.elementInstanceKey);
        this.parentChildColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.ELEMENT_INSTANCE_PARENT_CHILD, transactionContext, this.parentChildKey, (DbValue)DbNil.INSTANCE);
        this.elementInstance = new ElementInstance();
        this.elementInstanceColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.ELEMENT_INSTANCE_KEY, transactionContext, (DbKey)this.elementInstanceKey, (DbValue)this.elementInstance);
        this.awaitResultMetadata = new AwaitProcessInstanceResultMetadata();
        this.awaitProcessInstanceResultMetadataColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.AWAIT_WORKLOW_RESULT, transactionContext, (DbKey)this.elementInstanceKey, (DbValue)this.awaitResultMetadata);
        this.flowScopeKeyAndElementId = new DbCompositeKey((DbKey)this.flowScopeKey, (DbKey)this.gatewayElementId);
        this.numberOfTakenSequenceFlowsKey = new DbCompositeKey(this.flowScopeKeyAndElementId, (DbKey)this.sequenceFlowElementId);
        this.numberOfTakenSequenceFlowsColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.NUMBER_OF_TAKEN_SEQUENCE_FLOWS, transactionContext, this.numberOfTakenSequenceFlowsKey, (DbValue)this.numberOfTakenSequenceFlows);
    }

    @Override
    public ElementInstance newInstance(long key, ProcessInstanceRecord value, ProcessInstanceIntent state) {
        return this.newInstance(null, key, value, state);
    }

    @Override
    public ElementInstance newInstance(ElementInstance parent, long key, ProcessInstanceRecord value, ProcessInstanceIntent state) {
        ElementInstance instance;
        if (parent == null) {
            instance = new ElementInstance(key, state, value);
        } else {
            instance = new ElementInstance(key, parent, state, value);
            this.updateInstance(parent);
        }
        this.updateInstance(instance);
        return instance;
    }

    @Override
    public void removeInstance(long key) {
        ElementInstance instance = this.getInstance(key);
        if (instance != null) {
            this.elementInstanceKey.wrapLong(key);
            this.parentKey.wrapLong(instance.getParentKey());
            this.parentChildColumnFamily.delete(this.parentChildKey);
            this.elementInstanceColumnFamily.delete((DbKey)this.elementInstanceKey);
            this.variableState.removeScope(key);
            this.awaitProcessInstanceResultMetadataColumnFamily.delete((DbKey)this.elementInstanceKey);
            this.removeNumberOfTakenSequenceFlows(key);
            long parentKey = instance.getParentKey();
            if (parentKey > 0L) {
                ElementInstance parentInstance = this.getInstance(parentKey);
                if (parentInstance == null) {
                    this.handleMissingParentInstance(instance.getValue().getBpmnElementType(), parentKey);
                    return;
                }
                parentInstance.decrementChildCount();
                this.updateInstance(parentInstance);
            }
        }
    }

    @Override
    public void updateInstance(ElementInstance scopeInstance) {
        this.writeElementInstance(scopeInstance);
    }

    @Override
    public void updateInstance(long key, Consumer<ElementInstance> modifier) {
        ElementInstance scopeInstance = this.getInstance(key);
        modifier.accept(scopeInstance);
        this.updateInstance(scopeInstance);
    }

    @Override
    public void setAwaitResultRequestMetadata(long processInstanceKey, AwaitProcessInstanceResultMetadata metadata) {
        this.elementInstanceKey.wrapLong(processInstanceKey);
        this.awaitProcessInstanceResultMetadataColumnFamily.put((DbKey)this.elementInstanceKey, (DbValue)metadata);
    }

    @Override
    public void incrementNumberOfTakenSequenceFlows(long flowScopeKey, DirectBuffer gatewayElementId, DirectBuffer sequenceFlowElementId) {
        this.flowScopeKey.wrapLong(flowScopeKey);
        this.gatewayElementId.wrapBuffer(gatewayElementId);
        this.sequenceFlowElementId.wrapBuffer(sequenceFlowElementId);
        DbInt number = (DbInt)this.numberOfTakenSequenceFlowsColumnFamily.get(this.numberOfTakenSequenceFlowsKey);
        int newValue = 1;
        if (number != null) {
            newValue = number.getValue() + 1;
        }
        this.numberOfTakenSequenceFlows.wrapInt(newValue);
        this.numberOfTakenSequenceFlowsColumnFamily.put(this.numberOfTakenSequenceFlowsKey, (DbValue)this.numberOfTakenSequenceFlows);
    }

    @Override
    public void decrementNumberOfTakenSequenceFlows(long flowScopeKey, DirectBuffer gatewayElementId) {
        this.flowScopeKey.wrapLong(flowScopeKey);
        this.gatewayElementId.wrapBuffer(gatewayElementId);
        this.numberOfTakenSequenceFlowsColumnFamily.whileEqualPrefix(this.flowScopeKeyAndElementId, (key, number) -> {
            int newValue = number.getValue() - 1;
            if (newValue > 0) {
                this.numberOfTakenSequenceFlows.wrapInt(newValue);
                this.numberOfTakenSequenceFlowsColumnFamily.put((DbKey)key, (DbValue)this.numberOfTakenSequenceFlows);
            } else {
                this.numberOfTakenSequenceFlowsColumnFamily.delete((DbKey)key);
            }
        });
    }

    private void handleMissingParentInstance(BpmnElementType elementType, long parentKey) {
        if (MigratedStreamProcessors.isMigrated(elementType)) {
            String errorMsg = "Expected to find parent instance for element instance with key %d, but none was found.";
            throw new IllegalStateException(String.format("Expected to find parent instance for element instance with key %d, but none was found.", parentKey));
        }
    }

    private void writeElementInstance(ElementInstance instance) {
        this.elementInstanceKey.wrapLong(instance.getKey());
        this.parentKey.wrapLong(instance.getParentKey());
        this.elementInstanceColumnFamily.put((DbKey)this.elementInstanceKey, (DbValue)instance);
        this.parentChildColumnFamily.put(this.parentChildKey, (DbValue)DbNil.INSTANCE);
        this.variableState.createScope(this.elementInstanceKey.getValue(), this.parentKey.getValue());
    }

    @Override
    public ElementInstance getInstance(long key) {
        this.elementInstanceKey.wrapLong(key);
        ElementInstance elementInstance = (ElementInstance)this.elementInstanceColumnFamily.get((DbKey)this.elementInstanceKey);
        return this.copyElementInstance(elementInstance);
    }

    @Override
    public List<ElementInstance> getChildren(long parentKey) {
        ArrayList<ElementInstance> children = new ArrayList<ElementInstance>();
        ElementInstance parentInstance = this.getInstance(parentKey);
        if (parentInstance != null) {
            this.parentKey.wrapLong(parentKey);
            this.parentChildColumnFamily.whileEqualPrefix((DbKey)this.parentKey, (key, value) -> {
                DbLong childKey = (DbLong)key.getSecond();
                ElementInstance childInstance = this.getInstance(childKey.getValue());
                ElementInstance copiedElementInstance = this.copyElementInstance(childInstance);
                children.add(copiedElementInstance);
            });
        }
        return children;
    }

    @Override
    public AwaitProcessInstanceResultMetadata getAwaitResultRequestMetadata(long processInstanceKey) {
        this.elementInstanceKey.wrapLong(processInstanceKey);
        return (AwaitProcessInstanceResultMetadata)this.awaitProcessInstanceResultMetadataColumnFamily.get((DbKey)this.elementInstanceKey);
    }

    @Override
    public int getNumberOfTakenSequenceFlows(long flowScopeKey, DirectBuffer gatewayElementId) {
        this.flowScopeKey.wrapLong(flowScopeKey);
        this.gatewayElementId.wrapBuffer(gatewayElementId);
        MutableInteger count = new MutableInteger(0);
        this.numberOfTakenSequenceFlowsColumnFamily.whileEqualPrefix(this.flowScopeKeyAndElementId, (key, number) -> count.increment());
        return count.get();
    }

    private ElementInstance copyElementInstance(ElementInstance elementInstance) {
        if (elementInstance != null) {
            byte[] bytes = new byte[elementInstance.getLength()];
            UnsafeBuffer buffer = new UnsafeBuffer(bytes);
            elementInstance.write((MutableDirectBuffer)buffer, 0);
            ElementInstance copiedElementInstance = new ElementInstance();
            copiedElementInstance.wrap((DirectBuffer)buffer, 0, elementInstance.getLength());
            return copiedElementInstance;
        }
        return null;
    }

    private void removeNumberOfTakenSequenceFlows(long flowScopeKey) {
        this.flowScopeKey.wrapLong(flowScopeKey);
        this.numberOfTakenSequenceFlowsColumnFamily.whileEqualPrefix((DbKey)this.flowScopeKey, (key, number) -> this.numberOfTakenSequenceFlowsColumnFamily.delete((DbKey)key));
    }

    @FunctionalInterface
    public static interface RecordVisitor {
        public void visitRecord(IndexedRecord var1);
    }
}

