/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.message;

import io.camunda.zeebe.engine.state.immutable.MessageSubscriptionState;
import io.camunda.zeebe.engine.state.message.MessageSubscription;
import io.camunda.zeebe.engine.state.message.TransientSubscriptionCommandState;
import io.camunda.zeebe.engine.state.mutable.MutablePendingMessageSubscriptionState;
import io.camunda.zeebe.protocol.impl.record.value.message.MessageSubscriptionRecord;
import io.camunda.zeebe.util.buffer.BufferUtil;
import io.camunda.zeebe.util.sched.clock.ActorClock;

final class PendingMessageSubscriptionState
implements MutablePendingMessageSubscriptionState {
    private final TransientSubscriptionCommandState transientState = new TransientSubscriptionCommandState();
    private final MessageSubscriptionState persistentState;

    PendingMessageSubscriptionState(MessageSubscriptionState persistentState) {
        this.persistentState = persistentState;
    }

    @Override
    public void visitSubscriptionBefore(long deadline, MessageSubscriptionState.MessageSubscriptionVisitor visitor) {
        for (TransientSubscriptionCommandState.CommandEntry commandEntry : this.transientState.getEntriesBefore(deadline)) {
            MessageSubscription subscription = this.persistentState.get(commandEntry.getElementInstanceKey(), BufferUtil.wrapString((String)commandEntry.getMessageName()));
            visitor.visit(subscription);
        }
    }

    @Override
    public void updateCommandSentTime(MessageSubscriptionRecord record, long commandSentTime) {
        TransientSubscriptionCommandState.CommandEntry updatedEntry = this.buildCommandEntry(record, commandSentTime);
        this.transientState.updateCommandSentTime(updatedEntry);
    }

    final void add(MessageSubscriptionRecord record) {
        this.add(record, ActorClock.currentTimeMillis());
    }

    final void add(MessageSubscriptionRecord record, long commandSentTime) {
        this.transientState.add(this.buildCommandEntry(record, commandSentTime));
    }

    final void remove(MessageSubscriptionRecord record) {
        this.transientState.remove(this.buildCommandEntry(record, 0L));
    }

    private TransientSubscriptionCommandState.CommandEntry buildCommandEntry(MessageSubscriptionRecord record, long commandSentTime) {
        return new TransientSubscriptionCommandState.CommandEntry(record.getElementInstanceKey(), record.getMessageName(), commandSentTime);
    }
}

