/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql.legacy;

import io.debezium.connector.SnapshotRecord;
import io.debezium.connector.mysql.MySqlConnector;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.MysqlBinaryProtocolFieldReader;
import io.debezium.connector.mysql.MysqlFieldReader;
import io.debezium.connector.mysql.MysqlTextProtocolFieldReader;
import io.debezium.connector.mysql.legacy.AbstractReader;
import io.debezium.connector.mysql.legacy.Filters;
import io.debezium.connector.mysql.legacy.MySqlSchema;
import io.debezium.connector.mysql.legacy.MySqlTaskContext;
import io.debezium.connector.mysql.legacy.RecordMakers;
import io.debezium.connector.mysql.legacy.SnapshotReaderMetrics;
import io.debezium.connector.mysql.legacy.SourceInfo;
import io.debezium.function.BlockingConsumer;
import io.debezium.function.BufferedBlockingConsumer;
import io.debezium.function.Predicates;
import io.debezium.heartbeat.Heartbeat;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.relational.Column;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.relational.ddl.DdlChanges;
import io.debezium.schema.DataCollectionId;
import io.debezium.util.Clock;
import io.debezium.util.Strings;
import io.debezium.util.Threads;
import java.lang.invoke.LambdaMetafactory;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.source.SourceRecord;

public class SnapshotReader
extends AbstractReader {
    private final boolean includeData;
    private RecordRecorder recorder;
    private final SnapshotReaderMetrics metrics;
    private ExecutorService executorService;
    private final boolean useGlobalLock;
    private final MysqlFieldReader mysqlFieldReader;
    private final MySqlConnectorConfig.SnapshotLockingMode snapshotLockingMode;

    public SnapshotReader(String name, MySqlTaskContext context) {
        this(name, context, true);
    }

    SnapshotReader(String name, MySqlTaskContext context, boolean useGlobalLock) {
        super(name, context, null);
        this.includeData = context.snapshotMode().includeData();
        this.snapshotLockingMode = context.getConnectorConfig().getSnapshotLockingMode();
        this.recorder = this::recordRowAsRead;
        this.metrics = new SnapshotReaderMetrics(context, context.dbSchema(), this.changeEventQueueMetrics);
        this.useGlobalLock = useGlobalLock;
        this.mysqlFieldReader = context.getConnectorConfig().useCursorFetch() ? new MysqlBinaryProtocolFieldReader() : new MysqlTextProtocolFieldReader();
    }

    public SnapshotReader generateReadEvents() {
        this.recorder = this::recordRowAsRead;
        return this;
    }

    @Override
    protected void doInitialize() {
        this.metrics.register(this.logger);
    }

    @Override
    public void doDestroy() {
        this.metrics.unregister(this.logger);
    }

    @Override
    protected void doStart() {
        this.executorService = Threads.newSingleThreadExecutor(MySqlConnector.class, (String)this.context.getConnectorConfig().getLogicalName(), (String)"snapshot");
        this.executorService.execute(this::execute);
    }

    @Override
    protected void doStop() {
        this.logger.debug("Stopping snapshot reader");
        this.cleanupResources();
    }

    @Override
    protected void doCleanup() {
        this.executorService.shutdown();
        this.logger.debug("Completed writing all snapshot records");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void execute() {
        block212: {
            this.context.configureLoggingContext("snapshot");
            sql = new AtomicReference<String>();
            mysql = this.connectionContext.jdbc();
            schema = this.context.dbSchema();
            filters = schema.filters();
            source = this.context.source();
            clock = this.context.getClock();
            ts = clock.currentTimeInMillis();
            this.logger.info("Starting snapshot for {} with user '{}' with locking mode '{}'", new Object[]{this.connectionContext.connectionString(), mysql.username(), this.snapshotLockingMode.getValue()});
            this.logRolesForCurrentUser(mysql);
            this.logServerInformation(mysql);
            isLocked = false;
            isTxnStarted = false;
            tableLocks = false;
            tablesToSnapshotSchemaAfterUnlock = new ArrayList<TableId>();
            lockedTables = Collections.emptySet();
            snapshotAllowedTables = this.context.getConnectorConfig().getDataCollectionsToBeSnapshotted();
            isAllowedForSnapshot = (Predicate<TableId>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$execute$1(java.util.Set io.debezium.relational.TableId ), (Lio/debezium/relational/TableId;)Z)((Set)snapshotAllowedTables);
            try {
                block220: {
                    block210: {
                        block207: {
                            block219: {
                                block208: {
                                    block204: {
                                        block218: {
                                            block205: {
                                                block202: {
                                                    block217: {
                                                        block203: {
                                                            block200: {
                                                                block216: {
                                                                    block201: {
                                                                        block198: {
                                                                            block215: {
                                                                                block199: {
                                                                                    block196: {
                                                                                        block214: {
                                                                                            block197: {
                                                                                                block193: {
                                                                                                    block213: {
                                                                                                        block194: {
                                                                                                            this.metrics.snapshotStarted();
                                                                                                            if (!this.isRunning()) {
                                                                                                                return;
                                                                                                            }
                                                                                                            snapshotLockTimeout = this.context.getConnectorConfig().snapshotLockTimeout().getSeconds();
                                                                                                            this.logger.info("Step 0: disabling autocommit, enabling repeatable read transactions, and setting lock wait timeout to {}", (Object)snapshotLockTimeout);
                                                                                                            mysql.setAutoCommit(false);
                                                                                                            sql.set("SET TRANSACTION ISOLATION LEVEL REPEATABLE READ");
                                                                                                            mysql.executeWithoutCommitting(new String[]{(String)sql.get()});
                                                                                                            sql.set("SET SESSION lock_wait_timeout=" + snapshotLockTimeout);
                                                                                                            mysql.executeWithoutCommitting(new String[]{(String)sql.get()});
                                                                                                            try {
                                                                                                                sql.set("SET SESSION innodb_lock_wait_timeout=" + snapshotLockTimeout);
                                                                                                                mysql.executeWithoutCommitting(new String[]{(String)sql.get()});
                                                                                                            }
                                                                                                            catch (SQLException e) {
                                                                                                                this.logger.warn("Unable to set innodb_lock_wait_timeout", (Throwable)e);
                                                                                                            }
                                                                                                            systemVariables = this.connectionContext.readMySqlCharsetSystemVariables();
                                                                                                            setSystemVariablesStatement = this.connectionContext.setStatementFor(systemVariables);
                                                                                                            interrupted = new AtomicBoolean(false);
                                                                                                            lockAcquired = 0L;
                                                                                                            step = 1;
                                                                                                            configuration = this.context.config();
                                                                                                            if (this.isRunning()) break block193;
                                                                                                            rolledBack = false;
                                                                                                            if (!isTxnStarted) break block194;
                                                                                                            if (interrupted.get() || !this.isRunning()) {
                                                                                                                this.logger.info("Step {}: rolling back transaction after abort", (Object)step++);
                                                                                                                mysql.connection().rollback();
                                                                                                                this.metrics.snapshotAborted();
                                                                                                                rolledBack = true;
                                                                                                            } else {
                                                                                                                this.logger.info("Step {}: committing transaction", (Object)step++);
                                                                                                                mysql.connection().commit();
                                                                                                                this.metrics.snapshotCompleted();
                                                                                                            }
                                                                                                            break block213;
                                                                                                        }
                                                                                                        mysql.connection().rollback();
                                                                                                    }
                                                                                                    if (isLocked && !rolledBack) {
                                                                                                        if (tableLocks) {
                                                                                                            this.logger.info("Step {}: releasing table read locks to enable MySQL writes", (Object)step++);
                                                                                                        } else {
                                                                                                            this.logger.info("Step {}: releasing global read lock to enable MySQL writes", (Object)step++);
                                                                                                        }
                                                                                                        sql.set("UNLOCK TABLES");
                                                                                                        mysql.executeWithoutCommitting(new String[]{(String)sql.get()});
                                                                                                        isLocked = false;
                                                                                                        lockReleased = clock.currentTimeInMillis();
                                                                                                        this.metrics.globalLockReleased();
                                                                                                        if (this.logger.isInfoEnabled()) {
                                                                                                            if (tableLocks) {
                                                                                                                this.logger.info("Writes to MySQL prevented for a total of {}", (Object)Strings.duration((long)(lockReleased - lockAcquired)));
                                                                                                            } else {
                                                                                                                this.logger.info("Writes to MySQL tables prevented for a total of {}", (Object)Strings.duration((long)(lockReleased - lockAcquired)));
                                                                                                            }
                                                                                                        }
                                                                                                        if (!tablesToSnapshotSchemaAfterUnlock.isEmpty()) {
                                                                                                            this.logger.info("Step {}: reading table schema for non-whitelisted tables", (Object)step++);
                                                                                                            for (TableId tableId : tablesToSnapshotSchemaAfterUnlock) {
                                                                                                                if (!this.isRunning()) {
                                                                                                                    break;
                                                                                                                }
                                                                                                                this.readTableSchema(sql, mysql, schema, source, tableId.catalog(), tableId);
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                    return;
                                                                                                }
                                                                                                if (!this.snapshotLockingMode.equals((Object)MySqlConnectorConfig.SnapshotLockingMode.NONE) && this.useGlobalLock) {
                                                                                                    block195: {
                                                                                                        try {
                                                                                                            this.logger.info("Step 1: flush and obtain global read lock to prevent writes to database");
                                                                                                            sql.set(this.snapshotLockingMode.getLockStatement());
                                                                                                            mysql.executeWithoutCommitting(new String[]{(String)sql.get()});
                                                                                                            lockAcquired = clock.currentTimeInMillis();
                                                                                                            this.metrics.globalLockAcquired();
                                                                                                            isLocked = true;
                                                                                                        }
                                                                                                        catch (SQLException e) {
                                                                                                            this.logger.info("Step 1: unable to flush and acquire global read lock, will use table read locks after reading table names");
                                                                                                            if (SnapshotReader.$assertionsDisabled || !isLocked) break block195;
                                                                                                            throw new AssertionError();
                                                                                                        }
                                                                                                    }
                                                                                                    sql.set("SET TRANSACTION ISOLATION LEVEL REPEATABLE READ");
                                                                                                    mysql.executeWithoutCommitting(new String[]{(String)sql.get()});
                                                                                                }
                                                                                                if (this.isRunning()) break block196;
                                                                                                rolledBack = false;
                                                                                                if (!isTxnStarted) break block197;
                                                                                                if (interrupted.get() || !this.isRunning()) {
                                                                                                    this.logger.info("Step {}: rolling back transaction after abort", (Object)step++);
                                                                                                    mysql.connection().rollback();
                                                                                                    this.metrics.snapshotAborted();
                                                                                                    rolledBack = true;
                                                                                                } else {
                                                                                                    this.logger.info("Step {}: committing transaction", (Object)step++);
                                                                                                    mysql.connection().commit();
                                                                                                    this.metrics.snapshotCompleted();
                                                                                                }
                                                                                                break block214;
                                                                                            }
                                                                                            mysql.connection().rollback();
                                                                                        }
                                                                                        if (isLocked && !rolledBack) {
                                                                                            if (tableLocks) {
                                                                                                this.logger.info("Step {}: releasing table read locks to enable MySQL writes", (Object)step++);
                                                                                            } else {
                                                                                                this.logger.info("Step {}: releasing global read lock to enable MySQL writes", (Object)step++);
                                                                                            }
                                                                                            sql.set("UNLOCK TABLES");
                                                                                            mysql.executeWithoutCommitting(new String[]{(String)sql.get()});
                                                                                            isLocked = false;
                                                                                            lockReleased = clock.currentTimeInMillis();
                                                                                            this.metrics.globalLockReleased();
                                                                                            if (this.logger.isInfoEnabled()) {
                                                                                                if (tableLocks) {
                                                                                                    this.logger.info("Writes to MySQL prevented for a total of {}", (Object)Strings.duration((long)(lockReleased - lockAcquired)));
                                                                                                } else {
                                                                                                    this.logger.info("Writes to MySQL tables prevented for a total of {}", (Object)Strings.duration((long)(lockReleased - lockAcquired)));
                                                                                                }
                                                                                            }
                                                                                            if (!tablesToSnapshotSchemaAfterUnlock.isEmpty()) {
                                                                                                this.logger.info("Step {}: reading table schema for non-whitelisted tables", (Object)step++);
                                                                                                for (TableId tableId : tablesToSnapshotSchemaAfterUnlock) {
                                                                                                    if (!this.isRunning()) {
                                                                                                        break;
                                                                                                    }
                                                                                                    this.readTableSchema(sql, mysql, schema, source, tableId.catalog(), tableId);
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                        return;
                                                                                    }
                                                                                    this.logger.info("Step 2: start transaction with consistent snapshot");
                                                                                    sql.set("START TRANSACTION WITH CONSISTENT SNAPSHOT");
                                                                                    mysql.executeWithoutCommitting(new String[]{(String)sql.get()});
                                                                                    isTxnStarted = true;
                                                                                    if (this.isRunning()) break block198;
                                                                                    rolledBack = false;
                                                                                    if (!isTxnStarted) break block199;
                                                                                    if (interrupted.get() || !this.isRunning()) {
                                                                                        this.logger.info("Step {}: rolling back transaction after abort", (Object)step++);
                                                                                        mysql.connection().rollback();
                                                                                        this.metrics.snapshotAborted();
                                                                                        rolledBack = true;
                                                                                    } else {
                                                                                        this.logger.info("Step {}: committing transaction", (Object)step++);
                                                                                        mysql.connection().commit();
                                                                                        this.metrics.snapshotCompleted();
                                                                                    }
                                                                                    break block215;
                                                                                }
                                                                                mysql.connection().rollback();
                                                                            }
                                                                            if (isLocked && !rolledBack) {
                                                                                if (tableLocks) {
                                                                                    this.logger.info("Step {}: releasing table read locks to enable MySQL writes", (Object)step++);
                                                                                } else {
                                                                                    this.logger.info("Step {}: releasing global read lock to enable MySQL writes", (Object)step++);
                                                                                }
                                                                                sql.set("UNLOCK TABLES");
                                                                                mysql.executeWithoutCommitting(new String[]{sql.get()});
                                                                                isLocked = false;
                                                                                lockReleased = clock.currentTimeInMillis();
                                                                                this.metrics.globalLockReleased();
                                                                                if (this.logger.isInfoEnabled()) {
                                                                                    if (tableLocks) {
                                                                                        this.logger.info("Writes to MySQL prevented for a total of {}", (Object)Strings.duration((long)(lockReleased - lockAcquired)));
                                                                                    } else {
                                                                                        this.logger.info("Writes to MySQL tables prevented for a total of {}", (Object)Strings.duration((long)(lockReleased - lockAcquired)));
                                                                                    }
                                                                                }
                                                                                if (!tablesToSnapshotSchemaAfterUnlock.isEmpty()) {
                                                                                    this.logger.info("Step {}: reading table schema for non-whitelisted tables", (Object)step++);
                                                                                    for (TableId tableId : tablesToSnapshotSchemaAfterUnlock) {
                                                                                        if (!this.isRunning()) {
                                                                                            break;
                                                                                        }
                                                                                        this.readTableSchema(sql, mysql, schema, source, tableId.catalog(), tableId);
                                                                                    }
                                                                                }
                                                                            }
                                                                            return;
                                                                        }
                                                                        step = 3;
                                                                        if (isLocked) {
                                                                            this.readBinlogPosition(step++, source, mysql, sql);
                                                                        }
                                                                        if (this.isRunning()) break block200;
                                                                        rolledBack = false;
                                                                        if (!isTxnStarted) break block201;
                                                                        if (interrupted.get() || !this.isRunning()) {
                                                                            this.logger.info("Step {}: rolling back transaction after abort", (Object)step++);
                                                                            mysql.connection().rollback();
                                                                            this.metrics.snapshotAborted();
                                                                            rolledBack = true;
                                                                        } else {
                                                                            this.logger.info("Step {}: committing transaction", (Object)step++);
                                                                            mysql.connection().commit();
                                                                            this.metrics.snapshotCompleted();
                                                                        }
                                                                        break block216;
                                                                    }
                                                                    mysql.connection().rollback();
                                                                }
                                                                if (isLocked && !rolledBack) {
                                                                    if (tableLocks) {
                                                                        this.logger.info("Step {}: releasing table read locks to enable MySQL writes", (Object)step++);
                                                                    } else {
                                                                        this.logger.info("Step {}: releasing global read lock to enable MySQL writes", (Object)step++);
                                                                    }
                                                                    sql.set("UNLOCK TABLES");
                                                                    mysql.executeWithoutCommitting(new String[]{sql.get()});
                                                                    isLocked = false;
                                                                    lockReleased = clock.currentTimeInMillis();
                                                                    this.metrics.globalLockReleased();
                                                                    if (this.logger.isInfoEnabled()) {
                                                                        if (tableLocks) {
                                                                            this.logger.info("Writes to MySQL prevented for a total of {}", (Object)Strings.duration((long)(lockReleased - lockAcquired)));
                                                                        } else {
                                                                            this.logger.info("Writes to MySQL tables prevented for a total of {}", (Object)Strings.duration((long)(lockReleased - lockAcquired)));
                                                                        }
                                                                    }
                                                                    if (!tablesToSnapshotSchemaAfterUnlock.isEmpty()) {
                                                                        this.logger.info("Step {}: reading table schema for non-whitelisted tables", (Object)step++);
                                                                        for (TableId tableId : tablesToSnapshotSchemaAfterUnlock) {
                                                                            if (!this.isRunning()) {
                                                                                break;
                                                                            }
                                                                            this.readTableSchema(sql, mysql, schema, source, tableId.catalog(), tableId);
                                                                        }
                                                                    }
                                                                }
                                                                return;
                                                            }
                                                            this.logger.info("Step {}: read list of available databases", (Object)step++);
                                                            databaseNames = new ArrayList<E>();
                                                            sql.set("SHOW DATABASES");
                                                            mysql.query(sql.get(), (JdbcConnection.ResultSetConsumer)LambdaMetafactory.metafactory(null, null, null, (Ljava/sql/ResultSet;)V, lambda$execute$2(java.util.List java.sql.ResultSet ), (Ljava/sql/ResultSet;)V)(databaseNames));
                                                            this.logger.info("\t list of available databases is: {}", databaseNames);
                                                            if (this.isRunning()) break block202;
                                                            rolledBack = false;
                                                            if (!isTxnStarted) break block203;
                                                            if (interrupted.get() || !this.isRunning()) {
                                                                this.logger.info("Step {}: rolling back transaction after abort", (Object)step++);
                                                                mysql.connection().rollback();
                                                                this.metrics.snapshotAborted();
                                                                rolledBack = true;
                                                            } else {
                                                                this.logger.info("Step {}: committing transaction", (Object)step++);
                                                                mysql.connection().commit();
                                                                this.metrics.snapshotCompleted();
                                                            }
                                                            break block217;
                                                        }
                                                        mysql.connection().rollback();
                                                    }
                                                    if (isLocked && !rolledBack) {
                                                        if (tableLocks) {
                                                            this.logger.info("Step {}: releasing table read locks to enable MySQL writes", (Object)step++);
                                                        } else {
                                                            this.logger.info("Step {}: releasing global read lock to enable MySQL writes", (Object)step++);
                                                        }
                                                        sql.set("UNLOCK TABLES");
                                                        mysql.executeWithoutCommitting(new String[]{sql.get()});
                                                        isLocked = false;
                                                        lockReleased = clock.currentTimeInMillis();
                                                        this.metrics.globalLockReleased();
                                                        if (this.logger.isInfoEnabled()) {
                                                            if (tableLocks) {
                                                                this.logger.info("Writes to MySQL prevented for a total of {}", (Object)Strings.duration((long)(lockReleased - lockAcquired)));
                                                            } else {
                                                                this.logger.info("Writes to MySQL tables prevented for a total of {}", (Object)Strings.duration((long)(lockReleased - lockAcquired)));
                                                            }
                                                        }
                                                        if (!tablesToSnapshotSchemaAfterUnlock.isEmpty()) {
                                                            this.logger.info("Step {}: reading table schema for non-whitelisted tables", (Object)step++);
                                                            for (TableId tableId : tablesToSnapshotSchemaAfterUnlock) {
                                                                if (!this.isRunning()) {
                                                                    break;
                                                                }
                                                                this.readTableSchema(sql, mysql, schema, source, tableId.catalog(), tableId);
                                                            }
                                                        }
                                                    }
                                                    return;
                                                }
                                                this.logger.info("Step {}: read list of available tables in each database", (Object)step++);
                                                knownTableIds = new ArrayList<E>();
                                                capturedTableIds = new ArrayList<TableId>();
                                                createTableFilters = this.getCreateTableFilters(filters);
                                                createTablesMap = new HashMap<K, V>();
                                                readableDatabaseNames = new HashSet<String>();
                                                for (String dbName : databaseNames) {
                                                    try {
                                                        sql.set("SHOW FULL TABLES IN " + this.quote(dbName) + " where Table_Type = 'BASE TABLE'");
                                                        mysql.query(sql.get(), (JdbcConnection.ResultSetConsumer)LambdaMetafactory.metafactory(null, null, null, (Ljava/sql/ResultSet;)V, lambda$execute$4(java.lang.String io.debezium.connector.mysql.legacy.MySqlSchema io.debezium.connector.mysql.legacy.Filters io.debezium.connector.mysql.legacy.Filters java.util.Map java.util.List java.util.function.Predicate java.util.List java.sql.ResultSet ), (Ljava/sql/ResultSet;)V)((SnapshotReader)this, (String)dbName, (MySqlSchema)schema, (Filters)filters, (Filters)createTableFilters, createTablesMap, knownTableIds, isAllowedForSnapshot, capturedTableIds));
                                                        readableDatabaseNames.add(dbName);
                                                    }
                                                    catch (SQLException e) {
                                                        this.logger.warn("\t skipping database '{}' due to error reading tables: {}", (Object)dbName, (Object)e.getMessage());
                                                    }
                                                }
                                                tableIncludeListPattern = Strings.listOfRegex((String)configuration.getFallbackStringProperty(MySqlConnectorConfig.TABLE_INCLUDE_LIST, MySqlConnectorConfig.TABLE_WHITELIST), (int)2);
                                                tableIdsSorted = new ArrayList<E>();
                                                tableIncludeListPattern.forEach((Consumer<Pattern>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$execute$7(java.util.List java.util.List java.util.regex.Pattern ), (Ljava/util/regex/Pattern;)V)(capturedTableIds, tableIdsSorted));
                                                capturedTableIds.sort(Comparator.comparing((Function<TableId, Integer>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, indexOf(java.lang.Object ), (Lio/debezium/relational/TableId;)Ljava/lang/Integer;)(tableIdsSorted)));
                                                includedDatabaseNames = readableDatabaseNames.stream().filter(filters.databaseFilter()).collect(Collectors.toSet());
                                                this.logger.info("\tsnapshot continuing with database(s): {}", includedDatabaseNames);
                                                if (!isLocked) {
                                                    if (!this.snapshotLockingMode.equals((Object)MySqlConnectorConfig.SnapshotLockingMode.NONE)) {
                                                        if (!this.connectionContext.userHasPrivileges("LOCK TABLES")) {
                                                            throw new ConnectException("User does not have the 'LOCK TABLES' privilege required to obtain a consistent snapshot by preventing concurrent writes to tables.");
                                                        }
                                                        this.logger.info("Step {}: flush and obtain read lock for {} tables (preventing writes)", (Object)step++, (Object)knownTableIds.size());
                                                        lockedTables = new HashSet<T>(capturedTableIds);
                                                        tableList = capturedTableIds.stream().map((Function<TableId, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$execute$8(io.debezium.relational.TableId ), (Lio/debezium/relational/TableId;)Ljava/lang/String;)((SnapshotReader)this)).reduce((BinaryOperator)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, lambda$execute$9(java.lang.String java.lang.String ), (Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;)()).orElse(null);
                                                        if (tableList != null) {
                                                            sql.set("FLUSH TABLES " + tableList + " WITH READ LOCK");
                                                            mysql.executeWithoutCommitting(new String[]{sql.get()});
                                                        }
                                                        lockAcquired = clock.currentTimeInMillis();
                                                        this.metrics.globalLockAcquired();
                                                        isLocked = true;
                                                        tableLocks = true;
                                                    }
                                                    this.readBinlogPosition(step++, source, mysql, sql);
                                                }
                                                try {
                                                    this.logger.info("Step {}: generating DROP and CREATE statements to reflect current database schemas:", (Object)step++);
                                                    schema.applyDdl(source, null, setSystemVariablesStatement, (DdlChanges.DatabaseStatementStringConsumer)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/String;Ljava/util/Set;Ljava/lang/String;)V, enqueueSchemaChanges(java.lang.String java.util.Set<io.debezium.relational.TableId> java.lang.String ), (Ljava/lang/String;Ljava/util/Set;Ljava/lang/String;)V)((SnapshotReader)this));
                                                    knownTableIds.stream().filter((Predicate<TableId>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$execute$10(io.debezium.relational.TableId ), (Lio/debezium/relational/TableId;)Z)((SnapshotReader)this)).forEach((Consumer<TableId>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$execute$11(io.debezium.connector.mysql.legacy.MySqlSchema io.debezium.connector.mysql.legacy.SourceInfo io.debezium.relational.TableId ), (Lio/debezium/relational/TableId;)V)((SnapshotReader)this, (MySqlSchema)schema, (SourceInfo)source));
                                                    schema.tableIds().stream().map((Function<TableId, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, catalog(), (Lio/debezium/relational/TableId;)Ljava/lang/String;)()).filter(Predicates.not((Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, contains(java.lang.Object ), (Ljava/lang/String;)Z)(readableDatabaseNames))).filter((Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$execute$12(java.lang.String ), (Ljava/lang/String;)Z)((SnapshotReader)this)).forEach((Consumer<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$execute$13(io.debezium.connector.mysql.legacy.MySqlSchema io.debezium.connector.mysql.legacy.SourceInfo java.lang.String ), (Ljava/lang/String;)V)((SnapshotReader)this, (MySqlSchema)schema, (SourceInfo)source));
                                                    databaseCharsets = this.connectionContext.readDatabaseCollations();
                                                    block75: for (Map.Entry<K, V> entry : createTablesMap.entrySet()) {
                                                        if (!this.isRunning()) break;
                                                        dbName = (String)entry.getKey();
                                                        schema.applyDdl(source, dbName, "DROP DATABASE IF EXISTS " + this.quote(dbName), (DdlChanges.DatabaseStatementStringConsumer)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/String;Ljava/util/Set;Ljava/lang/String;)V, enqueueSchemaChanges(java.lang.String java.util.Set<io.debezium.relational.TableId> java.lang.String ), (Ljava/lang/String;Ljava/util/Set;Ljava/lang/String;)V)((SnapshotReader)this));
                                                        createDatabaseDddl = new StringBuilder("CREATE DATABASE " + this.quote(dbName));
                                                        defaultDatabaseLocales = databaseCharsets.get(dbName);
                                                        if (defaultDatabaseLocales != null) {
                                                            defaultDatabaseLocales.appendToDdlStatement(dbName, createDatabaseDddl);
                                                        }
                                                        schema.applyDdl(source, dbName, createDatabaseDddl.toString(), (DdlChanges.DatabaseStatementStringConsumer)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/String;Ljava/util/Set;Ljava/lang/String;)V, enqueueSchemaChanges(java.lang.String java.util.Set<io.debezium.relational.TableId> java.lang.String ), (Ljava/lang/String;Ljava/util/Set;Ljava/lang/String;)V)((SnapshotReader)this));
                                                        schema.applyDdl(source, dbName, "USE " + this.quote(dbName), (DdlChanges.DatabaseStatementStringConsumer)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/String;Ljava/util/Set;Ljava/lang/String;)V, enqueueSchemaChanges(java.lang.String java.util.Set<io.debezium.relational.TableId> java.lang.String ), (Ljava/lang/String;Ljava/util/Set;Ljava/lang/String;)V)((SnapshotReader)this));
                                                        for (TableId tableId : (List)entry.getValue()) {
                                                            if (!this.isRunning()) continue block75;
                                                            if (lockedTables.isEmpty() || lockedTables.contains(tableId)) {
                                                                this.readTableSchema(sql, mysql, schema, source, dbName, tableId);
                                                                continue;
                                                            }
                                                            tablesToSnapshotSchemaAfterUnlock.add(tableId);
                                                        }
                                                    }
                                                    this.context.makeRecord().regenerate();
                                                }
                                                catch (Exception e) {
                                                    interrupted.set(true);
                                                    throw e;
                                                }
                                                if (this.snapshotLockingMode.usesMinimalLocking() && isLocked) {
                                                    if (tableLocks) {
                                                        this.logger.info("Step {}: tables were locked explicitly, but to get a consistent snapshot we cannot release the locks until we've read all tables.", (Object)step++);
                                                    } else {
                                                        this.logger.info("Step {}: releasing global read lock to enable MySQL writes", (Object)step);
                                                        sql.set("UNLOCK TABLES");
                                                        mysql.executeWithoutCommitting(new String[]{sql.get()});
                                                        isLocked = false;
                                                        lockReleased = clock.currentTimeInMillis();
                                                        this.metrics.globalLockReleased();
                                                        this.logger.info("Step {}: blocked writes to MySQL for a total of {}", (Object)step++, (Object)Strings.duration((long)(lockReleased - lockAcquired)));
                                                    }
                                                }
                                                if (this.isRunning()) break block204;
                                                rolledBack = false;
                                                if (!isTxnStarted) break block205;
                                                if (interrupted.get() || !this.isRunning()) {
                                                    this.logger.info("Step {}: rolling back transaction after abort", (Object)step++);
                                                    mysql.connection().rollback();
                                                    this.metrics.snapshotAborted();
                                                    rolledBack = true;
                                                } else {
                                                    this.logger.info("Step {}: committing transaction", (Object)step++);
                                                    mysql.connection().commit();
                                                    this.metrics.snapshotCompleted();
                                                }
                                                break block218;
                                            }
                                            mysql.connection().rollback();
                                        }
                                        if (isLocked && !rolledBack) {
                                            if (tableLocks) {
                                                this.logger.info("Step {}: releasing table read locks to enable MySQL writes", (Object)step++);
                                            } else {
                                                this.logger.info("Step {}: releasing global read lock to enable MySQL writes", (Object)step++);
                                            }
                                            sql.set("UNLOCK TABLES");
                                            mysql.executeWithoutCommitting(new String[]{sql.get()});
                                            isLocked = false;
                                            lockReleased = clock.currentTimeInMillis();
                                            this.metrics.globalLockReleased();
                                            if (this.logger.isInfoEnabled()) {
                                                if (tableLocks) {
                                                    this.logger.info("Writes to MySQL prevented for a total of {}", (Object)Strings.duration((long)(lockReleased - lockAcquired)));
                                                } else {
                                                    this.logger.info("Writes to MySQL tables prevented for a total of {}", (Object)Strings.duration((long)(lockReleased - lockAcquired)));
                                                }
                                            }
                                            if (!tablesToSnapshotSchemaAfterUnlock.isEmpty()) {
                                                this.logger.info("Step {}: reading table schema for non-whitelisted tables", (Object)step++);
                                                for (TableId tableId : tablesToSnapshotSchemaAfterUnlock) {
                                                    if (!this.isRunning()) {
                                                        break;
                                                    }
                                                    this.readTableSchema(sql, mysql, schema, source, tableId.catalog(), tableId);
                                                }
                                            }
                                        }
                                        return;
                                    }
                                    if (!this.includeData) ** GOTO lbl528
                                    bufferedRecordQueue = BufferedBlockingConsumer.bufferLast((BlockingConsumer)(BlockingConsumer)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$execute$14(org.apache.kafka.connect.source.SourceRecord ), (Lorg/apache/kafka/connect/source/SourceRecord;)V)((SnapshotReader)this));
                                    this.logger.info("Step {}: scanning contents of {} tables while still in transaction", (Object)step, (Object)capturedTableIds.size());
                                    this.metrics.monitoredDataCollectionsDetermined(capturedTableIds);
                                    startScan = clock.currentTimeInMillis();
                                    totalRowCount = new AtomicLong();
                                    counter = 0;
                                    completedCounter = 0;
                                    largeTableCount = this.context.rowCountForLargeTable();
                                    for (TableId tableId : capturedTableIds) {
                                        rowNum = new AtomicLong();
                                        if (!this.isRunning()) break;
                                        recordMaker = this.context.makeRecord().forTable(tableId, null, (BlockingConsumer<SourceRecord>)bufferedRecordQueue);
                                        if (recordMaker != null) {
                                            sql.set("USE " + this.quote(tableId.catalog()) + ";");
                                            mysql.executeWithoutCommitting(new String[]{sql.get()});
                                            numRows = new AtomicLong(-1L);
                                            rowCountStr = new AtomicReference<String>("<unknown>");
                                            statementFactory = (JdbcConnection.StatementFactory)LambdaMetafactory.metafactory(null, null, null, (Ljava/sql/Connection;)Ljava/sql/Statement;, createStatementWithLargeResultSet(java.sql.Connection ), (Ljava/sql/Connection;)Ljava/sql/Statement;)((SnapshotReader)this);
                                            if (largeTableCount > 0L) {
                                                try {
                                                    sql.set("SHOW TABLE STATUS LIKE '" + tableId.table() + "';");
                                                    mysql.query(sql.get(), (JdbcConnection.ResultSetConsumer)LambdaMetafactory.metafactory(null, null, null, (Ljava/sql/ResultSet;)V, lambda$execute$15(java.util.concurrent.atomic.AtomicLong java.sql.ResultSet ), (Ljava/sql/ResultSet;)V)((AtomicLong)numRows));
                                                    if (numRows.get() <= largeTableCount) {
                                                        statementFactory = (JdbcConnection.StatementFactory)LambdaMetafactory.metafactory(null, null, null, (Ljava/sql/Connection;)Ljava/sql/Statement;, createStatement(java.sql.Connection ), (Ljava/sql/Connection;)Ljava/sql/Statement;)((SnapshotReader)this);
                                                    }
                                                    rowCountStr.set(numRows.toString());
                                                }
                                                catch (SQLException e) {
                                                    this.logger.debug("Error while getting number of rows in table {}: {}", new Object[]{tableId, e.getMessage(), e});
                                                }
                                            }
                                            start = clock.currentTimeInMillis();
                                            this.logger.info("Step {}: - scanning table '{}' ({} of {} tables)", new Object[]{step, tableId, ++counter, capturedTableIds.size()});
                                            selectOverrides = this.context.getConnectorConfig().getSnapshotSelectOverridesByTable();
                                            selectStatement = selectOverrides.getOrDefault(tableId, "SELECT * FROM " + this.quote(tableId));
                                            this.logger.info("For table '{}' using select statement: '{}'", (Object)tableId, (Object)selectStatement);
                                            sql.set(selectStatement);
                                            try {
                                                stepNum = step;
                                                mysql.query(sql.get(), statementFactory, (JdbcConnection.ResultSetConsumer)LambdaMetafactory.metafactory(null, null, null, (Ljava/sql/ResultSet;)V, lambda$execute$16(io.debezium.connector.mysql.legacy.MySqlSchema io.debezium.relational.TableId io.debezium.connector.mysql.legacy.RecordMakers$RecordsForTable io.debezium.util.Clock java.util.concurrent.atomic.AtomicLong int java.util.concurrent.atomic.AtomicReference long java.util.concurrent.atomic.AtomicLong java.util.concurrent.atomic.AtomicBoolean java.sql.ResultSet ), (Ljava/sql/ResultSet;)V)((SnapshotReader)this, (MySqlSchema)schema, (TableId)tableId, (RecordMakers.RecordsForTable)recordMaker, (Clock)clock, (AtomicLong)rowNum, (int)stepNum, rowCountStr, (long)start, (AtomicLong)totalRowCount, (AtomicBoolean)interrupted));
                                            }
                                            finally {
                                                this.metrics.dataCollectionSnapshotCompleted((DataCollectionId)tableId, rowNum.get());
                                                if (interrupted.get()) break;
                                            }
                                        }
                                        ++completedCounter;
                                    }
                                    if (this.isRunning() && !interrupted.get()) break block207;
                                    rolledBack = false;
                                    if (!isTxnStarted) break block208;
                                    if (interrupted.get() || !this.isRunning()) {
                                        this.logger.info("Step {}: rolling back transaction after abort", (Object)step++);
                                        mysql.connection().rollback();
                                        this.metrics.snapshotAborted();
                                        rolledBack = true;
                                    } else {
                                        this.logger.info("Step {}: committing transaction", (Object)step++);
                                        mysql.connection().commit();
                                        this.metrics.snapshotCompleted();
                                    }
                                    break block219;
                                }
                                mysql.connection().rollback();
                            }
                            if (isLocked && !rolledBack) {
                                if (tableLocks) {
                                    this.logger.info("Step {}: releasing table read locks to enable MySQL writes", (Object)step++);
                                } else {
                                    this.logger.info("Step {}: releasing global read lock to enable MySQL writes", (Object)step++);
                                }
                                sql.set("UNLOCK TABLES");
                                mysql.executeWithoutCommitting(new String[]{sql.get()});
                                isLocked = false;
                                lockReleased = clock.currentTimeInMillis();
                                this.metrics.globalLockReleased();
                                if (this.logger.isInfoEnabled()) {
                                    if (tableLocks) {
                                        this.logger.info("Writes to MySQL prevented for a total of {}", (Object)Strings.duration((long)(lockReleased - lockAcquired)));
                                    } else {
                                        this.logger.info("Writes to MySQL tables prevented for a total of {}", (Object)Strings.duration((long)(lockReleased - lockAcquired)));
                                    }
                                }
                                if (!tablesToSnapshotSchemaAfterUnlock.isEmpty()) {
                                    this.logger.info("Step {}: reading table schema for non-whitelisted tables", (Object)step++);
                                    for (TableId tableId : tablesToSnapshotSchemaAfterUnlock) {
                                        if (!this.isRunning()) {
                                            break;
                                        }
                                        this.readTableSchema(sql, mysql, schema, source, tableId.catalog(), tableId);
                                    }
                                }
                            }
                            return;
                        }
                        try {
                            block209: {
                                source.markLastSnapshot(configuration);
                                stop = clock.currentTimeInMillis();
                                try {
                                    bufferedRecordQueue.close((Function<SourceRecord, SourceRecord>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, replaceOffsetAndSource(org.apache.kafka.connect.source.SourceRecord ), (Lorg/apache/kafka/connect/source/SourceRecord;)Lorg/apache/kafka/connect/source/SourceRecord;)((SnapshotReader)this));
                                    if (this.logger.isInfoEnabled()) {
                                        this.logger.info("Step {}: scanned {} rows in {} tables in {}", new Object[]{step, totalRowCount, capturedTableIds.size(), Strings.duration((long)(stop - startScan))});
                                    }
                                    break block209;
                                }
                                catch (InterruptedException e) {
                                    Thread.currentThread().interrupt();
                                    if (this.logger.isInfoEnabled()) {
                                        this.logger.info("Step {}: aborting the snapshot after {} rows in {} of {} tables {}", new Object[]{step, totalRowCount, completedCounter, capturedTableIds.size(), Strings.duration((long)(stop - startScan))});
                                    }
                                    interrupted.set(true);
                                }
                                break block209;
lbl528:
                                // 1 sources

                                this.logger.info("Step {}: encountered only schema based snapshot, skipping data snapshot", (Object)step);
                            }
                            ++step;
                            rolledBack = false;
                            if (!isTxnStarted) break block210;
                        }
                        catch (Throwable var55_103) {
                            rolledBack = false;
                            if (isTxnStarted) {
                                if (interrupted.get() || !this.isRunning()) {
                                    this.logger.info("Step {}: rolling back transaction after abort", (Object)step++);
                                    mysql.connection().rollback();
                                    this.metrics.snapshotAborted();
                                    rolledBack = true;
                                } else {
                                    this.logger.info("Step {}: committing transaction", (Object)step++);
                                    mysql.connection().commit();
                                    this.metrics.snapshotCompleted();
                                }
                            } else {
                                mysql.connection().rollback();
                            }
                            if (isLocked && !rolledBack) {
                                if (tableLocks) {
                                    this.logger.info("Step {}: releasing table read locks to enable MySQL writes", (Object)step++);
                                } else {
                                    this.logger.info("Step {}: releasing global read lock to enable MySQL writes", (Object)step++);
                                }
                                sql.set("UNLOCK TABLES");
                                mysql.executeWithoutCommitting(new String[]{(String)sql.get()});
                                isLocked = false;
                                lockReleased = clock.currentTimeInMillis();
                                this.metrics.globalLockReleased();
                                if (this.logger.isInfoEnabled()) {
                                    if (tableLocks) {
                                        this.logger.info("Writes to MySQL prevented for a total of {}", (Object)Strings.duration((long)(lockReleased - lockAcquired)));
                                    } else {
                                        this.logger.info("Writes to MySQL tables prevented for a total of {}", (Object)Strings.duration((long)(lockReleased - lockAcquired)));
                                    }
                                }
                                if (!tablesToSnapshotSchemaAfterUnlock.isEmpty()) {
                                    this.logger.info("Step {}: reading table schema for non-whitelisted tables", (Object)step++);
                                    for (TableId tableId : tablesToSnapshotSchemaAfterUnlock) {
                                        if (!this.isRunning()) break;
                                        this.readTableSchema(sql, mysql, schema, source, tableId.catalog(), tableId);
                                    }
                                }
                            }
                            throw var55_103;
                        }
                        if (interrupted.get() || !this.isRunning()) {
                            this.logger.info("Step {}: rolling back transaction after abort", (Object)step++);
                            mysql.connection().rollback();
                            this.metrics.snapshotAborted();
                            rolledBack = true;
                        } else {
                            this.logger.info("Step {}: committing transaction", (Object)step++);
                            mysql.connection().commit();
                            this.metrics.snapshotCompleted();
                        }
                        break block220;
                    }
                    mysql.connection().rollback();
                }
                if (isLocked && !rolledBack) {
                    if (tableLocks) {
                        this.logger.info("Step {}: releasing table read locks to enable MySQL writes", (Object)step++);
                    } else {
                        this.logger.info("Step {}: releasing global read lock to enable MySQL writes", (Object)step++);
                    }
                    sql.set("UNLOCK TABLES");
                    mysql.executeWithoutCommitting(new String[]{sql.get()});
                    isLocked = false;
                    lockReleased = clock.currentTimeInMillis();
                    this.metrics.globalLockReleased();
                    if (this.logger.isInfoEnabled()) {
                        if (tableLocks) {
                            this.logger.info("Writes to MySQL prevented for a total of {}", (Object)Strings.duration((long)(lockReleased - lockAcquired)));
                        } else {
                            this.logger.info("Writes to MySQL tables prevented for a total of {}", (Object)Strings.duration((long)(lockReleased - lockAcquired)));
                        }
                    }
                    if (!tablesToSnapshotSchemaAfterUnlock.isEmpty()) {
                        this.logger.info("Step {}: reading table schema for non-whitelisted tables", (Object)step++);
                        for (TableId tableId : tablesToSnapshotSchemaAfterUnlock) {
                            if (this.isRunning()) {
                                this.readTableSchema(sql, mysql, schema, source, tableId.catalog(), tableId);
                                continue;
                            }
                            break;
                        }
                    }
                }
                if (!this.isRunning()) {
                    try {
                        this.completeSuccessfully();
                        if (this.logger.isInfoEnabled()) {
                            stop = clock.currentTimeInMillis();
                            this.logger.info("Stopped snapshot after {} but before completing", (Object)Strings.duration((long)(stop - ts)));
                        }
                        break block212;
                    }
                    finally {
                        this.cleanupResources();
                    }
                }
                try {
                    source.completeSnapshot();
                    Heartbeat.create((Duration)configuration.getDuration(Heartbeat.HEARTBEAT_INTERVAL, (TemporalUnit)ChronoUnit.MILLIS), (String)this.context.topicSelector().getHeartbeatTopic(), (String)this.context.getConnectorConfig().getLogicalName()).forcedBeat(source.partition(), source.offset(), (BlockingConsumer)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, enqueueRecord(org.apache.kafka.connect.source.SourceRecord ), (Lorg/apache/kafka/connect/source/SourceRecord;)V)((SnapshotReader)this));
                }
                finally {
                    this.completeSuccessfully();
                    if (this.logger.isInfoEnabled()) {
                        stop = clock.currentTimeInMillis();
                        this.logger.info("Completed snapshot in {}", (Object)Strings.duration((long)(stop - ts)));
                    }
                }
            }
            catch (Throwable e) {
                this.failed(e, "Aborting snapshot due to error when last running '" + (String)sql.get() + "': " + e.getMessage());
                if (!isLocked) break block212;
                try {
                    sql.set("UNLOCK TABLES");
                    mysql.executeWithoutCommitting(new String[]{(String)sql.get()});
                }
                catch (Exception eUnlock) {
                    this.logger.error("Removing of table locks not completed successfully", (Throwable)eUnlock);
                }
                try {
                    mysql.connection().rollback();
                }
                catch (Exception eRollback) {
                    this.logger.error("Execption while rollback is executed", (Throwable)eRollback);
                }
            }
            finally {
                try {
                    mysql.close();
                }
                catch (SQLException e) {
                    this.logger.warn("Failed to close the connection properly", (Throwable)e);
                }
            }
        }
    }

    private void readTableSchema(AtomicReference<String> sql, JdbcConnection mysql, MySqlSchema schema, SourceInfo source, String dbName, TableId tableId) throws SQLException {
        sql.set("SHOW CREATE TABLE " + this.quote(tableId));
        mysql.query(sql.get(), rs -> {
            if (rs.next()) {
                schema.applyDdl(source, dbName, rs.getString(2), this::enqueueSchemaChanges);
            }
        });
    }

    private boolean shouldRecordTableSchema(MySqlSchema schema, Filters filters, TableId id) {
        if (filters.ignoredTableFilter().test(id)) {
            return false;
        }
        return filters.tableFilter().test(id) || !schema.isStoreOnlyCapturedTablesDdl();
    }

    protected void readBinlogPosition(int step, SourceInfo source, JdbcConnection mysql, AtomicReference<String> sql) throws SQLException {
        if (this.context.isSchemaOnlyRecoverySnapshot()) {
            if (Strings.isNullOrEmpty((String)source.binlogFilename())) {
                throw new IllegalStateException("Could not find existing binlog information while attempting schema only recovery snapshot");
            }
            source.startSnapshot();
        } else {
            this.logger.info("Step {}: read binlog position of MySQL primary server", (Object)step);
            String showMasterStmt = "SHOW MASTER STATUS";
            sql.set(showMasterStmt);
            mysql.query(sql.get(), rs -> {
                if (rs.next()) {
                    String binlogFilename = rs.getString(1);
                    long binlogPosition = rs.getLong(2);
                    source.setBinlogStartPoint(binlogFilename, binlogPosition);
                    if (rs.getMetaData().getColumnCount() > 4) {
                        String gtidSet = rs.getString(5);
                        source.setCompletedGtidSet(gtidSet);
                        this.logger.info("\t using binlog '{}' at position '{}' and gtid '{}'", new Object[]{binlogFilename, binlogPosition, gtidSet});
                    } else {
                        this.logger.info("\t using binlog '{}' at position '{}'", (Object)binlogFilename, (Object)binlogPosition);
                    }
                } else {
                    throw new IllegalStateException("Cannot read the binlog filename and position via '" + showMasterStmt + "'. Make sure your server is correctly configured");
                }
                source.startSnapshot();
            });
        }
    }

    private Filters getCreateTableFilters(Filters filters) {
        MySqlConnectorConfig.SnapshotNewTables snapshotNewTables = this.context.getConnectorConfig().getSnapshotNewTables();
        if (snapshotNewTables == MySqlConnectorConfig.SnapshotNewTables.PARALLEL) {
            return new Filters.Builder(this.context.config()).build();
        }
        return filters;
    }

    protected String quote(String dbOrTableName) {
        return "`" + dbOrTableName + "`";
    }

    protected String quote(TableId id) {
        return this.quote(id.catalog()) + "." + this.quote(id.table());
    }

    private Statement createStatementWithLargeResultSet(Connection connection) throws SQLException {
        int fetchSize = this.context.getConnectorConfig().getSnapshotFetchSize();
        Statement stmt = connection.createStatement(1003, 1007);
        stmt.setFetchSize(fetchSize);
        return stmt;
    }

    private Statement createStatement(Connection connection) throws SQLException {
        return connection.createStatement();
    }

    private void logServerInformation(JdbcConnection mysql) {
        try {
            this.logger.info("MySQL server variables related to change data capture:");
            mysql.query("SHOW VARIABLES WHERE Variable_name REGEXP 'version|binlog|tx_|gtid|character_set|collation|time_zone'", rs -> {
                while (rs.next()) {
                    this.logger.info("\t{} = {}", (Object)Strings.pad((String)rs.getString(1), (int)45, (char)' '), (Object)Strings.pad((String)rs.getString(2), (int)45, (char)' '));
                }
            });
        }
        catch (SQLException e) {
            this.logger.info("Cannot determine MySql server version", (Throwable)e);
        }
    }

    private void logRolesForCurrentUser(JdbcConnection mysql) {
        try {
            ArrayList grants = new ArrayList();
            mysql.query("SHOW GRANTS FOR CURRENT_USER", rs -> {
                while (rs.next()) {
                    grants.add(rs.getString(1));
                }
            });
            if (grants.isEmpty()) {
                this.logger.warn("Snapshot is using user '{}' but it likely doesn't have proper privileges. If tables are missing or are empty, ensure connector is configured with the correct MySQL user and/or ensure that the MySQL user has the required privileges.", (Object)mysql.username());
            } else {
                this.logger.info("Snapshot is using user '{}' with these MySQL grants:", (Object)mysql.username());
                grants.forEach(grant -> this.logger.info("\t{}", grant));
            }
        }
        catch (SQLException e) {
            this.logger.info("Cannot determine the privileges for '{}' ", (Object)mysql.username(), (Object)e);
        }
    }

    protected SourceRecord replaceOffsetAndSource(SourceRecord record) {
        if (record == null) {
            return null;
        }
        Map<String, ?> newOffset = this.context.source().offset();
        Struct envelope = (Struct)record.value();
        Struct source = (Struct)envelope.get("source");
        if (SnapshotRecord.fromSource((Struct)source) == SnapshotRecord.TRUE) {
            SnapshotRecord.LAST.toSource(source);
        }
        return new SourceRecord(record.sourcePartition(), newOffset, record.topic(), record.kafkaPartition(), record.keySchema(), record.key(), record.valueSchema(), record.value());
    }

    protected void enqueueSchemaChanges(String dbName, Set<TableId> tables, String ddlStatement) {
        if (!this.context.includeSchemaChangeRecords() || ddlStatement.length() == 0) {
            return;
        }
        if (this.context.makeRecord().schemaChanges(dbName, tables, ddlStatement, (BlockingConsumer<SourceRecord>)((BlockingConsumer)x$0 -> super.enqueueRecord((SourceRecord)x$0))) > 0) {
            this.logger.info("\t{}", (Object)ddlStatement);
        }
    }

    protected void recordRowAsRead(RecordMakers.RecordsForTable recordMaker, Object[] row, Instant ts) throws InterruptedException {
        recordMaker.read(row, ts);
    }

    protected void recordRowAsInsert(RecordMakers.RecordsForTable recordMaker, Object[] row, Instant ts) throws InterruptedException {
        recordMaker.create(row, ts);
    }

    private /* synthetic */ void lambda$execute$16(MySqlSchema schema, TableId tableId, RecordMakers.RecordsForTable recordMaker, Clock clock, AtomicLong rowNum, int stepNum, AtomicReference rowCountStr, long start, AtomicLong totalRowCount, AtomicBoolean interrupted, ResultSet rs) throws SQLException {
        try {
            Table table = schema.tableFor(tableId);
            int numColumns = table.columns().size();
            Object[] row = new Object[numColumns];
            while (rs.next()) {
                int i = 0;
                int j = 1;
                while (i != numColumns) {
                    Column actualColumn = (Column)table.columns().get(i);
                    row[i] = this.mysqlFieldReader.readField(rs, j, actualColumn, table);
                    ++i;
                    ++j;
                }
                this.recorder.recordRow(recordMaker, row, clock.currentTimeAsInstant());
                rowNum.incrementAndGet();
                if (rowNum.get() % 100L == 0L && !this.isRunning()) break;
                if (rowNum.get() % 10000L != 0L) continue;
                if (this.logger.isInfoEnabled()) {
                    long stop = clock.currentTimeInMillis();
                    this.logger.info("Step {}: - {} of {} rows scanned from table '{}' after {}", new Object[]{stepNum, rowNum, rowCountStr, tableId, Strings.duration((long)(stop - start))});
                }
                this.metrics.rowsScanned(tableId, rowNum.get());
            }
            totalRowCount.addAndGet(rowNum.get());
            if (this.isRunning()) {
                if (this.logger.isInfoEnabled()) {
                    long stop = clock.currentTimeInMillis();
                    this.logger.info("Step {}: - Completed scanning a total of {} rows from table '{}' after {}", new Object[]{stepNum, rowNum, tableId, Strings.duration((long)(stop - start))});
                }
                this.metrics.rowsScanned(tableId, rowNum.get());
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.logger.info("Step {}: Stopping the snapshot due to thread interruption", (Object)stepNum);
            interrupted.set(true);
        }
    }

    private static /* synthetic */ void lambda$execute$15(AtomicLong numRows, ResultSet rs) throws SQLException {
        if (rs.next()) {
            numRows.set(rs.getLong(5));
        }
    }

    private /* synthetic */ void lambda$execute$14(SourceRecord x$0) throws InterruptedException {
        super.enqueueRecord(x$0);
    }

    private /* synthetic */ void lambda$execute$13(MySqlSchema schema, SourceInfo source, String missingDbName) {
        schema.applyDdl(source, missingDbName, "DROP DATABASE IF EXISTS " + this.quote(missingDbName), this::enqueueSchemaChanges);
    }

    private /* synthetic */ boolean lambda$execute$12(String id) {
        return this.isRunning();
    }

    private /* synthetic */ void lambda$execute$11(MySqlSchema schema, SourceInfo source, TableId tableId) {
        schema.applyDdl(source, tableId.catalog(), "DROP TABLE IF EXISTS " + this.quote(tableId), this::enqueueSchemaChanges);
    }

    private /* synthetic */ boolean lambda$execute$10(TableId id) {
        return this.isRunning();
    }

    private static /* synthetic */ String lambda$execute$9(String r, String element) {
        return r + "," + element;
    }

    private /* synthetic */ String lambda$execute$8(TableId tid) {
        return this.quote(tid);
    }

    private static /* synthetic */ void lambda$execute$7(List capturedTableIds, List tableIdsSorted, Pattern pattern) {
        List<TableId> tablesMatchedByPattern = capturedTableIds.stream().filter(t -> pattern.asPredicate().test(t.toString())).collect(Collectors.toList());
        tablesMatchedByPattern.forEach(t -> {
            if (!tableIdsSorted.contains(t)) {
                tableIdsSorted.add(t);
            }
        });
    }

    private /* synthetic */ void lambda$execute$4(String dbName, MySqlSchema schema, Filters filters, Filters createTableFilters, Map createTablesMap, List knownTableIds, Predicate isAllowedForSnapshot, List capturedTableIds, ResultSet rs) throws SQLException {
        while (rs.next() && this.isRunning()) {
            TableId id = new TableId(dbName, null, rs.getString(1));
            boolean shouldRecordTableSchema = this.shouldRecordTableSchema(schema, filters, id);
            if (createTableFilters == filters && shouldRecordTableSchema || createTableFilters.tableFilter().test(id)) {
                createTablesMap.computeIfAbsent(dbName, k -> new ArrayList()).add(id);
            }
            if (shouldRecordTableSchema) {
                knownTableIds.add(id);
                this.logger.info("\t including '{}' among known tables", (Object)id);
            } else {
                this.logger.info("\t '{}' is not added among known tables", (Object)id);
            }
            if (filters.tableFilter().and(isAllowedForSnapshot).test(id)) {
                capturedTableIds.add(id);
                this.logger.info("\t including '{}' for further processing", (Object)id);
                continue;
            }
            this.logger.info("\t '{}' is filtered out of capturing", (Object)id);
        }
    }

    private static /* synthetic */ void lambda$execute$2(List databaseNames, ResultSet rs) throws SQLException {
        while (rs.next()) {
            databaseNames.add(rs.getString(1));
        }
    }

    private static /* synthetic */ boolean lambda$execute$1(Set snapshotAllowedTables, TableId tableId) {
        return snapshotAllowedTables.size() == 0 || snapshotAllowedTables.stream().anyMatch(s -> tableId.identifier().matches((String)s));
    }

    protected static interface RecordRecorder {
        public void recordRow(RecordMakers.RecordsForTable var1, Object[] var2, Instant var3) throws InterruptedException;
    }
}

