/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core;

import io.lettuce.core.CompositeArgument;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.protocol.CommandArgs;
import io.lettuce.core.protocol.CommandKeyword;
import java.time.Duration;
import java.time.Instant;

public class HSetExArgs
implements CompositeArgument {
    private Long ex;
    private Long exAt;
    private Long px;
    private Long pxAt;
    private boolean fnx = false;
    private boolean fxx = false;
    private boolean keepttl = false;

    public HSetExArgs ex(Duration timeout) {
        LettuceAssert.notNull((Object)timeout, "Timeout must not be null");
        this.ex = timeout.getSeconds();
        return this;
    }

    public HSetExArgs exAt(Instant timestamp) {
        LettuceAssert.notNull((Object)timestamp, "Timestamp must not be null");
        this.exAt = timestamp.getEpochSecond();
        return this;
    }

    public HSetExArgs px(Duration timeout) {
        LettuceAssert.notNull((Object)timeout, "Timeout must not be null");
        this.px = timeout.toMillis();
        return this;
    }

    public HSetExArgs pxAt(Instant timestamp) {
        LettuceAssert.notNull((Object)timestamp, "Timestamp must not be null");
        this.pxAt = timestamp.toEpochMilli();
        return this;
    }

    public HSetExArgs fnx() {
        this.fnx = true;
        return this;
    }

    public HSetExArgs keepttl() {
        this.keepttl = true;
        return this;
    }

    public HSetExArgs fxx() {
        this.fxx = true;
        return this;
    }

    @Override
    public <K, V> void build(CommandArgs<K, V> args) {
        if (this.ex != null) {
            args.add("EX").add(this.ex);
        }
        if (this.exAt != null) {
            args.add("EXAT").add(this.exAt);
        }
        if (this.px != null) {
            args.add("PX").add(this.px);
        }
        if (this.pxAt != null) {
            args.add("PXAT").add(this.pxAt);
        }
        if (this.fnx) {
            args.add(CommandKeyword.FNX);
        }
        if (this.fxx) {
            args.add(CommandKeyword.FXX);
        }
        if (this.keepttl) {
            args.add("KEEPTTL");
        }
    }

    public static class Builder {
        private Builder() {
        }

        public static HSetExArgs ex(Duration timeout) {
            return new HSetExArgs().ex(timeout);
        }

        public static HSetExArgs exAt(Instant timestamp) {
            return new HSetExArgs().exAt(timestamp);
        }

        public static HSetExArgs px(Duration timeout) {
            return new HSetExArgs().px(timeout);
        }

        public static HSetExArgs pxAt(Instant timestamp) {
            return new HSetExArgs().pxAt(timestamp);
        }

        public static HSetExArgs fnx() {
            return new HSetExArgs().fnx();
        }

        public static HSetExArgs xx() {
            return new HSetExArgs().fxx();
        }

        public static HSetExArgs keepttl() {
            return new HSetExArgs().keepttl();
        }
    }
}

