/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.tracing.contextpropagation;

import io.micrometer.context.ThreadLocalAccessor;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationRegistry;
import io.micrometer.tracing.Span;
import io.micrometer.tracing.Tracer;
import io.micrometer.tracing.handler.TracingObservationHandler;
import java.util.Objects;

public class ObservationAwareSpanThreadLocalAccessor
implements ThreadLocalAccessor<Span> {
    public static final String KEY = "micrometer.tracing";
    private final ObservationRegistry registry;
    private final Tracer tracer;

    public ObservationAwareSpanThreadLocalAccessor(Tracer tracer) {
        this(ObservationRegistry.create(), tracer);
    }

    public ObservationAwareSpanThreadLocalAccessor(ObservationRegistry observationRegistry, Tracer tracer) {
        this.registry = Objects.requireNonNull(observationRegistry, "observationRegistry must not be null");
        this.tracer = Objects.requireNonNull(tracer, "tracer must not be null");
    }

    public Object key() {
        return KEY;
    }

    public Span getValue() {
        Observation currentObservation = this.registry.getCurrentObservation();
        if (currentObservation != null) {
            TracingObservationHandler.TracingContext tracingContext = (TracingObservationHandler.TracingContext)currentObservation.getContextView().getOrDefault(TracingObservationHandler.TracingContext.class, (Object)new TracingObservationHandler.TracingContext());
            Span currentSpan = this.tracer.currentSpan();
            if (currentSpan != null && !currentSpan.equals(tracingContext.getSpan())) {
                return currentSpan;
            }
            currentObservation.getContext().put((Object)"micrometer.tracing.handled-by-observation", (Object)true);
            return null;
        }
        return this.tracer.currentSpan();
    }

    public void setValue(Span value) {
        this.tracer.withSpan(value);
    }

    public void reset() {
        Observation currentObservation = this.registry.getCurrentObservation();
        boolean handledByObservation = false;
        if (currentObservation != null) {
            handledByObservation = (Boolean)currentObservation.getContext().getOrDefault((Object)"micrometer.tracing.handled-by-observation", (Object)false);
        }
        if (!handledByObservation) {
            this.tracer.withSpan(null);
        } else {
            currentObservation.getContext().remove((Object)"micrometer.tracing.handled-by-observation");
        }
    }
}

