/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.jwt.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.security.jwt.Consumer;
import com.ibm.websphere.security.jwt.InvalidConsumerException;
import com.ibm.websphere.security.jwt.InvalidTokenException;
import com.ibm.websphere.security.jwt.JwtToken;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.jwt.config.ConsumerUtils;
import com.ibm.ws.security.jwt.config.JwtConsumerConfig;
import com.ibm.ws.ssl.KeyStoreService;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceMap;
import java.util.Map;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={Consumer.class}, immediate=true, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM"}, name="consumer")
public class ConsumerImpl
implements Consumer {
    private static final TraceComponent tc = Tr.register(ConsumerImpl.class, (String)"JWTBUILDER", (String)"com.ibm.ws.security.jwt.internal.resources.JWTMessages");
    private String configId = "defaultJwtConsumer";
    private static boolean active = false;
    private static final String KEY_JWT_CONSUMER_SERVICE = "jwtConsumerConfig";
    private static final String KEY_KEYSTORE_SERVICE = "keyStoreService";
    private static final String CFG_KEY_ID = "id";
    private static ConcurrentServiceReferenceMap<String, JwtConsumerConfig> jwtServiceMapRef = new ConcurrentServiceReferenceMap("jwtConsumerConfig");
    private static AtomicServiceReference<KeyStoreService> keyStoreServiceRef = new AtomicServiceReference("keyStoreService");
    static final long serialVersionUID = 8572723232957933525L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference(service=JwtConsumerConfig.class, name="jwtConsumerConfig", policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MULTIPLE, policyOption=ReferencePolicyOption.RELUCTANT)
    protected void setJwtConsumerConfig(ServiceReference<JwtConsumerConfig> ref) {
        ConcurrentServiceReferenceMap<String, JwtConsumerConfig> concurrentServiceReferenceMap = jwtServiceMapRef;
        synchronized (concurrentServiceReferenceMap) {
            jwtServiceMapRef.putReference((Object)((String)ref.getProperty(CFG_KEY_ID)), ref);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unsetJwtConsumerConfig(ServiceReference<JwtConsumerConfig> ref) {
        ConcurrentServiceReferenceMap<String, JwtConsumerConfig> concurrentServiceReferenceMap = jwtServiceMapRef;
        synchronized (concurrentServiceReferenceMap) {
            jwtServiceMapRef.removeReference((Object)((String)ref.getProperty(CFG_KEY_ID)), ref);
        }
    }

    @Reference(service=KeyStoreService.class, name="keyStoreService", policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL, policyOption=ReferencePolicyOption.GREEDY)
    protected void setKeyStoreService(ServiceReference<KeyStoreService> ref) {
        keyStoreServiceRef.setReference(ref);
    }

    protected void unsetKeyStoreService(ServiceReference<KeyStoreService> ref) {
        keyStoreServiceRef.unsetReference(ref);
    }

    @Activate
    protected void activate(ComponentContext cc) {
        jwtServiceMapRef.activate(cc);
        keyStoreServiceRef.activate(cc);
        active = true;
        Tr.info((TraceComponent)tc, (String)"JWT_CONSUMER_SERVICE_ACTIVATED", (Object[])new Object[0]);
    }

    @Modified
    protected void modify(Map<String, Object> properties) {
    }

    @Deactivate
    protected void deactivate(int reason, ComponentContext cc) {
        jwtServiceMapRef.deactivate(cc);
        keyStoreServiceRef.deactivate(cc);
        active = false;
    }

    public ConsumerImpl() {
        this("defaultJwtConsumer");
    }

    public ConsumerImpl(String consumerConfigId) {
        if (consumerConfigId == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Null config ID provided; using defaultJwtConsumer instead", (Object[])new Object[0]);
            }
            consumerConfigId = "defaultJwtConsumer";
        }
        if (consumerConfigId.equals("")) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Blank config ID provided; using defaultJwtConsumer instead", (Object[])new Object[0]);
            }
            consumerConfigId = "defaultJwtConsumer";
        }
        this.configId = consumerConfigId;
    }

    @Override
    public synchronized Consumer create() throws InvalidConsumerException {
        if (!active) {
            String err = Tr.formatMessage((TraceComponent)tc, (String)"JWT_CONSUMER_SERVICE_NOT_ACTIVATED", (Object[])new Object[0]);
            throw new InvalidConsumerException(err);
        }
        return this.create("defaultJwtConsumer");
    }

    @Override
    public synchronized Consumer create(String consumerConfigId) throws InvalidConsumerException {
        if (!active) {
            String err = Tr.formatMessage((TraceComponent)tc, (String)"JWT_CONSUMER_SERVICE_NOT_ACTIVATED", (Object[])new Object[0]);
            throw new InvalidConsumerException(err);
        }
        if (consumerConfigId == null) {
            String err = Tr.formatMessage((TraceComponent)tc, (String)"JWT_CONSUMER_NULL_ID", (Object[])new Object[0]);
            throw new InvalidConsumerException(err);
        }
        return new ConsumerImpl(consumerConfigId);
    }

    @Override
    @FFDCIgnore(value={Exception.class})
    public JwtToken createJwt(String encodedTokenString) throws InvalidTokenException, InvalidConsumerException {
        JwtConsumerConfig config = (JwtConsumerConfig)jwtServiceMapRef.getService((Object)this.configId);
        if (config == null) {
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"JWT_CONSUMER_CONFIG_NOT_FOUND", (Object[])new Object[]{this.configId});
            throw new InvalidConsumerException(msg);
        }
        if (encodedTokenString == null || encodedTokenString.isEmpty()) {
            String errorMsg = Tr.formatMessage((TraceComponent)tc, (String)"JWT_CONSUMER_NULL_OR_EMPTY_STRING", (Object[])new Object[]{this.configId, encodedTokenString});
            throw new InvalidTokenException(errorMsg);
        }
        ConsumerUtils util = config.getConsumerUtils();
        if (util == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("ConsumerUtil object was not found for config [" + this.configId + "]"), (Object[])new Object[0]);
            }
            return null;
        }
        JwtToken token = null;
        try {
            token = util.parseJwt(encodedTokenString, config);
        }
        catch (Exception e) {
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"JWT_ERROR_PROCESSING_JWT", (Object[])new Object[]{this.configId, e.getLocalizedMessage()});
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)msg, (Object[])new Object[0]);
            }
            throw new InvalidTokenException(msg, e);
        }
        return token;
    }
}

