/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ejbcontainer.jitdeploy;

import com.ibm.ejs.container.EJBConfigurationException;
import com.ibm.ejs.container.util.DeploymentUtil;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ejbcontainer.jitdeploy.CORBA_Utils;
import com.ibm.ws.ejbcontainer.jitdeploy.HashSorter;
import com.ibm.ws.ejbcontainer.jitdeploy.JITUtils;
import com.ibm.ws.ejbcontainer.jitdeploy.RMItoIDL;
import com.ibm.wsspi.ejbcontainer.JITDeploy;
import java.rmi.Remote;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;

public final class JIT_Tie {
    private static final TraceComponent tc = Tr.register(JIT_Tie.class, (String)"JITDeploy", (String)"com.ibm.ejs.container.container");

    static String getTieClassName(String remoteClassName) {
        StringBuilder tieBuilder = new StringBuilder(remoteClassName);
        int packageOffset = Math.max(remoteClassName.lastIndexOf(46) + 1, remoteClassName.lastIndexOf(36) + 1);
        tieBuilder.insert(packageOffset, '_');
        tieBuilder.append("_Tie");
        return tieBuilder.toString();
    }

    static byte[] generateClassBytes(String tieClassName, String servantClassName, Class<?> remoteInterface, java.lang.reflect.Method[] remoteMethods, String[] idlNames, int rmicCompatible, boolean portableServer) throws EJBConfigurationException {
        int numMethods = remoteMethods.length;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        String internalTieClassName = JITUtils.convertClassName(tieClassName);
        String internalServantClassName = JITUtils.convertClassName(servantClassName);
        String internalInterfaceName = JITUtils.convertClassName(remoteInterface.getName());
        String servantDescriptor = "L" + internalServantClassName + ";";
        boolean isRmiRemote = Remote.class.isAssignableFrom(remoteInterface);
        if (isTraceOn) {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"generateClassBytes", (Object[])new Object[0]);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("     className = " + internalTieClassName), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("     interface = " + internalInterfaceName), (Object[])new Object[0]);
                if (isRmiRemote) {
                    Tr.debug((TraceComponent)tc, (String)"     implements java.rmi.Remote", (Object[])new Object[0]);
                }
            }
        }
        LinkedHashSet<String> classConstantFieldNames = new LinkedHashSet<String>();
        ClassWriter cw = new ClassWriter(1);
        String parentClassName = portableServer ? "org/omg/PortableServer/Servant" : "org/omg/CORBA_2_3/portable/ObjectImpl";
        cw.visit(46, 33, internalTieClassName, null, parentClassName, new String[]{"javax/rmi/CORBA/Tie"});
        String sourceFileName = tieClassName.substring(tieClassName.lastIndexOf(".") + 1) + ".java";
        cw.visitSource(sourceFileName, null);
        JIT_Tie.addFields(cw, servantDescriptor);
        JIT_Tie.initializeStaticFields(cw, internalTieClassName, remoteInterface);
        JIT_Tie.addCtor(cw, internalTieClassName, parentClassName, servantDescriptor);
        JIT_Tie.addCommonTieMethods(cw, internalTieClassName, internalServantClassName, servantDescriptor, portableServer);
        JIT_Tie.add_invokeMethod(cw, internalTieClassName, idlNames);
        for (int i = 0; i < numMethods; ++i) {
            JIT_Tie.addDelegateMethod(cw, internalTieClassName, classConstantFieldNames, internalServantClassName, servantDescriptor, remoteMethods[i], idlNames[i], isRmiRemote, rmicCompatible);
        }
        JITUtils.addClassConstantMembers((ClassVisitor)cw, classConstantFieldNames);
        cw.visitEnd();
        byte[] classBytes = cw.toByteArray();
        if (isTraceOn && tc.isDebugEnabled()) {
            JITUtils.writeToClassFile(internalTieClassName, classBytes);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("generateClassBytes: " + classBytes.length + " bytes"));
        }
        return classBytes;
    }

    private static void addFields(ClassWriter cw, String servantDescriptor) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("     adding field : target " + servantDescriptor), (Object[])new Object[0]);
        }
        FieldVisitor fv = cw.visitField(2, "target", servantDescriptor, null, null);
        fv.visitEnd();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"     adding field : orb Lorg/omg/CORBA/ORB;", (Object[])new Object[0]);
        }
        fv = cw.visitField(2, "orb", "Lorg/omg/CORBA/ORB;", null, null);
        fv.visitEnd();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"     adding field : _type_ids [Ljava/lang/String;", (Object[])new Object[0]);
        }
        fv = cw.visitField(26, "_type_ids", "[Ljava/lang/String;", null, null);
        fv.visitEnd();
    }

    private static void initializeStaticFields(ClassWriter cw, String tieClassName, Class<?> remoteInterface) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"     adding method : <clinit> ()V", (Object[])new Object[0]);
        }
        Method m = new Method("<clinit>", Type.VOID_TYPE, new Type[0]);
        GeneratorAdapter mg = new GeneratorAdapter(8, m, null, null, (ClassVisitor)cw);
        mg.visitCode();
        String[] remoteTypes = CORBA_Utils.getRemoteTypeIds(remoteInterface);
        mg.push(remoteTypes.length);
        mg.visitTypeInsn(189, "java/lang/String");
        for (int i = 0; i < remoteTypes.length; ++i) {
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("        _type_ids = " + remoteTypes[i]), (Object[])new Object[0]);
            }
            mg.visitInsn(89);
            mg.push(i);
            mg.visitLdcInsn((Object)remoteTypes[i]);
            mg.visitInsn(83);
        }
        mg.visitFieldInsn(179, tieClassName, "_type_ids", "[Ljava/lang/String;");
        mg.visitInsn(177);
        mg.endMethod();
        mg.visitEnd();
    }

    private static void addCtor(ClassWriter cw, String tieClassName, String parentClassName, String servantDescriptor) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"     adding method : <init> ()V", (Object[])new Object[0]);
        }
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, parentClassName, "<init>", "()V");
        mv.visitVarInsn(25, 0);
        mv.visitInsn(1);
        mv.visitFieldInsn(181, tieClassName, "target", servantDescriptor);
        mv.visitVarInsn(25, 0);
        mv.visitInsn(1);
        mv.visitFieldInsn(181, tieClassName, "orb", "Lorg/omg/CORBA/ORB;");
        mv.visitInsn(177);
        mv.visitMaxs(2, 1);
        mv.visitEnd();
    }

    private static void addCommonTieMethods(ClassWriter cw, String tieClassName, String servantClassName, String servantDescriptor, boolean portableServer) {
        Label try_end;
        Label try_begin;
        Label if_notnull_end;
        MethodVisitor mv;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (portableServer) {
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"     adding method : _all_interfaces(Lorg/omg/PortableServer/POA;[B)[Ljava/lang/String;", (Object[])new Object[0]);
            }
            mv = cw.visitMethod(1, "_all_interfaces", "(Lorg/omg/PortableServer/POA;[B)[Ljava/lang/String;", null, null);
        } else {
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"     adding method : _ids ()[Ljava/lang/String;", (Object[])new Object[0]);
            }
            mv = cw.visitMethod(1, "_ids", "()[Ljava/lang/String;", null, null);
        }
        mv.visitCode();
        mv.visitFieldInsn(178, tieClassName, "_type_ids", "[Ljava/lang/String;");
        mv.visitMethodInsn(182, "java/lang/Object", "clone", "()Ljava/lang/Object;");
        mv.visitTypeInsn(192, "[Ljava/lang/String;");
        mv.visitInsn(176);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        if (!portableServer) {
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"     adding method : _set_delegate (Lorg/omg/CORBA/portable/Delegate;)V", (Object[])new Object[0]);
            }
            mv = cw.visitMethod(1, "_set_delegate", "(Lorg/omg/CORBA/portable/Delegate;)V", null, null);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            mv.visitMethodInsn(183, "org/omg/CORBA/portable/ObjectImpl", "_set_delegate", "(Lorg/omg/CORBA/portable/Delegate;)V");
            mv.visitVarInsn(25, 1);
            Label if_notnull_else = new Label();
            mv.visitJumpInsn(198, if_notnull_else);
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(182, "org/omg/CORBA/portable/ObjectImpl", "_orb", "()Lorg/omg/CORBA/ORB;");
            mv.visitFieldInsn(181, tieClassName, "orb", "Lorg/omg/CORBA/ORB;");
            if_notnull_end = new Label();
            mv.visitJumpInsn(167, if_notnull_end);
            mv.visitLabel(if_notnull_else);
            mv.visitVarInsn(25, 0);
            mv.visitInsn(1);
            mv.visitFieldInsn(181, tieClassName, "orb", "Lorg/omg/CORBA/ORB;");
            mv.visitLabel(if_notnull_end);
            mv.visitInsn(177);
            mv.visitMaxs(2, 2);
            mv.visitEnd();
        }
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"     adding method : deactivate ()V", (Object[])new Object[0]);
        }
        mv = cw.visitMethod(1, "deactivate", "()V", null, null);
        mv.visitCode();
        if (portableServer) {
            try_begin = new Label();
            mv.visitLabel(try_begin);
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(182, tieClassName, "_poa", "()Lorg/omg/PortableServer/POA;");
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(182, tieClassName, "_poa", "()Lorg/omg/PortableServer/POA;");
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(182, "org/omg/PortableServer/POA", "servant_to_id", "(Lorg/omg/PortableServer/Servant;)[B");
            mv.visitMethodInsn(182, "org/omg/PortableServer/POA", "deactivate_object", "([B)V");
            mv.visitInsn(177);
            try_end = new Label();
            mv.visitLabel(try_end);
            Label catch_WrongPolicy_label = try_end;
            mv.visitInsn(87);
            mv.visitInsn(177);
            Label catch_ObjectNotActive_label = new Label();
            mv.visitLabel(catch_ObjectNotActive_label);
            mv.visitInsn(87);
            mv.visitInsn(177);
            Label catch_ServantNotActive_label = new Label();
            mv.visitLabel(catch_ServantNotActive_label);
            mv.visitInsn(87);
            mv.visitInsn(177);
            mv.visitTryCatchBlock(try_begin, try_end, catch_WrongPolicy_label, "org/omg/PortableServer/POAPackage/WrongPolicy");
            mv.visitTryCatchBlock(try_begin, try_end, catch_ObjectNotActive_label, "org/omg/PortableServer/POAPackage/ObjectNotActive");
            mv.visitTryCatchBlock(try_begin, try_end, catch_ServantNotActive_label, "org/omg/PortableServer/POAPackage/ServantNotActive");
        } else {
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, tieClassName, "orb", "Lorg/omg/CORBA/ORB;");
            if_notnull_end = new Label();
            mv.visitJumpInsn(198, if_notnull_end);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, tieClassName, "orb", "Lorg/omg/CORBA/ORB;");
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(182, "org/omg/CORBA/ORB", "disconnect", "(Lorg/omg/CORBA/Object;)V");
            mv.visitVarInsn(25, 0);
            mv.visitInsn(1);
            mv.visitMethodInsn(182, tieClassName, "_set_delegate", "(Lorg/omg/CORBA/portable/Delegate;)V");
            mv.visitLabel(if_notnull_end);
            mv.visitInsn(177);
        }
        mv.visitMaxs(2, 1);
        mv.visitEnd();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"     adding method : getTarget ()Ljava/rmi/Remote;", (Object[])new Object[0]);
        }
        mv = cw.visitMethod(1, "getTarget", "()Ljava/rmi/Remote;", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, tieClassName, "target", servantDescriptor);
        mv.visitInsn(176);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"     adding method : orb ()Lorg/omg/CORBA/ORB;", (Object[])new Object[0]);
        }
        mv = cw.visitMethod(1, "orb", "()Lorg/omg/CORBA/ORB;", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, tieClassName, "_orb", "()Lorg/omg/CORBA/ORB;");
        mv.visitInsn(176);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"     adding method : orb (Lorg/omg/CORBA/ORB;)V", (Object[])new Object[0]);
        }
        mv = cw.visitMethod(1, "orb", "(Lorg/omg/CORBA/ORB;)V", null, null);
        mv.visitCode();
        if (portableServer) {
            try_begin = new Label();
            mv.visitLabel(try_begin);
            mv.visitVarInsn(25, 1);
            mv.visitTypeInsn(192, "org/omg/CORBA_2_3/ORB");
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(182, "org/omg/CORBA_2_3/ORB", "set_delegate", "(Ljava/lang/Object;)V");
            mv.visitInsn(177);
            try_end = new Label();
            mv.visitLabel(try_end);
            Label catch_ClassCastException_label = try_end;
            mv.visitInsn(87);
            mv.visitTypeInsn(187, "org/omg/CORBA/BAD_PARAM");
            mv.visitInsn(89);
            mv.visitLdcInsn((Object)"POA Servant needs an org.omg.CORBA_2_3.ORB");
            mv.visitMethodInsn(183, "org/omg/CORBA/BAD_PARAM", "<init>", "(Ljava/lang/String;)V");
            mv.visitInsn(191);
            mv.visitTryCatchBlock(try_begin, try_end, catch_ClassCastException_label, "java/lang/ClassCastException");
        } else {
            mv.visitVarInsn(25, 1);
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(182, "org/omg/CORBA/ORB", "connect", "(Lorg/omg/CORBA/Object;)V");
            mv.visitInsn(177);
        }
        mv.visitMaxs(2, 2);
        mv.visitEnd();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"     adding method : setTarget (Ljava/rmi/Remote;)V", (Object[])new Object[0]);
        }
        mv = cw.visitMethod(1, "setTarget", "(Ljava/rmi/Remote;)V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, servantClassName);
        mv.visitFieldInsn(181, tieClassName, "target", servantDescriptor);
        mv.visitInsn(177);
        mv.visitMaxs(2, 2);
        mv.visitEnd();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"     adding method : orb (Lorg/omg/CORBA/ORB;)V", (Object[])new Object[0]);
        }
        mv = cw.visitMethod(1, "thisObject", "()Lorg/omg/CORBA/Object;", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        if (portableServer) {
            mv.visitMethodInsn(182, tieClassName, "_this_object", "()Lorg/omg/CORBA/Object;");
        }
        mv.visitInsn(176);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }

    private static void add_invokeMethod(ClassWriter cw, String tieClassName, String[] idlNames) {
        int i;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"     adding method : _invoke (Ljava/lang/String;Lorg/omg/CORBA/portable/InputStream;Lorg/omg/CORBA/portable/ResponseHandler;)Lorg/omg/CORBA/portable/OutputStream;", (Object[])new Object[0]);
        }
        Type returnType = CORBA_Utils.TYPE_CORBA_OutputStream;
        Type[] argTypes = new Type[]{JITUtils.TYPE_String, CORBA_Utils.TYPE_CORBA_InputStream, CORBA_Utils.TYPE_CORBA_ResponseHandler};
        Type[] exceptionTypes = new Type[]{CORBA_Utils.TYPE_CORBA_SystemException};
        Method m = new Method("_invoke", returnType, argTypes);
        GeneratorAdapter mg = new GeneratorAdapter(1, m, null, exceptionTypes, (ClassVisitor)cw);
        mg.visitCode();
        Label try_begin = new Label();
        mg.visitLabel(try_begin);
        int in = mg.newLocal(CORBA_Utils.TYPE_CORBA_2_3_InputStream);
        mg.loadArg(1);
        mg.checkCast(CORBA_Utils.TYPE_CORBA_2_3_InputStream);
        mg.storeLocal(in);
        int numMethods = idlNames.length;
        String[] sortedNames = (String[])idlNames.clone();
        Arrays.sort(sortedNames, new HashSorter());
        int numCases = 0;
        int[] case_keys = new int[numMethods];
        Label[] case_labels = new Label[numMethods];
        Label case_default = new Label();
        Label[] method_labels = new Label[numMethods];
        for (i = 0; i < numMethods; ++i) {
            Label method_label;
            method_labels[i] = method_label = new Label();
            int hashCode = sortedNames[i].hashCode();
            if (i != 0 && hashCode == sortedNames[i - 1].hashCode()) continue;
            case_keys[numCases] = hashCode;
            case_labels[numCases] = method_label;
            ++numCases;
        }
        if (numCases != numMethods) {
            int[] new_keys = new int[numCases];
            System.arraycopy(case_keys, 0, new_keys, 0, numCases);
            case_keys = new_keys;
            Label[] new_labels = new Label[numCases];
            System.arraycopy(case_labels, 0, new_labels, 0, numCases);
            case_labels = new_labels;
        }
        mg.loadArg(0);
        mg.visitMethodInsn(182, "java/lang/String", "hashCode", "()I");
        mg.visitLookupSwitchInsn(case_default, case_keys, case_labels);
        for (i = 0; i < numMethods; ++i) {
            mg.visitLabel(method_labels[i]);
            mg.loadArg(0);
            mg.push(sortedNames[i]);
            mg.visitMethodInsn(182, "java/lang/String", "equals", "(Ljava/lang/Object;)Z");
            int nextMethod = i + 1;
            Label next_label = case_default;
            if (nextMethod < numMethods) {
                next_label = method_labels[nextMethod];
            }
            mg.visitJumpInsn(153, next_label);
            mg.loadThis();
            mg.loadLocal(in);
            mg.loadArg(2);
            mg.visitMethodInsn(183, tieClassName, sortedNames[i], "(Lorg/omg/CORBA_2_3/portable/InputStream;Lorg/omg/CORBA/portable/ResponseHandler;)Lorg/omg/CORBA/portable/OutputStream;");
            mg.returnValue();
        }
        mg.visitLabel(case_default);
        mg.visitTypeInsn(187, "org/omg/CORBA/BAD_OPERATION");
        mg.visitInsn(89);
        mg.loadArg(0);
        mg.visitMethodInsn(183, "org/omg/CORBA/BAD_OPERATION", "<init>", "(Ljava/lang/String;)V");
        mg.visitInsn(191);
        Label try_end = new Label();
        mg.visitLabel(try_end);
        Label catch_SysException_label = try_end;
        int ex = mg.newLocal(CORBA_Utils.TYPE_CORBA_SystemException);
        mg.storeLocal(ex);
        mg.loadLocal(ex);
        mg.visitInsn(191);
        Label catch_Throwable_label = new Label();
        mg.visitLabel(catch_Throwable_label);
        int th = mg.newLocal(JITUtils.TYPE_Throwable);
        mg.storeLocal(th);
        mg.visitTypeInsn(187, "org/omg/CORBA/portable/UnknownException");
        mg.visitInsn(89);
        mg.loadLocal(th);
        mg.visitMethodInsn(183, "org/omg/CORBA/portable/UnknownException", "<init>", "(Ljava/lang/Throwable;)V");
        mg.visitInsn(191);
        mg.visitTryCatchBlock(try_begin, try_end, catch_SysException_label, "org/omg/CORBA/SystemException");
        mg.visitTryCatchBlock(try_begin, try_end, catch_Throwable_label, "java/lang/Throwable");
        mg.endMethod();
        mg.visitEnd();
    }

    private static void addDelegateMethod(ClassWriter cw, String tieClassName, Set<String> classConstantFieldNames, String servantClassName, String servantDescriptor, java.lang.reflect.Method method, String idlName, boolean isRmiRemote, int rmicCompatible) throws EJBConfigurationException {
        Class<?>[] methodParameters = method.getParameterTypes();
        Type[] argTypes = JITUtils.getTypes(methodParameters);
        int numArgs = argTypes.length;
        Class<?> returnClass = method.getReturnType();
        Type returnType = Type.getType(returnClass);
        String methodDescriptor = Type.getMethodDescriptor((Type)returnType, (Type[])argTypes);
        Class<?>[] checkedExceptions = DeploymentUtil.getCheckedExceptions(method, isRmiRemote, DeploymentUtil.DeploymentTarget.TIE);
        Type[] checkedTypes = JITUtils.getTypes(checkedExceptions);
        int numChecked = checkedExceptions.length;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("     adding method : " + idlName + " (Lorg/omg/CORBA_2_3/portable/InputStream;Lorg/omg/CORBA/portable/ResponseHandler;)Lorg/omg/CORBA/portable/OutputStream;"), (Object[])new Object[0]);
        }
        Type delegateReturnType = CORBA_Utils.TYPE_CORBA_OutputStream;
        Type[] delegateArgTypes = new Type[]{CORBA_Utils.TYPE_CORBA_2_3_InputStream, CORBA_Utils.TYPE_CORBA_ResponseHandler};
        Type[] delegateExceptionTypes = new Type[]{JITUtils.TYPE_Throwable};
        Method m = new Method(idlName, delegateReturnType, delegateArgTypes);
        GeneratorAdapter mg = new GeneratorAdapter(2, m, null, delegateExceptionTypes, (ClassVisitor)cw);
        mg.visitCode();
        int[] argValues = new int[numArgs];
        for (int i = 0; i < numArgs; ++i) {
            JITUtils.setLineNumber((MethodVisitor)mg, 100 + i);
            argValues[i] = mg.newLocal(argTypes[i]);
            mg.loadArg(0);
            CORBA_Utils.read_value(mg, tieClassName, classConstantFieldNames, method, methodParameters[i], argTypes[i], rmicCompatible);
            mg.storeLocal(argValues[i]);
        }
        JITUtils.setLineNumber((MethodVisitor)mg, 1);
        Label try_begin = null;
        if (numChecked > 0) {
            try_begin = new Label();
            mg.visitLabel(try_begin);
        }
        mg.loadThis();
        mg.visitFieldInsn(180, tieClassName, "target", servantDescriptor);
        for (int arg : argValues) {
            mg.loadLocal(arg);
        }
        mg.visitMethodInsn(182, servantClassName, method.getName(), methodDescriptor);
        int result = -1;
        if (returnType != Type.VOID_TYPE) {
            result = mg.newLocal(returnType);
            mg.storeLocal(result);
        }
        Label try_end = null;
        Label try_catch_exit = null;
        if (numChecked > 0) {
            try_end = new Label();
            mg.visitLabel(try_end);
            try_catch_exit = new Label();
            mg.visitJumpInsn(167, try_catch_exit);
        }
        Label[] catch_checked_labels = null;
        if (numChecked > 0) {
            catch_checked_labels = new Label[numChecked];
            for (int i = 0; i < numChecked; ++i) {
                Label catch_label;
                JITUtils.setLineNumber((MethodVisitor)mg, 1000 + i);
                catch_checked_labels[i] = catch_label = new Label();
                mg.visitLabel(catch_label);
                int ex = mg.newLocal(checkedTypes[i]);
                mg.storeLocal(ex);
                int id = mg.newLocal(JITUtils.TYPE_String);
                boolean mangleComponents = JITDeploy.isRMICCompatibleExceptions(rmicCompatible);
                String exIdlName = RMItoIDL.getIdlExceptionName(checkedExceptions[i].getName(), mangleComponents);
                mg.visitLdcInsn((Object)exIdlName);
                mg.storeLocal(id);
                int out = mg.newLocal(CORBA_Utils.TYPE_CORBA_2_3_OutputStream);
                mg.loadArg(1);
                mg.visitMethodInsn(185, "org/omg/CORBA/portable/ResponseHandler", "createExceptionReply", "()Lorg/omg/CORBA/portable/OutputStream;");
                mg.checkCast(CORBA_Utils.TYPE_CORBA_2_3_OutputStream);
                mg.storeLocal(out);
                mg.loadLocal(out);
                mg.loadLocal(id);
                mg.visitMethodInsn(182, "org/omg/CORBA/portable/OutputStream", "write_string", "(Ljava/lang/String;)V");
                mg.loadLocal(out);
                mg.loadLocal(ex);
                JITUtils.loadClassConstant((MethodVisitor)mg, tieClassName, classConstantFieldNames, checkedExceptions[i]);
                mg.visitMethodInsn(182, "org/omg/CORBA_2_3/portable/OutputStream", "write_value", "(Ljava/io/Serializable;Ljava/lang/Class;)V");
                mg.loadLocal(out);
                mg.returnValue();
            }
            mg.visitLabel(try_catch_exit);
        }
        JITUtils.setLineNumber((MethodVisitor)mg, 2);
        Type outType = CORBA_Utils.getRequiredOutputStreamType(returnClass, rmicCompatible);
        int out = mg.newLocal(CORBA_Utils.TYPE_CORBA_OutputStream);
        mg.loadArg(1);
        mg.visitMethodInsn(185, "org/omg/CORBA/portable/ResponseHandler", "createReply", "()Lorg/omg/CORBA/portable/OutputStream;");
        if (outType != CORBA_Utils.TYPE_CORBA_OutputStream) {
            mg.checkCast(outType);
        }
        mg.storeLocal(out);
        if (returnType != Type.VOID_TYPE) {
            mg.loadLocal(out);
            mg.loadLocal(result);
            CORBA_Utils.write_value(mg, tieClassName, classConstantFieldNames, method, returnClass, rmicCompatible);
        }
        mg.loadLocal(out);
        mg.returnValue();
        for (int i = 0; i < numChecked; ++i) {
            String exName = JITUtils.convertClassName(checkedExceptions[i].getName());
            mg.visitTryCatchBlock(try_begin, try_end, catch_checked_labels[i], exName);
        }
        mg.endMethod();
        mg.visitEnd();
    }
}

