/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.faulttolerance20.state.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.microprofile.faulttolerance.spi.BulkheadPolicy;
import com.ibm.ws.microprofile.faulttolerance.spi.MetricRecorder;
import com.ibm.ws.microprofile.faulttolerance20.impl.MethodResult;
import com.ibm.ws.microprofile.faulttolerance20.state.impl.SyncBulkheadStateNullImpl;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.concurrent.Callable;
import java.util.concurrent.Semaphore;
import org.eclipse.microprofile.faulttolerance.exceptions.BulkheadException;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class SyncBulkheadStateImpl
extends SyncBulkheadStateNullImpl {
    private final Semaphore semaphore;
    private final MetricRecorder metrics;
    static final long serialVersionUID = 8819626751211285534L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public SyncBulkheadStateImpl(BulkheadPolicy policy, MetricRecorder metrics) {
        int maxThreads = policy.getMaxThreads();
        this.semaphore = new Semaphore(maxThreads);
        this.metrics = metrics;
        metrics.setBulkheadConcurentExecutionCountSupplier(() -> maxThreads - this.semaphore.availablePermits());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> MethodResult<R> run(Callable<R> callable) {
        if (!this.semaphore.tryAcquire()) {
            this.metrics.incrementBulkheadRejectedCount();
            return MethodResult.failure((Throwable)new BulkheadException());
        }
        long startTime = System.nanoTime();
        this.metrics.incrementBulkeadAcceptedCount();
        try {
            MethodResult<R> methodResult = super.run(callable);
            return methodResult;
        }
        finally {
            this.semaphore.release();
            long endTime = System.nanoTime();
            this.metrics.recordBulkheadExecutionTime(endTime - startTime);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.microprofile.faulttolerance20.state.impl.SyncBulkheadStateImpl", SyncBulkheadStateImpl.class, (String)"FAULTTOLERANCE", null);
    }
}

