/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.opentracing;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.opentracing.filters.SpanFilter;
import com.ibm.ws.opentracing.filters.SpanFilterType;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.opentracing.Span;
import io.opentracing.tag.Tags;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Modified;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(configurationPid={"com.ibm.ws.opentracing"}, configurationPolicy=ConfigurationPolicy.OPTIONAL, immediate=true, property={"service.vendor=IBM"})
public class OpentracingService {
    private static final TraceComponent tc = Tr.register(OpentracingService.class, (String)"OPENTRACING", (String)"com.ibm.ws.opentracing.resources.Opentracing");
    private static volatile SpanFilter[] allFilters = new SpanFilter[0];
    static final long serialVersionUID = -7921175685189152800L;

    @Activate
    protected void activate(Map<String, Object> map) {
        this.modified(map);
    }

    @Modified
    protected void modified(Map<String, Object> map) {
        ArrayList filters = new ArrayList();
        SpanFilter[] finalFilters = new SpanFilter[filters.size()];
        filters.toArray(finalFilters);
        allFilters = finalFilters;
    }

    public static boolean process(URI uri, SpanFilterType type) {
        String methodName = "process";
        boolean result = true;
        SpanFilter[] filters = allFilters;
        for (int i = 0; i < filters.length; ++i) {
            result = filters[i].process(result, uri, type);
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)"process", (Object[])new Object[]{"filter " + filters[i] + " set result to " + result});
        }
        return result;
    }

    public static void addSpanErrorInfo(Span span, Throwable exception) {
        String methodName = "addSpanErrorInfo";
        span.setTag(Tags.ERROR.getKey(), true);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(methodName + " error"), (Object[])new Object[]{Boolean.TRUE});
        }
        if (exception != null) {
            HashMap<String, Object> log = new HashMap<String, Object>();
            log.put("event", "error");
            log.put("error.object", exception);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(methodName + " adding log entry"), (Object[])new Object[]{log});
            }
            span.log(log);
        }
    }
}

