/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ras.instrument.internal.introspect;

import com.ibm.ws.ras.instrument.internal.introspect.TraceOptionsAnnotationVisitor;
import com.ibm.ws.ras.instrument.internal.model.PackageInfo;
import com.ibm.ws.ras.instrument.internal.model.TraceOptionsData;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;

public class TraceConfigPackageVisitor
extends ClassVisitor {
    protected static final Type TRACE_OPTIONS_TYPE = Type.getObjectType((String)"com/ibm/websphere/ras/annotation/TraceOptions");
    protected static final Type TRIVIAL_TYPE = Type.getObjectType((String)"com/ibm/websphere/ras/annotation/Trivial");
    protected String internalPackageName;
    protected boolean trivialPackage;
    protected TraceOptionsAnnotationVisitor traceOptionsAnnotationVisitor;

    public TraceConfigPackageVisitor() {
        super(524288);
    }

    public TraceConfigPackageVisitor(ClassVisitor visitor) {
        super(524288, visitor);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        this.internalPackageName = name.replaceAll("/[^/]+$", "");
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        AnnotationVisitor av = super.visitAnnotation(desc, visible);
        if (TRIVIAL_TYPE.getDescriptor().equals(desc)) {
            this.trivialPackage = true;
        } else if (TRACE_OPTIONS_TYPE.getDescriptor().equals(desc)) {
            this.traceOptionsAnnotationVisitor = new TraceOptionsAnnotationVisitor(av);
            av = this.traceOptionsAnnotationVisitor;
        }
        return av;
    }

    public PackageInfo getPackageInfo() {
        TraceOptionsData traceOptionsData = null;
        if (this.traceOptionsAnnotationVisitor != null) {
            traceOptionsData = this.traceOptionsAnnotationVisitor.getTraceOptionsData();
        }
        return new PackageInfo(this.internalPackageName, this.trivialPackage, traceOptionsData);
    }
}

