/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.cache;

import com.ibm.ws.cache.config.Field;
import com.ibm.ws.cache.config.Method;
import com.ibm.ws.cache.config.NotValue;
import com.ibm.ws.cache.config.Range;
import com.ibm.ws.cache.config.Value;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;

public class ConfigEntry {
    private com.ibm.ws.cache.config.ConfigEntry configEntry = null;

    public ConfigEntry(com.ibm.ws.cache.config.ConfigEntry ce) {
        this.configEntry = ce;
    }

    public String getClassName() {
        return this.configEntry.className;
    }

    public HashSet getAllNames() {
        return this.configEntry.allNames;
    }

    public int getSharingPolicy() {
        return this.configEntry.sharingPolicy;
    }

    public Object clone() {
        return new ConfigEntry((com.ibm.ws.cache.config.ConfigEntry)this.configEntry.clone());
    }

    public ArrayList getProperties() {
        ArrayList<Property> properties = new ArrayList<Property>();
        if (this.configEntry.properties != null) {
            Iterator it = this.configEntry.properties.values().iterator();
            while (it.hasNext()) {
                Property property = new Property((com.ibm.ws.cache.config.Property)it.next());
                properties.add(property);
            }
        }
        return properties;
    }

    public CacheId[] getCacheIds() {
        CacheId[] cacheIds = new CacheId[this.configEntry.cacheIds.length];
        for (int i = 0; i < this.configEntry.cacheIds.length; ++i) {
            cacheIds[i] = new CacheId(this.configEntry.cacheIds[i]);
        }
        return cacheIds;
    }

    public DependencyId[] getDependencyIds() {
        DependencyId[] depIds = new DependencyId[this.configEntry.dependencyIds.length];
        for (int i = 0; i < this.configEntry.dependencyIds.length; ++i) {
            depIds[i] = new DependencyId(this.configEntry.dependencyIds[i]);
        }
        return depIds;
    }

    public Invalidation[] getInvalidations() {
        Invalidation[] invalidations = new Invalidation[this.configEntry.invalidations.length];
        for (int i = 0; i < this.configEntry.invalidations.length; ++i) {
            invalidations[i] = new Invalidation(this.configEntry.invalidations[i]);
        }
        return invalidations;
    }

    public class Invalidation {
        private com.ibm.ws.cache.config.Invalidation invalidation = null;

        public Invalidation(com.ibm.ws.cache.config.Invalidation i) {
            this.invalidation = i;
        }

        public String getBaseName() {
            return this.invalidation.baseName;
        }

        public String getInvalidationGenerator() {
            return this.invalidation.invalidationGenerator;
        }

        public Component[] getComponents() {
            Component[] components = new Component[this.invalidation.components.length];
            for (int i = 0; i < this.invalidation.components.length; ++i) {
                components[i] = new Component(this.invalidation.components[i]);
            }
            return components;
        }
    }

    public class DependencyId {
        private com.ibm.ws.cache.config.DependencyId depId = null;

        public DependencyId(com.ibm.ws.cache.config.DependencyId di) {
            this.depId = di;
        }

        public String getBaseName() {
            return this.depId.baseName;
        }

        public Component[] getComponents() {
            Component[] components = new Component[this.depId.components.length];
            for (int i = 0; i < this.depId.components.length; ++i) {
                components[i] = new Component(this.depId.components[i]);
            }
            return components;
        }
    }

    public class Component {
        private com.ibm.ws.cache.config.Component component = null;

        public Component(com.ibm.ws.cache.config.Component c) {
            this.component = c;
        }

        public String getId() {
            return this.component.id;
        }

        public String getType() {
            return this.component.type;
        }

        public boolean getIgnoreValue() {
            return this.component.ignoreValue;
        }

        public String getMethod() {
            Method method = this.component.method;
            if (method != null) {
                return method.toString();
            }
            return null;
        }

        public String getField() {
            Field field = this.component.field;
            if (field != null) {
                return field.toString();
            }
            return null;
        }

        public boolean getRequired() {
            return this.component.required;
        }

        public int getIndex() {
            return this.component.index;
        }

        public boolean getMultipleIds() {
            return this.component.multipleIds;
        }

        public ArrayList getValues() {
            ArrayList<String> values = new ArrayList<String>();
            if (this.component.values != null) {
                for (Value v : this.component.values.values()) {
                    values.add(v.value);
                }
            }
            return values;
        }

        public ArrayList getNotValues() {
            ArrayList<String> notValues = new ArrayList<String>();
            if (this.component.notValues != null) {
                for (NotValue nv : this.component.notValues.values()) {
                    notValues.add(nv.notValue);
                }
            }
            return notValues;
        }

        public ArrayList getValueRanges() {
            ArrayList<String> valueRanges = new ArrayList<String>();
            if (this.component.valueRanges != null) {
                for (Range range : this.component.valueRanges) {
                    valueRanges.add("range low: " + range.low + " high: " + range.high);
                }
            }
            return valueRanges;
        }

        public ArrayList getNotValueRanges() {
            ArrayList<String> notValueRanges = new ArrayList<String>();
            if (this.component.notValueRanges != null) {
                for (Range range : this.component.notValueRanges) {
                    notValueRanges.add("range low: " + range.low + " high: " + range.high);
                }
            }
            return notValueRanges;
        }
    }

    public class CacheId {
        private com.ibm.ws.cache.config.CacheId cacheId = null;

        public CacheId(com.ibm.ws.cache.config.CacheId ci) {
            this.cacheId = ci;
        }

        public int getTimeout() {
            return this.cacheId.timeout;
        }

        public int getPriority() {
            return this.cacheId.priority;
        }

        public int getInactivity() {
            return this.cacheId.inactivity;
        }

        public String getIdGenerator() {
            return this.cacheId.idGenerator;
        }

        public String getMetaDataGenerator() {
            return this.cacheId.metaDataGenerator;
        }

        public ArrayList getProperties() {
            ArrayList<Property> properties = new ArrayList<Property>();
            if (this.cacheId.properties != null) {
                Iterator it = this.cacheId.properties.values().iterator();
                while (it.hasNext()) {
                    Property property = new Property((com.ibm.ws.cache.config.Property)it.next());
                    properties.add(property);
                }
            }
            return properties;
        }

        public Component[] getComponents() {
            Component[] components = new Component[this.cacheId.components.length];
            for (int i = 0; i < this.cacheId.components.length; ++i) {
                components[i] = new Component(this.cacheId.components[i]);
            }
            return components;
        }
    }

    public class Property {
        private com.ibm.ws.cache.config.Property property = null;

        public Property(com.ibm.ws.cache.config.Property prop) {
            this.property = prop;
        }

        public String getName() {
            return this.property.name;
        }

        public String getValue() {
            return this.property.value;
        }

        public String[] getExcludeList() {
            return this.property.excludeList;
        }
    }
}

