/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.monitor.internal.bci;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.monitor.internal.ProbeManagerImpl;
import com.ibm.ws.monitor.internal.bci.ClassAvailableHookClassAdapter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.commons.SerialVersionUIDAdder;
import org.objectweb.asm.util.CheckClassAdapter;
import org.objectweb.asm.util.TraceClassVisitor;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class ClassAvailableTransformer
implements ClassFileTransformer {
    private static final TraceComponent tc = Tr.register(ClassAvailableTransformer.class, (String)"PMI", (String)"com.ibm.ws.pmi.properties.PMIMessages");
    final ProbeManagerImpl probeManagerImpl;
    final Instrumentation instrumentation;
    final boolean includeBootstrap;
    static final long serialVersionUID = 7286092986297419988L;

    public ClassAvailableTransformer(ProbeManagerImpl probeManagerImpl, Instrumentation instrumentation, boolean includeBootstrap) {
        this.probeManagerImpl = probeManagerImpl;
        this.instrumentation = instrumentation;
        this.includeBootstrap = includeBootstrap;
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        if (loader == null && !this.includeBootstrap || this.probeManagerImpl.isExcludedClass(className)) {
            return null;
        }
        if (this.probeManagerImpl.isProbeCandidate(className)) {
            return this.transformCandidate(classfileBuffer);
        }
        return null;
    }

    byte[] transformCandidate(byte[] classfileBuffer) {
        ClassWriter writer;
        ClassReader reader = new ClassReader(classfileBuffer);
        Object visitor = writer = new ClassWriter(reader, 1);
        StringWriter stringWriter = null;
        if (tc.isDumpEnabled()) {
            stringWriter = new StringWriter();
            visitor = new CheckClassAdapter((ClassVisitor)visitor);
            visitor = new TraceClassVisitor((ClassVisitor)visitor, new PrintWriter(stringWriter));
        }
        visitor = new ClassAvailableHookClassAdapter((ClassVisitor)visitor);
        visitor = new SerialVersionUIDAdder((ClassVisitor)visitor);
        reader.accept((ClassVisitor)visitor, 0);
        if (stringWriter != null && tc.isDumpEnabled()) {
            Tr.dump((TraceComponent)tc, (String)"Transformed class", (Object[])new Object[]{stringWriter});
        }
        return writer.toByteArray();
    }
}

