/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.transaction.services;

import com.ibm.tx.jta.impl.TransactionImpl;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.LocalTransaction.InconsistentLocalTranException;
import com.ibm.ws.LocalTransaction.LocalTransactionCoordinator;
import com.ibm.ws.LocalTransaction.LocalTransactionCurrent;
import com.ibm.ws.LocalTransaction.RolledbackException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.transaction.services.LTCUOWCallbackService;
import com.ibm.ws.tx.embeddable.EmbeddableWebSphereTransactionManager;
import com.ibm.ws.tx.embeddable.EmbeddableWebSphereUserTransaction;
import com.ibm.ws.uow.UOWScopeCallback;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.webcontainer.collaborator.IWebAppTransactionCollaborator;
import com.ibm.wsspi.webcontainer.collaborator.TxCollaboratorConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionRolledbackException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class WebAppTransactionCollaboratorImpl
implements IWebAppTransactionCollaborator {
    private static final TraceComponent tc = Tr.register(WebAppTransactionCollaboratorImpl.class, (String)"transaction", (String)"com.ibm.ws.transaction.services.TransactionMessages");
    private final AtomicServiceReference<LocalTransactionCurrent> ltCurrentRef = new AtomicServiceReference("ltCurrent");
    private final AtomicServiceReference<EmbeddableWebSphereTransactionManager> tranMgrRef = new AtomicServiceReference("tranMgr");
    private final AtomicServiceReference<EmbeddableWebSphereUserTransaction> userTranRef = new AtomicServiceReference("userTran");
    private final AtomicServiceReference<LTCUOWCallbackService> uowCallbackRef = new AtomicServiceReference("uowCallback");
    static final long serialVersionUID = -8319003162899973281L;

    protected void activate(ComponentContext ctx) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Activating WebAppTransactionCollaborator Service!", (Object[])new Object[0]);
        }
        this.ltCurrentRef.activate(ctx);
        this.tranMgrRef.activate(ctx);
        this.userTranRef.activate(ctx);
        this.uowCallbackRef.activate(ctx);
        EmbeddableWebSphereUserTransaction userTran = this.getUserTran();
        LTCUOWCallbackService ltcCallback = this.getUowCallback();
        if (userTran == null || ltcCallback == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((Object)this, (TraceComponent)tc, (String)("Unable to register a LTC callback.  userTran:" + userTran + " | ltcCallback:" + ltcCallback), (Object[])new Object[0]);
            }
            return;
        }
        userTran.registerCallback((UOWScopeCallback)ltcCallback);
    }

    protected void deactivate(ComponentContext ctx) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Deactivating WebAppTransactionCollaborator Service!", (Object[])new Object[0]);
        }
        this.ltCurrentRef.deactivate(ctx);
        this.tranMgrRef.deactivate(ctx);
        this.userTranRef.deactivate(ctx);
        this.uowCallbackRef.deactivate(ctx);
        EmbeddableWebSphereUserTransaction userTran = this.getUserTran();
        LTCUOWCallbackService ltcCallback = this.getUowCallback();
        if (userTran == null || ltcCallback == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((Object)this, (TraceComponent)tc, (String)("Unable to unregister a LTC callback.  userTran:" + userTran + " | ltcCallback:" + ltcCallback), (Object[])new Object[0]);
            }
            return;
        }
        userTran.unregisterCallback((UOWScopeCallback)ltcCallback);
    }

    protected void setLtCurrent(ServiceReference<LocalTransactionCurrent> ref) {
        this.ltCurrentRef.setReference(ref);
    }

    protected void unsetLtCurrent(ServiceReference<LocalTransactionCurrent> ref) {
        this.ltCurrentRef.unsetReference(ref);
    }

    private LocalTransactionCurrent getLtCurrent() {
        return (LocalTransactionCurrent)this.ltCurrentRef.getService();
    }

    protected void setUowCallback(ServiceReference<LTCUOWCallbackService> ref) {
        this.uowCallbackRef.setReference(ref);
    }

    protected void unsetUowCallback(ServiceReference<LTCUOWCallbackService> ref) {
        this.uowCallbackRef.unsetReference(ref);
    }

    private LTCUOWCallbackService getUowCallback() {
        return (LTCUOWCallbackService)this.uowCallbackRef.getService();
    }

    protected void setTranMgr(ServiceReference<EmbeddableWebSphereTransactionManager> ref) {
        this.tranMgrRef.setReference(ref);
    }

    protected void setUserTran(ServiceReference<EmbeddableWebSphereUserTransaction> ref) {
        this.userTranRef.setReference(ref);
    }

    protected void unsetTranMgr(ServiceReference<EmbeddableWebSphereTransactionManager> ref) {
        this.tranMgrRef.unsetReference(ref);
    }

    protected void unsetUserTran(ServiceReference<EmbeddableWebSphereUserTransaction> ref) {
        this.userTranRef.unsetReference(ref);
    }

    private EmbeddableWebSphereTransactionManager getTranMgr() {
        return (EmbeddableWebSphereTransactionManager)this.tranMgrRef.getService();
    }

    private EmbeddableWebSphereUserTransaction getUserTran() {
        return (EmbeddableWebSphereUserTransaction)this.userTranRef.getService();
    }

    /*
     * WARNING - void declaration
     */
    public TxCollaboratorConfig preInvoke(HttpServletRequest request, boolean isServlet23) throws ServletException {
        block12: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Calling preInvoke. Request=" + request + " | isServlet23=" + isServlet23), (Object[])new Object[0]);
            }
            try {
                Transaction incumbentTx;
                EmbeddableWebSphereTransactionManager tranManager = this.getTranMgr();
                if (tranManager == null || (incumbentTx = tranManager.getTransaction()) == null) break block12;
                TransactionImpl incumbentTxImpl = null;
                if (incumbentTx instanceof TransactionImpl) {
                    incumbentTxImpl = (TransactionImpl)incumbentTx;
                }
                if (incumbentTxImpl != null && incumbentTxImpl.getTxType() == 2) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"the tx is NONINTEROP_GLOBAL set it to null", (Object[])new Object[0]);
                    }
                    tranManager.suspend();
                    break block12;
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Global transaction was present.", (Object[])new Object[0]);
                }
                this.checkGlobalTimeout();
                TxCollaboratorConfig retConfig = new TxCollaboratorConfig();
                retConfig.setIncumbentTx((Object)incumbentTx);
                return retConfig;
            }
            catch (SystemException tranManager) {
                void e;
                FFDCFilter.processException((Throwable)tranManager, (String)"com.ibm.ws.transaction.services.WebAppTransactionCollaboratorImpl", (String)"241", (Object)this, (Object[])new Object[]{request, isServlet23});
                Tr.error((TraceComponent)tc, (String)"UNEXPECTED_TRAN_ERROR", (Object[])new Object[]{e.toString()});
                ServletException se = new ServletException("Unexpected error during transaction fetching: ", (Throwable)e);
                throw se;
            }
        }
        LocalTransactionCurrent ltCurrent = this.getLtCurrent();
        if (ltCurrent == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((Object)this, (TraceComponent)tc, (String)"Unable to resolve LocalTransactionCurrent", (Object[])new Object[0]);
            }
            return null;
        }
        TxCollaboratorConfig retConfig = new TxCollaboratorConfig();
        LocalTransactionCoordinator ltCoord = ltCurrent.getLocalTranCoord();
        if (ltCoord != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Suspending LTC's coord: " + ltCoord), (Object[])new Object[0]);
            }
            retConfig.setSuspendTx((Object)ltCurrent.suspend());
        }
        ltCurrent.begin();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Began LTC's coord:" + ltCurrent.getLocalTranCoord()), (Object[])new Object[0]);
        }
        return retConfig;
    }

    /*
     * WARNING - void declaration
     */
    private void checkGlobalTimeout() throws ServletException {
        try {
            EmbeddableWebSphereTransactionManager tranManager = this.getTranMgr();
            if (tranManager != null) {
                tranManager.completeTxTimeout();
            }
        }
        catch (TransactionRolledbackException tranManager) {
            void e;
            FFDCFilter.processException((Throwable)tranManager, (String)"com.ibm.ws.transaction.services.WebAppTransactionCollaboratorImpl", (String)"288", (Object)this, (Object[])new Object[0]);
            Tr.error((TraceComponent)tc, (String)"GLOBAL_TRAN_ROLLBACK", (Object[])new Object[]{e.toString()});
            ServletException se = new ServletException("Global transaction rolled-back due to timeout", (Throwable)e);
            throw se;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void postInvoke(HttpServletRequest request, Object txConfig, boolean isServlet23) throws ServletException {
        LocalTransactionCurrent ltCurrent;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Calling postInvoke. Request=" + request + " | isServlet23=" + isServlet23), (Object[])new Object[0]);
        }
        if ((ltCurrent = this.getLtCurrent()) == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((Object)this, (TraceComponent)tc, (String)"Unable to resolve LocalTransactionCurrent", (Object[])new Object[0]);
            }
            return;
        }
        LocalTransactionCoordinator currentCoord = ltCurrent.getLocalTranCoord();
        if (currentCoord != null) {
            block23: {
                try {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Ending LTC's coord:" + currentCoord), (Object[])new Object[0]);
                        Tr.debug((TraceComponent)tc, (String)"Unregistering LTC callback", (Object[])new Object[0]);
                    }
                    currentCoord.end(0);
                }
                catch (IllegalStateException illegalStateException) {
                    FFDCFilter.processException((Throwable)illegalStateException, (String)"com.ibm.ws.transaction.services.WebAppTransactionCollaboratorImpl", (String)"322", (Object)this, (Object[])new Object[]{request, txConfig, isServlet23});
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        void e1;
                        Tr.event((TraceComponent)tc, (String)"IllegalStateException", (Object[])new Object[]{e1});
                    }
                }
                catch (InconsistentLocalTranException e1) {
                    FFDCFilter.processException((Throwable)e1, (String)"com.ibm.ws.transaction.services.WebAppTransactionCollaboratorImpl", (String)"327", (Object)this, (Object[])new Object[]{request, txConfig, isServlet23});
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"InconsistentLocalTranException", (Object[])new Object[]{e1});
                    }
                }
                catch (RolledbackException e1) {
                    FFDCFilter.processException((Throwable)e1, (String)"com.ibm.ws.transaction.services.WebAppTransactionCollaboratorImpl", (String)"332", (Object)this, (Object[])new Object[]{request, txConfig, isServlet23});
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block23;
                    Tr.event((TraceComponent)tc, (String)"RolledbackException", (Object[])new Object[]{e1});
                }
            }
            this.resumeSuspendedLTC(ltCurrent, txConfig);
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"There must be a global tran on the thread", (Object[])new Object[0]);
            }
            boolean resumeSuspendedLTC = false;
            EmbeddableWebSphereTransactionManager tranManager = this.getTranMgr();
            if (tranManager != null) {
                try {
                    Transaction tx = tranManager.getTransaction();
                    if (tx != null) {
                        Object incumbentTx = null;
                        if (txConfig instanceof TxCollaboratorConfig) {
                            incumbentTx = ((TxCollaboratorConfig)txConfig).getIncumbentTx();
                        }
                        if (!tx.equals(incumbentTx)) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Servlet started Tx", (Object[])new Object[]{tx});
                            }
                            resumeSuspendedLTC = true;
                            if (tranManager.getStatus() != 6) {
                                tranManager.rollback();
                            }
                        }
                    }
                }
                catch (SystemException tx) {
                    void e;
                    FFDCFilter.processException((Throwable)tx, (String)"com.ibm.ws.transaction.services.WebAppTransactionCollaboratorImpl", (String)"374", (Object)this, (Object[])new Object[]{request, txConfig, isServlet23});
                    FFDCFilter.processException((Throwable)e, (String)(this.getClass().getCanonicalName() + "postInvoke"), (String)"374");
                }
            }
            if (resumeSuspendedLTC) {
                this.resumeSuspendedLTC(ltCurrent, txConfig);
            } else {
                this.checkGlobalTimeout();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void resumeSuspendedLTC(LocalTransactionCurrent ltCurrent, Object txConfig) throws ServletException {
        Object suspended;
        if (txConfig instanceof TxCollaboratorConfig && (suspended = ((TxCollaboratorConfig)txConfig).getSuspendTx()) instanceof LocalTransactionCoordinator) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Resuming previously suspended LTC coord:" + suspended), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)"Registering LTC callback", (Object[])new Object[0]);
            }
            try {
                ltCurrent.resume((LocalTransactionCoordinator)suspended);
            }
            catch (IllegalStateException illegalStateException) {
                FFDCFilter.processException((Throwable)illegalStateException, (String)"com.ibm.ws.transaction.services.WebAppTransactionCollaboratorImpl", (String)"405", (Object)this, (Object[])new Object[]{ltCurrent, txConfig});
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    void ex;
                    Tr.event((TraceComponent)tc, (String)"IllegalStateException", (Object[])new Object[]{ex});
                }
                try {
                    ltCurrent.cleanup();
                }
                catch (InconsistentLocalTranException inconsistentLocalTranException) {
                    FFDCFilter.processException((Throwable)inconsistentLocalTranException, (String)"com.ibm.ws.transaction.services.WebAppTransactionCollaboratorImpl", (String)"412", (Object)this, (Object[])new Object[]{ltCurrent, txConfig});
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        void iltex;
                        Tr.event((TraceComponent)tc, (String)"InconsistentLocalTranException", (Object[])new Object[]{iltex});
                    }
                }
                catch (RolledbackException iltex) {
                    void rbe;
                    FFDCFilter.processException((Throwable)iltex, (String)"com.ibm.ws.transaction.services.WebAppTransactionCollaboratorImpl", (String)"418", (Object)this, (Object[])new Object[]{ltCurrent, txConfig});
                    ServletException se = new ServletException("LocalTransaction rolled-back due to setRollbackOnly", (Throwable)rbe);
                    throw se;
                }
            }
        }
    }
}

