/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.javaee.ddmodel.webext;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.container.service.app.deploy.ApplicationInfo;
import com.ibm.ws.container.service.app.deploy.ModuleInfo;
import com.ibm.ws.container.service.app.deploy.NestedConfigHelper;
import com.ibm.ws.container.service.app.deploy.extended.ExtendedApplicationInfo;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.javaee.dd.app.Application;
import com.ibm.ws.javaee.dd.app.Module;
import com.ibm.ws.javaee.dd.web.WebApp;
import com.ibm.ws.javaee.dd.webext.WebExt;
import com.ibm.ws.javaee.ddmodel.DDParser;
import com.ibm.ws.javaee.ddmodel.webext.WebExtComponentImpl;
import com.ibm.ws.javaee.ddmodel.webext.WebExtDDParser;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.Entry;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.adaptable.module.adapters.ContainerAdapter;
import com.ibm.wsspi.artifact.ArtifactContainer;
import com.ibm.wsspi.artifact.overlay.OverlayContainer;
import java.util.HashSet;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(configurationPolicy=ConfigurationPolicy.IGNORE, service={ContainerAdapter.class}, property={"service.vendor=IBM", "toType=com.ibm.ws.javaee.dd.webext.WebExt"})
public class WebExtAdapter
implements ContainerAdapter<WebExt> {
    private static final TraceComponent tc = Tr.register(WebExtAdapter.class, (String)"ddmodel", (String)"com.ibm.ws.javaee.internal.ddmodel.resources.DDModelMessages");
    private static final String MODULE_NAME_INVALID = "module.name.invalid";
    private static final String MODULE_NAME_NOT_SPECIFIED = "module.name.not.specified";
    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    volatile List<WebExt> configurations;
    static final long serialVersionUID = -1542311626818206050L;

    private static boolean markError(OverlayContainer overlay, String errorTag) {
        if (overlay.getFromNonPersistentCache(errorTag, WebExtAdapter.class) == null) {
            overlay.addToNonPersistentCache(errorTag, WebExtAdapter.class, (Object)errorTag);
            return true;
        }
        return false;
    }

    @FFDCIgnore(value={DDParser.ParseException.class})
    public WebExt adapt(Container root, OverlayContainer rootOverlay, ArtifactContainer artifactContainer, Container containerToAdapt) throws UnableToAdaptException {
        WebApp primary = (WebApp)containerToAdapt.adapt(WebApp.class);
        String primaryVersion = primary == null ? null : primary.getVersion();
        boolean xmi = "2.2".equals(primaryVersion) || "2.3".equals(primaryVersion) || "2.4".equals(primaryVersion);
        String ddEntryName = xmi ? "WEB-INF/ibm-web-ext.xmi" : "WEB-INF/ibm-web-ext.xml";
        Entry ddEntry = containerToAdapt.getEntry(ddEntryName);
        WebExtComponentImpl fromConfig = this.getConfigOverrides(rootOverlay, artifactContainer);
        if (ddEntry == null && fromConfig == null) {
            return null;
        }
        if (ddEntry != null) {
            WebExt fromApp;
            try {
                fromApp = new WebExtDDParser(containerToAdapt, ddEntry, xmi).parse();
            }
            catch (DDParser.ParseException e) {
                throw new UnableToAdaptException((Throwable)e);
            }
            if (fromConfig == null) {
                return fromApp;
            }
            fromConfig.setDelegate(fromApp);
            return fromConfig;
        }
        return fromConfig;
    }

    private WebExtComponentImpl getConfigOverrides(OverlayContainer overlay, ArtifactContainer artifactContainer) throws UnableToAdaptException {
        if (this.configurations == null || this.configurations.isEmpty()) {
            return null;
        }
        ApplicationInfo appInfo = (ApplicationInfo)overlay.getFromNonPersistentCache(artifactContainer.getPath(), ApplicationInfo.class);
        ModuleInfo moduleInfo = null;
        if (appInfo == null) {
            moduleInfo = (ModuleInfo)overlay.getFromNonPersistentCache(artifactContainer.getPath(), ModuleInfo.class);
            if (moduleInfo == null) {
                return null;
            }
            appInfo = moduleInfo.getApplicationInfo();
            if (appInfo == null) {
                return null;
            }
        }
        if (!(appInfo instanceof ExtendedApplicationInfo)) {
            return null;
        }
        NestedConfigHelper configHelper = ((ExtendedApplicationInfo)appInfo).getConfigHelper();
        if (configHelper == null) {
            return null;
        }
        OverlayContainer rootOverlay = overlay;
        if (overlay.getParentOverlay() != null) {
            rootOverlay = overlay.getParentOverlay();
        }
        HashSet<String> overrideModuleNames = new HashSet<String>();
        String servicePid = (String)configHelper.get("service.pid");
        String extendsPid = (String)configHelper.get("ibm.extends.source.pid");
        for (WebExt config : this.configurations) {
            WebExtComponentImpl configImpl = (WebExtComponentImpl)config;
            String parentPid = (String)configImpl.getConfigAdminProperties().get("config.parentPID");
            if (!servicePid.equals(parentPid) && !parentPid.equals(extendsPid)) continue;
            if (moduleInfo == null) {
                return configImpl;
            }
            String overrideModuleName = (String)configImpl.getConfigAdminProperties().get("moduleName");
            if (overrideModuleName == null) {
                if (!WebExtAdapter.markError(rootOverlay, MODULE_NAME_NOT_SPECIFIED)) continue;
                Tr.error((TraceComponent)tc, (String)MODULE_NAME_NOT_SPECIFIED, (Object[])new Object[]{"web-ext"});
                continue;
            }
            overrideModuleName = this.stripExtension(overrideModuleName);
            overrideModuleNames.add(overrideModuleName);
            if (!moduleInfo.getName().equals(overrideModuleName)) continue;
            return configImpl;
        }
        if (moduleInfo != null && !overrideModuleNames.isEmpty() && WebExtAdapter.markError(rootOverlay, MODULE_NAME_INVALID)) {
            Application appDD = (Application)appInfo.getContainer().adapt(Application.class);
            if (appDD != null) {
                HashSet<String> moduleDDNames = new HashSet<String>();
                for (Module moduleDD : appDD.getModules()) {
                    String moduleDDName = this.stripExtension(moduleDD.getModulePath());
                    moduleDDNames.add(moduleDDName);
                }
                overrideModuleNames.removeAll(moduleDDNames);
            }
            if (!overrideModuleNames.isEmpty()) {
                Tr.error((TraceComponent)tc, (String)MODULE_NAME_INVALID, (Object[])new Object[]{overrideModuleNames, "web-ext"});
            }
        }
        return null;
    }

    private String stripExtension(String moduleName) {
        if (moduleName.endsWith(".war") || moduleName.endsWith(".jar")) {
            return moduleName.substring(0, moduleName.length() - 4);
        }
        return moduleName;
    }
}

