/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.repository.connections;

import com.ibm.ws.repository.common.enums.FilterPredicate;
import com.ibm.ws.repository.common.enums.FilterableAttribute;
import com.ibm.ws.repository.common.enums.ResourceType;
import com.ibm.ws.repository.common.enums.Visibility;
import com.ibm.ws.repository.connections.ProductDefinition;
import com.ibm.ws.repository.exceptions.RepositoryBackendException;
import com.ibm.ws.repository.exceptions.RepositoryBadDataException;
import com.ibm.ws.repository.resources.EsaResource;
import com.ibm.ws.repository.resources.RepositoryResource;
import com.ibm.ws.repository.resources.SampleResource;
import com.ibm.ws.repository.transport.exceptions.RequestFailureException;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;

public interface RepositoryConnection {
    public boolean isRepositoryAvailable();

    public void checkRepositoryStatus() throws IOException, RequestFailureException;

    public String getRepositoryLocation();

    public RepositoryResource getResource(String var1) throws RepositoryBackendException, RepositoryBadDataException;

    public Collection<SampleResource> getMatchingSamples(FilterableAttribute var1, String var2) throws RepositoryBackendException;

    public Collection<EsaResource> getMatchingEsas(FilterableAttribute var1, String var2) throws RepositoryBackendException;

    public Collection<RepositoryResource> getMatchingResources(FilterPredicate ... var1) throws RepositoryBackendException;

    public Collection<? extends RepositoryResource> getAllResources() throws RepositoryBackendException;

    public Collection<? extends RepositoryResource> getAllResources(ResourceType var1) throws RepositoryBackendException;

    public Collection<? extends RepositoryResource> getAllResourcesWithDupes() throws RepositoryBackendException;

    public Collection<? extends RepositoryResource> getAllResourcesWithDupes(ResourceType var1) throws RepositoryBackendException;

    public Map<ResourceType, Collection<? extends RepositoryResource>> getResources(Collection<ProductDefinition> var1, Collection<ResourceType> var2, Visibility var3) throws RepositoryBackendException;

    public Collection<? extends RepositoryResource> findResources(String var1, Collection<ProductDefinition> var2, Collection<ResourceType> var3, Visibility var4) throws RepositoryBackendException;
}

