/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jmx.connector.client.rest.internal;

import com.ibm.ws.jmx.connector.client.rest.internal.Connector;
import com.ibm.ws.jmx.connector.client.rest.internal.RESTMBeanServerConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;

class DynamicURL {
    private static final Logger logger = Logger.getLogger(DynamicURL.class.getName());
    private final String name;
    private final Connector connector;

    DynamicURL(Connector connector, String name) {
        this.name = name;
        this.connector = connector;
    }

    URL getURL() throws MalformedURLException {
        String[] endpoint = RESTMBeanServerConnection.splitEndpoint(this.connector.getCurrentEndpoint());
        URL retURL = new URL("https", endpoint[0], Integer.valueOf(endpoint[1]), this.getName());
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, logger.getName(), "getURL", "URL: " + retURL.toString());
        }
        return retURL;
    }

    String getName() {
        return this.name;
    }
}

