/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.javaeesec;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.jaspi.BridgeBuilderService;
import com.ibm.ws.security.javaeesec.AuthProvider;
import com.ibm.ws.security.javaeesec.properties.ModulePropertiesUtils;
import java.util.concurrent.ConcurrentHashMap;
import javax.security.auth.message.config.AuthConfigFactory;
import javax.security.auth.message.config.AuthConfigProvider;
import javax.security.auth.message.config.RegistrationListener;
import javax.security.enterprise.authentication.mechanism.http.AuthenticationParameters;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={BridgeBuilderService.class}, name="com.ibm.ws.security.javaeesec", configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true, property={"service.vendor=IBM"})
public class BridgeBuilderImpl
implements BridgeBuilderService {
    private static final TraceComponent tc = Tr.register(BridgeBuilderImpl.class, (String)"security", (String)"com.ibm.ws.security.javaeesec.internal.resources.JavaEESecMessages");
    private static final String JASPIC_LAYER_HTTP_SERVLET = "HttpServlet";
    static final long serialVersionUID = -6923147454663634569L;

    @Activate
    protected void activate(ComponentContext cc) {
    }

    @Deactivate
    protected void deactivate(ComponentContext cc) {
    }

    public synchronized void buildBridgeIfNeeded(String appContext, AuthConfigFactory providerFactory) {
        AuthConfigProvider authConfigProvider = providerFactory.getConfigProvider(JASPIC_LAYER_HTTP_SERVLET, appContext, (RegistrationListener)null);
        if (authConfigProvider != null) {
            return;
        }
        if (this.getModulePropertiesUtils().isHttpAuthenticationMechanism()) {
            ConcurrentHashMap<String, String> props = new ConcurrentHashMap<String, String>();
            authConfigProvider = new AuthProvider(props, providerFactory);
            providerFactory.registerConfigProvider(authConfigProvider, JASPIC_LAYER_HTTP_SERVLET, appContext, "Bridge Provider for JSR-375 Java EE Security API");
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"HttpAuthenticationMechanism bean is not identified. JSR375 BridgeProvider is not enabled.", (Object[])new Object[0]);
        }
    }

    public boolean isProcessingNewAuthentication(HttpServletRequest req) {
        AuthenticationParameters authParams;
        if (this.getModulePropertiesUtils().isHttpAuthenticationMechanism() && (authParams = (AuthenticationParameters)req.getAttribute("com.ibm.ws.security.javaeesec.auth.params")) != null) {
            return authParams.isNewAuthentication();
        }
        return false;
    }

    public boolean isCredentialPresent(HttpServletRequest req) {
        AuthenticationParameters authParams;
        if (this.getModulePropertiesUtils().isHttpAuthenticationMechanism() && (authParams = (AuthenticationParameters)req.getAttribute("com.ibm.ws.security.javaeesec.auth.params")) != null) {
            return authParams.getCredential() != null;
        }
        return false;
    }

    protected ModulePropertiesUtils getModulePropertiesUtils() {
        return ModulePropertiesUtils.getInstance();
    }
}

