/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.inject.spi.Bean;
import org.jboss.weld.bean.proxy.ProxyInstantiator;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.config.WeldConfiguration;
import org.jboss.weld.exceptions.UnproxyableResolutionException;
import org.jboss.weld.logging.UtilLogger;
import org.jboss.weld.logging.ValidatorLogger;
import org.jboss.weld.util.Beans;
import org.jboss.weld.util.CustomClassComparator;
import org.jboss.weld.util.SecurityActions;
import org.jboss.weld.util.collections.Arrays2;
import org.jboss.weld.util.collections.ImmutableList;
import org.jboss.weld.util.collections.ImmutableMap;
import org.jboss.weld.util.reflection.Reflections;

public class Proxies {
    private Proxies() {
    }

    public static boolean isTypeProxyable(Type type, ServiceRegistry services) {
        return Proxies.getUnproxyableTypeException(type, services) == null;
    }

    public static UnproxyableResolutionException getUnproxyableTypeException(Type type, ServiceRegistry services) {
        return Proxies.getUnproxyableTypeException(type, null, services, false);
    }

    public static boolean isTypesProxyable(Bean<?> declaringBean, ServiceRegistry services) {
        return Proxies.getUnproxyableTypesException(declaringBean, services) == null;
    }

    public static boolean isTypesProxyable(Iterable<? extends Type> types, ServiceRegistry services) {
        return Proxies.getUnproxyableTypesException(types, services) == null;
    }

    public static UnproxyableResolutionException getUnproxyableTypesException(Bean<?> declaringBean, ServiceRegistry services) {
        if (declaringBean == null) {
            throw new IllegalArgumentException("Null declaring bean!");
        }
        return Proxies.getUnproxyableTypesExceptionInt(declaringBean.getTypes(), declaringBean, services);
    }

    public static UnproxyableResolutionException getUnproxyableTypesException(Iterable<? extends Type> types, ServiceRegistry services) {
        return Proxies.getUnproxyableTypesExceptionInt(types, null, services);
    }

    public static UnproxyableResolutionException getUnproxyableTypeException(Type type, Bean<?> declaringBean, ServiceRegistry services, boolean ignoreFinalMethods) {
        if (type instanceof Class || type instanceof ParameterizedType || type instanceof GenericArrayType) {
            return Proxies.getUnproxyableClassException(Reflections.getRawType(type), declaringBean, services, ignoreFinalMethods);
        }
        return ValidatorLogger.LOG.notProxyableUnknown(type, Proxies.getDeclaringBeanInfo(declaringBean));
    }

    private static UnproxyableResolutionException getUnproxyableTypesExceptionInt(Iterable<? extends Type> types, Bean<?> declaringBean, ServiceRegistry services) {
        for (Type type : types) {
            UnproxyableResolutionException e;
            if (Object.class.equals((Object)type) || (e = Proxies.getUnproxyableTypeException(type, declaringBean, services, false)) == null) continue;
            return e;
        }
        return null;
    }

    private static UnproxyableResolutionException getUnproxyableClassException(Class<?> clazz, Bean<?> declaringBean, ServiceRegistry services, boolean ignoreFinalMethods) {
        UnproxyableResolutionException exception;
        if (clazz.isInterface()) {
            return null;
        }
        Constructor<?> constructor = null;
        try {
            constructor = SecurityActions.getDeclaredConstructor(clazz, new Class[0]);
        }
        catch (Exception exception2) {
            // empty catch block
        }
        if (clazz.isPrimitive()) {
            return ValidatorLogger.LOG.notProxyablePrimitive(clazz, Proxies.getDeclaringBeanInfo(declaringBean));
        }
        if (Reflections.isArrayType(clazz)) {
            return ValidatorLogger.LOG.notProxyableArrayType(clazz, Proxies.getDeclaringBeanInfo(declaringBean));
        }
        if (Reflections.isFinal(clazz)) {
            return ValidatorLogger.LOG.notProxyableFinalType(clazz, Proxies.getDeclaringBeanInfo(declaringBean));
        }
        Method finalMethod = Reflections.getNonPrivateNonStaticFinalMethod(clazz);
        if (finalMethod != null) {
            if (ignoreFinalMethods || Beans.shouldIgnoreFinalMethods(declaringBean) || services.get(WeldConfiguration.class).isFinalMethodIgnored(clazz.getName())) {
                ValidatorLogger.LOG.notProxyableFinalMethodIgnored(finalMethod, Proxies.getDeclaringBeanInfo(declaringBean));
            } else {
                return ValidatorLogger.LOG.notProxyableFinalMethod(clazz, finalMethod, Proxies.getDeclaringBeanInfo(declaringBean));
            }
        }
        if ((exception = services.get(ProxyInstantiator.class).validateNoargConstructor(constructor, clazz, declaringBean)) != null) {
            return exception;
        }
        return null;
    }

    public static Object getDeclaringBeanInfo(Bean<?> bean) {
        return bean != null ? bean : "<unknown javax.enterprise.inject.spi.Bean instance>";
    }

    public static LinkedHashSet<Class<?>> sortInterfacesHierarchy(Set<Class<?>> interfaces) {
        LinkedHashSet sorted = new LinkedHashSet(interfaces.size());
        Proxies.processSuperinterface(null, interfaces, sorted);
        if (interfaces.size() != sorted.size()) {
            HashSet unprocessed = new HashSet(interfaces);
            unprocessed.removeAll(sorted);
            for (Class clazz : unprocessed) {
                Proxies.processSuperinterface(clazz, interfaces, sorted);
                sorted.add(clazz);
            }
        }
        return sorted;
    }

    private static void processSuperinterface(Class<?> superinterface, Set<Class<?>> interfaces, LinkedHashSet<Class<?>> sorted) {
        for (Class<?> interfaceClass : interfaces) {
            if (!Proxies.isInterfaceExtending(interfaceClass, superinterface)) continue;
            Proxies.processSuperinterface(interfaceClass, interfaces, sorted);
            sorted.add(interfaceClass);
        }
    }

    private static boolean isInterfaceExtending(Class<?> interfaceClass, Class<?> superinterface) {
        if (interfaceClass.equals(superinterface)) {
            return false;
        }
        if (superinterface == null) {
            return interfaceClass.getInterfaces().length == 0;
        }
        return Arrays2.contains(interfaceClass.getInterfaces(), superinterface);
    }

    public static class TypeInfo {
        private final List<Class<?>> interfaces;
        private final List<Class<?>> classes;
        private final Map<String, String> classToPackageMap;

        private TypeInfo(Set<? extends Type> types) {
            ArrayList foundInterfaces = new ArrayList();
            ArrayList foundClasses = new ArrayList();
            HashMap classToPackage = new HashMap();
            types.stream().forEach(type -> this.add((Type)type, foundInterfaces, foundClasses, classToPackage));
            Collections.sort(foundClasses, Comparator.comparing(Class::getName));
            Collections.sort(foundInterfaces, new CustomClassComparator());
            this.interfaces = ImmutableList.copyOf(foundInterfaces);
            this.classes = ImmutableList.copyOf(foundClasses);
            this.classToPackageMap = ImmutableMap.copyOf(classToPackage);
        }

        private TypeInfo add(Type type, List<Class<?>> foundInterfaces, List<Class<?>> foundClasses, Map<String, String> classToPackageMap) {
            if (type instanceof Class) {
                Class clazz = (Class)type;
                classToPackageMap.put(clazz.getName(), clazz.getPackage().getName());
                if (clazz.isInterface()) {
                    foundInterfaces.add(clazz);
                } else {
                    foundClasses.add(clazz);
                }
            } else if (type instanceof ParameterizedType) {
                this.add(((ParameterizedType)type).getRawType(), foundInterfaces, foundClasses, classToPackageMap);
            } else {
                throw UtilLogger.LOG.cannotProxyNonClassType(type);
            }
            return this;
        }

        public Class<?> getSuperClass() {
            if (this.classes.isEmpty()) {
                return Object.class;
            }
            Iterator<Class<?>> it = this.classes.iterator();
            Class<?> superclass = it.next();
            while (it.hasNext()) {
                Class<?> clazz = it.next();
                if (!superclass.isAssignableFrom(clazz)) continue;
                superclass = clazz;
            }
            return superclass;
        }

        public Class<?> getSuperInterface() {
            if (this.interfaces.isEmpty()) {
                return null;
            }
            Iterator<Class<?>> it = this.interfaces.iterator();
            Class<?> superclass = it.next();
            while (it.hasNext()) {
                Class<?> clazz = it.next();
                if (!superclass.isAssignableFrom(clazz)) continue;
                superclass = clazz;
            }
            return superclass;
        }

        public List<Class<?>> getClasses() {
            return this.classes;
        }

        public List<Class<?>> getInterfaces() {
            return this.interfaces;
        }

        public String getPackageNameForClass(Class<?> clazz) {
            return this.classToPackageMap.get(clazz.getName());
        }

        public static TypeInfo of(Set<? extends Type> types) {
            return new TypeInfo(types);
        }
    }
}

