/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.health30.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.health30.impl.HealthCheck30ResponseImpl;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.HealthCheckResponseBuilder;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class HealthCheck30ResponseBuilderImpl
extends HealthCheckResponseBuilder {
    private static final TraceComponent tc = Tr.register(HealthCheck30ResponseBuilderImpl.class, (String)"HEALTH", (String)"io.openliberty.microprofile.health.resources.Health");
    private String name;
    private final Optional<Map<String, Object>> data = Optional.of(new HashMap());
    private HealthCheckResponse.Status status;
    static final long serialVersionUID = 7686011240972772919L;

    public HealthCheckResponseBuilder name(String name) {
        this.validateName(name);
        this.name = name;
        return this;
    }

    public HealthCheckResponseBuilder withData(String key, String value) {
        return this.withData(key, (Object)value);
    }

    public HealthCheckResponseBuilder withData(String key, long value) {
        return this.withData(key, (Object)value);
    }

    public HealthCheckResponseBuilder withData(String key, boolean value) {
        return this.withData(key, (Object)value);
    }

    public HealthCheckResponseBuilder up() {
        this.status = HealthCheckResponse.Status.UP;
        return this;
    }

    public HealthCheckResponseBuilder down() {
        this.status = HealthCheckResponse.Status.DOWN;
        return this;
    }

    public HealthCheckResponseBuilder status(boolean up) {
        this.status = up ? HealthCheckResponse.Status.UP : HealthCheckResponse.Status.DOWN;
        return this;
    }

    public HealthCheckResponse build() {
        HealthCheck30ResponseImpl response = new HealthCheck30ResponseImpl(this.name, this.status, this.data);
        return response;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("HealthCheckResponseBuilder: ");
        builder.append("\n\t");
        builder.append("name");
        builder.append(" = ");
        builder.append(this.name);
        builder.append("\n\t");
        builder.append("status");
        builder.append(" = ");
        builder.append(this.status);
        builder.append("\n\t");
        builder.append("data");
        builder.append(" = ");
        builder.append(this.data);
        return builder.toString();
    }

    private HealthCheckResponseBuilder withData(String key, Object value) {
        this.validateKey(key);
        if (this.data.isPresent()) {
            this.data.get().put(key, value);
        }
        return this;
    }

    private void validateName(String name) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException(Tr.formatMessage((TraceComponent)tc, (String)"Name is null", (Object[])new Object[0]));
        }
    }

    private void validateKey(String key) {
        if (key == null || key.length() == 0) {
            throw new IllegalArgumentException(Tr.formatMessage((TraceComponent)tc, (String)"Key is null", (Object[])new Object[0]));
        }
    }
}

