/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.connectionpool.monitor;

import com.ibm.ws.connectionpool.monitor.ConnectionPoolMonitor;
import com.ibm.ws.connectionpool.monitor.ConnectionPoolStats;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.pmi.stat.BoundedRangeStatisticImpl;
import com.ibm.ws.pmi.stat.CountStatisticImpl;
import com.ibm.ws.pmi.stat.TimeStatisticImpl;
import com.ibm.wsspi.pmi.factory.StatisticActions;
import com.ibm.wsspi.pmi.factory.StatsFactory;
import com.ibm.wsspi.pmi.factory.StatsFactoryException;
import com.ibm.wsspi.pmi.factory.StatsGroup;
import com.ibm.wsspi.pmi.factory.StatsInstance;
import com.ibm.wsspi.pmi.stat.SPIStatistic;

public class LegacyMonitor
extends StatisticActions {
    public static final int NUM_CREATES = 1;
    public static final int NUM_DESTROYS = 2;
    public static final int NUM_MANAGED_CONNECTIONS = 14;
    public static final int NUM_CONNECTIONS = 15;
    public static final int AVERAGE_WAIT = 13;
    public static final int FREE_POOL_SIZE = 6;
    private StatsInstance si;
    private CountStatisticImpl numManagedConnections = null;
    private CountStatisticImpl numConnectionHandles = null;
    private CountStatisticImpl numManagedConnectionsCreated = null;
    private CountStatisticImpl numManagedConnectionsDestroyed = null;
    private TimeStatisticImpl averageWait = null;
    private BoundedRangeStatisticImpl freePoolSize = null;

    public LegacyMonitor(String dsName, StatsGroup grp) {
        if (grp != null) {
            try {
                this.si = StatsFactory.createStatsInstance((String)dsName, (StatsGroup)grp, null, (StatisticActions)this);
            }
            catch (StatsFactoryException e) {
                FFDCFilter.processException((Throwable)e, (String)((Object)((Object)this)).getClass().getName(), (String)"ConnectionPool LegacyMonitor");
            }
        }
    }

    public void statisticCreated(SPIStatistic s) {
        if (s.getId() == 1) {
            this.numManagedConnectionsCreated = (CountStatisticImpl)s;
        } else if (s.getId() == 2) {
            this.numManagedConnectionsDestroyed = (CountStatisticImpl)s;
        } else if (s.getId() == 14) {
            this.numManagedConnections = (CountStatisticImpl)s;
        } else if (s.getId() == 15) {
            this.numConnectionHandles = (CountStatisticImpl)s;
        } else if (s.getId() == 13) {
            this.averageWait = (TimeStatisticImpl)s;
        } else if (s.getId() == 6) {
            this.freePoolSize = (BoundedRangeStatisticImpl)s;
        }
    }

    public void updateStatisticOnRequest(int dataId) {
        if (this.si != null) {
            ConnectionPoolStats temp = ConnectionPoolMonitor.getConnectionPoolOB(this.si.getName());
            if (dataId == 1) {
                this.numManagedConnectionsCreated.setCount(temp.getCreateCount());
            }
            if (dataId == 2) {
                this.numManagedConnectionsDestroyed.setCount(temp.getDestroyCount());
            }
            if (dataId == 14) {
                this.numManagedConnections.setCount(temp.getManagedConnectionCount());
            }
            if (dataId == 15) {
                this.numConnectionHandles.setCount(temp.getConnectionHandleCount());
            }
            if (dataId == 13) {
                this.averageWait.set((long)temp.getWaitTime(), (long)temp.getWaitTime(), (long)temp.getWaitTime(), 0L, 0.0, 0L, 0L);
            }
            if (dataId == 6) {
                this.freePoolSize.set(temp.getFreeConnectionCount());
            }
        }
    }

    public void removeSInstance() {
        try {
            StatsFactory.removeStatsInstance((StatsInstance)this.si);
        }
        catch (StatsFactoryException e) {
            e.getMessage();
        }
    }
}

