/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.jaxrs.server;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jaxrs20.api.JaxRsProviderFactoryService;
import com.ibm.ws.jaxrs20.endpoint.JaxRsWebEndpoint;
import com.ibm.ws.jaxrs20.server.JaxRsHttpServletRequestAdapter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.wsspi.webcontainer.collaborator.IWebAppNameSpaceCollaborator;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class IBMRestServlet
extends HttpServlet {
    private static final long serialVersionUID = -6835560282014155024L;
    private static final List<String> KNOWN_HTTP_VERBS;
    private static final String HTML_CONTENT_TYPE = "text/html";
    private transient JaxRsWebEndpoint endpoint;
    private final transient IWebAppNameSpaceCollaborator collaborator;
    private final transient JaxRsProviderFactoryService providerFactoryService;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public IBMRestServlet(JaxRsWebEndpoint endpoint, JaxRsProviderFactoryService jaxRsProviderFactoryServicer) {
        this(endpoint, null, jaxRsProviderFactoryServicer);
    }

    public IBMRestServlet(JaxRsWebEndpoint endpoint, IWebAppNameSpaceCollaborator collaborator, JaxRsProviderFactoryService jaxRsProviderFactoryService) {
        this.endpoint = endpoint;
        this.collaborator = collaborator;
        this.providerFactoryService = jaxRsProviderFactoryService;
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        if (this.endpoint != null) {
            this.endpoint.init(servletConfig, this.providerFactoryService);
        } else if (this.endpoint == null) {
            throw new ServletException("Could not find endpoint information.");
        }
    }

    /*
     * WARNING - void declaration
     */
    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        HttpServletResponse response;
        HttpServletRequest request;
        try {
            request = (HttpServletRequest)req;
            if (this.collaborator != null) {
                ComponentMetaData componentMetaData = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
                request = new JaxRsHttpServletRequestAdapter(request, this.collaborator, componentMetaData);
            }
            response = (HttpServletResponse)res;
        }
        catch (ClassCastException componentMetaData) {
            void e;
            FFDCFilter.processException((Throwable)componentMetaData, (String)"com.ibm.websphere.jaxrs.server.IBMRestServlet", (String)"90", (Object)((Object)this), (Object[])new Object[]{req, res});
            throw new ServletException("Unrecognized HTTP request or response object", (Throwable)e);
        }
        String method = request.getMethod();
        if (KNOWN_HTTP_VERBS.contains(method)) {
            super.service(request, response);
        } else {
            this.handleRequest(request, response);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.handleRequest(request, response);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.handleRequest(request, response);
    }

    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.handleRequest(request, response);
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.handleRequest(request, response);
    }

    protected void doHead(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.handleRequest(request, response);
    }

    protected void handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        if (this.endpoint != null) {
            this.endpoint.invoke(request, response);
        }
    }

    protected void doOptions(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.handleRequest(request, response);
    }

    protected void doTrace(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.handleRequest(request, response);
    }

    public void destroy() {
        if (this.endpoint != null) {
            this.endpoint.destroy();
        }
        this.endpoint = null;
        super.destroy();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.websphere.jaxrs.server.IBMRestServlet", IBMRestServlet.class, null, null);
        KNOWN_HTTP_VERBS = Arrays.asList("POST", "GET", "PUT", "DELETE", "HEAD", "OPTIONS", "TRACE");
    }
}

