/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxrs20.server.component;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jaxrs20.metadata.JaxRsModuleInfo;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.webcontainer.webapp.WebApp;
import com.ibm.wsspi.adaptable.module.NonPersistentCache;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import java.util.ArrayList;
import java.util.Set;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(name="com.ibm.ws.jaxrs20.server.JaxRsRouterServletContainerInitializer", property={"service.vendor=IBM"})
public class JaxRsRouterServletContainerInitializer
implements ServletContainerInitializer {
    private static final TraceComponent tc = Tr.register(JaxRsRouterServletContainerInitializer.class, (String)"JaxRsServer", (String)"com.ibm.ws.jaxrs20.server.internal.resources.JaxRsServerMessages");
    static final long serialVersionUID = 2275917321912964282L;

    public void activate(ComponentContext context) {
    }

    public void deactivate(ComponentContext context) {
    }

    public void onStartup(Set<Class<?>> classes, ServletContext sc) throws ServletException {
        if (sc instanceof WebApp) {
            WebApp wapp = (WebApp)WebApp.class.cast(sc);
            String moduleName = wapp.getModuleMetaData().getName();
            if (moduleName.indexOf("-RSRouter") == -1) {
                return;
            }
            try {
                NonPersistentCache overlayCache = (NonPersistentCache)wapp.getModuleContainer().adapt(NonPersistentCache.class);
                JaxRsModuleInfo jaxrsModuleInfo = (JaxRsModuleInfo)overlayCache.getFromCache(JaxRsModuleInfo.class);
                if (jaxrsModuleInfo == null) {
                    return;
                }
            }
            catch (UnableToAdaptException overlayCache) {
                FFDCFilter.processException((Throwable)overlayCache, (String)"com.ibm.ws.jaxrs20.server.component.JaxRsRouterServletContainerInitializer", (String)"71", (Object)this, (Object[])new Object[]{classes, sc});
                return;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Jaxrs EJB Router module '" + moduleName + "' is detected"), (Object[])new Object[]{moduleName});
            }
            ArrayList sca = wapp.getServletContextListeners();
            int index = -1;
            for (int i = 0; i < sca.size(); ++i) {
                ServletContextListener scl = (ServletContextListener)sca.get(i);
                if (!scl.getClass().getName().equals("org.apache.myfaces.webapp.StartupServletContextListener")) continue;
                index = i;
                break;
            }
            if (index != -1) {
                ServletContextListener scl = (ServletContextListener)sca.remove(index);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("org.apache.myfaces.webapp.StartupServletContextListener is removed from Jaxrs EJB Router module '" + moduleName + "'"), (Object[])new Object[]{moduleName, scl});
                }
            }
        }
    }
}

