/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.common.jwk.subject.mapping;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.jwk.utils.JsonUtils;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.jose4j.lang.JoseException;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class AttributeToSubject {
    public static final TraceComponent tc = Tr.register(AttributeToSubject.class, (String)"SecurityCommon", (String)"com.ibm.ws.security.common.internal.resources.SSOCommonMessages");
    String realm = null;
    String uniqueSecurityName = null;
    String userName = null;
    String clientId = null;
    ArrayList<String> groupIds = null;
    String userApiRespId = null;
    static final long serialVersionUID = 3437796802050638276L;

    public AttributeToSubject(String jsonstr, String userAttr, String uniqueNameAttr, String realmName, String realmAttr, String groupAttr, boolean mapToUr, String userApiRespIdentifier) {
        this.userName = this.getTheUserName(userAttr, jsonstr, userApiRespIdentifier);
        if (this.userName != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"user name = ", (Object[])new Object[]{this.userName});
            }
            if (!mapToUr) {
                block14: {
                    if (this.realm == null || this.realm.isEmpty()) {
                        this.realm = this.getTheRealmName(realmName, realmAttr, jsonstr);
                    }
                    if (this.uniqueSecurityName == null || this.uniqueSecurityName.isEmpty()) {
                        this.uniqueSecurityName = this.getTheUniqueSecurityName(uniqueNameAttr, jsonstr);
                    }
                    Object group = null;
                    if (groupAttr != null) {
                        try {
                            group = JsonUtils.claimFromJsonObject(jsonstr, groupAttr);
                        }
                        catch (JoseException joseException) {
                            FFDCFilter.processException((Throwable)joseException, (String)"com.ibm.ws.security.common.jwk.subject.mapping.AttributeToSubject", (String)"61", (Object)this, (Object[])new Object[]{jsonstr, userAttr, uniqueNameAttr, realmName, realmAttr, groupAttr, mapToUr, userApiRespIdentifier});
                        }
                    }
                    if (group != null) {
                        if (group instanceof ArrayList) {
                            this.groupIds = (ArrayList)group;
                        } else {
                            try {
                                String groupName = (String)group;
                                this.groupIds = new ArrayList();
                                this.groupIds.add(groupName);
                            }
                            catch (ClassCastException groupName) {
                                FFDCFilter.processException((Throwable)groupName, (String)"com.ibm.ws.security.common.jwk.subject.mapping.AttributeToSubject", (String)"73", (Object)this, (Object[])new Object[]{jsonstr, userAttr, uniqueNameAttr, realmName, realmAttr, groupAttr, mapToUr, userApiRespIdentifier});
                                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block14;
                                Tr.debug((TraceComponent)tc, (String)"can not get meaningful group due to CCE.", (Object[])new Object[0]);
                            }
                        }
                    }
                }
                if (this.groupIds != null && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"groups size = ", (Object[])new Object[]{this.groupIds.size()});
                }
            }
        }
    }

    public boolean checkUserNameForNull() {
        if (this.userName == null || this.userName.isEmpty()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"There is no principal", (Object[])new Object[0]);
            }
            return true;
        }
        return false;
    }

    public boolean checkForNullRealm() {
        if (this.realm == null || this.realm.isEmpty()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"There is no realm", (Object[])new Object[0]);
            }
            return true;
        }
        return false;
    }

    public String getMappedUser() {
        return this.userName;
    }

    public String getMappedUniqueUser() {
        return this.uniqueSecurityName;
    }

    public String getMappedRealm() {
        return this.realm;
    }

    public ArrayList<String> getMappedGroups() {
        return this.groupIds;
    }

    private String getTheUserName(String userNameAttr, String jsonstr, String userApiRespIdentifier) {
        if (jsonstr != null && userNameAttr != null && !userNameAttr.isEmpty()) {
            Object user = null;
            try {
                user = JsonUtils.claimFromJsonObject(jsonstr, userNameAttr);
            }
            catch (JoseException joseException) {
                FFDCFilter.processException((Throwable)joseException, (String)"com.ibm.ws.security.common.jwk.subject.mapping.AttributeToSubject", (String)"134", (Object)this, (Object[])new Object[]{userNameAttr, jsonstr, userApiRespIdentifier});
            }
            if (user != null) {
                if (user instanceof String) {
                    this.userName = (String)user;
                } else if (userApiRespIdentifier != null) {
                    this.userName = this.handleDifferentDataTypes(user, userNameAttr, userApiRespIdentifier);
                } else {
                    Tr.error((TraceComponent)tc, (String)"SUBJECT_MAPPING_INCORRECT_CLAIM_TYPE", (Object[])new Object[]{userNameAttr, "userNameAttribute"});
                }
            } else {
                try {
                    this.userName = this.parseTheJsonAgain(jsonstr, userNameAttr);
                }
                catch (JoseException joseException) {
                    FFDCFilter.processException((Throwable)joseException, (String)"com.ibm.ws.security.common.jwk.subject.mapping.AttributeToSubject", (String)"150", (Object)this, (Object[])new Object[]{userNameAttr, jsonstr, userApiRespIdentifier});
                }
            }
        }
        if (this.userName == null) {
            Tr.error((TraceComponent)tc, (String)"SUBJECT_MAPPING_MISSING_ATTR", (Object[])new Object[]{userNameAttr, "userNameAttribute"});
        }
        return this.userName;
    }

    private String parseTheJsonAgain(String jsonstr, String attr) throws JoseException {
        Map map = JsonUtils.claimsFromJsonObject(jsonstr);
        Set keys = map.keySet();
        for (String key : keys) {
            Object obj = map.get(key);
            if (!(obj instanceof Map) || !((Map)obj).containsKey(attr)) continue;
            try {
                return (String)((Map)obj).get(attr);
            }
            catch (ClassCastException classCastException) {
                FFDCFilter.processException((Throwable)classCastException, (String)"com.ibm.ws.security.common.jwk.subject.mapping.AttributeToSubject", (String)"173", (Object)this, (Object[])new Object[]{jsonstr, attr});
                return null;
            }
        }
        return null;
    }

    private String handleDifferentDataTypes(Object user, String userNameAttr, String userApiRespIdentifier) {
        boolean logerror;
        String name;
        block11: {
            name = null;
            logerror = false;
            try {
                if (user instanceof Map) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"response is a map", (Object[])new Object[0]);
                    }
                    name = (String)((Map)user).get(userNameAttr);
                    break block11;
                }
                if (user instanceof ArrayList) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"response is an array list", (Object[])new Object[0]);
                    }
                    try {
                        ArrayList list = (ArrayList)user;
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"response is an array list of maps", (Object[])new Object[0]);
                        }
                        for (int i = 0; i < list.size(); ++i) {
                            Map map = (Map)list.get(i);
                            if (!map.containsKey(userApiRespIdentifier) || !((Boolean)map.get(userApiRespIdentifier)).booleanValue()) continue;
                            name = (String)map.get(userNameAttr);
                            break block11;
                        }
                        break block11;
                    }
                    catch (ClassCastException list) {
                        FFDCFilter.processException((Throwable)list, (String)"com.ibm.ws.security.common.jwk.subject.mapping.AttributeToSubject", (String)"209", (Object)this, (Object[])new Object[]{user, userNameAttr, userApiRespIdentifier});
                        logerror = true;
                        break block11;
                    }
                }
                logerror = true;
            }
            catch (Exception cce) {
                FFDCFilter.processException((Throwable)cce, (String)"com.ibm.ws.security.common.jwk.subject.mapping.AttributeToSubject", (String)"216", (Object)this, (Object[])new Object[]{user, userNameAttr, userApiRespIdentifier});
                logerror = true;
            }
        }
        if (logerror) {
            Tr.error((TraceComponent)tc, (String)"SUBJECT_MAPPING_INCORRECT_CLAIM_TYPE", (Object[])new Object[]{userNameAttr, "userNameAttribute"});
        }
        return name;
    }

    protected String getTheRealmName(String realmNameFromConfig, String realmAttr, String jsonstr) {
        if (realmNameFromConfig != null) {
            this.realm = realmNameFromConfig;
            return this.realm;
        }
        if (jsonstr != null) {
            if (realmAttr != null && !realmAttr.isEmpty()) {
                Object realmfrom = null;
                try {
                    realmfrom = JsonUtils.claimFromJsonObject(jsonstr, realmAttr);
                }
                catch (JoseException joseException) {
                    FFDCFilter.processException((Throwable)joseException, (String)"com.ibm.ws.security.common.jwk.subject.mapping.AttributeToSubject", (String)"237", (Object)this, (Object[])new Object[]{realmNameFromConfig, realmAttr, jsonstr});
                }
                if (realmfrom != null && realmfrom instanceof String) {
                    this.realm = (String)realmfrom;
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"realm name = ", (Object[])new Object[]{this.realm});
            }
        }
        return this.realm;
    }

    protected String getTheUniqueSecurityName(String uniqueUserAttr, String jsonstr) {
        if (jsonstr != null) {
            if (uniqueUserAttr != null && !uniqueUserAttr.isEmpty()) {
                Object unique = null;
                try {
                    unique = JsonUtils.claimFromJsonObject(jsonstr, uniqueUserAttr);
                }
                catch (JoseException joseException) {
                    FFDCFilter.processException((Throwable)joseException, (String)"com.ibm.ws.security.common.jwk.subject.mapping.AttributeToSubject", (String)"261", (Object)this, (Object[])new Object[]{uniqueUserAttr, jsonstr});
                }
                if (unique != null) {
                    if (unique instanceof String) {
                        this.uniqueSecurityName = (String)unique;
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"unique security name = ", (Object[])new Object[]{this.uniqueSecurityName});
                    }
                }
            }
            if (this.uniqueSecurityName == null || this.uniqueSecurityName.isEmpty()) {
                this.uniqueSecurityName = this.userName;
            }
        }
        return this.uniqueSecurityName;
    }
}

