/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.common.structures;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public abstract class CommonCache {
    protected int entryLimit = 50000;
    protected long timeoutInMilliSeconds = 300000L;
    private ScheduledThreadPoolExecutor evictionSchedule;
    static final long serialVersionUID = 4338242437071766702L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public int size() {
        return this.entryLimit;
    }

    public long getTimeoutInMilliseconds() {
        return this.timeoutInMilliSeconds;
    }

    public abstract void remove(@Sensitive Object var1);

    public abstract Object get(@Sensitive String var1);

    public abstract void put(@Sensitive String var1, Object var2);

    public synchronized void rescheduleCleanup(long newTimeoutInMillis) {
        if (newTimeoutInMillis > 0L) {
            this.timeoutInMilliSeconds = newTimeoutInMillis;
        }
        if (this.evictionSchedule != null) {
            this.evictionSchedule.shutdownNow();
        }
        this.evictionSchedule = new ScheduledThreadPoolExecutor(1);
        this.evictionSchedule.scheduleWithFixedDelay(new EvictionTask(), this.timeoutInMilliSeconds, this.timeoutInMilliSeconds, TimeUnit.MILLISECONDS);
    }

    protected abstract void evictStaleEntries();

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.common.structures.CommonCache", CommonCache.class, null, null);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class EvictionTask
    implements Runnable {
        static final long serialVersionUID = -1733067057985688587L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private EvictionTask() {
        }

        @Override
        public void run() {
            CommonCache.this.evictStaleEntries();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.common.structures.CommonCache$EvictionTask", EvictionTask.class, null, null);
        }
    }
}

