/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.openapi.impl.validation;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.microprofile.openapi.impl.validation.OASValidationResult;
import com.ibm.ws.microprofile.openapi.impl.validation.TypeValidator;
import com.ibm.ws.microprofile.openapi.impl.validation.ValidationHelper;
import com.ibm.ws.microprofile.openapi.impl.validation.ValidatorUtils;
import com.ibm.ws.microprofile.openapi.utils.OpenAPIModelWalker;
import org.eclipse.microprofile.openapi.models.headers.Header;
import org.eclipse.microprofile.openapi.models.media.Content;
import org.eclipse.microprofile.openapi.models.media.Schema;

public class HeaderValidator
extends TypeValidator<Header> {
    private static final TraceComponent tc = Tr.register(HeaderValidator.class);
    private static final HeaderValidator INSTANCE = new HeaderValidator();

    public static HeaderValidator getInstance() {
        return INSTANCE;
    }

    private HeaderValidator() {
    }

    @Override
    public void validate(ValidationHelper helper, OpenAPIModelWalker.Context context, String key, Header t) {
        if (t != null) {
            String message;
            String reference = t.getRef();
            if (reference != null && !reference.isEmpty()) {
                ValidatorUtils.referenceValidatorHelper(reference, t, helper, context, key);
                return;
            }
            if (t.getExample() != null && t.getExamples() != null && !t.getExamples().isEmpty()) {
                String message2 = Tr.formatMessage((TraceComponent)tc, (String)"headerExampleOrExamples", (Object[])new Object[]{key});
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.WARNING, context.getLocation(), message2));
            }
            Schema schema = t.getSchema();
            Content content = t.getContent();
            if (schema == null && content == null) {
                message = Tr.formatMessage((TraceComponent)tc, (String)"headerSchemaOrContent", (Object[])new Object[]{key});
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message));
            }
            if (schema != null && content != null) {
                message = Tr.formatMessage((TraceComponent)tc, (String)"headerSchemaAndContent", (Object[])new Object[]{key});
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message));
            }
            if (content != null && content.size() > 1) {
                message = Tr.formatMessage((TraceComponent)tc, (String)"headerContentMap", (Object[])new Object[]{key});
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message));
            }
        }
    }
}

