/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.logging.internal.StackFinder;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;

public class TraceNLSResolver {
    private static final TraceComponent tc = Tr.register(TraceNLSResolver.class, "logging", "com.ibm.ws.logging.internal.resources.LoggingMessages");
    public static final String DEBUG_TRACE_NLS_PROPERTY = "com.ibm.ejs.ras.debugTraceNLSResolver";
    Boolean debugTraceNLSResolver = Boolean.getBoolean("com.ibm.ejs.ras.debugTraceNLSResolver");
    boolean makeNoise = this.debugTraceNLSResolver;
    protected static final String nullKey = "null";
    protected static final String svNullBundleName = "Resource Bundle name is null, key = {0}";
    protected static final String svBundleNotLoaded = "Unable to load ResourceBundle {0}";
    protected static final String svNullKeyMessage = "Null key passed while using ResourceBundle {0}";
    protected static final String svMalformedMessage = "No message text associated with key {0} in bundle {1}";

    public static final TraceNLSResolver getInstance() {
        return ResolverSingleton.instance;
    }

    TraceNLSResolver() {
    }

    public String getMessage(Class<?> aClass, ResourceBundle bundle, String bundleName, String key, Object[] args, String defaultString, boolean format, Locale locale, boolean quiet) {
        String returnValue = null;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        try {
            if (bundle == null) {
                bundle = this.getResourceBundle(aClass, bundleName, locale);
            }
            if ((returnValue = bundle.getString(key)).equals("")) {
                if (!quiet) {
                    TraceNLSResolver.logEvent(svMalformedMessage, new Object[]{key, bundleName});
                }
                returnValue = defaultString == null ? key : defaultString;
            }
            if (!format) {
                return returnValue;
            }
            return this.getFormattedMessage(returnValue, args);
        }
        catch (RuntimeException re) {
            if (bundleName == null) {
                if (key == null && defaultString == null) {
                    if (!quiet) {
                        TraceNLSResolver.logEvent(svNullBundleName, new Object[]{nullKey});
                    }
                    return MessageFormat.format(svNullBundleName, nullKey);
                }
                if (!quiet) {
                    TraceNLSResolver.logEvent(svNullBundleName, new Object[]{key, defaultString});
                }
                returnValue = defaultString == null ? key : defaultString;
                if (!format) {
                    return returnValue;
                }
                return this.getFormattedMessage(returnValue, args);
            }
            if (bundle == null) {
                if (!quiet) {
                    TraceNLSResolver.logEvent(svBundleNotLoaded, new Object[]{bundleName});
                }
                if (key == null && defaultString == null) {
                    return MessageFormat.format(svBundleNotLoaded, bundleName);
                }
                returnValue = defaultString == null ? key : defaultString;
                if (!format) {
                    return returnValue;
                }
                return this.getFormattedMessage(returnValue, args);
            }
            if (key == null) {
                if (!quiet) {
                    TraceNLSResolver.logEvent(svNullKeyMessage, new Object[]{bundleName});
                }
                if (defaultString == null) {
                    return MessageFormat.format(svNullKeyMessage, bundleName);
                }
                returnValue = defaultString;
                if (!format) {
                    return returnValue;
                }
                return this.getFormattedMessage(returnValue, args);
            }
            if (!quiet) {
                TraceNLSResolver.logEvent(svMalformedMessage, new Object[]{key, bundleName});
            }
            returnValue = defaultString == null ? key : defaultString;
            if (!format) {
                return returnValue;
            }
            return this.getFormattedMessage(returnValue, args);
        }
    }

    public String getFormattedMessage(String message, Object[] args) {
        if (args == null || message == null) {
            return message;
        }
        String formattedMessage = null;
        try {
            formattedMessage = MessageFormat.format(message, args);
        }
        catch (IllegalArgumentException e) {
            return message;
        }
        return formattedMessage;
    }

    public ResourceBundle getResourceBundle(Class<?> aClass, String bundleName, Locale locale) {
        return this.getResourceBundle(aClass, bundleName, locale == null ? null : Collections.singletonList(locale));
    }

    public ResourceBundle getResourceBundle(Class<?> aClass, String bundleName, List<Locale> locales) {
        ResourceBundle bundle = null;
        ClassLoader classLoader = null;
        if (bundleName == null) {
            throw new NullPointerException("Unable to load resource bundle: null bundleName");
        }
        if (locales == null) {
            locales = new ArrayList<Locale>();
        }
        if (locales.isEmpty()) {
            locales.add(Locale.getDefault());
        }
        Locale locale = locales.get(0);
        LocaleListControl control = new LocaleListControl(locales);
        if (aClass == null) {
            StackFinder finder = StackFinder.getInstance();
            aClass = finder.getCaller();
        }
        if (aClass != null) {
            try {
                classLoader = aClass.getClassLoader();
                bundle = ResourceBundle.getBundle(bundleName, locale, classLoader, control);
            }
            catch (RuntimeException re) {
                TraceNLSResolver.logEvent("Unable to load {0} from {1} (from class {2}) in {3}; caught exception: {4}", new Object[]{bundleName, classLoader, aClass, locale, re});
            }
        }
        if (bundle == null) {
            try {
                bundle = ResourceBundle.getBundle(bundleName, locale, control);
            }
            catch (RuntimeException re) {
                TraceNLSResolver.logEvent("Unable to load {0} from {1} in {2}; caught exception: {3}", new Object[]{bundleName, classLoader, locale, re});
                try {
                    classLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                        @Override
                        public Object run() throws Exception {
                            return Thread.currentThread().getContextClassLoader();
                        }
                    });
                    bundle = ResourceBundle.getBundle(bundleName, locale, classLoader, control);
                }
                catch (PrivilegedActionException pae) {
                    TraceNLSResolver.logEvent("Unable to load {0} from {1} in {2}; caught exception: {3}", new Object[]{bundleName, classLoader, locale, pae});
                    throw new RuntimeException("Unable to get context classloader", pae);
                }
            }
        }
        return bundle;
    }

    protected static final void logEvent(String message, Object[] args) {
        if (TraceNLSResolver.getInstance().makeNoise && tc.isEventEnabled()) {
            if (args == null) {
                Tr.event(tc, message, new Object[0]);
            } else {
                Tr.event(tc, MessageFormat.format(message, args), new Object[0]);
            }
        }
    }

    static class LocaleListControl
    extends ResourceBundle.Control {
        private final List<Locale> locales;

        public LocaleListControl(List<Locale> locales) {
            this.locales = locales;
        }

        @Override
        public List<Locale> getCandidateLocales(String baseName, Locale locale) {
            ArrayList<Locale> allLocales = new ArrayList<Locale>(this.locales);
            allLocales.addAll(super.getCandidateLocales(baseName, locale));
            return allLocales;
        }
    }

    private static class ResolverSingleton {
        static TraceNLSResolver instance = new TraceNLSResolver();

        private ResolverSingleton() {
        }
    }
}

