/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.metrics30.internal.writer;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.microprofile.metrics.exceptions.EmptyRegistryException;
import com.ibm.ws.microprofile.metrics.exceptions.NoSuchMetricException;
import com.ibm.ws.microprofile.metrics.exceptions.NoSuchRegistryException;
import com.ibm.ws.microprofile.metrics.writer.JSONMetadataWriter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.metrics30.internal.helper.Util30;
import io.openliberty.microprofile.metrics30.internal.writer.OutputWriter;
import java.io.Writer;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.Tag;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class JSONMetadataWriter30
extends JSONMetadataWriter
implements OutputWriter {
    private static final TraceComponent tc = Tr.register(JSONMetadataWriter30.class, (String)"METRICS", (String)"com.ibm.ws.microprofile.metrics.resources.Metrics");
    static final long serialVersionUID = 3667350261012257234L;

    public JSONMetadataWriter30(Writer writer, Locale locale) {
        super(writer, locale);
    }

    @Override
    protected JSONObject getMetricsMetadataAsJson(String registryName) throws NoSuchRegistryException, EmptyRegistryException {
        return this.getJsonFromMetricMetadataMap(Util30.getMetricsMetadataAsMap(registryName), Util30.getMetricsAsMap(registryName));
    }

    @Override
    protected JSONObject getMetricsMetadataAsJson(String registryName, String metricName) throws NoSuchRegistryException, EmptyRegistryException, NoSuchMetricException {
        return this.getJsonFromMetricMetadataMap(Util30.getMetricsMetadataAsMap(registryName, metricName), Util30.getMetricsAsMap(registryName, metricName));
    }

    @Override
    protected JSONObject getJsonFromObject(Metadata metadata) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"name", (Object)this.sanitizeMetadata(metadata.getName()));
        jsonObject.put((Object)"displayName", (Object)this.sanitizeMetadata(metadata.getDisplayName()));
        String description = metadata.description().isPresent() ? (String)metadata.description().get() : "";
        jsonObject.put((Object)"description", (Object)Tr.formatMessage((TraceComponent)tc, (Locale)this.locale, (String)description, (Object[])new Object[0]));
        jsonObject.put((Object)"type", (Object)this.sanitizeMetadata(metadata.getType()));
        jsonObject.put((Object)"unit", (Object)this.sanitizeMetadata(metadata.getUnit()));
        return jsonObject;
    }

    @Override
    protected JSONArray getJsonArrayTags(Map<MetricID, Metric> metricMap, String metricName) {
        JSONArray jsonArray = new JSONArray();
        for (MetricID metricID : metricMap.keySet()) {
            if (!metricID.getName().equals(metricName)) continue;
            JSONArray metricTagJsonArray = new JSONArray();
            TreeMap<String, String> tagsMap = metricID.getTags();
            Tag[] globalTags = Util30.getCachedGlobalTags();
            if (globalTags != null) {
                Tag[] metricTags = metricID.getTagsAsArray();
                TreeMap<String, String> tagsMapWithGlobalTags = new TreeMap<String, String>();
                for (Tag t : globalTags) {
                    tagsMapWithGlobalTags.put(t.getTagName(), t.getTagValue());
                }
                for (Tag t : metricTags) {
                    tagsMapWithGlobalTags.put(t.getTagName(), t.getTagValue());
                }
                tagsMap = tagsMapWithGlobalTags;
            }
            if (tagsMap == null) continue;
            for (Map.Entry tagEntry : tagsMap.entrySet()) {
                metricTagJsonArray.add((Object)((String)tagEntry.getKey() + "=" + (String)tagEntry.getValue()));
            }
            if (metricTagJsonArray.size() == 0) continue;
            jsonArray.add((Object)metricTagJsonArray);
        }
        return jsonArray;
    }
}

