/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.filemonitor.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.kernel.filemonitor.internal.UpdateMonitor;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.File;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class DirectoryUpdateMonitor
extends UpdateMonitor {
    static final TraceComponent tc = Tr.register(DirectoryUpdateMonitor.class, (String)"fileMonitor", (String)"com.ibm.ws.kernel.filemonitor.internal.resources.Messages");
    private final String fileFilter;
    private final boolean filesOnly;
    private final boolean directoriesOnly;
    private final Pattern fileNameRegex;
    private LinkedHashMap<String, FileInfo> inMemoryScanResults = null;
    static final long serialVersionUID = 5130703381772373064L;

    protected DirectoryUpdateMonitor(File monitoredFile, UpdateMonitor.MonitorType type, String filter) {
        super(monitoredFile, type);
        this.fileFilter = filter;
        this.filesOnly = "files".equals(this.fileFilter);
        this.directoriesOnly = this.filesOnly ? false : "directories".equals(this.fileFilter);
        this.fileNameRegex = this.filesOnly || this.directoriesOnly || filter == null ? null : Pattern.compile(this.fileFilter);
    }

    @Override
    public void init(Collection<File> baseline) {
        this.performScan(baseline, null, null);
    }

    @Override
    public void destroy() {
        this.inMemoryScanResults = null;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[type=" + (Object)((Object)this.type) + ",filter=" + this.fileFilter + ",file=" + this.monitoredFile + "]";
    }

    @Trivial
    protected boolean isFile(File f) {
        boolean rc;
        boolean bl = rc = f.exists() && !f.isDirectory();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"isFile", (Object[])new Object[]{"isFile = " + rc});
        }
        return rc;
    }

    @Override
    @Trivial
    public void scanForUpdates(Collection<File> created, Collection<File> modified, Collection<File> deleted) {
        this.performScan(created, modified, deleted);
    }

    protected void performScan(Collection<File> created, Collection<File> modified, Collection<File> deleted) {
        LinkedHashMap<String, FileInfo> newScanResult;
        block5: {
            boolean isFile;
            LinkedHashMap<String, FileInfo> prevScanResult;
            block4: {
                prevScanResult = this.inMemoryScanResults;
                newScanResult = new LinkedHashMap<String, FileInfo>();
                if (this.monitoredFile.isDirectory()) break block4;
                if (prevScanResult == null || prevScanResult.isEmpty() || deleted == null) break block5;
                for (Map.Entry<String, FileInfo> entry : prevScanResult.entrySet()) {
                    File f = new File(entry.getKey());
                    deleted.add(f);
                }
                if (!this.isIncludeSelf()) break block5;
                deleted.add(this.monitoredFile);
                break block5;
            }
            this.scanDirectory(prevScanResult, newScanResult, this.monitoredFile, created, modified);
            if (this.isIncludeSelf() && this.matches(this.monitoredFile, isFile = this.isFile(this.monitoredFile))) {
                this.scanFile(prevScanResult, newScanResult, this.monitoredFile, created, modified, isFile);
            }
            if (deleted != null && prevScanResult != null) {
                for (Map.Entry<String, FileInfo> entry : prevScanResult.entrySet()) {
                    File f = new File(entry.getKey());
                    deleted.add(f);
                }
            }
        }
        this.inMemoryScanResults = newScanResult;
    }

    private void scanFile(LinkedHashMap<String, FileInfo> cacheMap, LinkedHashMap<String, FileInfo> newMap, File f, Collection<File> created, Collection<File> modified, boolean isFile) {
        FileInfo newValue;
        String key = f.getAbsolutePath();
        FileInfo cachedValue = null;
        if (cacheMap != null) {
            cachedValue = (FileInfo)cacheMap.remove(key);
        }
        long fileModified = f.lastModified();
        long fileSize = f.length();
        if (cachedValue == null) {
            newValue = new FileInfo(isFile, fileModified, fileSize);
            this.addToList(created, f);
        } else if (cachedValue.hasChanged(isFile, fileModified, fileSize)) {
            newValue = new FileInfo(isFile, fileModified, fileSize);
            this.addToList(modified, f);
        } else {
            newValue = cachedValue;
        }
        newMap.put(key, newValue);
    }

    private void scanDirectory(LinkedHashMap<String, FileInfo> cacheMap, LinkedHashMap<String, FileInfo> newMap, File currentDir, Collection<File> created, Collection<File> modified) {
        File[] children = currentDir.listFiles();
        if (children != null) {
            for (File child : children) {
                boolean isFile;
                if (this.isRecursing() && child.isDirectory()) {
                    this.scanDirectory(cacheMap, newMap, child, created, modified);
                }
                if (!this.matches(child, isFile = this.isFile(child))) continue;
                this.scanFile(cacheMap, newMap, child, created, modified, isFile);
            }
        }
    }

    @Trivial
    protected boolean isRecursing() {
        boolean rc;
        boolean bl = rc = this.type == UpdateMonitor.MonitorType.DIRECTORY_RECURSE || this.type == UpdateMonitor.MonitorType.DIRECTORY_RECURSE_SELF;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"isRecursing", (Object[])new Object[]{"isRecursing = " + rc});
        }
        return rc;
    }

    @Trivial
    protected boolean isIncludeSelf() {
        boolean rc;
        boolean bl = rc = this.type == UpdateMonitor.MonitorType.DIRECTORY_SELF || this.type == UpdateMonitor.MonitorType.DIRECTORY_RECURSE_SELF;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"isIncludeSelf", (Object[])new Object[]{"isIncludeSelf = " + rc});
        }
        return rc;
    }

    protected boolean matches(File f, boolean isFile) {
        if (this.fileFilter != null) {
            Matcher m;
            if (isFile && this.directoriesOnly) {
                return false;
            }
            if (!isFile && this.filesOnly) {
                return false;
            }
            if (this.fileNameRegex != null && !(m = this.fileNameRegex.matcher(f.getName())).matches()) {
                return false;
            }
        }
        return true;
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && ((DirectoryUpdateMonitor)obj).fileFilter.equals(this.fileFilter);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static final class FileInfo {
        final boolean isFile;
        final long lastModified;
        final long size;
        static final long serialVersionUID = 5515965870359499889L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        FileInfo(boolean isFile, long lastModified, long size) {
            this.isFile = isFile;
            this.lastModified = lastModified;
            this.size = size;
        }

        boolean hasChanged(boolean newIsFile, long newLastModified, long newSize) {
            if (this.isFile != newIsFile) {
                return true;
            }
            if (this.isFile) {
                return newLastModified != this.lastModified || newSize != this.size;
            }
            return false;
        }

        public String toString() {
            return this.lastModified + ":" + this.size + (this.isFile ? ":f" : ":d");
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.filemonitor.internal.DirectoryUpdateMonitor$FileInfo", FileInfo.class, (String)"fileMonitor", (String)"com.ibm.ws.kernel.filemonitor.internal.resources.Messages");
        }
    }
}

