/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.event.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.event.internal.CurrentEvent;
import com.ibm.ws.event.internal.EventEngineImpl;
import com.ibm.ws.event.internal.EventImpl;
import com.ibm.ws.event.internal.adapter.OSGiHandlerAdapter;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.event.EventHandler;
import org.osgi.service.event.TopicPermission;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public final class HandlerHolder
implements Comparable<HandlerHolder>,
Runnable {
    private final ConcurrentLinkedQueue<EventImpl> eventQueue = new ConcurrentLinkedQueue();
    Lock lock = new ReentrantLock();
    private final List<String> discreteTopics = new ArrayList<String>();
    private final List<String> wildcardTopics = new ArrayList<String>();
    final EventEngineImpl eventEngine;
    final ServiceReference<?> serviceReference;
    final String filterSpec;
    com.ibm.websphere.event.EventHandler target = null;
    Filter filter = null;
    final String referenceName;
    final boolean reentrant;
    final long serviceId;
    final int serviceRanking;
    static final long serialVersionUID = 2102238793764547930L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    HandlerHolder(EventEngineImpl eventEngine, ServiceReference serviceReference, boolean osgiHandler) {
        this.eventEngine = eventEngine;
        this.serviceReference = serviceReference;
        Object topicsPropertyValue = serviceReference.getProperty("event.topics");
        if (topicsPropertyValue instanceof String) {
            this.populateTopics(new String[]{(String)topicsPropertyValue});
        } else if (topicsPropertyValue instanceof String[]) {
            this.populateTopics((String[])topicsPropertyValue);
        } else if (topicsPropertyValue instanceof Collection) {
            this.populateTopics(((Collection)topicsPropertyValue).toArray(new String[0]));
        } else {
            this.populateTopics(new String[0]);
        }
        this.filterSpec = (String)serviceReference.getProperty("event.filter");
        this.serviceId = (Long)serviceReference.getProperty("service.id");
        Object tmp = serviceReference.getProperty("service.ranking");
        int n = this.serviceRanking = tmp == null ? 0 : (Integer)tmp;
        if (osgiHandler) {
            this.reentrant = false;
            this.referenceName = "OsgiEventHandler";
        } else {
            String reentrantValue = (String)serviceReference.getProperty("reentrant.handler");
            this.reentrant = reentrantValue != null ? Boolean.valueOf(reentrantValue).booleanValue() : eventEngine.getDefaultReentrancy();
            this.referenceName = "WsEventHandler";
        }
    }

    private void populateTopics(String[] topics) {
        for (String t : topics) {
            if ((t = t.trim()).startsWith("/") || t.endsWith("/") || t.contains("//") || t.isEmpty()) continue;
            this.checkTopicSubscribePermission(t);
            if (t.equals("*")) {
                this.wildcardTopics.add("");
                continue;
            }
            if (t.endsWith("/*")) {
                this.wildcardTopics.add(t.substring(0, t.length() - 1));
                continue;
            }
            this.discreteTopics.add(t);
        }
    }

    private void checkTopicSubscribePermission(String topic) {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return;
        }
        sm.checkPermission(new TopicPermission(topic, "subscribe"));
    }

    ServiceReference getServiceReference() {
        return this.serviceReference;
    }

    List<String> getDiscreteTopics() {
        return this.discreteTopics;
    }

    List<String> getWildcardTopics() {
        return this.wildcardTopics;
    }

    boolean isReentrant() {
        return this.reentrant;
    }

    com.ibm.websphere.event.EventHandler getService() {
        if (this.target != null) {
            return this.target;
        }
        ComponentContext context = this.eventEngine.getComponentContext();
        if (context == null) {
            return null;
        }
        Object svc = context.locateService(this.referenceName, this.serviceReference);
        if (svc instanceof com.ibm.websphere.event.EventHandler) {
            this.target = (com.ibm.websphere.event.EventHandler)svc;
        } else if (svc instanceof EventHandler) {
            this.target = new OSGiHandlerAdapter((EventHandler)svc);
        }
        return this.target;
    }

    Filter getFilter() throws InvalidSyntaxException {
        if (this.filter == null && this.filterSpec != null) {
            this.filter = this.eventEngine.getBundleContext().createFilter(this.filterSpec);
        }
        return this.filter;
    }

    @Override
    public int compareTo(HandlerHolder holderToCompare) {
        if (holderToCompare == this || this.serviceId == holderToCompare.serviceId) {
            return 0;
        }
        int compare = holderToCompare.serviceRanking - this.serviceRanking;
        if (compare == 0) {
            return holderToCompare.serviceId > this.serviceId ? -1 : 1;
        }
        return holderToCompare.serviceRanking > this.serviceRanking ? 1 : -1;
    }

    @Override
    public void run() {
        this.fireEvent();
    }

    void addEvent(EventImpl event) {
        this.eventQueue.add(event);
    }

    void fireEvent() {
        boolean useLock;
        boolean bl = useLock = !this.isReentrant();
        if (useLock) {
            this.lock.lock();
        }
        EventImpl event = this.eventQueue.poll();
        try {
            if (event != null) {
                this.fireEvent(event);
            }
        }
        finally {
            if (useLock) {
                this.lock.unlock();
            }
        }
    }

    void fireSynchronousEvent(EventImpl event) {
        boolean useLock;
        boolean bl = useLock = !this.isReentrant();
        if (useLock) {
            this.lock.lock();
        }
        try {
            this.fireEvent(event);
        }
        finally {
            if (useLock) {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void fireEvent(EventImpl event) {
        CurrentEvent.push(event);
        try {
            com.ibm.websphere.event.EventHandler handler;
            Filter filter = this.getFilter();
            if ((filter == null || event.matches(filter)) && (handler = this.getService()) != null) {
                handler.handleEvent(event);
            }
        }
        catch (InvalidSyntaxException filter) {
            void ise;
            FFDCFilter.processException((Throwable)filter, (String)"com.ibm.ws.event.internal.HandlerHolder", (String)"391", (Object)this, (Object[])new Object[]{event});
            String msg = "Invalid filter specification: " + this.filterSpec;
            this.eventEngine.log(this.serviceReference, 2, msg, (Throwable)ise);
            if ("OsgiEventHandler".equals(this.referenceName)) {
                this.eventEngine.unsetWsEventHandler(this.serviceReference);
            } else if ("OsgiEventHandler".equals(this.referenceName)) {
                this.eventEngine.unsetOsgiEventHandler(this.serviceReference);
            }
        }
        catch (Throwable ise) {
            void t;
            FFDCFilter.processException((Throwable)ise, (String)"com.ibm.ws.event.internal.HandlerHolder", (String)"401", (Object)this, (Object[])new Object[]{event});
            String msg = "EventHandler " + this.target + " raised an exception while handling an event";
            this.eventEngine.log(this.serviceReference, 2, msg, (Throwable)t);
        }
        finally {
            CurrentEvent.pop();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append(";target=").append(this.target);
        sb.append(",serviceReference=").append(this.serviceReference);
        return sb.toString();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.event.internal.HandlerHolder", HandlerHolder.class, (String)"EventEngine", null);
    }
}

