/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.session.store.db;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.LocalTransaction.InconsistentLocalTranException;
import com.ibm.ws.LocalTransaction.LocalTransactionCoordinator;
import com.ibm.ws.LocalTransaction.LocalTransactionCurrent;
import com.ibm.ws.LocalTransaction.RolledbackException;
import com.ibm.ws.Transaction.UOWCoordinator;
import com.ibm.ws.Transaction.UOWCurrent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.serialization.SerializationService;
import com.ibm.ws.session.SessionManagerConfig;
import com.ibm.ws.session.SessionStatistics;
import com.ibm.ws.session.store.common.BackedHashMap;
import com.ibm.ws.session.store.common.BackedSession;
import com.ibm.ws.session.store.db.DBPortability;
import com.ibm.ws.session.store.db.DatabaseHandler;
import com.ibm.ws.session.store.db.DatabaseSession;
import com.ibm.ws.session.store.db.DatabaseStore;
import com.ibm.ws.session.store.db.DatabaseStoreService;
import com.ibm.ws.session.store.db.LoggingUtil;
import com.ibm.ws.session.store.db.MySQLHandler;
import com.ibm.ws.session.store.db.PostgreSQLHandler;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.wsspi.resource.ResourceConfig;
import com.ibm.wsspi.resource.ResourceInfo;
import com.ibm.wsspi.session.IStore;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ConcurrentModificationException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Level;
import javax.sql.DataSource;
import javax.transaction.Transaction;

public class DatabaseHashMap
extends BackedHashMap {
    static final String varList = "id, propid, appname, listenercnt, lastaccess, creationtime, maxinactivetime, username, small, medium, large";
    static final String TABLE_NAME = "sessions";
    String tableName = "sessions";
    String dbid;
    String dbpwd;
    private transient DatabaseStoreService databaseStoreService;
    boolean appDataTablesPerThread = false;
    String delPropall;
    boolean initialized = false;
    boolean tryingToInitialize = false;
    boolean firstInitialize = true;
    IStore _iStore;
    SessionManagerConfig _smc;
    static final int SOMEBIGSIZE = 0x200B20;
    static final int SMALLCOL_SIZE_DB2 = 3122;
    static final int SMALLCOL_SIZE_DB2_8K = 7218;
    static final int SMALLCOL_SIZE_DB2_16K = 15410;
    static final int SMALLCOL_SIZE_DB2_32K = 31794;
    static final int MEDIUMCOL_SIZE_DB2 = 32700;
    static final int MEDIUMCOL_SIZE_DB2_ZOS = 28869;
    static final int LARGECOL_SIZE_DB2 = 0x200000;
    static final int SMALLCOL_SIZE_ORACLE = 2000;
    static final int MEDIUMCOL_SIZE_ORACLE = 0x200000;
    static final int LARGECOL_SIZE_ORACLE = 1;
    static final int SMALLCOL_SIZE_SYBASE = 0xA00000;
    static final int MEDIUMCOL_SIZE_SYBASE = 1;
    static final int LARGECOL_SIZE_SYBASE = 1;
    static final int SMALLCOL_SIZE_INFORMIX = 0xA00000;
    static final int MEDIUMCOL_SIZE_INFORMIX = 1;
    static final int LARGECOL_SIZE_INFORMIX = 1;
    static final String idCol = "id";
    static final String propCol = "propid";
    static final String appCol = "appname";
    static final String listenCol = "listenercnt";
    static final String lastAccCol = "lastaccess";
    static final String userCol = "username";
    static final String maxInactCol = "maxinactivetime";
    static final String comma = " , ";
    static final String equals = " = ? ";
    static final String smallCol = "small";
    static final String medCol = "medium";
    static final String lgCol = "large";
    static final String upId = " where id = ? and propid = ? and appname = ? ";
    static final String setSmallNull = "small = NULL";
    static final String setMediumNull = "medium = NULL";
    static final String setLargeNull = "large = NULL";
    String insNoProp;
    String insSm;
    String insMed;
    String insLg;
    String getOneNoUpdate;
    String getOneNoUpdateNonDB2;
    String upBase;
    String asyncUpdate;
    String getProp;
    String getPropNotDB2;
    String delProp;
    String insSmProp;
    String insMedProp;
    String insLgProp;
    String selMed;
    String selLg;
    String dropIt;
    String readLastAccess;
    String selectForUpdate;
    String insForInval;
    String delPrimaryRowInval;
    String findAllKeys;
    String readPrimitiveData;
    String readPrimitiveDataDb2;
    String delOne;
    String selDelNoListener;
    String selNukerString;
    String optUpdate;
    String optUpdatePrimRow;
    String remoteInvalAll;
    transient DataSource dataSource;
    int smallColSize = 0x200B20;
    int mediumColSize;
    int largeColSize;
    boolean usingOracle = false;
    String as400_collection = null;
    String collectionName = null;
    String qualifierNameWhenCustomSchemaIsSet = null;
    boolean usingAS400DB2 = false;
    boolean usingSybase = false;
    boolean usingDB2 = false;
    boolean usingDB2Connect = false;
    int dbConnectVersion = 5;
    boolean usingSQLServer = false;
    boolean usingInformix = false;
    boolean usingCloudScape = false;
    boolean usingDerby = false;
    boolean usingDB2zOS = false;
    boolean usingSolidDB = false;
    boolean usingPostgreSQL = false;
    transient DatabaseHandler dbHandler = null;
    private Hashtable suspendedTransactions = null;
    private static final long serialVersionUID = -4653089886686024589L;
    private static final ComponentMetaDataAccessorImpl cmda = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor();
    private static final String methodClassName = "DatabaseHashMap";
    private static final int SET_USER_INFO = 0;
    private static final int INIT_DB_SETTINGS = 1;
    private static final int GET_TABLE_DEFINITION = 2;
    private static final int CREATE_TABLE = 3;
    private static final int GET_DATA_SOURCE = 4;
    private static final int REMOVE_PERSISTED_SESSION = 5;
    private static final int DO_INVALIDATIONS = 6;
    private static final int POLL_FOR_INVALID_SESSIONS_WITH_LISTENERS = 7;
    private static final int CLOSE_RESULT_SET = 8;
    private static final int CLOSE_STATEMENT = 9;
    private static final int CLOSE_CONNECTION = 10;
    private static final int GET_CONNECTION = 11;
    private static final int SUSPEND_TRANSACTION = 12;
    private static final int RESUME_TRANSACTION = 13;
    private static final int GET_VALUE = 14;
    private static final int UPDATE_LAST_ACCESS_TIME = 15;
    private static final int OVERQUAL_LAST_ACCESS_TIME_UPDATE = 16;
    private static final int READ_FROM_EXTERNAL = 17;
    private static final int IS_PRESENT = 18;
    private static final int INSERT_SESSION = 19;
    private static final int HANDLE_PROPERTY_HITS = 20;
    private static final int PERSIST_SESSION = 21;
    private static final int SERIALIZE_APP_DATA = 22;
    private static final int WRITE_CACHED_LAST_ACCESSED_TIMES = 23;
    private static final int GET_COLLECTION_NAME = 24;
    private static final int ORACLE_GET_VALUE = 25;
    private static final int SET_MAX_INACT_TO_ZERO = 26;
    private static final int PERFORM_INVALIDATION = 27;
    private static final int PROCESS_INVALID_LISTENERS = 28;
    private static final int UPDATE_NUKER_TIME_STAMP = 29;
    private static final int BEGIN_DB_CONTEXT = 30;
    private static final int DOES_INDEX_EXISTS_DISTRIBUTED = 31;
    private static final int DOES_INDEX_EXISTS_ISERIES = 32;
    private static final int IS_TABLE_MARKED_VOLATILE = 33;
    private static final String[] methodNames = new String[]{"setUserInfo", "initDBSettings", "getTableDefinition", "createTable", "getDataSource", "removePersistedSession", "doInvalidations", "pollForInvalidSessionsWithListeners", "closeResultSet", "closeStatement", "closeConnection", "getConnection", "suspendTransaction", "resumeTransaction", "getValue", "updateLastAccessTime", "overQualLastAccessTimeUpdate", "readFromExternal", "isPresent", "insertSession", "handlePropertyHits", "persistSession", "serializeAppData", "writeCachedLastAccessedTimes", "getCollectionName", "oracleGetValue", "setMaxInactToZero", "performInvalidation", "processInvalidListeners", "updateNukerTimeStamp", "beginDBContext", "doesIndexExistsDistributed", "doesIndexExistsISeries", "isTableMarkedVolatile"};

    public DatabaseHashMap(IStore store, SessionManagerConfig smc, DatabaseStoreService databaseStoreService) {
        super(store, smc);
        this.databaseStoreService = databaseStoreService;
        this._iStore = store;
        this._smc = smc;
        if (smc.getTableNameValue() != null) {
            this.tableName = smc.getTableNameValue();
        }
        this.suspendedTransactions = new Hashtable();
        this.getDataSource();
        this.initDBSettings();
    }

    public boolean getAppDataTablesPerThread() {
        return this.appDataTablesPerThread;
    }

    protected DatabaseStoreService getDatabaseStoreService() {
        return this.databaseStoreService;
    }

    void setUserInfo() {
        String smcDBID = this._smc.getSessionDBID();
        if (smcDBID != null && smcDBID.indexOf("::") != -1) {
            try {
                this.dbid = smcDBID.substring(0, smcDBID.indexOf("::"));
                this.collectionName = smcDBID.substring(smcDBID.indexOf("::") + 2);
                if (this.collectionName.indexOf("$V") > 0) {
                    this.collectionName = this.collectionName.substring(0, this.collectionName.indexOf("$V") - 1);
                    String dbConnectVersionName = smcDBID.substring(smcDBID.indexOf("$V") + 2);
                    this.dbConnectVersion = (int)new Double(dbConnectVersionName).doubleValue();
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.session.store.db.DatabaseHashMap.setUserInfo", (String)"241", (Object)((Object)this));
                LoggingUtil.SESSION_LOGGER_WAS.logp(Level.SEVERE, methodClassName, methodNames[0], "CommonMessage.exception", e);
            }
        } else {
            this.dbid = smcDBID;
        }
        this.dbpwd = this._smc.getSessionDBPWD();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initDBSettings() {
        DatabaseHashMap databaseHashMap = this;
        synchronized (databaseHashMap) {
            Connection tbcon = null;
            String url = null;
            try {
                int dbCode;
                this.setUserInfo();
                tbcon = this.getConnection(true);
                if (tbcon == null) {
                    return;
                }
                DatabaseMetaData dmd = tbcon.getMetaData();
                if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                    String dbProductName = dmd.getDatabaseProductName();
                    String dbProductVersion = dmd.getDatabaseProductVersion();
                    LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[1], "dbProductName: " + dbProductName);
                    LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[1], "dbProductVersion: " + dbProductVersion);
                    LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[1], "dbUserName: " + dmd.getUserName());
                }
                if ((dbCode = DBPortability.getDBCode(dmd)) == 4) {
                    this.smallColSize = 2000;
                    this.mediumColSize = 0x200000;
                    if (this._smc.isUsingMultirow() && this._smc.getRowSizeLimit() * 0x100000 > this.mediumColSize) {
                        this.mediumColSize = this._smc.getRowSizeLimit() * 0x100000;
                        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                            LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[1], "Oracle row size limit : " + this.mediumColSize);
                        }
                    }
                    this.largeColSize = 1;
                    this.usingOracle = true;
                } else if (dbCode == 5) {
                    this.smallColSize = 0xA00000;
                    this.mediumColSize = 1;
                    this.largeColSize = 1;
                    this.usingSybase = true;
                } else if (dbCode == 7) {
                    this.smallColSize = 0xA00000;
                    this.mediumColSize = 1;
                    this.largeColSize = 1;
                    this.usingSQLServer = true;
                } else if (dbCode == 8) {
                    this.smallColSize = 0xA00000;
                    this.mediumColSize = 1;
                    this.largeColSize = 1;
                    this.usingInformix = true;
                } else if (dbCode == 9) {
                    this.smallColSize = 0xA00000;
                    this.mediumColSize = 1;
                    this.largeColSize = 1;
                    this.usingCloudScape = true;
                } else if (dbCode == 13) {
                    this.dbHandler = new PostgreSQLHandler();
                    this.smallColSize = this.dbHandler.getSmallColumnSize();
                    this.mediumColSize = this.dbHandler.getMediumColumnSize();
                    this.largeColSize = this.dbHandler.getLargeColumnSize();
                    this.usingPostgreSQL = true;
                } else if (dbCode == 14) {
                    this.dbHandler = new MySQLHandler();
                    this.smallColSize = this.dbHandler.getSmallColumnSize();
                    this.mediumColSize = this.dbHandler.getMediumColumnSize();
                    this.largeColSize = this.dbHandler.getLargeColumnSize();
                } else {
                    if (this._smc.getRowSize() == 4) {
                        this.smallColSize = 3122;
                    } else if (this._smc.getRowSize() == 8) {
                        this.smallColSize = 7218;
                    } else if (this._smc.getRowSize() == 16) {
                        this.smallColSize = 15410;
                    } else if (this._smc.getRowSize() == 32) {
                        this.smallColSize = 31794;
                    }
                    this.mediumColSize = 32700;
                    this.largeColSize = 0x200000;
                    this.usingDB2 = true;
                    if (dbCode == 12) {
                        this.usingSolidDB = true;
                    }
                    if (dbCode == 6) {
                        this.smallColSize = 3122;
                        this.usingDB2Connect = true;
                    } else if (dbCode == 10) {
                        this.smallColSize = 3122;
                        this.mediumColSize = 28869;
                        this.usingDB2Connect = true;
                        this.usingDB2zOS = true;
                    } else if (dbCode == 2) {
                        this.smallColSize = 3122;
                        this.mediumColSize = 28898;
                        this.usingAS400DB2 = true;
                        url = dmd.getURL();
                    } else if (dbCode == 11) {
                        this.usingDB2 = false;
                        this.usingDerby = true;
                    }
                }
            }
            catch (SQLException se) {
                FFDCFilter.processException((Throwable)se, (String)"com.ibm.ws.session.store.db.DatabaseHashMap.initConnPool", (String)"344", (Object)((Object)this));
                LoggingUtil.SESSION_LOGGER_WAS.logp(Level.SEVERE, methodClassName, methodNames[1], "DatabaseHashMap.createTableError");
                LoggingUtil.SESSION_LOGGER_WAS.logp(Level.SEVERE, methodClassName, methodNames[1], "CommonMessage.exception", se);
            }
            finally {
                if (tbcon != null) {
                    this.closeConnection(tbcon);
                }
            }
            if (this.usingAS400DB2 && this.firstInitialize) {
                if (this.collectionName == null) {
                    int index = this.tableName.indexOf(".");
                    if (index != -1) {
                        this.collectionName = this.tableName.substring(0, index);
                    } else {
                        this.collectionName = this.getCollectionName(url);
                        this.tableName = this.collectionName + "." + this.tableName;
                    }
                } else {
                    this.tableName = this.collectionName + "." + this.tableName;
                }
                this.firstInitialize = false;
                if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                    LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[1], "AS400DB2 Table Name value = ", this.tableName);
                }
            } else if (this.usingDB2zOS) {
                if (this._smc.getTableNameValue() != null) {
                    this.tableName = this._smc.getTableNameValue();
                }
                if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                    LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[1], "DB2 Table Name value = ", this.tableName);
                }
            } else if (this.usingDB2Connect && this.firstInitialize) {
                this.tableName = this.collectionName + "." + this.tableName;
                this.firstInitialize = false;
                if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                    LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[1], "DB2Connect Table Name value = ", this.tableName);
                }
            }
            this.initializeSQL_Strings();
            if (!SessionManagerConfig.is_zOS()) {
                this.createTable();
            }
        }
        this.initialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getTableDefinition(Connection tbcon) throws SQLException {
        boolean defExists = false;
        boolean smallExists = false;
        boolean mediumExists = false;
        boolean largeExists = false;
        DatabaseMetaData dmd = tbcon.getMetaData();
        String tbName = this.tableName;
        String qualifierName = null;
        if (this.usingAS400DB2 || this.usingDB2Connect) {
            int index = this.tableName.indexOf(".");
            tbName = index != -1 ? this.tableName.substring(index + 1).toUpperCase() : this.tableName.toUpperCase();
            if (this.collectionName != null) {
                qualifierName = this.collectionName;
            }
        } else if (this.usingDB2 || this.usingDerby || this.usingOracle) {
            tbName = tbName.toUpperCase();
            if (this.dbid != null) {
                qualifierName = this.dbid.toUpperCase();
            }
            if (this._smc.isUsingCustomSchemaName() && this.usingDB2) {
                Statement s = null;
                ResultSet rs1 = null;
                s = tbcon.createStatement();
                s.execute("VALUES (CURRENT SCHEMA)");
                rs1 = s.getResultSet();
                while (rs1.next()) {
                    this.qualifierNameWhenCustomSchemaIsSet = rs1.getString("1");
                }
                if (this.qualifierNameWhenCustomSchemaIsSet != null) {
                    qualifierName = this.qualifierNameWhenCustomSchemaIsSet;
                    if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                        LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[2], "Database being used is DB2 and UsingCustomSchemaName is set to true. The following qualifier name obtained from running the query VALUES (CURRENT SCHEMA) will be used for subsequent queries in this method: " + this.qualifierNameWhenCustomSchemaIsSet);
                    }
                }
            }
        } else if (this.usingPostgreSQL) {
            qualifierName = dmd.getUserName();
        }
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[2], "Qualifier Name = " + qualifierName + " Table Name = " + tbName);
        }
        ResultSet rs1 = dmd.getColumns(null, qualifierName, tbName, "%");
        try {
            while (rs1.next()) {
                String columnname = rs1.getString("COLUMN_NAME");
                int columnsize = rs1.getInt("COLUMN_SIZE");
                if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                    LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[2], "COLUMN_NAME = " + columnname + " COLUMN_SIZE = " + Integer.toString(columnsize));
                }
                if (columnname.equalsIgnoreCase("SMALL")) {
                    this.smallColSize = columnsize;
                    smallExists = true;
                }
                if (columnname.equalsIgnoreCase("MEDIUM")) {
                    if (!this.usingOracle) {
                        this.mediumColSize = columnsize;
                    }
                    mediumExists = true;
                }
                if (columnname.equalsIgnoreCase("LARGE")) {
                    this.largeColSize = columnsize;
                    largeExists = true;
                }
                defExists = true;
            }
            if (defExists) {
                if (smallExists && mediumExists && largeExists) {
                    if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                        LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[2], "Table exists with all the required columns");
                    }
                } else {
                    LoggingUtil.SESSION_LOGGER_WAS.logp(Level.SEVERE, methodClassName, methodNames[2], "DatabaseHashMap.wrongTableDef");
                }
            }
        }
        finally {
            DatabaseHashMap.closeResultSet(rs1);
        }
        return defExists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createTable() {
        block50: {
            Connection con = null;
            Statement s = null;
            con = this.getConnection(true);
            if (con == null) {
                return;
            }
            try {
                block49: {
                    try {
                        s = con.createStatement();
                        if (this.getTableDefinition(con)) break block49;
                        if (this.usingOracle) {
                            if (this._smc.isUseOracleBlob()) {
                                s.executeUpdate("create table " + this.tableName + " (id varchar(128) not null, propid varchar(128) not null, appname varchar(128) not null, listenercnt smallint, lastaccess integer, creationtime integer, maxinactivetime integer, username varchar(256), small raw(" + 2000 + "), medium BLOB, large raw(1))");
                            } else {
                                s.executeUpdate("create table " + this.tableName + " (id varchar(128) not null, propid varchar(128) not null, appname varchar(128) not null, listenercnt smallint, lastaccess integer, creationtime integer, maxinactivetime integer, username varchar(256), small raw(" + 2000 + "), medium long raw, large raw(1))");
                            }
                            break block49;
                        }
                        if (this.usingAS400DB2) {
                            try {
                                s.executeUpdate("CREATE COLLECTION " + this.collectionName);
                            }
                            catch (Exception e) {
                                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.session.store.db.DatabaseHashMap.createTable", (String)"470", (Object)con);
                            }
                            s.executeUpdate("create table " + this.tableName + " (id varchar(128) not null, propid varchar(128) not null, appname varchar(128) not null, listenercnt smallint, lastaccess bigint, creationtime bigint, maxinactivetime integer, username varchar(256), small varchar(" + 3122 + ") for bit data, medium long varchar for bit data, large BLOB(2M))");
                            break block49;
                        }
                        if (this.usingSybase) {
                            s.executeUpdate("create table " + this.tableName + " (id varchar(128) not null, propid varchar(128) not null, appname varchar(128) not null, listenercnt smallint null, lastaccess numeric(21,0) null, creationtime numeric(21,0) null, maxinactivetime numeric(10,0) null, username varchar(255) null, small image null, medium image null, large image null)");
                        } else if (this.usingSQLServer) {
                            s.executeUpdate("create table " + this.tableName + " (id varchar(128) not null, propid varchar(128) not null, appname varchar(128) not null, listenercnt smallint null, lastaccess decimal(21,0) null, creationtime decimal(21,0) null, maxinactivetime integer null, username varchar(255) null, small image null, medium image null, large image null)");
                        } else if (this.usingInformix) {
                            s.executeUpdate("create table " + this.tableName + " (id varchar(128) not null, propid varchar(128) not null, appname varchar(128) not null, listenercnt smallint, lastaccess int8, creationtime int8, maxinactivetime integer, username varchar(255), small BYTE, medium BYTE, large BYTE)");
                        } else if (this.usingCloudScape) {
                            s.executeUpdate("create table " + this.tableName + " (id varchar(128) not null, propid varchar(128) not null, appname varchar(128) not null, listenercnt smallint, lastaccess bigint, creationtime bigint, maxinactivetime integer, username varchar(255), small LONG VARBINARY , medium char(1) , large char(1))");
                        } else if (this.dbHandler != null) {
                            this.dbHandler.createTable(s, this.tableName);
                        } else if (!this.usingDB2Connect && !this.usingDB2zOS) {
                            String tableSpaceName = " ";
                            String configTableSpaceName = this._smc.getTableSpaceName();
                            if (configTableSpaceName != null && !configTableSpaceName.equals("") && configTableSpaceName.length() != 0) {
                                tableSpaceName = " in " + configTableSpaceName;
                            }
                            if (this.usingSolidDB) {
                                s.executeUpdate("create table " + this.tableName + " (id varchar(128) not null, propid varchar(128) not null, appname varchar(128) not null, listenercnt smallint, lastaccess bigint, creationtime bigint, maxinactivetime integer, username varchar(256), small varchar(" + this.smallColSize + "), medium long varchar, large BLOB(2M)) " + tableSpaceName);
                            } else {
                                s.executeUpdate("create table " + this.tableName + " (id varchar(128) not null, propid varchar(128) not null, appname varchar(128) not null, listenercnt smallint, lastaccess bigint, creationtime bigint, maxinactivetime integer, username varchar(256), small varchar(" + this.smallColSize + ") for bit data, medium long varchar for bit data, large BLOB(2M)) " + tableSpaceName);
                            }
                        }
                    }
                    catch (SQLException err) {
                        FFDCFilter.processException((Throwable)err, (String)"com.ibm.ws.session.store.db.DatabaseHashMap.createTable", (String)"497", (Object)((Object)this));
                        if (!this.usingCloudScape) {
                            LoggingUtil.SESSION_LOGGER_WAS.logp(Level.SEVERE, methodClassName, methodNames[3], "CommonMessage.exception", err);
                        }
                        if (err.getErrorCode() == 30000) break block49;
                        LoggingUtil.SESSION_LOGGER_WAS.logp(Level.SEVERE, methodClassName, methodNames[3], "CommonMessage.exception", err);
                    }
                }
                if (this._smc.isSessionTableSkipIndexCreation()) break block50;
                try {
                    if (s == null) {
                        s = con.createStatement();
                    }
                    if (this.usingSybase) {
                        s.executeUpdate("create unique index sess_index on " + this.tableName + " (id, propid, appname)");
                        s.executeUpdate("alter table sessions lock datarows");
                    } else if (this.usingSolidDB) {
                        s.executeUpdate("create unique index sess_index on " + this.tableName + " (id, propid, appname)");
                    } else if (this.usingAS400DB2) {
                        this.mediumColSize -= 2;
                        if (!this.doesIndexExists(con, "sess_index")) {
                            s.executeUpdate("create unique index " + this.collectionName + ".sess_index on " + this.tableName + " (id,propid,appname)");
                        } else if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                            LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[3], "Skip index creation");
                        }
                    } else if (this.dbHandler != null) {
                        this.dbHandler.createIndex(con, s, this.tableName);
                    } else if (!this.usingDB2Connect && !this.usingDB2zOS) {
                        if (!this.doesIndexExists(con, "sess_index")) {
                            s.executeUpdate("create unique index sess_index on " + this.tableName + " (id, propid, appname)");
                        } else if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                            LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[3], "Skip index creation");
                        }
                        if (this.usingDB2 && !this.isTableMarkedVolatile(con)) {
                            s.executeUpdate("alter table " + this.tableName + " volatile");
                        } else if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                            LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[3], "Skip marking table volatile");
                        }
                    }
                }
                catch (SQLException err) {
                    FFDCFilter.processException((Throwable)err, (String)"com.ibm.ws.session.store.db.DatabaseHashMap.createTable", (String)"526", (Object)con);
                }
            }
            finally {
                if (s != null) {
                    DatabaseHashMap.closeStatement(s);
                }
                this.closeConnection(con);
            }
        }
    }

    DataSource getDataSource() {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINER)) {
            LoggingUtil.SESSION_LOGGER_WAS.entering(methodClassName, methodNames[4]);
        }
        if (this.dataSource != null) {
            return this.dataSource;
        }
        try {
            this.beginDBContext();
            ResourceConfig rc = this.getDatabaseStoreService().getResourceConfigFactory().createResourceConfig("javax.sql.DataSource");
            rc.setResAuthType(0);
            rc.setSharingScope(0);
            rc.setIsolationLevel(2);
            this.dataSource = (DataSource)this.getDatabaseStoreService().getDataSourceFactory().createResource((ResourceInfo)rc);
            this.endDBContext();
            return this.dataSource;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.session.store.db.DatabaseHashMap.getDataSource", (String)"558", (Object)((Object)this));
            LoggingUtil.SESSION_LOGGER_WAS.logp(Level.SEVERE, methodClassName, methodNames[4], "DatabaseHashMap.dataSrcErr");
            LoggingUtil.SESSION_LOGGER_WAS.logp(Level.SEVERE, methodClassName, methodNames[4], "CommonMessage.exception", e);
            this.dataSource = null;
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removePersistedSession(String id) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_WAS.entering(methodClassName, methodNames[5], id);
        }
        PreparedStatement ps = null;
        boolean psClose = false;
        this.superRemove(id);
        Connection con = this.getConnection(false);
        if (con == null) {
            return;
        }
        try {
            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[5], "before upd " + id);
            }
            ps = con.prepareStatement(this.delOne);
            ps.setString(1, id);
            ps.setString(2, this._iStore.getId());
            ps.executeUpdate();
            ps.close();
            psClose = true;
            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[5], "after upd " + id);
            }
            this.addToRecentlyInvalidatedList(id);
        }
        catch (SQLException se) {
            FFDCFilter.processException((Throwable)se, (String)"com.ibm.ws.session.store.db.DatabaseHashMap.removePersistedSession", (String)"621", (Object)id);
            LoggingUtil.SESSION_LOGGER_WAS.logp(Level.SEVERE, methodClassName, methodNames[5], "DatabaseHashMap.removeSessionsError");
            LoggingUtil.SESSION_LOGGER_WAS.logp(Level.SEVERE, methodClassName, methodNames[5], "CommonMessage.exception", se);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.session.store.db.DatabaseHashMap.removePersistedSession", (String)"626", (Object)id);
            LoggingUtil.SESSION_LOGGER_WAS.logp(Level.SEVERE, methodClassName, methodNames[5], "DatabaseHashMap.removeSessionsError");
            LoggingUtil.SESSION_LOGGER_WAS.logp(Level.SEVERE, methodClassName, methodNames[5], "CommonMessage.exception", e);
        }
        finally {
            if (!psClose && ps != null) {
                DatabaseHashMap.closeStatement(ps);
            }
            this.closeConnection(con);
        }
    }

    /*
     * Exception decompiling
     */
    void doInvalidations(Connection nukerCon) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[CATCHBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    Enumeration pollForInvalidSessionsWithListeners(Connection nukerCon) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[CATCHBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static void closeResultSet(ResultSet rs) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_WAS.entering(methodClassName, methodNames[8], "closing " + rs);
        }
        try {
            rs.close();
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.session.store.db.DatabaseHashMap.closeResultSet", (String)"1018");
        }
    }

    static void closeStatement(Statement ps) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_WAS.entering(methodClassName, methodNames[9], "closing " + ps);
        }
        try {
            ps.close();
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.session.store.db.DatabaseHashMap.closeStatement", (String)"1031");
        }
    }

    void closeConnection(Connection con) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_WAS.entering(methodClassName, methodNames[10], "closing " + con);
        }
        try {
            con.close();
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.session.store.db.DatabaseHashMap.closeConnection", (String)"1056", (Object)con);
            LoggingUtil.SESSION_LOGGER_WAS.logp(Level.SEVERE, methodClassName, methodNames[10], "CommonMessage.exception", t);
        }
        this.endDBContext();
        this.resumeTransaction();
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINER)) {
            LoggingUtil.SESSION_LOGGER_WAS.exiting(methodClassName, methodNames[10], "closed " + con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Connection getConnection(boolean fromInit) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_WAS.entering(methodClassName, methodNames[11]);
        }
        Connection conn = null;
        boolean exceptionOccured = false;
        if (this.dataSource == null) {
            this.getDataSource();
        }
        if (this.dataSource != null) {
            int tries = 0;
            this.suspendTransaction();
            this.beginDBContext();
            while (tries < this._smc.getConnectionRetryCount() + 1) {
                try {
                    ++tries;
                    exceptionOccured = false;
                    conn = this.dataSource.getConnection();
                    if (this.dbHandler != null && !this.dbHandler.isConnectionValid(conn)) {
                        LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[11], "Stale connection detected.");
                        continue;
                    }
                    conn.setAutoCommit(true);
                    if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINER)) {
                        LoggingUtil.SESSION_LOGGER_WAS.exiting(methodClassName, methodNames[11], "Connection-isolation-level" + conn.getTransactionIsolation());
                    }
                    if (!(this.initialized || fromInit || this.tryingToInitialize)) {
                        DatabaseHashMap databaseHashMap = this;
                        synchronized (databaseHashMap) {
                            this.tryingToInitialize = true;
                            if (!this.initialized) {
                                this.initDBSettings();
                            }
                            this.tryingToInitialize = false;
                        }
                    }
                    return conn;
                }
                catch (Throwable th) {
                    exceptionOccured = true;
                    LoggingUtil.SESSION_LOGGER_WAS.logp(Level.SEVERE, methodClassName, methodNames[11], "CommonMessage.exception", th);
                }
            }
        } else {
            LoggingUtil.SESSION_LOGGER_WAS.logp(Level.WARNING, methodClassName, methodNames[11], "DatabaseHashMap.getConnectionError");
        }
        if (exceptionOccured) {
            this.endDBContext();
            this.resumeTransaction();
        }
        return null;
    }

    protected void suspendTransaction() {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_WAS.entering(methodClassName, methodNames[12]);
        }
        Object[] suspendedTx = new Object[]{null, null};
        UOWCurrent uowCurrent = this.getDatabaseStoreService().getUOWCurrent();
        UOWCoordinator uowCoord = uowCurrent.getUOWCoord();
        LocalTransactionCurrent ltCurrent = this.getDatabaseStoreService().getLocalTransactionCurrent();
        if (uowCoord == null) {
            if (isTraceOn && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[12], "No Global or Local Transaction exists");
            }
        } else if (!uowCoord.isGlobal()) {
            if (isTraceOn && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[12], "LocalTransaction is active so suspend");
            }
            suspendedTx[0] = ltCurrent.suspend();
        } else {
            if (isTraceOn && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[12], "Global Transaction is Active");
                LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[12], "Global Transaction is Active so suspend");
            }
            try {
                suspendedTx[0] = this.getDatabaseStoreService().getEmbeddableWebSphereTransactionManager().suspend();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            uowCoord = this.getDatabaseStoreService().getUOWCurrent().getUOWCoord();
            if (uowCoord != null && !uowCoord.isGlobal()) {
                if (isTraceOn && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                    LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[12], "LocalTransaction is active after global suspend");
                }
                suspendedTx[1] = ltCurrent.suspend();
            }
        }
        if (suspendedTx[0] != null || suspendedTx[1] != null) {
            this.suspendedTransactions.put(Thread.currentThread(), suspendedTx);
        }
        try {
            if (isTraceOn && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[12], "Starting a Local Transaction");
            }
            boolean boundaryIsAS = false;
            boolean unresActionIsCommit = false;
            boolean resolverIsCAB = false;
            ltCurrent.begin(boundaryIsAS, unresActionIsCommit, resolverIsCAB);
        }
        catch (Exception ex) {
            LoggingUtil.SESSION_LOGGER_WAS.logp(Level.SEVERE, methodClassName, methodNames[12], "DatabaseHashMap.cantstartLTC");
        }
        if (isTraceOn && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINER)) {
            LoggingUtil.SESSION_LOGGER_WAS.exiting(methodClassName, methodNames[12]);
        }
    }

    protected void resumeTransaction() {
        Object[] suspendedTx;
        LocalTransactionCurrent ltCurrent;
        LocalTransactionCoordinator coord;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_WAS.entering(methodClassName, methodNames[13]);
        }
        if ((coord = (ltCurrent = this.getDatabaseStoreService().getLocalTransactionCurrent()).getLocalTranCoord()) != null) {
            if (isTraceOn && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[13], "Complete the Local Transaction");
            }
            try {
                coord.cleanup();
            }
            catch (InconsistentLocalTranException ex) {
                LoggingUtil.SESSION_LOGGER_WAS.logp(Level.SEVERE, methodClassName, methodNames[13], "InconsistentLocalTranException", ex);
            }
            catch (RolledbackException rbe) {
                LoggingUtil.SESSION_LOGGER_WAS.logp(Level.SEVERE, methodClassName, methodNames[13], "DatabaseHashMap.localRollBack", rbe);
            }
        }
        if ((suspendedTx = (Object[])this.suspendedTransactions.remove(Thread.currentThread())) != null) {
            for (int i = suspendedTx.length - 1; i >= 0; --i) {
                Object susTrans = suspendedTx[i];
                if (susTrans == null) continue;
                if (susTrans instanceof Transaction) {
                    if (isTraceOn && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                        LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[13], "Resume the suspended Global Transaction");
                    }
                    Transaction tx = (Transaction)susTrans;
                    try {
                        this.getDatabaseStoreService().getEmbeddableWebSphereTransactionManager().resume(tx);
                    }
                    catch (Throwable ex) {
                        FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.session.store.db.DatabaseHashMap.resumeGlobalTransaction", (String)"1210", (Object)((Object)this));
                        LoggingUtil.SESSION_LOGGER_WAS.logp(Level.SEVERE, methodClassName, methodNames[13], "CommonMessage.exception", ex);
                    }
                    continue;
                }
                if (!(susTrans instanceof LocalTransactionCoordinator)) continue;
                if (isTraceOn && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                    LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[13], "Resume the suspended Local Transaction");
                }
                try {
                    coord = (LocalTransactionCoordinator)susTrans;
                    ltCurrent.resume(coord);
                    continue;
                }
                catch (IllegalStateException ex) {
                    LoggingUtil.SESSION_LOGGER_WAS.logp(Level.SEVERE, methodClassName, methodNames[13], "IllegalStateException", ex);
                    try {
                        coord.cleanup();
                        continue;
                    }
                    catch (InconsistentLocalTranException iltex) {
                        LoggingUtil.SESSION_LOGGER_WAS.logp(Level.SEVERE, methodClassName, methodNames[13], "InconsistentLocalTranException", iltex);
                        continue;
                    }
                    catch (RolledbackException rbe) {
                        LoggingUtil.SESSION_LOGGER_WAS.logp(Level.SEVERE, methodClassName, methodNames[13], "DatabaseHashMap.localRollBack", rbe);
                    }
                }
            }
        }
        if (isTraceOn && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINER)) {
            LoggingUtil.SESSION_LOGGER_WAS.exiting(methodClassName, methodNames[13]);
        }
    }

    protected boolean available(InputStream in) throws IOException {
        if (this.usingSQLServer) {
            return true;
        }
        return in.available() > 0;
    }

    protected Object getAllValues(BackedSession sess) {
        return this.getValue(sess.getId(), sess);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected Object getValue(String id, BackedSession s) {
        Object tmp;
        block33: {
            Connection conn;
            block31: {
                String sessId;
                boolean psClose;
                ResultSet rs;
                PreparedStatement prop_stmt;
                block29: {
                    Object var15_9;
                    block30: {
                        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                            LoggingUtil.SESSION_LOGGER_WAS.entering(methodClassName, methodNames[14]);
                        }
                        conn = null;
                        prop_stmt = null;
                        rs = null;
                        psClose = false;
                        sessId = s.getId();
                        tmp = null;
                        conn = this.getConnection(false);
                        if (conn == null) {
                            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINER)) {
                                LoggingUtil.SESSION_LOGGER_WAS.exiting(methodClassName, methodNames[14], "unable to get con when processing session " + sessId + " for prop " + id);
                            }
                            return null;
                        }
                        rs = null;
                        prop_stmt = this.usingDB2 || this.usingDerby ? conn.prepareStatement(this.getProp) : conn.prepareStatement(this.getPropNotDB2);
                        prop_stmt.setString(1, sessId);
                        prop_stmt.setString(2, id);
                        prop_stmt.setString(3, this.getIStore().getId());
                        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                            LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[14], "before query for " + id + " session " + sessId);
                        }
                        if ((rs = prop_stmt.executeQuery()).next()) break block29;
                        rs.close();
                        prop_stmt.close();
                        psClose = true;
                        var15_9 = null;
                        if (psClose || prop_stmt == null) break block30;
                        DatabaseHashMap.closeResultSet(rs);
                        DatabaseHashMap.closeStatement(prop_stmt);
                    }
                    this.closeConnection(conn);
                    return var15_9;
                }
                try {
                    if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                        LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[14], "read results after query (FOUND) for " + id + " session " + sessId);
                    }
                    if (this.usingOracle) {
                        tmp = this.oracleGetValue(rs, s);
                    } else {
                        SessionStatistics pmiStats;
                        InputStream is_large;
                        Blob getBlobData;
                        InputStream is_medium;
                        long startTime = System.currentTimeMillis();
                        long readSize = 0L;
                        InputStream is_small = rs.getBinaryStream(smallCol);
                        boolean found = false;
                        if (is_small != null) {
                            if (this.available(is_small)) {
                                readSize = is_small.available();
                                BufferedInputStream bis_small = new BufferedInputStream(is_small);
                                try {
                                    tmp = ((DatabaseStore)this.getIStore()).getLoader().loadObject((InputStream)bis_small);
                                }
                                catch (ClassNotFoundException ce) {
                                    FFDCFilter.processException((Throwable)ce, (String)"com.ibm.ws.session.store.db.DatabaseHashMap.getValue", (String)"1335", (Object)s);
                                    LoggingUtil.SESSION_LOGGER_WAS.logp(Level.SEVERE, methodClassName, methodNames[14], "BackedHashtable.classNotFoundError");
                                    LoggingUtil.SESSION_LOGGER_WAS.logp(Level.SEVERE, methodClassName, methodNames[14], "CommonMessage.sessionid", id);
                                    LoggingUtil.SESSION_LOGGER_WAS.logp(Level.SEVERE, methodClassName, methodNames[14], "CommonMessage.exception", ce);
                                }
                                bis_small.close();
                                is_small.close();
                                found = true;
                            } else {
                                is_small.close();
                            }
                        }
                        if (!found && (is_medium = rs.getBinaryStream(medCol)) != null) {
                            if (this.available(is_medium)) {
                                readSize = is_medium.available();
                                BufferedInputStream bis_medium = new BufferedInputStream(is_medium);
                                try {
                                    tmp = ((DatabaseStore)this.getIStore()).getLoader().loadObject((InputStream)bis_medium);
                                }
                                catch (ClassNotFoundException ce) {
                                    FFDCFilter.processException((Throwable)ce, (String)"com.ibm.ws.session.store.db.DatabaseHashMap.getValue", (String)"1360", (Object)s);
                                    LoggingUtil.SESSION_LOGGER_WAS.logp(Level.SEVERE, methodClassName, methodNames[14], "BackedHashtable.classNotFoundError");
                                    LoggingUtil.SESSION_LOGGER_WAS.logp(Level.SEVERE, methodClassName, methodNames[14], "CommonMessage.sessionid", id);
                                    LoggingUtil.SESSION_LOGGER_WAS.logp(Level.SEVERE, methodClassName, methodNames[14], "CommonMessage.exception", ce);
                                }
                                bis_medium.close();
                                is_medium.close();
                                found = true;
                            } else {
                                is_medium.close();
                            }
                        }
                        if (!found && !this.usingSybase && (getBlobData = rs.getBlob(lgCol)) != null && getBlobData.length() > 0L && (is_large = getBlobData.getBinaryStream()) != null) {
                            readSize = getBlobData.length();
                            BufferedInputStream bis_large = new BufferedInputStream(is_large);
                            try {
                                tmp = ((DatabaseStore)this.getIStore()).getLoader().loadObject((InputStream)bis_large);
                            }
                            catch (ClassNotFoundException ce) {
                                FFDCFilter.processException((Throwable)ce, (String)"com.ibm.ws.session.store.db.DatabaseHashMap.getValue", (String)"1387", (Object)s);
                                LoggingUtil.SESSION_LOGGER_WAS.logp(Level.SEVERE, methodClassName, methodNames[14], "BackedHashtable.classNotFoundError");
                                LoggingUtil.SESSION_LOGGER_WAS.logp(Level.SEVERE, methodClassName, methodNames[14], "CommonMessage.sessionid", id);
                                LoggingUtil.SESSION_LOGGER_WAS.logp(Level.SEVERE, methodClassName, methodNames[14], "CommonMessage.exception", ce);
                            }
                            bis_large.close();
                            is_large.close();
                            found = true;
                        }
                        if ((pmiStats = this._iStore.getSessionStatistics()) != null) {
                            pmiStats.readTimes(readSize, System.currentTimeMillis() - startTime);
                        }
                    }
                    rs.close();
                    prop_stmt.close();
                    psClose = true;
                    if (psClose || prop_stmt == null) break block31;
                }
                catch (SQLException se) {
                    block32: {
                        FFDCFilter.processException((Throwable)se, (String)"com.ibm.ws.session.store.db.DatabaseHashMap.getValue", (String)"1411", (Object)s);
                        LoggingUtil.SESSION_LOGGER_WAS.logp(Level.SEVERE, methodClassName, methodNames[14], "DatabaseHashMap.getValueErrBH");
                        LoggingUtil.SESSION_LOGGER_WAS.logp(Level.SEVERE, methodClassName, methodNames[14], "CommonMessage.sessionid", sessId + " " + id);
                        LoggingUtil.SESSION_LOGGER_WAS.logp(Level.SEVERE, methodClassName, methodNames[14], "CommonMessage.exception", se);
                        if (psClose || prop_stmt == null) break block32;
                        DatabaseHashMap.closeResultSet(rs);
                        DatabaseHashMap.closeStatement(prop_stmt);
                    }
                    this.closeConnection(conn);
                    break block33;
                }
                catch (Exception e) {
                    block34: {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.session.store.db.DatabaseHashMap.getValue", (String)"1417", (Object)s);
                        LoggingUtil.SESSION_LOGGER_WAS.logp(Level.SEVERE, methodClassName, methodNames[14], "DatabaseHashMap.getValueErrBH");
                        LoggingUtil.SESSION_LOGGER_WAS.logp(Level.SEVERE, methodClassName, methodNames[14], "CommonMessage.exception", e);
                        if (psClose || prop_stmt == null) break block34;
                        {
                            catch (Throwable throwable) {
                                if (!psClose && prop_stmt != null) {
                                    DatabaseHashMap.closeResultSet(rs);
                                    DatabaseHashMap.closeStatement(prop_stmt);
                                }
                                this.closeConnection(conn);
                                throw throwable;
                            }
                        }
                        DatabaseHashMap.closeResultSet(rs);
                        DatabaseHashMap.closeStatement(prop_stmt);
                    }
                    this.closeConnection(conn);
                }
                DatabaseHashMap.closeResultSet(rs);
                DatabaseHashMap.closeStatement(prop_stmt);
            }
            this.closeConnection(conn);
        }
        return tmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int updateLastAccessTime(BackedSession sess, long nowTime) {
        Connection con;
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_WAS.entering(methodClassName, methodNames[15]);
        }
        if ((con = this.getConnection(false)) == null) {
            return 1;
        }
        PreparedStatement s = null;
        String id = sess.getId();
        int rowsRet = 0;
        try {
            s = con.prepareStatement(this.asyncUpdate);
            this.setPSLong(s, 1, nowTime);
            s.setString(2, id);
            s.setString(3, id);
            s.setString(4, this.getIStore().getId());
            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[15], "before lastacc upd for " + id);
            }
            rowsRet = s.executeUpdate();
            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                if (rowsRet > 0) {
                    LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[15], "after upd (row changed " + id);
                } else {
                    LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[15], "row does not exist for " + id);
                }
            }
        }
        catch (Throwable th) {
            FFDCFilter.processException((Throwable)th, (String)"com.ibm.ws.session.store.db.DatabaseHashMap.updateLastAccessTime", (String)"1476", (Object)sess);
            LoggingUtil.SESSION_LOGGER_WAS.logp(Level.SEVERE, methodClassName, methodNames[15], "CommonMessage.sessionid", id);
            LoggingUtil.SESSION_LOGGER_WAS.logp(Level.SEVERE, methodClassName, methodNames[15], "CommonMessage.exception", th);
        }
        finally {
            if (s != null) {
                DatabaseHashMap.closeStatement(s);
            }
            this.closeConnection(con);
        }
        return rowsRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected int overQualLastAccessTimeUpdate(BackedSession sess, long nowTime) {
        int rowsRet;
        Connection con;
        block16: {
            String id;
            PreparedStatement s;
            block14: {
                int n;
                block15: {
                    if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                        StringBuffer sb = new StringBuffer(" lastAccessTime= ");
                        sb.append(sess.getCurrentAccessTime());
                        sb.append("; nowTime= ").append(nowTime);
                        LoggingUtil.SESSION_LOGGER_WAS.entering(methodClassName, methodNames[16], sb);
                    }
                    con = null;
                    s = null;
                    id = sess.getId();
                    rowsRet = 1;
                    BackedSession backedSession = sess;
                    // MONITORENTER : backedSession
                    con = this.getConnection(false);
                    if (con != null) break block14;
                    n = 1;
                    // MONITOREXIT : backedSession
                    if (s == null) break block15;
                    DatabaseHashMap.closeStatement(s);
                }
                if (con == null) return n;
                this.closeConnection(con);
                return n;
            }
            try {
                s = con.prepareStatement(this.optUpdatePrimRow);
                this.setPSLong(s, 1, nowTime);
                s.setString(2, id);
                s.setString(3, id);
                s.setString(4, sess.getAppName());
                this.setPSLong(s, 5, sess.getCurrentAccessTime());
                rowsRet = s.executeUpdate();
                if (rowsRet > 0) {
                    sess.updateLastAccessTime(nowTime);
                }
                // MONITOREXIT : backedSession
                if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                    if (rowsRet > 0) {
                        LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[16], "after upd (row changed " + id);
                    } else {
                        LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[16], "It might be either cache hit or session is not in cache for  " + id);
                    }
                }
                if (s == null) break block16;
            }
            catch (Throwable th) {
                block17: {
                    try {
                        FFDCFilter.processException((Throwable)th, (String)"com.ibm.ws.session.store.db.DatabaseHashMap.overQualLastAccessTimeUpdate", (String)"1531", (Object)sess);
                        LoggingUtil.SESSION_LOGGER_WAS.logp(Level.SEVERE, methodClassName, methodNames[16], "CommonMessage.sessionid", id);
                        LoggingUtil.SESSION_LOGGER_WAS.logp(Level.SEVERE, methodClassName, methodNames[16], "CommonMessage.exception", th);
                        if (s == null) break block17;
                    }
                    catch (Throwable throwable) {
                        if (s != null) {
                            DatabaseHashMap.closeStatement(s);
                        }
                        if (con == null) throw throwable;
                        this.closeConnection(con);
                        throw throwable;
                    }
                    DatabaseHashMap.closeStatement(s);
                }
                if (con == null) return rowsRet;
                this.closeConnection(con);
                return rowsRet;
            }
            DatabaseHashMap.closeStatement(s);
        }
        if (con == null) return rowsRet;
        this.closeConnection(con);
        return rowsRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BackedSession readFromExternal(String id) {
        Statement s = null;
        String appName = this.getIStore().getId();
        Connection con = this.getConnection(false);
        if (con == null) {
            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[17], "unable to get con when processing session " + id);
            }
            return null;
        }
        DatabaseSession sess = null;
        try {
            sess = this.readPrimitives(id, appName, con);
        }
        catch (Throwable th) {
            FFDCFilter.processException((Throwable)th, (String)"com.ibm.ws.session.store.db.DatabaseHashMap.readFromExternal", (String)"1611", (Object)((Object)sess));
            LoggingUtil.SESSION_LOGGER_WAS.logp(Level.SEVERE, methodClassName, methodNames[17], "DatabaseHashMap.selectAndLockError");
            LoggingUtil.SESSION_LOGGER_WAS.logp(Level.SEVERE, methodClassName, methodNames[17], "CommonMessage.sessionid", id);
            LoggingUtil.SESSION_LOGGER_WAS.logp(Level.SEVERE, methodClassName, methodNames[17], "CommonMessage.exception", th);
        }
        finally {
            if (s != null) {
                DatabaseHashMap.closeStatement(s);
            }
            this.closeConnection(con);
        }
        return sess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DatabaseSession readPrimitives(String id, String appName, Connection con) throws SQLException {
        DatabaseSession sess;
        PreparedStatement ps;
        block6: {
            ps = null;
            ResultSet rs = null;
            sess = null;
            try {
                ps = this.usingDB2 || this.usingDerby ? con.prepareStatement(this.readPrimitiveDataDb2) : con.prepareStatement(this.readPrimitiveData);
                ps.setString(1, id);
                ps.setString(2, id);
                ps.setString(3, appName);
                rs = ps.executeQuery();
                if (rs.next()) {
                    sess = new DatabaseSession(this, id, ((DatabaseStore)this.getIStore()).getStoreCallback());
                    long lastaccess = rs.getLong(1);
                    long createTime = rs.getLong(2);
                    int maxInact = rs.getInt(3);
                    String userName = rs.getString(4);
                    short listenerflag = rs.getShort(5);
                    sess.updateLastAccessTime(lastaccess);
                    sess.setCreationTime(createTime);
                    sess.internalSetMaxInactive(maxInact);
                    sess.internalSetUser(userName);
                    sess.setIsValid(true);
                    sess.setListenerFlag(listenerflag);
                }
                if (rs == null) break block6;
            }
            catch (Throwable throwable) {
                if (rs != null) {
                    DatabaseHashMap.closeResultSet(rs);
                }
                if (ps != null) {
                    DatabaseHashMap.closeStatement(ps);
                }
                throw throwable;
            }
            DatabaseHashMap.closeResultSet(rs);
        }
        if (ps != null) {
            DatabaseHashMap.closeStatement(ps);
        }
        return sess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - bad return control flow
     */
    protected boolean isPresent(String id) {
        boolean bl;
        Connection con;
        PreparedStatement s;
        block16: {
            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_WAS.entering(methodClassName, methodNames[18]);
            }
            if (this.isPresentInRecentlyInvalidatedList(id)) {
                return true;
            }
            s = null;
            ResultSet rs = null;
            con = null;
            boolean sessionIdInUse = false;
            con = this.getConnection(false);
            if (con == null) {
                return false;
            }
            try {
                s = this.usingDB2 || this.usingDerby ? con.prepareStatement(this.getOneNoUpdate) : con.prepareStatement(this.getOneNoUpdateNonDB2);
                s.setString(1, id);
                s.setString(2, id);
                rs = s.executeQuery();
                if (rs.next()) {
                    if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINER)) {
                        LoggingUtil.SESSION_LOGGER_WAS.exiting(methodClassName, methodNames[18], "Found sessionid in Database");
                    }
                    sessionIdInUse = true;
                }
                bl = sessionIdInUse;
                if (rs == null) break block16;
            }
            catch (SQLException se) {
                block17: {
                    FFDCFilter.processException((Throwable)se, (String)"com.ibm.ws.session.store.db.DatabaseHashMap.isPresent", (String)"1715", (Object)((Object)this));
                    LoggingUtil.SESSION_LOGGER_WAS.logp(Level.SEVERE, methodClassName, methodNames[18], "DatabaseHashMap.selectNoUpdateError");
                    LoggingUtil.SESSION_LOGGER_WAS.logp(Level.SEVERE, methodClassName, methodNames[18], "CommonMessage.sessionid", id);
                    LoggingUtil.SESSION_LOGGER_WAS.logp(Level.SEVERE, methodClassName, methodNames[18], "CommonMessage.exception", se);
                    if (rs == null) break block17;
                    DatabaseHashMap.closeResultSet(rs);
                }
                if (s != null) {
                    DatabaseHashMap.closeStatement(s);
                }
                this.closeConnection(con);
            }
            catch (Exception e) {
                block18: {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.session.store.db.DatabaseHashMap.isPresent", (String)"1720", (Object)((Object)this));
                    LoggingUtil.SESSION_LOGGER_WAS.logp(Level.SEVERE, methodClassName, methodNames[18], "DatabaseHashMap.selectNoUpdateError");
                    LoggingUtil.SESSION_LOGGER_WAS.logp(Level.SEVERE, methodClassName, methodNames[18], "CommonMessage.sessionid", id);
                    LoggingUtil.SESSION_LOGGER_WAS.logp(Level.SEVERE, methodClassName, methodNames[18], "CommonMessage.exception", e);
                    if (rs == null) break block18;
                    {
                        catch (Throwable throwable) {
                            if (rs != null) {
                                DatabaseHashMap.closeResultSet(rs);
                            }
                            if (s != null) {
                                DatabaseHashMap.closeStatement(s);
                            }
                            this.closeConnection(con);
                            throw throwable;
                        }
                    }
                    DatabaseHashMap.closeResultSet(rs);
                }
                if (s != null) {
                    DatabaseHashMap.closeStatement(s);
                }
                this.closeConnection(con);
            }
            DatabaseHashMap.closeResultSet(rs);
        }
        if (s != null) {
            DatabaseHashMap.closeStatement(s);
        }
        this.closeConnection(con);
        return bl;
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void insertSession(BackedSession d2) {
        Connection conn;
        block12: {
            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_WAS.entering(methodClassName, methodNames[19]);
            }
            d2.update = new StringBuffer();
            conn = null;
            PreparedStatement ps = null;
            boolean psClose = false;
            conn = this.getConnection(false);
            if (conn == null) {
                return;
            }
            try {
                d2.update.append(this.insNoProp);
                if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                    LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[19], "updating Primary Row - NO properties");
                }
                ps = conn.prepareStatement(d2.update.toString());
                String id = d2.getId();
                ps.setString(1, id);
                ps.setString(2, id);
                ps.setString(3, d2.getAppName());
                this.listenerFlagUpdate(d2);
                ps.setShort(4, d2.listenerFlag);
                long tmpCreationTime = d2.getCreationTime();
                d2.setLastWriteLastAccessTime(tmpCreationTime);
                this.setPSLong(ps, 5, tmpCreationTime);
                this.setPSLong(ps, 6, tmpCreationTime);
                ps.setInt(7, d2.getMaxInactiveInterval());
                ps.setString(8, d2.getUserName());
                if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                    LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[19], "before upd " + d2.update.toString() + " for sess " + id);
                }
                ps.executeUpdate();
                d2.needToInsert = false;
                if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                    LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[19], "after upd " + d2.update.toString() + " for sess " + id);
                }
                ps.close();
                psClose = true;
                this.removeFromRecentlyInvalidatedList(d2.getId());
                if (psClose || ps == null) break block12;
            }
            catch (SQLException se) {
                block13: {
                    FFDCFilter.processException((Throwable)se, (String)"com.ibm.ws.session.store.db.DatabaseHashMap.insertSession", (String)"1803", (Object)d2);
                    LoggingUtil.SESSION_LOGGER_WAS.logp(Level.SEVERE, methodClassName, methodNames[19], "DatabaseHashMap.ejbCreateError");
                    LoggingUtil.SESSION_LOGGER_WAS.logp(Level.SEVERE, methodClassName, methodNames[19], "CommonMessage.object", d2.toString());
                    LoggingUtil.SESSION_LOGGER_WAS.logp(Level.SEVERE, methodClassName, methodNames[19], "CommonMessage.miscData", "  Update SQL " + d2.update);
                    LoggingUtil.SESSION_LOGGER_WAS.logp(Level.SEVERE, methodClassName, methodNames[19], "CommonMessage.exception", se);
                    if (psClose || ps == null) break block13;
                    DatabaseHashMap.closeStatement(ps);
                }
                this.closeConnection(conn);
            }
            catch (Exception ee) {
                block14: {
                    FFDCFilter.processException((Throwable)ee, (String)"com.ibm.ws.session.store.db.DatabaseHashMap.insertSession", (String)"1810", (Object)d2);
                    LoggingUtil.SESSION_LOGGER_WAS.logp(Level.SEVERE, methodClassName, methodNames[19], "DatabaseHashMap.ejbCreateError");
                    LoggingUtil.SESSION_LOGGER_WAS.logp(Level.SEVERE, methodClassName, methodNames[19], "CommonMessage.exception", ee);
                    if (psClose || ps == null) break block14;
                    {
                        catch (Throwable throwable) {
                            if (!psClose && ps != null) {
                                DatabaseHashMap.closeStatement(ps);
                            }
                            this.closeConnection(conn);
                            throw throwable;
                        }
                    }
                    DatabaseHashMap.closeStatement(ps);
                }
                this.closeConnection(conn);
            }
            DatabaseHashMap.closeStatement(ps);
        }
        this.closeConnection(conn);
        d2.update = null;
        d2.userWriteHit = false;
        d2.maxInactWriteHit = false;
        d2.listenCntHit = false;
    }

    boolean handlePropertyHits(BackedSession d2, Thread t, int buflen) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_WAS.entering(methodClassName, methodNames[20]);
        }
        boolean rc = true;
        if (buflen <= this.smallColSize) {
            d2.update.append(smallCol).append(equals).append(comma).append(setMediumNull).append(comma).append(setLargeNull);
        } else if (buflen <= this.mediumColSize) {
            d2.update.append(setSmallNull).append(comma).append(medCol).append(equals).append(comma).append(setLargeNull);
        } else if (buflen <= this.largeColSize) {
            d2.update.append(setSmallNull).append(comma).append(setMediumNull).append(comma).append(lgCol).append(equals);
        } else {
            rc = false;
            LoggingUtil.SESSION_LOGGER_WAS.logp(Level.SEVERE, methodClassName, methodNames[20], "DatabaseHashMap.db2LongVarCharErr");
        }
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINER)) {
            LoggingUtil.SESSION_LOGGER_WAS.exiting(methodClassName, methodNames[20], rc);
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean persistSession(BackedSession d2, boolean propHit) {
        Connection con;
        block57: {
            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_WAS.entering(methodClassName, methodNames[21]);
            }
            con = null;
            String id = d2.getId();
            Thread t = Thread.currentThread();
            PreparedStatement ps = null;
            boolean psClose = false;
            byte[] objbuf = null;
            int objbufLength = 0;
            try {
                SessionStatistics pmiStats;
                boolean success;
                d2.update = new StringBuffer();
                boolean didFirstCol = false;
                d2.update.append(this.upBase);
                if (d2.userWriteHit) {
                    if (didFirstCol) {
                        d2.update.append(comma);
                    }
                    d2.update.append(userCol).append(equals);
                    didFirstCol = true;
                }
                if (d2.maxInactWriteHit) {
                    if (didFirstCol) {
                        d2.update.append(comma);
                    } else {
                        didFirstCol = true;
                    }
                    d2.update.append(maxInactCol).append(equals);
                }
                if (d2.listenCntHit) {
                    if (didFirstCol) {
                        d2.update.append(comma);
                    } else {
                        didFirstCol = true;
                    }
                    d2.update.append(listenCol).append(equals);
                }
                if (!this._smc.getEnableEOSWrite() || this._smc.getScheduledInvalidation()) {
                    if (didFirstCol) {
                        d2.update.append(comma);
                    } else {
                        didFirstCol = true;
                    }
                    d2.update.append(lastAccCol).append(equals);
                }
                if (propHit) {
                    if (!this._smc.isUsingMultirow()) {
                        if (didFirstCol) {
                            d2.update.append(comma);
                        } else {
                            didFirstCol = true;
                        }
                        objbuf = this.serializeAppData(d2);
                        if (objbuf != null) {
                            objbufLength = objbuf.length;
                        }
                    }
                    if (!(success = this.handlePropertyHits(d2, t, objbufLength))) {
                        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                            LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[21], "returning false after handlePropertyHits");
                        }
                        boolean bl = false;
                        if (!psClose && ps != null) {
                            DatabaseHashMap.closeStatement(ps);
                        }
                        if (con == null) return bl;
                        this.closeConnection(con);
                        return bl;
                    }
                }
                if (!didFirstCol) {
                    d2.update = null;
                    d2.userWriteHit = false;
                    d2.maxInactWriteHit = false;
                    d2.listenCntHit = false;
                    if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINER)) {
                        LoggingUtil.SESSION_LOGGER_WAS.exiting(methodClassName, methodNames[21], "true - Nothing changed");
                    }
                    success = true;
                    if (!psClose && ps != null) {
                        DatabaseHashMap.closeStatement(ps);
                    }
                    if (con == null) return success;
                    this.closeConnection(con);
                    return success;
                }
                d2.update.append(upId);
                con = this.getConnection(false);
                if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                    LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[21], "thread " + t + " is dealing with session " + id);
                }
                if (con == null) {
                    if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINER)) {
                        LoggingUtil.SESSION_LOGGER_WAS.exiting(methodClassName, methodNames[21], "null connection on id " + id);
                    }
                    success = false;
                    if (!psClose && ps != null) {
                        DatabaseHashMap.closeStatement(ps);
                    }
                    if (con == null) return success;
                    this.closeConnection(con);
                    return success;
                }
                ps = con.prepareStatement(d2.update.toString());
                long startTime = System.currentTimeMillis();
                if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                    LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[21], "doing a sql update of " + d2.update.toString());
                }
                int colcnt = 0;
                if (d2.userWriteHit) {
                    if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                        LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[21], "update username " + d2.getUserName());
                    }
                    ps.setString(++colcnt, d2.getUserName());
                    d2.userWriteHit = false;
                }
                if (d2.maxInactWriteHit) {
                    if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                        LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[21], "update maxinactive " + d2.getMaxInactiveInterval());
                    }
                    ps.setInt(++colcnt, d2.getMaxInactiveInterval());
                    d2.maxInactWriteHit = false;
                }
                if (d2.listenCntHit) {
                    if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                        LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[21], "update listerncnt " + d2.listenerFlag);
                    }
                    ps.setShort(++colcnt, d2.listenerFlag);
                    d2.listenCntHit = false;
                }
                ByteArrayInputStream bis = null;
                long time = d2.getCurrentAccessTime();
                if (!this._smc.getEnableEOSWrite() || this._smc.getScheduledInvalidation()) {
                    if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                        LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[21], "update last write time to DB !!!!!!! " + time);
                    }
                    this.setPSLong(ps, ++colcnt, time);
                    d2.setLastWriteLastAccessTime(time);
                }
                if (propHit && !this._smc.isUsingMultirow()) {
                    if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                        LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[21], "update  " + time);
                    }
                    ++colcnt;
                    if (!this.usingInformix && !this._smc.isUseOracleBlob()) {
                        ps.setBytes(colcnt, objbuf);
                    } else {
                        bis = new ByteArrayInputStream(objbuf);
                        ps.setBinaryStream(colcnt, (InputStream)bis, objbufLength);
                    }
                }
                ps.setString(++colcnt, id);
                ps.setString(++colcnt, id);
                ps.setString(++colcnt, d2.getAppName());
                if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                    LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[21], "before upd " + d2.update.toString() + " for sess " + id);
                }
                ps.executeUpdate();
                if (objbuf != null && propHit && !this._smc.isUsingMultirow() && (pmiStats = this._iStore.getSessionStatistics()) != null) {
                    pmiStats.writeTimes((long)objbuf.length, System.currentTimeMillis() - startTime);
                }
                if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                    LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[21], "Just wrote out Primary Row ");
                }
                ps.close();
                psClose = true;
                if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                    LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[21], "thread " + t + " has sent updates for " + id);
                }
                if (psClose || ps == null) break block57;
            }
            catch (SQLException se) {
                boolean bl;
                block58: {
                    FFDCFilter.processException((Throwable)se, (String)"com.ibm.ws.session.store.db.DatabaseHashMap.persistSession", (String)"2099", (Object)d2);
                    LoggingUtil.SESSION_LOGGER_WAS.logp(Level.SEVERE, methodClassName, methodNames[21], "DatabaseHashMap.ejbStoreError");
                    LoggingUtil.SESSION_LOGGER_WAS.logp(Level.SEVERE, methodClassName, methodNames[21], "CommonMessage.object", d2.toString());
                    LoggingUtil.SESSION_LOGGER_WAS.logp(Level.SEVERE, methodClassName, methodNames[21], "CommonMessage.miscData", " Update string: " + d2.update);
                    LoggingUtil.SESSION_LOGGER_WAS.logp(Level.SEVERE, methodClassName, methodNames[21], "CommonMessage.exception", se);
                    bl = false;
                    if (psClose || ps == null) break block58;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    DatabaseHashMap.closeStatement(ps);
                }
                if (con == null) return bl;
                this.closeConnection(con);
                return bl;
                catch (Exception ee) {
                    FFDCFilter.processException((Throwable)ee, (String)"com.ibm.ws.session.store.db.DatabaseHashMap.ejbStore", (String)"1994", (Object)d2);
                    LoggingUtil.SESSION_LOGGER_WAS.logp(Level.SEVERE, methodClassName, methodNames[21], "DatabaseHashMap.ejbStoreError");
                    LoggingUtil.SESSION_LOGGER_WAS.logp(Level.SEVERE, methodClassName, methodNames[21], "CommonMessage.object", d2.toString());
                    LoggingUtil.SESSION_LOGGER_WAS.logp(Level.SEVERE, methodClassName, methodNames[21], "CommonMessage.exception", ee);
                    bl = false;
                    return bl;
                }
            }
            finally {
                if (!psClose && ps != null) {
                    DatabaseHashMap.closeStatement(ps);
                }
                if (con != null) {
                    this.closeConnection(con);
                }
            }
            DatabaseHashMap.closeStatement(ps);
        }
        if (con != null) {
            this.closeConnection(con);
        }
        if (!TraceComponent.isAnyTracingEnabled()) return true;
        if (!LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINER)) return true;
        LoggingUtil.SESSION_LOGGER_WAS.exiting(methodClassName, methodNames[21], true);
        return true;
    }

    private SerializationService getSerializationService() {
        return this.getDatabaseStoreService().getSerializationService();
    }

    protected ObjectOutputStream createObjectOutputStream(OutputStream output) throws IOException {
        return this.getSerializationService().createObjectOutputStream(output);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] serializeAppData(BackedSession d2) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_WAS.entering(methodClassName, methodNames[22]);
        }
        ByteArrayOutputStream baos = null;
        ObjectOutputStream oos = null;
        byte[] objbuf = null;
        try {
            Map ht = null;
            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[22], "get swappableData and convert to byte array");
            }
            BackedSession backedSession = d2;
            synchronized (backedSession) {
                ht = d2.getSwappableData();
            }
            baos = new ByteArrayOutputStream();
            oos = this.createObjectOutputStream(baos);
            oos.writeObject(ht);
            oos.flush();
            objbuf = baos.toByteArray();
            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[22], "success - size of byte array is " + objbuf.length);
            }
            oos.close();
            baos.close();
        }
        catch (ConcurrentModificationException cme) {
            LoggingUtil.SESSION_LOGGER_WAS.logp(Level.INFO, methodClassName, methodNames[22], "DatabaseHashMap.deferWrite", d2.getId());
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.session.store.db.DatabaseHashMap.commonSetup", (String)"2052", (Object)d2);
            LoggingUtil.SESSION_LOGGER_WAS.logp(Level.SEVERE, methodClassName, methodNames[22], "DatabaseHashMap.commonSetupError");
            LoggingUtil.SESSION_LOGGER_WAS.logp(Level.SEVERE, methodClassName, methodNames[22], "CommonMessage.exception", e);
        }
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINER)) {
            LoggingUtil.SESSION_LOGGER_WAS.exiting(methodClassName, methodNames[22]);
        }
        return objbuf;
    }

    void writeCachedLastAccessedTimes(Connection nukerCon) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_WAS.entering(methodClassName, methodNames[23]);
        }
        Hashtable updTab = (Hashtable)this.cachedLastAccessedTimes.clone();
        this.cachedLastAccessedTimes.clear();
        Enumeration updEnum = updTab.keys();
        String id = null;
        PreparedStatement ps = null;
        boolean psClose = false;
        while (updEnum.hasMoreElements()) {
            id = (String)updEnum.nextElement();
            Long timeObj = (Long)updTab.get(id);
            long time = timeObj;
            try {
                ps = nukerCon.prepareStatement(this.asyncUpdate);
                this.setPSLong(ps, 1, time);
                ps.setString(2, id);
                ps.setString(3, id);
                ps.setString(4, this.getIStore().getId());
                ps.executeUpdate();
                ps.close();
                psClose = true;
                if (!TraceComponent.isAnyTracingEnabled() || !LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) continue;
                LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[23], "handleAsyncUpdates - Updating LastAccess for " + id);
            }
            catch (Exception se1) {
                FFDCFilter.processException((Throwable)se1, (String)"com.ibm.ws.session.store.db.DatabaseHashMap.writeCachedLastAccessedTimes", (String)"2109", (Object)id);
                LoggingUtil.SESSION_LOGGER_WAS.logp(Level.SEVERE, methodClassName, methodNames[23], "DatabaseHashMap.handleAsyncError");
                LoggingUtil.SESSION_LOGGER_WAS.logp(Level.SEVERE, methodClassName, methodNames[23], "CommonMessage.sessionid", id);
                LoggingUtil.SESSION_LOGGER_WAS.logp(Level.SEVERE, methodClassName, methodNames[23], "CommonMessage.exception", se1);
                throw se1;
            }
            finally {
                if (psClose || ps == null) continue;
                DatabaseHashMap.closeStatement(ps);
            }
        }
    }

    String getCollectionName(String url) {
        String SEPARATOR = "\\";
        Object cell = null;
        Object node = null;
        Object serverName = null;
        int index = -1;
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_WAS.entering(methodClassName, methodNames[24], "url: " + url);
        }
        if (url != null && url.indexOf("jdbc:db2") != -1) {
            String collection = url;
            index = collection.indexOf(";");
            if (index != -1) {
                collection = collection.substring(0, index);
            }
            if ((index = collection.indexOf("//")) != -1) {
                collection = collection.substring(index + 2);
            }
            if ((index = collection.indexOf("/")) != -1 && (collection = collection.substring(index + 1).trim()).length() != 0) {
                this.as400_collection = collection;
            }
        }
        if (this.as400_collection == null) {
            String installLibrary = System.getProperty("was.install.library");
            if (installLibrary == null) {
                LoggingUtil.SESSION_LOGGER_WAS.logp(Level.WARNING, methodClassName, methodNames[24], "CommonMessage.miscData", "was.install.library not set.  Using collection QEJBASSN for session persistance.");
                this.as400_collection = "QEJBASSN";
            } else {
                LoggingUtil.SESSION_LOGGER_WAS.logp(Level.WARNING, methodClassName, methodNames[24], "CommonMessage.miscData", "using was.install.library to derive collection name for session persistance.");
                this.as400_collection = installLibrary + "SN";
                if (this.as400_collection.length() > 10) {
                    this.as400_collection = this.as400_collection.substring(0, 10);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINER)) {
            LoggingUtil.SESSION_LOGGER_WAS.exiting(methodClassName, methodNames[24], "Session Persistance will use the collection: " + this.as400_collection);
        }
        return this.as400_collection;
    }

    private Object oracleGetValue(ResultSet rsltset, BackedSession s) {
        Object tmp;
        block11: {
            tmp = null;
            try {
                SessionStatistics pmiStats;
                long startTime = System.currentTimeMillis();
                long readSize = 0L;
                BufferedInputStream bis = null;
                ByteArrayInputStream bais = null;
                byte[] b = rsltset.getBytes(smallCol);
                if (b == null) {
                    if (!this._smc.isUseOracleBlob()) {
                        b = rsltset.getBytes(medCol);
                    } else {
                        Blob blob = rsltset.getBlob(medCol);
                        if (blob != null) {
                            bis = new BufferedInputStream(blob.getBinaryStream());
                            readSize = blob.length();
                        }
                    }
                }
                if (b != null && b.length > 0) {
                    readSize = b.length;
                    bais = new ByteArrayInputStream(b);
                    bis = new BufferedInputStream(bais);
                }
                if (bis == null) break block11;
                try {
                    tmp = ((DatabaseStore)this.getIStore()).getLoader().loadObject(bis);
                }
                catch (ClassNotFoundException ce) {
                    FFDCFilter.processException((Throwable)ce, (String)"com.ibm.ws.session.store.db.DatabaseHashMap.oracleGetValue", (String)"2321", (Object)s);
                    LoggingUtil.SESSION_LOGGER_WAS.logp(Level.SEVERE, methodClassName, methodNames[25], "BackedHashtable.classNotFoundError");
                    LoggingUtil.SESSION_LOGGER_WAS.logp(Level.SEVERE, methodClassName, methodNames[25], "CommonMessage.sessionid", s.getId());
                    LoggingUtil.SESSION_LOGGER_WAS.logp(Level.SEVERE, methodClassName, methodNames[25], "CommonMessage.exception", ce);
                }
                bis.close();
                if (bais != null) {
                    bais.close();
                }
                if ((pmiStats = this._iStore.getSessionStatistics()) != null) {
                    pmiStats.readTimes(readSize, System.currentTimeMillis() - startTime);
                }
            }
            catch (Throwable e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.session.store.db.DatabaseHashMap.oracleGetValue", (String)"2334", (Object)s);
                LoggingUtil.SESSION_LOGGER_WAS.logp(Level.SEVERE, methodClassName, methodNames[25], "DatabaseHashMap.oracleGetValueError");
                LoggingUtil.SESSION_LOGGER_WAS.logp(Level.SEVERE, methodClassName, methodNames[25], "CommonMessage.exception", e);
            }
        }
        return tmp;
    }

    protected void initializeSQL_Strings() {
        String createCol = "creationtime";
        String commonPreListener = " and (listenercnt = 1 OR listenercnt = 3 ) and maxinactivetime >= 0 and (maxinactivetime < ((? - lastaccess) / 1000.0)))";
        String commonPreNoListener = " and (listenercnt = 0 OR listenercnt = 2 ) and maxinactivetime >= 0 and (maxinactivetime < ((? - lastaccess) / 1000.0)))";
        String upBaseAcc = "update " + this.tableName + " set " + lastAccCol + equals;
        this.remoteInvalAll = "update " + this.tableName + " set maxinactivetime = 0 where id = ? and propid = ? and appname = ? and maxinactivetime != 0";
        this.getOneNoUpdate = "select maxinactivetime,lastaccess, appname from " + this.tableName + " where id = ? and propid = ? for read only";
        this.getOneNoUpdateNonDB2 = "select maxinactivetime,lastaccess, appname from " + this.tableName + " where id = ? and propid = ?";
        this.upBase = "update " + this.tableName + " set ";
        this.asyncUpdate = upBaseAcc + " where id = ? and propid = ?  and appname = ?";
        this.optUpdate = upBaseAcc + " where id = ? and propid = ?  and appname = ? and " + lastAccCol + equals;
        this.optUpdatePrimRow = upBaseAcc + " where id = ? and propid = ?  and appname = ? and " + lastAccCol + equals;
        this.insNoProp = "insert into " + this.tableName + " (" + varList + ") values (?, ?, ?, ?, ?, ?, ?, ?, NULL, NULL, NULL)";
        this.insForInval = "insert into " + this.tableName + " (" + idCol + "," + propCol + "," + appCol + "," + lastAccCol + "," + maxInactCol + ") values (?, ?, ?, ?, ?)";
        this.insSm = "insert into " + this.tableName + " (" + varList + ") values (?, ?, ?, ?, ?, ?, ?, ?, ?, NULL, NULL)";
        this.insMed = "insert into " + this.tableName + " (" + varList + ") values (?, ?, ?, ?, ?, ?, ?, ?, NULL, ?, NULL)";
        this.insLg = "insert into " + this.tableName + " (" + varList + ") values (?, ?, ?, ?, ?, ?, ?, ?, NULL, NULL, ?)";
        this.getProp = "select small, medium, large from  " + this.tableName + "  where id = ? and propid = ? and appname = ? for read only";
        this.delPropall = "delete from  " + this.tableName + " where id = ? and propid <> id and appname = ?";
        this.getPropNotDB2 = "select small, medium, large from  " + this.tableName + "  where id = ? and propid = ? and appname = ?";
        this.delProp = "delete from " + this.tableName + " where id = ? and propid = ? and appname = ?";
        this.insSmProp = "insert into " + this.tableName + " (id, propid, small, appname) values (?, ?, ?, ?)";
        this.insMedProp = "insert into " + this.tableName + " (id, propid, medium, appname) values (?, ?, ?, ?)";
        this.insLgProp = "insert into " + this.tableName + " (id, propid, large, appname) values (?, ?, ?, ?)";
        this.selMed = "select medium from " + this.tableName;
        this.selLg = "select large from " + this.tableName;
        this.readLastAccess = "select lastaccess from " + this.tableName + " where id = ? and propid = ? and appname = ?";
        this.selectForUpdate = "select lastaccess from " + this.tableName + " where id = ? and propid = ? and appname = ? for update of lastaccess";
        this.delPrimaryRowInval = "delete from  " + this.tableName + " where id = ? and propid = id  and appname = ? and lastaccess = ?";
        this.readPrimitiveData = "select lastaccess, creationtime ,maxinactivetime,username,listenercnt from " + this.tableName + " where id = ? and propid = ? and appname = ?";
        this.readPrimitiveDataDb2 = this.readPrimitiveData + " for read only";
        this.delOne = "delete from " + this.tableName + " where id = ?  and appname = ?";
        this.selDelNoListener = "select id,lastaccess, creationtime from  " + this.tableName + " where (appname = ? " + " and (listenercnt = 0 OR listenercnt = 2 ) and maxinactivetime >= 0 and (maxinactivetime < ((? - lastaccess) / 1000.0)))";
        this.selNukerString = "select id,lastaccess, creationtime,maxinactivetime,username,listenercnt from  " + this.tableName + " where ( appname = ? " + " and (listenercnt = 1 OR listenercnt = 3 ) and maxinactivetime >= 0 and (maxinactivetime < ((? - lastaccess) / 1000.0)))";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int setMaxInactToZero(String sessId, String appName) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_WAS.entering(methodClassName, methodNames[26], "for " + sessId + " and app " + appName);
        }
        int rc = 0;
        PreparedStatement psRemoteInval = null;
        Connection con = this.getConnection(false);
        if (con == null) {
            LoggingUtil.SESSION_LOGGER_WAS.logp(Level.SEVERE, methodClassName, methodNames[26], "DatabaseHashMap.nullConnection");
            return 0;
        }
        try {
            psRemoteInval = con.prepareStatement(this.remoteInvalAll);
            psRemoteInval.setString(1, sessId);
            psRemoteInval.setString(2, sessId);
            psRemoteInval.setString(3, appName);
            rc = psRemoteInval.executeUpdate();
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.session.store.db.DatabaseHashMap.setMaxInactToZero", (String)"2417", (Object)((Object)this));
            LoggingUtil.SESSION_LOGGER_WAS.logp(Level.SEVERE, methodClassName, methodNames[26], "CommonMessage.exception", t);
        }
        finally {
            if (psRemoteInval != null) {
                DatabaseHashMap.closeStatement(psRemoteInval);
            }
            this.closeConnection(con);
        }
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINER)) {
            LoggingUtil.SESSION_LOGGER_WAS.exiting(methodClassName, methodNames[26], "for " + sessId + " returning " + rc);
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performInvalidation() {
        Connection nukerCon;
        boolean ps2Closed;
        boolean ps1Closed;
        PreparedStatement ps2;
        PreparedStatement ps1;
        block30: {
            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_WAS.entering(methodClassName, methodNames[27]);
            }
            long now = System.currentTimeMillis();
            ps1 = null;
            ResultSet rs1 = null;
            ps2 = null;
            ps1Closed = false;
            ps2Closed = false;
            nukerCon = null;
            String appName = this.getIStore().getId();
            boolean doInvals = false;
            boolean doDatabaseInval = this.doScheduledInvalidation();
            nukerCon = this.getConnection(false);
            if (nukerCon == null) {
                if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINER)) {
                    LoggingUtil.SESSION_LOGGER_WAS.exiting(methodClassName, methodNames[27], "Connection is null");
                }
                return;
            }
            try {
                if (!this._smc.getEnableEOSWrite()) {
                    this.writeCachedLastAccessedTimes(nukerCon);
                }
                if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                    LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[27], "doDatabaseInval=" + doDatabaseInval);
                }
                if (doDatabaseInval) {
                    ps1 = nukerCon.prepareStatement(this.readLastAccess);
                    ps1.setString(1, appName);
                    ps1.setString(2, appName);
                    ps1.setString(3, appName);
                    rs1 = ps1.executeQuery();
                    boolean rowExists = false;
                    long lastTime = 0L;
                    if (rs1.next()) {
                        rowExists = true;
                        lastTime = rs1.getLong(1);
                    }
                    rs1.close();
                    ps1.close();
                    ps1Closed = true;
                    if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                        LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[27], "rowExists=" + rowExists);
                    }
                    if (rowExists) {
                        long lastCheck = now - this._smc.getInvalidationCheckInterval() * 1000L;
                        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                            LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[27], "lastCheck=" + lastCheck + ",lastTime=" + lastTime + ",now=" + now);
                        }
                        if (lastCheck >= lastTime || lastTime > now) {
                            ps2 = nukerCon.prepareStatement(this.optUpdate);
                            this.setPSLong(ps2, 1, now);
                            ps2.setString(2, appName);
                            ps2.setString(3, appName);
                            ps2.setString(4, appName);
                            this.setPSLong(ps2, 5, lastTime);
                            int res = ps2.executeUpdate();
                            if (res > 0) {
                                doInvals = true;
                            }
                        }
                    } else {
                        ps2 = nukerCon.prepareStatement(this.insForInval);
                        ps2.setString(1, appName);
                        ps2.setString(2, appName);
                        ps2.setString(3, appName);
                        this.setPSLong(ps2, 4, now);
                        ps2.setInt(5, -1);
                        ps2.executeUpdate();
                        doInvals = true;
                    }
                    if (ps2 != null) {
                        ps2.close();
                    }
                    ps2Closed = true;
                    if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                        LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, methodClassName, methodNames[27], "doInvals=" + doInvals);
                    }
                    if (doInvals) {
                        this.doInvalidations(nukerCon);
                        Enumeration e = this.pollForInvalidSessionsWithListeners(nukerCon);
                        this.processInvalidListeners(e, nukerCon);
                    }
                }
                if (ps1Closed || rs1 == null) break block30;
            }
            catch (Throwable t) {
                block31: {
                    try {
                        FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.session.store.db.DatabaseHashMap.performInvalidation", (String)"2537", (Object)((Object)this));
                        LoggingUtil.SESSION_LOGGER_WAS.logp(Level.SEVERE, methodClassName, methodNames[27], "DatabaseHashMap.performInvalidationError");
                        LoggingUtil.SESSION_LOGGER_WAS.logp(Level.SEVERE, methodClassName, methodNames[27], "CommonMessage.exception", t);
                        if (ps1Closed || rs1 == null) break block31;
                    }
                    catch (Throwable throwable) {
                        if (!ps1Closed && rs1 != null) {
                            DatabaseHashMap.closeResultSet(rs1);
                        }
                        if (!ps1Closed && ps1 != null) {
                            DatabaseHashMap.closeStatement(ps1);
                        }
                        if (!ps2Closed && ps2 != null) {
                            DatabaseHashMap.closeStatement(ps2);
                        }
                        this.closeConnection(nukerCon);
                        throw throwable;
                    }
                    DatabaseHashMap.closeResultSet(rs1);
                }
                if (!ps1Closed && ps1 != null) {
                    DatabaseHashMap.closeStatement(ps1);
                }
                if (!ps2Closed && ps2 != null) {
                    DatabaseHashMap.closeStatement(ps2);
                }
                this.closeConnection(nukerCon);
            }
            DatabaseHashMap.closeResultSet(rs1);
        }
        if (!ps1Closed && ps1 != null) {
            DatabaseHashMap.closeStatement(ps1);
        }
        if (!ps2Closed && ps2 != null) {
            DatabaseHashMap.closeStatement(ps2);
        }
        this.closeConnection(nukerCon);
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINER)) {
            LoggingUtil.SESSION_LOGGER_WAS.exiting(methodClassName, methodNames[27]);
        }
    }

    void processInvalidListeners(Enumeration enum1, Connection nukerCon) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_WAS.entering(methodClassName, methodNames[28]);
        }
        PreparedStatement delNuke = null;
        boolean delNukeClose = false;
        PreparedStatement ps = null;
        boolean psClose = false;
        long now = System.currentTimeMillis();
        int deleteCount = 0;
        while (enum1.hasMoreElements()) {
            block11: {
                DatabaseSession s = (DatabaseSession)((Object)enum1.nextElement());
                String id = s.getId();
                long lastAccess = s.getCurrentAccessTime();
                try {
                    s.setIsNew(false);
                    s.getSwappableListeners((short)1);
                    delNuke = nukerCon.prepareStatement(this.delPrimaryRowInval);
                    delNuke.setString(1, id);
                    delNuke.setString(2, s.getAppName());
                    this.setPSLong(delNuke, 3, lastAccess);
                    int rc = delNuke.executeUpdate();
                    delNuke.close();
                    delNukeClose = true;
                    if (rc > 0) {
                        s.internalInvalidate(true);
                        if (this._smc.isUsingMultirow()) {
                            ps = nukerCon.prepareStatement(this.delOne);
                            ps.setString(1, id);
                            ps.setString(2, s.getAppName());
                            ps.executeUpdate();
                            ps.close();
                            psClose = true;
                        }
                        ++deleteCount;
                    }
                    if (now + this._smc.getInvalidationCheckInterval() * 500L < System.currentTimeMillis()) {
                        this.updateNukerTimeStamp(nukerCon, this.getIStore().getId());
                        now = System.currentTimeMillis();
                    }
                    if (delNukeClose || delNuke == null) break block11;
                }
                catch (Exception e) {
                    try {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.session.store.db.DatabaseHashMap.processInvalidListeners", (String)"2623", (Object)((Object)s));
                        LoggingUtil.SESSION_LOGGER_WAS.logp(Level.SEVERE, methodClassName, methodNames[28], "DatabaseHashMap.invalidateError");
                        LoggingUtil.SESSION_LOGGER_WAS.logp(Level.SEVERE, methodClassName, methodNames[28], "CommonMessage.exception", e);
                        throw e;
                    }
                    catch (Throwable throwable) {
                        if (!delNukeClose && delNuke != null) {
                            DatabaseHashMap.closeStatement(delNuke);
                        }
                        if (!psClose && ps != null) {
                            DatabaseHashMap.closeStatement(ps);
                        }
                        throw throwable;
                    }
                }
                DatabaseHashMap.closeStatement(delNuke);
            }
            if (psClose || ps == null) continue;
            DatabaseHashMap.closeStatement(ps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNukerTimeStamp(Connection nukerCon, String appName) throws SQLException {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_WAS.entering(methodClassName, methodNames[29], "appName=" + appName);
        }
        PreparedStatement ps = null;
        long now = System.currentTimeMillis();
        try {
            ps = nukerCon.prepareStatement(this.asyncUpdate);
            this.setPSLong(ps, 1, now);
            ps.setString(2, appName);
            ps.setString(3, appName);
            ps.setString(4, appName);
            ps.executeUpdate();
        }
        finally {
            if (ps != null) {
                DatabaseHashMap.closeStatement(ps);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINER)) {
            LoggingUtil.SESSION_LOGGER_WAS.exiting(methodClassName, methodNames[29], "appName=" + appName);
        }
    }

    protected Object loadOneValue(String attrName, BackedSession sess) {
        Object value = null;
        if (this._smc.isUsingMultirow() && !((DatabaseSession)sess).getPopulatedAppData()) {
            value = this.getValue(attrName, sess);
        }
        return value;
    }

    final void setPSLong(PreparedStatement ps, int index, long value) throws SQLException {
        if (this.usingDB2Connect || this.usingSQLServer || this.usingDB2zOS) {
            ps.setBigDecimal(index, BigDecimal.valueOf(value));
        } else {
            ps.setLong(index, value);
        }
    }

    private void beginDBContext() {
    }

    private void endDBContext() {
    }

    private boolean doesIndexExists(Connection con, String indexName) {
        if (this.usingDB2) {
            if (this.usingAS400DB2) {
                return this.doesIndexExistsiSeries(con, indexName);
            }
            return this.doesIndexExistsDistributed(con, indexName);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private boolean doesIndexExistsDistributed(Connection con, String indexName) {
        block21: {
            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_WAS.entering("DatabaseHashMap", DatabaseHashMap.methodNames[31]);
            }
            indexExists = false;
            indexColDefCorrect = false;
            tblName = this.tableName;
            qualifierName = null;
            colNames = null;
            sqlQueryCol = null;
            sqlQueryIndex = null;
            ps = null;
            rs = null;
            tblName = tblName.toUpperCase();
            if (this._smc.isUsingCustomSchemaName()) {
                qualifierName = this.qualifierNameWhenCustomSchemaIsSet;
            } else if (this.dbid != null) {
                qualifierName = this.dbid.toUpperCase();
            }
            sqlQueryCol = "select ColNames from syscat.indexes where IndName = '" + indexName.toUpperCase() + "' and TabName = '" + tblName + "' and UniqueRule = 'U'";
            if (qualifierName != null) {
                sqlQueryCol = sqlQueryCol + " and tabschema = '" + qualifierName + "'";
            }
            sqlQueryCol = sqlQueryCol + " for read only";
            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, "DatabaseHashMap", DatabaseHashMap.methodNames[31], "Sql: " + sqlQueryCol);
            }
            try {
                ps = con.prepareStatement(sqlQueryCol);
                rs = ps.executeQuery();
                if (rs.next()) {
                    colNames = rs.getString(1);
                    indexExists = true;
                    if (colNames != null) {
                        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                            LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, "DatabaseHashMap", DatabaseHashMap.methodNames[31], colNames);
                        }
                        if (colNames.indexOf("id".toUpperCase()) != -1 && colNames.indexOf("propid".toUpperCase()) != -1 && colNames.indexOf("appname".toUpperCase()) != -1) {
                            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                                LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, "DatabaseHashMap", DatabaseHashMap.methodNames[31], "Index Column Definition is correct");
                            }
                            indexColDefCorrect = true;
                        }
                        if (!indexColDefCorrect) {
                            LoggingUtil.SESSION_LOGGER_WAS.logp(Level.WARNING, "DatabaseHashMap", DatabaseHashMap.methodNames[31], "DatabaseHashMap.IndexIncorrect");
                        }
                    }
                }
                if (rs == null) break block21;
            }
            catch (Throwable th) {
                block22: {
                    try {
                        LoggingUtil.SESSION_LOGGER_WAS.logp(Level.SEVERE, "DatabaseHashMap", DatabaseHashMap.methodNames[31], "CommonMessage.exception", th);
                        if (rs == null) break block22;
                    }
                    catch (Throwable var13_13) {
                        if (rs != null) {
                            DatabaseHashMap.closeResultSet(rs);
                        }
                        if (ps != null) {
                            DatabaseHashMap.closeStatement(ps);
                        }
                        throw var13_13;
                    }
                    DatabaseHashMap.closeResultSet(rs);
                }
                if (ps != null) {
                    DatabaseHashMap.closeStatement(ps);
                } else {
                    ** GOTO lbl60
                }
            }
            DatabaseHashMap.closeResultSet(rs);
        }
        if (ps != null) {
            DatabaseHashMap.closeStatement(ps);
        }
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_WAS.exiting("DatabaseHashMap", DatabaseHashMap.methodNames[31], indexExists);
        }
        return indexExists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private boolean doesIndexExistsiSeries(Connection con, String indexName) {
        block34: {
            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_WAS.entering("DatabaseHashMap", DatabaseHashMap.methodNames[32]);
            }
            indexExists_iSeries = false;
            sysIndexes = null;
            sysKeys = null;
            noQualifiertblName = this.tableName;
            qualifierName = null;
            sqlQueryIndex = null;
            sqlQueryCol = null;
            returnIndexName = null;
            index_colNames = null;
            schemaSeparator = ".";
            index = this.tableName.indexOf(".");
            if (index != -1) {
                noQualifiertblName = this.tableName.substring(index + 1);
            }
            ps = null;
            ps1 = null;
            rs = null;
            rs1 = null;
            counter = 0;
            sysIndexes = "QSYS2".concat(schemaSeparator).concat("sysindexes");
            sysKeys = "QSYS2".concat(schemaSeparator).concat("syskeys");
            sqlQueryIndex = "select index_name from " + sysIndexes + " where Index_Name = '" + indexName.toUpperCase() + "' and Table_Name = '" + noQualifiertblName + "' and IS_UNIQUE = 'U'";
            sqlQueryCol = "select COLUMN_NAME from " + sysKeys + " where INDEX_NAME = '" + indexName.toUpperCase() + "'";
            if (this.collectionName != null) {
                sqlQueryIndex = sqlQueryIndex + " and table_schema = '" + this.collectionName.toUpperCase() + "'";
                sqlQueryCol = sqlQueryCol + " and index_schema = '" + this.collectionName.toUpperCase() + "'";
            }
            sqlQueryIndex = sqlQueryIndex + " for read only";
            sqlQueryCol = sqlQueryCol + " for read only";
            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, "DatabaseHashMap", DatabaseHashMap.methodNames[32], "sqlQueryIndex: " + sqlQueryIndex);
                LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, "DatabaseHashMap", DatabaseHashMap.methodNames[32], "sqlQueryCol: " + sqlQueryCol);
            }
            try {
                ps = con.prepareStatement(sqlQueryIndex);
                rs = ps.executeQuery();
                if (rs.next()) {
                    returnIndexName = rs.getString(1);
                    if (returnIndexName != null) {
                        if (returnIndexName.indexOf(indexName.toUpperCase()) != -1) {
                            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                                LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, "DatabaseHashMap", DatabaseHashMap.methodNames[32], "index: " + returnIndexName + " exists");
                            }
                            indexExists_iSeries = true;
                        } else if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                            LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, "DatabaseHashMap", DatabaseHashMap.methodNames[32], "index: " + returnIndexName + " does not exist");
                        }
                    }
                } else if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                    LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, "DatabaseHashMap", DatabaseHashMap.methodNames[32], "ResultSet is null");
                }
                if (rs == null) break block34;
            }
            catch (Throwable th) {
                block35: {
                    try {
                        LoggingUtil.SESSION_LOGGER_WAS.logp(Level.SEVERE, "DatabaseHashMap", DatabaseHashMap.methodNames[32], "CommonMessage.exception", th);
                        if (rs == null) break block35;
                    }
                    catch (Throwable var20_22) {
                        if (rs != null) {
                            DatabaseHashMap.closeResultSet(rs);
                        }
                        if (ps != null) {
                            DatabaseHashMap.closeStatement(ps);
                        }
                        throw var20_22;
                    }
                    DatabaseHashMap.closeResultSet(rs);
                }
                if (ps != null) {
                    DatabaseHashMap.closeStatement(ps);
                } else {
                    ** GOTO lbl70
                }
            }
            DatabaseHashMap.closeResultSet(rs);
        }
        if (ps != null) {
            DatabaseHashMap.closeStatement(ps);
        }
        if (indexExists_iSeries) {
            block36: {
                try {
                    ps1 = con.prepareStatement(sqlQueryCol);
                    rs1 = ps1.executeQuery();
                    while (rs1.next()) {
                        extractedColumn = rs1.getString(1);
                        if (extractedColumn == null) continue;
                        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                            LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, "DatabaseHashMap", DatabaseHashMap.methodNames[32], "extractedColumn : " + extractedColumn);
                        }
                        if (extractedColumn.indexOf("id".toUpperCase()) == -1 && extractedColumn.indexOf("propid".toUpperCase()) == -1 && extractedColumn.indexOf("appname".toUpperCase()) == -1) continue;
                        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                            LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, "DatabaseHashMap", DatabaseHashMap.methodNames[32], "column is found : " + extractedColumn);
                        }
                        ++counter;
                    }
                    if (counter < 3) {
                        LoggingUtil.SESSION_LOGGER_WAS.logp(Level.WARNING, "DatabaseHashMap", DatabaseHashMap.methodNames[32], "DatabaseHashMap.IndexIncorrect");
                    }
                    if (rs1 == null) break block36;
                }
                catch (Throwable th) {
                    block37: {
                        try {
                            LoggingUtil.SESSION_LOGGER_WAS.logp(Level.SEVERE, "DatabaseHashMap", DatabaseHashMap.methodNames[32], "CommonMessage.exception", th);
                            if (rs1 == null) break block37;
                        }
                        catch (Throwable var21_23) {
                            if (rs1 != null) {
                                DatabaseHashMap.closeResultSet(rs1);
                            }
                            if (ps1 != null) {
                                DatabaseHashMap.closeStatement(ps1);
                            }
                            throw var21_23;
                        }
                        DatabaseHashMap.closeResultSet(rs1);
                    }
                    if (ps1 != null) {
                        DatabaseHashMap.closeStatement(ps1);
                    } else {
                        ** GOTO lbl108
                    }
                }
                DatabaseHashMap.closeResultSet(rs1);
            }
            if (ps1 != null) {
                DatabaseHashMap.closeStatement(ps1);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_WAS.exiting("DatabaseHashMap", DatabaseHashMap.methodNames[32], indexExists_iSeries);
        }
        return indexExists_iSeries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private boolean isTableMarkedVolatile(Connection con) {
        block16: {
            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_WAS.entering("DatabaseHashMap", DatabaseHashMap.methodNames[33]);
            }
            isMarkedVolatile = false;
            tblName = this.tableName;
            qualifierName = null;
            sqlQuery = null;
            ps = null;
            rs = null;
            tblName = tblName.toUpperCase();
            if (this._smc.isUsingCustomSchemaName()) {
                qualifierName = this.qualifierNameWhenCustomSchemaIsSet;
            } else if (this.dbid != null) {
                qualifierName = this.dbid.toUpperCase();
            }
            sqlQuery = "select 1 from syscat.tables where TabName = '" + tblName + "' and Volatile = 'C' ";
            if (qualifierName != null) {
                sqlQuery = sqlQuery + " and tabschema = '" + qualifierName + "'";
            }
            sqlQuery = sqlQuery + " for read only";
            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_WAS.logp(Level.FINE, "DatabaseHashMap", DatabaseHashMap.methodNames[3], "Sql: " + sqlQuery);
            }
            try {
                ps = con.prepareStatement(sqlQuery);
                rs = ps.executeQuery();
                if (rs.next()) {
                    isMarkedVolatile = true;
                }
                if (rs == null) break block16;
            }
            catch (Throwable th) {
                block17: {
                    try {
                        LoggingUtil.SESSION_LOGGER_WAS.logp(Level.SEVERE, "DatabaseHashMap", DatabaseHashMap.methodNames[3], "CommonMessage.exception", th);
                        if (rs == null) break block17;
                    }
                    catch (Throwable var9_9) {
                        if (rs != null) {
                            DatabaseHashMap.closeResultSet(rs);
                        }
                        if (ps != null) {
                            DatabaseHashMap.closeStatement(ps);
                        }
                        throw var9_9;
                    }
                    DatabaseHashMap.closeResultSet(rs);
                }
                if (ps != null) {
                    DatabaseHashMap.closeStatement(ps);
                } else {
                    ** GOTO lbl47
                }
            }
            DatabaseHashMap.closeResultSet(rs);
        }
        if (ps != null) {
            DatabaseHashMap.closeStatement(ps);
        }
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_WAS.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_WAS.exiting("DatabaseHashMap", DatabaseHashMap.methodNames[33], isMarkedVolatile);
        }
        return isMarkedVolatile;
    }
}

