/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.channelfw.utils;

import com.ibm.websphere.channelfw.osgi.CHFWBundle;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class HostNameUtils {
    private static final TraceComponent tc = Tr.register(HostNameUtils.class, (String)"ChannelFramework", (String)"com.ibm.ws.channelfw.internal.resources.ChannelfwMessages");
    public static final String LOCALHOST = "localhost";
    public static final String WILDCARD = "*";
    private static final boolean PREFER_IPV6 = Boolean.getBoolean("java.net.preferIPv6Addresses");
    protected static final int HOSTNAME_LOOKUP_TIMEOUT_WARNING_MS = 5000;

    @Trivial
    public static String tryResolveHostName(String nameToResolve) {
        return HostNameUtils.tryResolveHostName(nameToResolve, PREFER_IPV6);
    }

    public static String tryResolveHostName(final String nameToResolve, final boolean preferIPv6) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Trying to resolve hostname : " + nameToResolve + ", prefer IPv6 : " + preferIPv6), (Object[])new Object[0]);
        }
        PrivilegedAction<String> action = new PrivilegedAction<String>(){

            @Override
            @FFDCIgnore(value={SocketException.class, UnknownHostException.class})
            public String run() {
                InetAddress resultAddr = null;
                if (HostNameUtils.LOCALHOST.equalsIgnoreCase(nameToResolve)) {
                    return HostNameUtils.LOCALHOST;
                }
                if (HostNameUtils.WILDCARD.equals(nameToResolve) || nameToResolve == null || nameToResolve.isEmpty()) {
                    InetAddressResult result;
                    block18: {
                        result = new InetAddressResult(preferIPv6);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Result : " + result), (Object[])new Object[0]);
                            if (result != null) {
                                Tr.debug((TraceComponent)tc, (String)("Address : " + result.getAddress() + ", needs preferred address : " + result.needsPreferredAddr()), (Object[])new Object[0]);
                            }
                        }
                        ArrayList<NetworkInterface> p2p = new ArrayList<NetworkInterface>();
                        try {
                            Enumeration<NetworkInterface> nicEnum = NetworkInterface.getNetworkInterfaces();
                            for (NetworkInterface nic : Collections.list(nicEnum)) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)("NIC : " + nic), (Object[])new Object[0]);
                                    Tr.debug((TraceComponent)tc, (String)("isUp : " + nic.isUp()), (Object[])new Object[0]);
                                    Tr.debug((TraceComponent)tc, (String)("isVirtual : " + nic.isVirtual()), (Object[])new Object[0]);
                                    Tr.debug((TraceComponent)tc, (String)("isLoopback : " + nic.isLoopback()), (Object[])new Object[0]);
                                    Tr.debug((TraceComponent)tc, (String)("isPointToPoint : " + nic.isPointToPoint()), (Object[])new Object[0]);
                                }
                                Enumeration<InetAddress> addrs = nic.getInetAddresses();
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    for (InetAddress addr : Collections.list(addrs)) {
                                        Tr.debug((TraceComponent)tc, (String)("Address : " + addr + ", isLinkLocal : " + addr.isLinkLocalAddress()), (Object[])new Object[0]);
                                    }
                                }
                                if (!nic.isUp() || nic.isVirtual() || nic.isLoopback()) continue;
                                if (nic.isPointToPoint()) {
                                    p2p.add(nic);
                                    continue;
                                }
                                if (!this.findPreferredAddress(nic, result, preferIPv6)) continue;
                                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break;
                                Tr.debug((TraceComponent)tc, (String)"Found preferred address", (Object[])new Object[0]);
                                break;
                            }
                            if (!result.needsPreferredAddr() || p2p.isEmpty()) break block18;
                            for (NetworkInterface nic : p2p) {
                                if (!this.findPreferredAddress(nic, result, preferIPv6)) continue;
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"Found preferred address in point to point list", (Object[])new Object[0]);
                                }
                                break;
                            }
                        }
                        catch (SocketException e) {
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block18;
                            Tr.debug((TraceComponent)tc, (String)("Exception while finding preferred address : " + e), (Object[])new Object[0]);
                        }
                    }
                    resultAddr = result.getAddress();
                } else {
                    resultAddr = HostNameUtils.findLocalHostAddress(nameToResolve, preferIPv6);
                }
                if (resultAddr != null) {
                    String hostAddr = resultAddr.getHostAddress();
                    String hostName = resultAddr.getCanonicalHostName().toLowerCase();
                    if (resultAddr instanceof Inet6Address && hostName.contains(":") && !hostName.startsWith("[")) {
                        hostName = "[" + hostAddr + "]";
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("tryResolveHostName returning : " + hostName), (Object[])new Object[0]);
                    }
                    return hostName;
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"tryResolveHostName returning null", (Object[])new Object[0]);
                }
                return null;
            }

            private boolean findPreferredAddress(NetworkInterface nic, InetAddressResult result, boolean preferIPv62) {
                Enumeration<InetAddress> addrs = nic.getInetAddresses();
                for (InetAddress addr : Collections.list(addrs)) {
                    if (addr.isLinkLocalAddress() || !result.setAddressIsPreferred(addr)) continue;
                    return true;
                }
                return false;
            }
        };
        return HostNameUtils.doPrivilegedWithTimeoutWarning(action);
    }

    @Trivial
    public static boolean validLocalHostName(String hostName) {
        InetAddress addr = HostNameUtils.findLocalHostAddress(hostName, PREFER_IPV6);
        return addr != null;
    }

    @Trivial
    public static boolean validLocalHostName(String hostName, boolean preferIPv6) {
        InetAddress addr = HostNameUtils.findLocalHostAddress(hostName, preferIPv6);
        return addr != null;
    }

    private static InetAddress findLocalHostAddress(final String nameToResolve, final boolean preferIPv6) {
        PrivilegedAction<InetAddress> action = new PrivilegedAction<InetAddress>(){

            @Override
            @FFDCIgnore(value={SocketException.class, UnknownHostException.class})
            public InetAddress run() {
                InetAddressResult result = new InetAddressResult(preferIPv6);
                try {
                    InetAddress[] addrs = InetAddress.getAllByName(nameToResolve);
                    if (addrs != null) {
                        for (InetAddress addr : addrs) {
                            NetworkInterface nic;
                            if (addr.isLoopbackAddress() ? result.setAddressIsPreferred(addr) : (nic = NetworkInterface.getByInetAddress(addr)) != null && result.setAddressIsPreferred(addr)) break;
                        }
                    }
                }
                catch (SocketException socketException) {
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
                return result.getAddress();
            }
        };
        return HostNameUtils.doPrivilegedWithTimeoutWarning(action);
    }

    protected static <T> T doPrivilegedWithTimeoutWarning(final PrivilegedAction<T> runnable) {
        Callable doPrivCall = new Callable<T>(){

            @Override
            public T call() throws Exception {
                return AccessController.doPrivileged(runnable);
            }
        };
        ExecutorService e = CHFWBundle.getExecutorService();
        if (e != null && !e.isShutdown()) {
            Future future = e.submit(doPrivCall);
            T response = null;
            do {
                try {
                    response = future.get(5000L, TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException tex) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)"hostname lookup has taken longer than 5000 ms - something might be wrong with the network configuration. Continuing to wait.", (Object[])new Object[0]);
                }
                catch (InterruptedException iex) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("hostname lookup task was interrupted: " + iex), (Object[])new Object[0]);
                }
                catch (ExecutionException eex) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break;
                    Tr.debug((TraceComponent)tc, (String)("hostname lookup task was aborted: " + eex), (Object[])new Object[0]);
                    break;
                }
            } while (response == null && !future.isDone());
            return response;
        }
        try {
            return (T)doPrivCall.call();
        }
        catch (Exception ex) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("hostname runnable invocation failed: " + ex), (Object[])new Object[0]);
            }
            return null;
        }
    }

    private static class InetAddressResult {
        final boolean preferIPv6;
        InetAddress preferred;
        InetAddress fallback;

        InetAddressResult(boolean preferIPv6) {
            this.preferIPv6 = preferIPv6;
        }

        boolean needsPreferredAddr() {
            return this.preferred == null;
        }

        boolean setAddressIsPreferred(InetAddress addr) {
            if (this.preferIPv6) {
                if (addr instanceof Inet6Address) {
                    this.preferred = addr;
                    return true;
                }
                this.fallback = addr;
            } else {
                if (addr instanceof Inet4Address) {
                    this.preferred = addr;
                    return true;
                }
                this.fallback = addr;
            }
            return false;
        }

        InetAddress getAddress() {
            if (this.preferred != null) {
                return this.preferred;
            }
            return this.fallback;
        }
    }
}

