/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.annocache.classsource.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.annocache.classsource.internal.ClassSourceImpl;
import com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Factory;
import com.ibm.ws.annocache.jandex.internal.Jandex_Utils;
import com.ibm.ws.annocache.jandex.internal.SparseIndex;
import com.ibm.ws.annocache.util.internal.UtilImpl_FileStamp;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.Entry;
import com.ibm.wsspi.adaptable.module.FastModeControl;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.anno.classsource.ClassSource;
import com.ibm.wsspi.anno.classsource.ClassSource_Aggregate;
import com.ibm.wsspi.anno.classsource.ClassSource_ScanCounts;
import com.ibm.wsspi.annocache.classsource.ClassSource_Exception;
import com.ibm.wsspi.annocache.classsource.ClassSource_MappedContainer;
import com.ibm.wsspi.annocache.classsource.ClassSource_Streamer;
import com.ibm.wsspi.annocache.util.Util_InternMap;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.osgi.service.urlconversion.URLConverter;
import org.jboss.jandex.Index;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ClassSourceImpl_MappedContainer
extends ClassSourceImpl
implements ClassSource_MappedContainer {
    public static final String CLASS_NAME;
    protected final Container rootContainer;
    protected final Container container;
    private final URLConverter bundleEntryUrlConverter;
    public static final String EMPTY_PREFIX = "";
    static final long serialVersionUID = -1262937309237270978L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public ClassSourceImpl_MappedContainer(ClassSourceImpl_Factory factory, Util_InternMap internMap, String name, Container container, URLConverter bundleEntryUrlConverter) throws ClassSource_Exception {
        this(factory, internMap, name, container, NO_ENTRY_PREFIX, bundleEntryUrlConverter);
    }

    public ClassSourceImpl_MappedContainer(ClassSourceImpl_Factory factory, Util_InternMap internMap, String name, Container container, String entryPrefix, URLConverter bundleEntryUrlConverter) throws ClassSource_Exception {
        super(factory, internMap, entryPrefix, name, String.valueOf(container));
        this.bundleEntryUrlConverter = bundleEntryUrlConverter;
        this.rootContainer = container;
        this.container = this.navigateFrom(container, entryPrefix);
    }

    private Container navigateFrom(Container useContainer, String prefix) {
        String methodName = "navigateFrom";
        if (prefix == null) {
            return useContainer;
        }
        Entry prefixEntry = useContainer.getEntry(prefix);
        if (prefixEntry == null) {
            return null;
        }
        try {
            return (Container)prefixEntry.adapt(Container.class);
        }
        catch (UnableToAdaptException unableToAdaptException) {
            FFDCFilter.processException((Throwable)unableToAdaptException, (String)"com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_MappedContainer", (String)"90", (Object)this, (Object[])new Object[]{useContainer, prefix});
            logger.logp(Level.WARNING, CLASS_NAME, methodName, "ANNO_CLASSSOURCE_ADAPT_EXCEPTION", new Object[]{this.getHashText(), prefixEntry.getName(), prefixEntry, useContainer, prefix});
            return null;
        }
    }

    @Override
    @Trivial
    @FFDCIgnore(value={UnableToAdaptException.class})
    public void open() throws ClassSource_Exception {
        String methodName = "open";
        try {
            FastModeControl fastMode = (FastModeControl)this.getContainer().adapt(FastModeControl.class);
            fastMode.useFastMode();
        }
        catch (UnableToAdaptException e) {
            String eMsg = "[ " + this.getHashText() + " ] Failed to adapt [ " + this.getCanonicalName() + " ] to [ " + FastModeControl.class.getName() + " ]";
            throw this.getFactory().wrapIntoClassSourceException(CLASS_NAME, methodName, eMsg, e);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] ENTER/RETURN", this.getHashText());
        }
    }

    @Override
    @Trivial
    @FFDCIgnore(value={UnableToAdaptException.class})
    public void close() throws ClassSource_Exception {
        String methodName = "close";
        try {
            FastModeControl fastMode = (FastModeControl)this.getContainer().adapt(FastModeControl.class);
            fastMode.stopUsingFastMode();
        }
        catch (UnableToAdaptException e) {
            String eMsg = "[ " + this.getHashText() + " ] Failed to close [ " + this.getCanonicalName() + " ] to [ " + FastModeControl.class.getName() + " ]";
            throw this.getFactory().wrapIntoClassSourceException(CLASS_NAME, methodName, eMsg, e);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] ENTER/RETURN", this.getHashText());
        }
    }

    @Trivial
    public Container getRootContainer() {
        return this.rootContainer;
    }

    @Override
    @Trivial
    public Container getContainer() {
        return this.container;
    }

    @Override
    public int processFromScratch(ClassSource_Streamer streamer) throws ClassSource_Exception {
        Container useContainer = this.getContainer();
        if (useContainer != null) {
            return this.processContainer(EMPTY_PREFIX, useContainer, streamer);
        }
        return 0;
    }

    @Override
    protected String computeStamp() {
        String methodName = "computeStamp";
        Container useRootContainer = this.getRootContainer();
        String useStamp = UtilImpl_FileStamp.computeStamp(this.bundleEntryUrlConverter, useRootContainer);
        if (useStamp == null) {
            useStamp = "** UNAVAILABLE **";
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, MessageFormat.format("[ {0} ] Container [ {1} ] Stamp [ {2} ]", this.getHashText(), useRootContainer, useStamp));
        }
        return useStamp;
    }

    /*
     * WARNING - void declaration
     */
    @Trivial
    protected int processContainer(String prefix, Container targetContainer, ClassSource_Streamer streamer) throws ClassSource_Exception {
        String methodName = "processContainer";
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] ENTER [ {1} ] of [ {2} ]", new Object[]{this.getHashText(), prefix, targetContainer.getName()});
        }
        int classCount = 0;
        int initialResources = this.getInternMap().getSize();
        for (Entry nextEntry : targetContainer) {
            Container nextChildContainer;
            String nextChildName = nextEntry.getName();
            String nextPrefix = this.resourceAppend(prefix, nextChildName);
            try {
                nextChildContainer = (Container)nextEntry.adapt(Container.class);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_MappedContainer", (String)"247", (Object)this, (Object[])new Object[]{prefix, targetContainer, streamer});
                nextChildContainer = null;
                logger.logp(Level.WARNING, CLASS_NAME, methodName, "ANNO_CLASSSOURCE_ADAPT_EXCEPTION", new Object[]{this.getHashText(), nextChildName, nextEntry, targetContainer, prefix});
            }
            if (nextChildContainer != null) {
                if (nextChildContainer.isRoot()) continue;
                classCount += this.processContainer(nextPrefix, nextChildContainer, streamer);
                continue;
            }
            if (!this.isClassResource(nextPrefix)) continue;
            String nextClassName = this.getClassNameFromResourceName(nextPrefix);
            if (ClassSourceImpl.isJava9PackageName(nextClassName)) {
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Java9 class name [ {1} ]", new Object[]{this.getHashText(), nextClassName});
                continue;
            }
            String i_nextClassName = this.internClassName(nextClassName);
            try {
                boolean bl = this.processEntry(streamer, i_nextClassName, nextPrefix, nextEntry);
            }
            catch (ClassSource_Exception classSource_Exception) {
                void e;
                FFDCFilter.processException((Throwable)classSource_Exception, (String)"com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_MappedContainer", (String)"315", (Object)this, (Object[])new Object[]{prefix, targetContainer, streamer});
                logger.logp(Level.WARNING, CLASS_NAME, methodName, "ANNO_TARGETS_SCAN_EXCEPTION", new Object[]{nextClassName, targetContainer, nextPrefix, e});
            }
            ++classCount;
        }
        int finalResources = this.getInternMap().getSize();
        if (logger.isLoggable(Level.FINER)) {
            Object[] logParms = new Object[]{this.getHashText(), null, null};
            logParms[1] = finalResources - initialResources;
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] RETURN [ {1} ] Added classes", logParms);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] RETURN [ {1} ]", new Object[]{this.getHashText(), classCount});
        }
        return classCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean processEntry(ClassSource_Streamer streamer, String i_className, String resourceName, Entry entry) throws ClassSource_Exception {
        if (streamer == null) {
            return true;
        }
        if (!streamer.doProcess(i_className)) {
            return false;
        }
        InputStream inputStream = this.openResourceStream(i_className, resourceName, this.getContainer(), entry);
        try {
            streamer.process(i_className, inputStream);
        }
        finally {
            this.closeResourceStream(i_className, resourceName, entry, inputStream);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Trivial
    public void processSpecific(ClassSource_Streamer streamer, Set<String> i_classNames) throws ClassSource_Exception {
        Container useContainer;
        String methodName = "processSpecific";
        boolean doLog = logger.isLoggable(Level.FINER);
        if (doLog) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] [ {1} ]", new Object[]{this.getHashText(), i_classNames.size()});
        }
        if ((useContainer = this.getContainer()) == null) {
            if (doLog) {
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] RETURN", this.getHashText());
            }
            return;
        }
        long scanStart = System.nanoTime();
        for (String i_className : i_classNames) {
            Entry nextEntry;
            String resourceName = this.getResourceNameFromClassName(i_className);
            try {
                nextEntry = useContainer.getEntry(resourceName);
            }
            catch (Throwable throwable) {
                void th;
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_MappedContainer", (String)"396", (Object)this, (Object[])new Object[]{streamer, i_classNames});
                nextEntry = null;
                logger.logp(Level.WARNING, CLASS_NAME, methodName, "ANNO_TARGETS_SCAN_EXCEPTION", (Throwable)th);
            }
            if (nextEntry == null) {
                if (!doLog) continue;
                logger.logp(Level.FINER, CLASS_NAME, methodName, "Skip [ {0} ] as [ {1} ]", new Object[]{i_className, resourceName});
                continue;
            }
            try {
                this.processEntry(streamer, i_className, resourceName, nextEntry);
            }
            catch (ClassSource_Exception th) {
                void e;
                FFDCFilter.processException((Throwable)th, (String)"com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_MappedContainer", (String)"413", (Object)this, (Object[])new Object[]{streamer, i_classNames});
                logger.logp(Level.WARNING, CLASS_NAME, methodName, "ANNO_TARGETS_SCAN_EXCEPTION", (Throwable)e);
            }
        }
        long scanTime = System.nanoTime() - scanStart;
        this.setProcessTime(scanTime);
        this.setProcessCount(i_classNames.size());
        if (doLog) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] RETURN", this.getHashText());
        }
    }

    @Override
    protected boolean basicHasJandexIndex() {
        return this.getRootContainer().getEntry(this.getJandexIndexPath()) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Trivial
    protected Index basicGetJandexIndex() {
        InputStream jandexStream;
        String methodName = "basicGetJandexIndex";
        String useJandexIndexPath = this.getJandexIndexPath();
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Looking for JANDEX [ {1} ] in [ {2} ]", new Object[]{this.getHashText(), useJandexIndexPath, this.getContainer().getPhysicalPath()});
        }
        try {
            jandexStream = this.openRootResourceStream(null, useJandexIndexPath, 32768);
        }
        catch (ClassSource_Exception classSource_Exception) {
            FFDCFilter.processException((Throwable)classSource_Exception, (String)"com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_MappedContainer", (String)"453", (Object)this, (Object[])new Object[0]);
            logger.logp(Level.WARNING, CLASS_NAME, methodName, "JANDEX_INDEX_OPEN_EXCEPTION", new Object[]{useJandexIndexPath, this.getCanonicalName()});
            return null;
        }
        if (jandexStream == null) {
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] No JANDEX index was found", this.getHashText());
            }
            return null;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Located JANDEX index", this.getHashText());
        }
        try {
            Index jandexIndex = Jandex_Utils.basicReadIndex(jandexStream);
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Read JANDEX index [ {1} ] from [ {2} ]: Classes [ {3} ]", new Object[]{this.getHashText(), useJandexIndexPath, this.getCanonicalName(), Integer.toString(jandexIndex.getKnownClasses().size())});
            }
            Index index = jandexIndex;
            return index;
        }
        catch (Throwable jandexIndex) {
            FFDCFilter.processException((Throwable)jandexIndex, (String)"com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_MappedContainer", (String)"484", (Object)this, (Object[])new Object[0]);
            logger.logp(Level.WARNING, CLASS_NAME, methodName, "JANDEX_INDEX_READ_EXCEPTION", new Object[]{useJandexIndexPath, this.getCanonicalName()});
            Index index = null;
            return index;
        }
        finally {
            this.closeRootResourceStream(null, useJandexIndexPath, jandexStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected SparseIndex basicGetSparseJandexIndex() {
        InputStream jandexStream;
        String methodName = "basicGetSparseJandexIndex";
        String useJandexIndexPath = this.getJandexIndexPath();
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Looking for JANDEX [ {1} ] in [ {2} ]", new Object[]{this.getHashText(), useJandexIndexPath, this.getRootContainer().getPhysicalPath()});
        }
        try {
            jandexStream = this.openRootResourceStream(null, useJandexIndexPath, 32768);
        }
        catch (ClassSource_Exception classSource_Exception) {
            FFDCFilter.processException((Throwable)classSource_Exception, (String)"com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_MappedContainer", (String)"510", (Object)this, (Object[])new Object[0]);
            logger.logp(Level.WARNING, CLASS_NAME, methodName, "JANDEX_INDEX_READ_EXCEPTION", new Object[]{useJandexIndexPath, this.getCanonicalName()});
            return null;
        }
        if (jandexStream == null) {
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] No JANDEX index was found", this.getHashText());
            }
            return null;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Located JANDEX index", this.getHashText());
        }
        try {
            SparseIndex jandexIndex = Jandex_Utils.basicReadSparseIndex(jandexStream);
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Read JANDEX index [ {1} ] from [ {2} ]: Classes [ {3} ]", new Object[]{this.getHashText(), useJandexIndexPath, this.getCanonicalName(), Integer.toString(jandexIndex.getKnownClasses().size())});
            }
            SparseIndex sparseIndex = jandexIndex;
            return sparseIndex;
        }
        catch (Throwable jandexIndex) {
            FFDCFilter.processException((Throwable)jandexIndex, (String)"com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_MappedContainer", (String)"540", (Object)this, (Object[])new Object[0]);
            logger.logp(Level.WARNING, CLASS_NAME, methodName, "JANDEX_INDEX_READ_EXCEPTION", new Object[]{useJandexIndexPath, this.getCanonicalName()});
            SparseIndex sparseIndex = null;
            return sparseIndex;
        }
        finally {
            this.closeRootResourceStream(null, useJandexIndexPath, jandexStream);
        }
    }

    public InputStream openRootResourceStream(String className, String resourceName, int bufferSize) throws ClassSource_Exception {
        InputStream inputStream = this.openRootResourceStream(className, resourceName);
        return inputStream == null ? null : new BufferedInputStream(inputStream, bufferSize);
    }

    public InputStream openRootResourceStream(String className, String resourceName) throws ClassSource_Exception {
        Container useContainer = this.getRootContainer();
        Entry entry = useContainer.getEntry(resourceName);
        if (entry == null) {
            return null;
        }
        return this.openResourceStream(className, resourceName, useContainer, entry);
    }

    @Override
    public InputStream openResourceStream(String className, String resourceName) throws ClassSource_Exception {
        Container useContainer = this.getContainer();
        if (useContainer == null) {
            return null;
        }
        Entry entry = useContainer.getEntry(resourceName);
        if (entry == null) {
            return null;
        }
        return this.openResourceStream(className, resourceName, useContainer, entry);
    }

    /*
     * WARNING - void declaration
     */
    public InputStream openResourceStream(String className, String resourceName, Container useContainer, Entry entry) throws ClassSource_Exception {
        InputStream result;
        String methodName = "openResourceStream";
        try {
            result = (InputStream)entry.adapt(InputStream.class);
        }
        catch (Throwable throwable) {
            void th;
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_MappedContainer", (String)"604", (Object)this, (Object[])new Object[]{className, resourceName, useContainer, entry});
            String eMsg = "[ " + this.getHashText() + " ] Failed to open [ " + resourceName + " ] as [ " + entry + " ] under [ " + useContainer + " ]";
            if (className != null) {
                eMsg = eMsg + " for class [ " + className + " ]";
            }
            throw this.getFactory().wrapIntoClassSourceException(CLASS_NAME, methodName, eMsg, (Throwable)th);
        }
        if (result == null) {
            String eMsg = "[ " + this.getHashText() + " ] Failed to open [ " + resourceName + " ] as [ " + entry + " ] under [ " + useContainer + " ]";
            if (className != null) {
                eMsg = eMsg + " for class [ " + className + " ]";
            }
            throw this.getFactory().newClassSourceException(eMsg);
        }
        return result;
    }

    @Override
    public void closeResourceStream(String className, String resourceName, InputStream inputStream) {
        String methodName = "closeResourceStream";
        Entry entry = this.getContainer().getEntry(resourceName);
        if (entry == null) {
            logger.logp(Level.WARNING, CLASS_NAME, methodName, "ANNO_CLASSSOURCE_RESOURCE_NOTFOUND", new Object[]{this.getHashText(), resourceName, this.getRootContainer(), className});
        } else {
            this.closeResourceStream(className, resourceName, entry, inputStream);
        }
    }

    protected void closeResourceStream(String className, String resourceName, Entry entry, InputStream inputStream) {
        String methodName = "closeResourceStream";
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_MappedContainer", (String)"669", (Object)this, (Object[])new Object[]{className, resourceName, entry, inputStream});
            String eMsg = "[ " + this.getHashText() + " ] Failed to close [ " + resourceName + " ] in [ " + this.getCanonicalName() + " ]";
            if (className != null) {
                eMsg = eMsg + " for class [ " + className + " ]";
            }
            logger.logp(Level.WARNING, CLASS_NAME, methodName, eMsg);
        }
    }

    public void closeRootResourceStream(String className, String resourceName, InputStream inputStream) {
        String methodName = "closeResourceStream";
        Entry entry = this.getRootContainer().getEntry(resourceName);
        if (entry == null) {
            logger.logp(Level.WARNING, CLASS_NAME, methodName, "ANNO_CLASSSOURCE_RESOURCE_NOTFOUND", new Object[]{this.getHashText(), resourceName, this.getRootContainer(), className});
        } else {
            this.closeResourceStream(className, resourceName, entry, inputStream);
        }
    }

    @Override
    @Trivial
    public void log(Logger useLogger) {
        String methodName = "log";
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "Class Source [ {0} ]", this.getHashText());
    }

    @Override
    @Trivial
    public void log(TraceComponent tc) {
        Tr.debug((TraceComponent)tc, (String)MessageFormat.format("Class Source [ {0} ]", this.getHashText()), (Object[])new Object[0]);
    }

    @Override
    public void setParentSource(ClassSource classSource) {
    }

    @Override
    public void scanClasses(com.ibm.wsspi.anno.classsource.ClassSource_Streamer streamer, Set<String> i_seedClassNamesSet, ClassSource_Aggregate.ScanPolicy scanPolicy) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean scanSpecificSeedClass(String specificClassName, com.ibm.wsspi.anno.classsource.ClassSource_Streamer streamer) throws com.ibm.wsspi.anno.classsource.ClassSource_Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean scanReferencedClass(String referencedClassNam, com.ibm.wsspi.anno.classsource.ClassSource_Streamer streamer) throws com.ibm.wsspi.anno.classsource.ClassSource_Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean getConvertResourceNames() {
        return false;
    }

    @Override
    public String inconvertResourceName(String externalResourceName) {
        return null;
    }

    @Override
    public String outconvertResourceName(String internalResourceName) {
        return null;
    }

    @Override
    public InputStream openClassStream(String className) throws com.ibm.wsspi.anno.classsource.ClassSource_Exception {
        return null;
    }

    @Override
    public void closeClassStream(String className, InputStream inputStream) throws com.ibm.wsspi.anno.classsource.ClassSource_Exception {
    }

    @Override
    public ClassSource_ScanCounts getScanResults() {
        return null;
    }

    @Override
    public int getResult(ClassSource_ScanCounts.ResultField resultField) {
        return 0;
    }

    @Override
    public int getResourceExclusionCount() {
        return 0;
    }

    @Override
    public int getClassExclusionCount() {
        return 0;
    }

    @Override
    public int getClassInclusionCount() {
        return 0;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_MappedContainer", ClassSourceImpl_MappedContainer.class, (String)"com.ibm.ws.annocache", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
        CLASS_NAME = ClassSourceImpl_MappedContainer.class.getSimpleName();
    }
}

