/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.annocache.classsource.specification.internal;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Aggregate;
import com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_ClassLoader;
import com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_Factory;
import com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_MappedDirectory;
import com.ibm.ws.annocache.classsource.internal.ClassSourceImpl_MappedJar;
import com.ibm.ws.annocache.classsource.specification.ClassSource_Specification;
import com.ibm.ws.annocache.service.internal.AnnotationCacheServiceImpl_Logging;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.annocache.classsource.ClassSource_Aggregate;
import com.ibm.wsspi.annocache.classsource.ClassSource_Exception;
import com.ibm.wsspi.annocache.classsource.ClassSource_Options;
import java.util.logging.Level;
import java.util.logging.Logger;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public abstract class ClassSourceImpl_Specification
implements ClassSource_Specification {
    protected static final Logger logger = AnnotationCacheServiceImpl_Logging.ANNO_LOGGER;
    public static final String CLASS_NAME = ClassSourceImpl_Specification.class.getSimpleName();
    protected String hashText;
    protected ClassSourceImpl_Factory factory;
    protected final String appName;
    protected final String modName;
    protected final String modCatName;
    private ClassLoader rootClassLoader;
    static final long serialVersionUID = 9076880508057455758L;

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getHashText() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.classsource.specification.internal.ClassSourceImpl_Specification", "getHashText", new Object[0]);
        }
        String string = this.hashText;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.annocache.classsource.specification.internal.ClassSourceImpl_Specification", "getHashText", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ClassSourceImpl_Specification(ClassSourceImpl_Factory factory, String appName, String modName, String modCatName) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.classsource.specification.internal.ClassSourceImpl_Specification", "<init>", new Object[]{factory, appName, modName, modCatName});
        }
        String methodName = "<init>";
        this.hashText = this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode());
        this.factory = factory;
        this.appName = appName;
        this.modName = modName;
        this.modCatName = modCatName;
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, this.hashText);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.classsource.specification.internal.ClassSourceImpl_Specification", "<init>", this);
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ClassSourceImpl_Factory getFactory() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.classsource.specification.internal.ClassSourceImpl_Specification", "getFactory", new Object[0]);
        }
        ClassSourceImpl_Factory classSourceImpl_Factory = this.factory;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            classSourceImpl_Factory = classSourceImpl_Factory;
            logger.exiting("com.ibm.ws.annocache.classsource.specification.internal.ClassSourceImpl_Specification", "getFactory", classSourceImpl_Factory);
        }
        return classSourceImpl_Factory;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getAppName() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.classsource.specification.internal.ClassSourceImpl_Specification", "getAppName", new Object[0]);
        }
        String string = this.appName;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.annocache.classsource.specification.internal.ClassSourceImpl_Specification", "getAppName", string);
        }
        return string;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getModName() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.classsource.specification.internal.ClassSourceImpl_Specification", "getModName", new Object[0]);
        }
        String string = this.modName;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.annocache.classsource.specification.internal.ClassSourceImpl_Specification", "getModName", string);
        }
        return string;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getModCategoryName() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.classsource.specification.internal.ClassSourceImpl_Specification", "getModCategoryName", new Object[0]);
        }
        String string = this.modCatName;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.annocache.classsource.specification.internal.ClassSourceImpl_Specification", "getModCategoryName", string);
        }
        return string;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ClassLoader getRootClassLoader() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.classsource.specification.internal.ClassSourceImpl_Specification", "getRootClassLoader", new Object[0]);
        }
        ClassLoader classLoader = this.rootClassLoader;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            classLoader = classLoader;
            logger.exiting("com.ibm.ws.annocache.classsource.specification.internal.ClassSourceImpl_Specification", "getRootClassLoader", classLoader);
        }
        return classLoader;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setRootClassLoader(ClassLoader rootClassLoader) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.classsource.specification.internal.ClassSourceImpl_Specification", "setRootClassLoader", new Object[]{rootClassLoader});
        }
        this.rootClassLoader = rootClassLoader;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.classsource.specification.internal.ClassSourceImpl_Specification", "setRootClassLoader");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ClassSourceImpl_Aggregate createRootClassSource(ClassSource_Options classSourceOptions) throws ClassSource_Exception {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.classsource.specification.internal.ClassSourceImpl_Specification", "createRootClassSource", new Object[]{classSourceOptions});
        }
        ClassSourceImpl_Aggregate rootClassSource = this.createEmptyRootClassSource(classSourceOptions);
        this.addInternalClassSources(rootClassSource);
        this.addExternalClassSources(rootClassSource);
        this.addClassLoaderClassSource(rootClassSource);
        ClassSourceImpl_Aggregate classSourceImpl_Aggregate = rootClassSource;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            classSourceImpl_Aggregate = classSourceImpl_Aggregate;
            logger.exiting("com.ibm.ws.annocache.classsource.specification.internal.ClassSourceImpl_Specification", "createRootClassSource", classSourceImpl_Aggregate);
        }
        return classSourceImpl_Aggregate;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ClassSourceImpl_Aggregate createEmptyRootClassSource(ClassSource_Options classSourceOptions) throws ClassSource_Exception {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.classsource.specification.internal.ClassSourceImpl_Specification", "createEmptyRootClassSource", new Object[]{classSourceOptions});
        }
        ClassSourceImpl_Aggregate classSourceImpl_Aggregate = this.getFactory().createAggregateClassSource(this.getAppName(), this.getModName(), this.getModCategoryName(), classSourceOptions);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            classSourceImpl_Aggregate = classSourceImpl_Aggregate;
            logger.exiting("com.ibm.ws.annocache.classsource.specification.internal.ClassSourceImpl_Specification", "createEmptyRootClassSource", classSourceImpl_Aggregate);
        }
        return classSourceImpl_Aggregate;
    }

    @Override
    public abstract void addInternalClassSources(ClassSource_Aggregate var1) throws ClassSource_Exception;

    @Override
    public abstract void addExternalClassSources(ClassSource_Aggregate var1) throws ClassSource_Exception;

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void addClassLoaderClassSource(ClassSource_Aggregate rootClassSource) throws ClassSource_Exception {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.classsource.specification.internal.ClassSourceImpl_Specification", "addClassLoaderClassSource", new Object[]{rootClassSource});
        }
        ClassLoader useRootClassLoader = this.getRootClassLoader();
        if (useRootClassLoader != null) {
            ClassSourceImpl_ClassLoader classSourceImpl_ClassLoader = this.addClassLoaderClassSource(rootClassSource, "classloader", useRootClassLoader);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.classsource.specification.internal.ClassSourceImpl_Specification", "addClassLoaderClassSource");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ClassSourceImpl_MappedJar addJarClassSource(ClassSource_Aggregate rootClassSource, String name, String jarPath, String entryPrefix, ClassSource_Aggregate.ScanPolicy scanPolicy) throws ClassSource_Exception {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.classsource.specification.internal.ClassSourceImpl_Specification", "addJarClassSource", new Object[]{rootClassSource, name, jarPath, entryPrefix, scanPolicy});
        }
        ClassSourceImpl_MappedJar jarClassSource = this.getFactory().createJarClassSource(rootClassSource, name, jarPath, entryPrefix);
        rootClassSource.addClassSource(jarClassSource, scanPolicy);
        ClassSourceImpl_MappedJar classSourceImpl_MappedJar = jarClassSource;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            classSourceImpl_MappedJar = classSourceImpl_MappedJar;
            logger.exiting("com.ibm.ws.annocache.classsource.specification.internal.ClassSourceImpl_Specification", "addJarClassSource", classSourceImpl_MappedJar);
        }
        return classSourceImpl_MappedJar;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ClassSourceImpl_MappedJar addJarClassSource(ClassSource_Aggregate rootClassSource, String name, String jarPath, ClassSource_Aggregate.ScanPolicy scanPolicy) throws ClassSource_Exception {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.classsource.specification.internal.ClassSourceImpl_Specification", "addJarClassSource", new Object[]{rootClassSource, name, jarPath, scanPolicy});
        }
        ClassSourceImpl_MappedJar jarClassSource = this.getFactory().createJarClassSource(rootClassSource, name, jarPath);
        rootClassSource.addClassSource(jarClassSource, scanPolicy);
        ClassSourceImpl_MappedJar classSourceImpl_MappedJar = jarClassSource;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            classSourceImpl_MappedJar = classSourceImpl_MappedJar;
            logger.exiting("com.ibm.ws.annocache.classsource.specification.internal.ClassSourceImpl_Specification", "addJarClassSource", classSourceImpl_MappedJar);
        }
        return classSourceImpl_MappedJar;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ClassSourceImpl_MappedDirectory addDirectoryClassSource(ClassSource_Aggregate rootClassSource, String name, String dirPath, String entryPrefix, ClassSource_Aggregate.ScanPolicy scanPolicy) throws ClassSource_Exception {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.classsource.specification.internal.ClassSourceImpl_Specification", "addDirectoryClassSource", new Object[]{rootClassSource, name, dirPath, entryPrefix, scanPolicy});
        }
        ClassSourceImpl_MappedDirectory dirClassSource = this.getFactory().createDirectoryClassSource(rootClassSource, name, dirPath, entryPrefix);
        rootClassSource.addClassSource(dirClassSource, scanPolicy);
        ClassSourceImpl_MappedDirectory classSourceImpl_MappedDirectory = dirClassSource;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            classSourceImpl_MappedDirectory = classSourceImpl_MappedDirectory;
            logger.exiting("com.ibm.ws.annocache.classsource.specification.internal.ClassSourceImpl_Specification", "addDirectoryClassSource", classSourceImpl_MappedDirectory);
        }
        return classSourceImpl_MappedDirectory;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ClassSourceImpl_MappedDirectory addDirectoryClassSource(ClassSource_Aggregate rootClassSource, String name, String dirPath, ClassSource_Aggregate.ScanPolicy scanPolicy) throws ClassSource_Exception {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.classsource.specification.internal.ClassSourceImpl_Specification", "addDirectoryClassSource", new Object[]{rootClassSource, name, dirPath, scanPolicy});
        }
        ClassSourceImpl_MappedDirectory dirClassSource = this.getFactory().createDirectoryClassSource(rootClassSource, name, dirPath);
        rootClassSource.addClassSource(dirClassSource, scanPolicy);
        ClassSourceImpl_MappedDirectory classSourceImpl_MappedDirectory = dirClassSource;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            classSourceImpl_MappedDirectory = classSourceImpl_MappedDirectory;
            logger.exiting("com.ibm.ws.annocache.classsource.specification.internal.ClassSourceImpl_Specification", "addDirectoryClassSource", classSourceImpl_MappedDirectory);
        }
        return classSourceImpl_MappedDirectory;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ClassSourceImpl_ClassLoader addClassLoaderClassSource(ClassSource_Aggregate rootClassSource, String name, ClassLoader classLoader) throws ClassSource_Exception {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.classsource.specification.internal.ClassSourceImpl_Specification", "addClassLoaderClassSource", new Object[]{rootClassSource, name, classLoader});
        }
        ClassSourceImpl_ClassLoader classLoaderClassSource = this.getFactory().createClassLoaderClassSource(rootClassSource, name, classLoader);
        rootClassSource.addClassSource(classLoaderClassSource, ClassSource_Aggregate.ScanPolicy.EXTERNAL);
        ClassSourceImpl_ClassLoader classSourceImpl_ClassLoader = classLoaderClassSource;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            classSourceImpl_ClassLoader = classSourceImpl_ClassLoader;
            logger.exiting("com.ibm.ws.annocache.classsource.specification.internal.ClassSourceImpl_Specification", "addClassLoaderClassSource", classSourceImpl_ClassLoader);
        }
        return classSourceImpl_ClassLoader;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void log(Logger useLogger) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.classsource.specification.internal.ClassSourceImpl_Specification", "log", new Object[]{useLogger});
        }
        this.logHeader(useLogger);
        this.logInternal(useLogger);
        this.logExternal(useLogger);
        this.logClassLoader(useLogger);
        this.logTrailer(useLogger);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.classsource.specification.internal.ClassSourceImpl_Specification", "log");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void logHeader(Logger useLogger) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.classsource.specification.internal.ClassSourceImpl_Specification", "logHeader", new Object[]{useLogger});
        }
        String methodName = "logHeader";
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "Specification [ " + this.getClass().getName() + " ]");
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "  Application Name [ " + this.getAppName() + " ]");
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "  Module Name [ " + this.getModName() + " ]");
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "  Module Category Name [ " + this.getModCategoryName() + " ]");
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.classsource.specification.internal.ClassSourceImpl_Specification", "logHeader");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void logTrailer(Logger useLogger) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.classsource.specification.internal.ClassSourceImpl_Specification", "logTrailer", new Object[]{useLogger});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.classsource.specification.internal.ClassSourceImpl_Specification", "logTrailer");
        }
    }

    @Override
    public abstract void logInternal(Logger var1);

    @Override
    public abstract void logExternal(Logger var1);

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void logClassLoader(Logger useLogger) {
        String methodName = "logClassLoader";
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "  ClassLoader [ " + this.getRootClassLoader() + " ]");
    }
}

