/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.annocache.util.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.annocache.util.internal.UtilImpl_FileUtils;
import com.ibm.ws.annocache.util.internal.UtilImpl_RelativePath;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class UtilImpl_PathUtils {
    public static final String NORMALIZED_SEP = "/";
    public static final char NORMALIZED_SEP_CHAR = '/';
    static final long serialVersionUID = 5917035875338590028L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static String append(String headPath, String tailPath) {
        if (headPath == null || headPath.isEmpty()) {
            return tailPath;
        }
        if (tailPath == null || tailPath.isEmpty()) {
            return headPath;
        }
        if (headPath.endsWith(File.separator)) {
            if (tailPath.startsWith(File.separator)) {
                return headPath + tailPath.substring(1);
            }
            return headPath + tailPath;
        }
        if (tailPath.startsWith(File.separator)) {
            return headPath + tailPath;
        }
        return headPath + File.separator + tailPath;
    }

    public static String n_append(String n_headPath, String n_tailPath) {
        if (n_headPath == null || n_headPath.isEmpty()) {
            return n_tailPath;
        }
        if (n_tailPath == null || n_tailPath.isEmpty()) {
            return n_headPath;
        }
        if (n_headPath.endsWith(NORMALIZED_SEP)) {
            if (n_tailPath.startsWith(NORMALIZED_SEP)) {
                return n_headPath + n_tailPath.substring(1);
            }
            return n_headPath + n_tailPath;
        }
        if (n_tailPath.startsWith(NORMALIZED_SEP)) {
            return n_headPath + n_tailPath;
        }
        return n_headPath + NORMALIZED_SEP + n_tailPath;
    }

    public static String normalize(String path) {
        if (path == null || path.isEmpty()) {
            return path;
        }
        if (File.separatorChar == '/') {
            return path;
        }
        return path.replace(File.separatorChar, '/');
    }

    public static String denormalize(String n_path) {
        if (n_path == null || n_path.isEmpty()) {
            return n_path;
        }
        if (File.separatorChar == '/') {
            return n_path;
        }
        return n_path.replace('/', File.separatorChar);
    }

    public static String subtractPath(String basePath, String fullPath) {
        if (basePath.startsWith(File.separator)) {
            if (!fullPath.startsWith(basePath)) {
                return null;
            }
            return fullPath.substring(basePath.length());
        }
        if (!fullPath.startsWith(basePath)) {
            return null;
        }
        if (fullPath.length() <= basePath.length()) {
            return null;
        }
        if (fullPath.charAt(basePath.length()) != File.separatorChar) {
            return null;
        }
        return fullPath.substring(basePath.length() + 1);
    }

    public static String n_subtractPath(String n_basePath, String n_fullPath) {
        if (n_basePath.startsWith(NORMALIZED_SEP)) {
            if (!n_fullPath.startsWith(n_basePath)) {
                return null;
            }
            return n_fullPath.substring(n_basePath.length());
        }
        if (!n_fullPath.startsWith(n_basePath)) {
            return null;
        }
        if (n_fullPath.length() <= n_basePath.length()) {
            return null;
        }
        if (n_fullPath.charAt(n_basePath.length()) != '/') {
            return null;
        }
        return n_fullPath.substring(n_basePath.length() + 1);
    }

    public static UtilImpl_RelativePath addRelativePath(String basePath, String relativePath) {
        String n_basePath = UtilImpl_PathUtils.normalize(basePath);
        String n_relativePath = UtilImpl_PathUtils.normalize(relativePath);
        String n_fullPath = UtilImpl_PathUtils.n_append(n_basePath, n_relativePath);
        return new UtilImpl_RelativePath(n_basePath, n_relativePath, n_fullPath);
    }

    public static UtilImpl_RelativePath n_addRelativePath(String n_basePath, String n_relativePath) {
        String n_fullPath = UtilImpl_PathUtils.n_append(n_basePath, n_relativePath);
        return new UtilImpl_RelativePath(n_basePath, n_relativePath, n_fullPath);
    }

    public static UtilImpl_RelativePath subtractRelativePath(String basePath, String fullPath) {
        String n_basePath = UtilImpl_PathUtils.normalize(basePath);
        String n_fullPath = UtilImpl_PathUtils.normalize(fullPath);
        String n_relativePath = UtilImpl_PathUtils.n_subtractPath(n_basePath, n_fullPath);
        return new UtilImpl_RelativePath(n_basePath, n_relativePath, n_fullPath);
    }

    public static UtilImpl_RelativePath n_subtractRelativePath(String n_basePath, String n_fullPath) {
        String n_relativePath = UtilImpl_PathUtils.n_subtractPath(n_basePath, n_fullPath);
        return new UtilImpl_RelativePath(n_basePath, n_relativePath, n_fullPath);
    }

    public static List<UtilImpl_RelativePath> selectJars(String basePath) {
        String n_basePath = UtilImpl_PathUtils.normalize(basePath);
        ArrayList<UtilImpl_RelativePath> selectedJars = new ArrayList<UtilImpl_RelativePath>();
        UtilImpl_PathUtils.selectJars(n_basePath, new File(basePath), selectedJars);
        return selectedJars;
    }

    public static void selectJars(String n_basePath, File currentFile, List<UtilImpl_RelativePath> selectedJars) {
        if (!UtilImpl_FileUtils.exists(currentFile)) {
            return;
        }
        if (UtilImpl_FileUtils.isDirectory(currentFile)) {
            String[] childNames = UtilImpl_FileUtils.list(currentFile);
            if (childNames == null || childNames.length == 0) {
                return;
            }
            for (String childName : childNames) {
                UtilImpl_PathUtils.selectJars(n_basePath, new File(currentFile, childName), selectedJars);
            }
        } else {
            String currentName = currentFile.getName();
            if (!currentName.toUpperCase().endsWith(".JAR")) {
                return;
            }
            String currentPath = currentFile.getPath();
            String n_currentPath = UtilImpl_PathUtils.normalize(currentPath);
            UtilImpl_RelativePath relativePath = UtilImpl_PathUtils.n_subtractRelativePath(n_basePath, n_currentPath);
            selectedJars.add(relativePath);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.annocache.util.internal.UtilImpl_PathUtils", UtilImpl_PathUtils.class, (String)"com.ibm.ws.annocache", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
    }
}

