/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.runtime;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import javax.servlet.jsp.el.FunctionMapper;

public final class ProtectedFunctionMapper
extends javax.el.FunctionMapper
implements FunctionMapper {
    private HashMap fnmap = null;

    private ProtectedFunctionMapper() {
    }

    public static ProtectedFunctionMapper getInstance() {
        ProtectedFunctionMapper funcMapper = System.getSecurityManager() != null ? (ProtectedFunctionMapper)((Object)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new ProtectedFunctionMapper();
            }
        })) : new ProtectedFunctionMapper();
        funcMapper.fnmap = new HashMap();
        return funcMapper;
    }

    public void mapFunction(String prefix, String fnName, final Class c, final String methodName, final Class[] args) {
        Method method;
        if (fnName == null) {
            return;
        }
        if (System.getSecurityManager() != null) {
            try {
                method = (Method)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return c.getDeclaredMethod(methodName, args);
                    }
                });
            }
            catch (PrivilegedActionException ex) {
                throw new RuntimeException("Invalid function mapping - no such method: " + ex.getException().getMessage());
            }
        }
        try {
            method = c.getDeclaredMethod(methodName, args);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Invalid function mapping - no such method: " + e.getMessage());
        }
        this.fnmap.put(prefix + ":" + fnName, method);
    }

    public Method resolveFunction(String prefix, String localName) {
        return (Method)this.fnmap.get(prefix + ":" + localName);
    }
}

