/*
 * Decompiled with CFR 0.152.
 */
package io.seata.saga.engine.expression.impl;

import io.seata.saga.engine.expression.Expression;
import io.seata.saga.engine.expression.ExpressionFactory;
import io.seata.saga.engine.expression.ExpressionFactoryManager;
import io.seata.saga.engine.expression.ExpressionResolver;

public class DefaultExpressionResolver
implements ExpressionResolver {
    private ExpressionFactoryManager expressionFactoryManager;

    @Override
    public Expression getExpression(String expressionStr) {
        ExpressionStruct struct = this.parseExpressionStruct(expressionStr);
        ExpressionFactory expressionFactory = this.expressionFactoryManager.getExpressionFactory(struct.type);
        if (expressionFactory == null) {
            throw new IllegalArgumentException("Cannot get ExpressionFactory by Type[" + struct + "]");
        }
        return expressionFactory.createExpression(struct.content);
    }

    protected ExpressionStruct parseExpressionStruct(String expressionStr) {
        ExpressionStruct struct = new ExpressionStruct();
        struct.typeStart = expressionStr.indexOf("$");
        int dot = expressionStr.indexOf(".", struct.typeStart);
        int leftBracket = expressionStr.indexOf("{", struct.typeStart);
        boolean isOldEvaluatorStyle = false;
        if (struct.typeStart == 0) {
            if (leftBracket < 0 && dot < 0) {
                throw new IllegalArgumentException(String.format("Expression [%s] type is not closed", expressionStr));
            }
            if (leftBracket > 0 && (leftBracket < dot || dot < 0)) {
                struct.typeEnd = leftBracket;
                isOldEvaluatorStyle = true;
            }
            if (dot > 0 && (dot < leftBracket || leftBracket < 0)) {
                struct.typeEnd = dot;
            }
        }
        if (struct.typeStart == 0 && leftBracket != -1 && leftBracket < dot) {
            struct.typeEnd = expressionStr.indexOf("{", struct.typeStart);
            isOldEvaluatorStyle = true;
        }
        if (struct.typeStart != 0) {
            struct.typeEnd = -1;
            struct.typeStart = -1;
            struct.type = null;
        } else {
            struct.type = expressionStr.substring(struct.typeStart + 1, struct.typeEnd);
        }
        struct.end = isOldEvaluatorStyle ? expressionStr.indexOf("}", struct.typeEnd) : expressionStr.length();
        struct.content = expressionStr.substring(struct.typeEnd + 1, struct.end);
        return struct;
    }

    @Override
    public ExpressionFactoryManager getExpressionFactoryManager() {
        return this.expressionFactoryManager;
    }

    @Override
    public void setExpressionFactoryManager(ExpressionFactoryManager expressionFactoryManager) {
        this.expressionFactoryManager = expressionFactoryManager;
    }

    protected static class ExpressionStruct {
        int typeStart;
        int typeEnd;
        int end;
        String type;
        String content;

        protected ExpressionStruct() {
        }
    }
}

