/*
 * Decompiled with CFR 0.152.
 */
package io.seata.saga.statelang.validator;

import io.seata.saga.statelang.domain.StateMachine;
import io.seata.saga.statelang.validator.Rule;
import io.seata.saga.statelang.validator.RuleFactory;
import io.seata.saga.statelang.validator.ValidationException;
import java.util.List;

public class StateMachineValidator {
    public void validate(StateMachine stateMachine) throws ValidationException {
        List<Rule> rules = RuleFactory.getRules();
        for (Rule rule : rules) {
            boolean pass;
            try {
                pass = rule.validate(stateMachine);
            }
            catch (Throwable e) {
                throw new ValidationException(rule, "Exception occurs", e);
            }
            if (pass) continue;
            throw new ValidationException(rule, "Failed");
        }
    }
}

