/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.spring.client.config;

import io.zeebe.client.ZeebeClientBuilder;
import io.zeebe.client.impl.ZeebeClientBuilderImpl;
import io.zeebe.spring.client.config.ZeebeActuatorConfiguration;
import io.zeebe.spring.client.properties.ZeebeClientConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;

@Import(value={ZeebeActuatorConfiguration.class})
@EnableConfigurationProperties(value={ZeebeClientConfigurationProperties.class})
@Configuration
public class ZeebeClientStarterAutoConfiguration {
    private final ZeebeClientConfigurationProperties configurationProperties;

    @Bean
    @Primary
    public ZeebeClientBuilder builder() {
        ZeebeClientBuilderImpl builder = new ZeebeClientBuilderImpl();
        builder.brokerContactPoint(this.configurationProperties.getBrokerContactPoint());
        builder.defaultJobPollInterval(this.configurationProperties.getDefaultJobPollInterval());
        builder.defaultJobTimeout(this.configurationProperties.getDefaultJobTimeout());
        builder.defaultJobWorkerMaxJobsActive(this.configurationProperties.getDefaultJobWorkerMaxJobsActive());
        builder.defaultJobWorkerName(this.configurationProperties.getDefaultJobWorkerName());
        builder.defaultMessageTimeToLive(this.configurationProperties.getDefaultMessageTimeToLive());
        builder.numJobWorkerExecutionThreads(this.configurationProperties.getNumJobWorkerExecutionThreads());
        builder.defaultRequestTimeout(this.configurationProperties.getDefaultRequestTimeout());
        builder.credentialsProvider(this.configurationProperties.getCredentialsProvider());
        builder.caCertificatePath(this.configurationProperties.getCaCertificatePath());
        if (this.configurationProperties.isPlaintextConnectionEnabled()) {
            builder.usePlaintext();
        }
        return builder;
    }

    public ZeebeClientStarterAutoConfiguration(ZeebeClientConfigurationProperties configurationProperties) {
        this.configurationProperties = configurationProperties;
    }
}

