/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.spring.client.properties;

import io.grpc.ClientInterceptor;
import io.zeebe.client.CredentialsProvider;
import io.zeebe.spring.client.config.ZeebeClientSpringConfiguration;
import io.zeebe.spring.client.properties.ZeebeClientProperties;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

@ConfigurationProperties(prefix="zeebe.client")
public class ZeebeClientConfigurationProperties
implements ZeebeClientProperties {
    @NestedConfigurationProperty
    private Broker broker = new Broker();
    @NestedConfigurationProperty
    private Cloud cloud = new Cloud();
    @NestedConfigurationProperty
    private Worker worker = new Worker();
    @NestedConfigurationProperty
    private Message message = new Message();
    @NestedConfigurationProperty
    private Security security = new Security();
    @NestedConfigurationProperty
    private Job job = new Job();
    private ArrayList<ClientInterceptor> interceptors = new ArrayList();
    private Duration requestTimeout = ZeebeClientSpringConfiguration.DEFAULT.getDefaultRequestTimeout();

    public String getBrokerContactPoint() {
        if (this.cloud.isConfigured()) {
            return this.cloud.getBrokerContactPoint();
        }
        return this.broker.getContactPoint();
    }

    public Duration getDefaultRequestTimeout() {
        return this.getRequestTimeout();
    }

    public int getNumJobWorkerExecutionThreads() {
        return this.worker.getThreads();
    }

    public int getDefaultJobWorkerMaxJobsActive() {
        return this.worker.getMaxJobsActive();
    }

    public String getDefaultJobWorkerName() {
        return this.worker.getDefaultName();
    }

    public String getDefaultJobWorkerType() {
        return this.worker.getDefaultType();
    }

    public Duration getDefaultJobTimeout() {
        return this.job.getTimeout();
    }

    public Duration getDefaultJobPollInterval() {
        return this.job.getPollInterval();
    }

    public Duration getDefaultMessageTimeToLive() {
        return this.message.getTimeToLive();
    }

    public boolean isPlaintextConnectionEnabled() {
        return this.security.isPlaintext();
    }

    public String getCaCertificatePath() {
        return this.security.getCertPath();
    }

    public CredentialsProvider getCredentialsProvider() {
        if (this.cloud.clientId != null && this.cloud.clientSecret != null) {
            return CredentialsProvider.newCredentialsProviderBuilder().clientId(this.cloud.clientId).clientSecret(this.cloud.clientSecret).audience(this.cloud.getAudience()).authorizationServerUrl(this.cloud.authUrl).credentialsCachePath(this.cloud.credentialsCachePath).build();
        }
        return null;
    }

    public Duration getKeepAlive() {
        return this.broker.getKeepAlive();
    }

    public List<ClientInterceptor> getInterceptors() {
        return this.interceptors;
    }

    public Broker getBroker() {
        return this.broker;
    }

    public Cloud getCloud() {
        return this.cloud;
    }

    public Worker getWorker() {
        return this.worker;
    }

    public Message getMessage() {
        return this.message;
    }

    public Security getSecurity() {
        return this.security;
    }

    public Job getJob() {
        return this.job;
    }

    public Duration getRequestTimeout() {
        return this.requestTimeout;
    }

    public void setBroker(Broker broker) {
        this.broker = broker;
    }

    public void setCloud(Cloud cloud) {
        this.cloud = cloud;
    }

    public void setWorker(Worker worker) {
        this.worker = worker;
    }

    public void setMessage(Message message) {
        this.message = message;
    }

    public void setSecurity(Security security) {
        this.security = security;
    }

    public void setJob(Job job) {
        this.job = job;
    }

    public void setInterceptors(ArrayList<ClientInterceptor> interceptors) {
        this.interceptors = interceptors;
    }

    public void setRequestTimeout(Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ZeebeClientConfigurationProperties)) {
            return false;
        }
        ZeebeClientConfigurationProperties other = (ZeebeClientConfigurationProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Broker this$broker = this.getBroker();
        Broker other$broker = other.getBroker();
        if (this$broker == null ? other$broker != null : !((Object)this$broker).equals(other$broker)) {
            return false;
        }
        Cloud this$cloud = this.getCloud();
        Cloud other$cloud = other.getCloud();
        if (this$cloud == null ? other$cloud != null : !((Object)this$cloud).equals(other$cloud)) {
            return false;
        }
        Worker this$worker = this.getWorker();
        Worker other$worker = other.getWorker();
        if (this$worker == null ? other$worker != null : !((Object)this$worker).equals(other$worker)) {
            return false;
        }
        Message this$message = this.getMessage();
        Message other$message = other.getMessage();
        if (this$message == null ? other$message != null : !((Object)this$message).equals(other$message)) {
            return false;
        }
        Security this$security = this.getSecurity();
        Security other$security = other.getSecurity();
        if (this$security == null ? other$security != null : !((Object)this$security).equals(other$security)) {
            return false;
        }
        Job this$job = this.getJob();
        Job other$job = other.getJob();
        if (this$job == null ? other$job != null : !((Object)this$job).equals(other$job)) {
            return false;
        }
        List<ClientInterceptor> this$interceptors = this.getInterceptors();
        List<ClientInterceptor> other$interceptors = other.getInterceptors();
        if (this$interceptors == null ? other$interceptors != null : !((Object)this$interceptors).equals(other$interceptors)) {
            return false;
        }
        Duration this$requestTimeout = this.getRequestTimeout();
        Duration other$requestTimeout = other.getRequestTimeout();
        return !(this$requestTimeout == null ? other$requestTimeout != null : !((Object)this$requestTimeout).equals(other$requestTimeout));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ZeebeClientConfigurationProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Broker $broker = this.getBroker();
        result = result * 59 + ($broker == null ? 43 : ((Object)$broker).hashCode());
        Cloud $cloud = this.getCloud();
        result = result * 59 + ($cloud == null ? 43 : ((Object)$cloud).hashCode());
        Worker $worker = this.getWorker();
        result = result * 59 + ($worker == null ? 43 : ((Object)$worker).hashCode());
        Message $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : ((Object)$message).hashCode());
        Security $security = this.getSecurity();
        result = result * 59 + ($security == null ? 43 : ((Object)$security).hashCode());
        Job $job = this.getJob();
        result = result * 59 + ($job == null ? 43 : ((Object)$job).hashCode());
        List<ClientInterceptor> $interceptors = this.getInterceptors();
        result = result * 59 + ($interceptors == null ? 43 : ((Object)$interceptors).hashCode());
        Duration $requestTimeout = this.getRequestTimeout();
        result = result * 59 + ($requestTimeout == null ? 43 : ((Object)$requestTimeout).hashCode());
        return result;
    }

    public String toString() {
        return "ZeebeClientConfigurationProperties(broker=" + this.getBroker() + ", cloud=" + this.getCloud() + ", worker=" + this.getWorker() + ", message=" + this.getMessage() + ", security=" + this.getSecurity() + ", job=" + this.getJob() + ", interceptors=" + this.getInterceptors() + ", requestTimeout=" + this.getRequestTimeout() + ")";
    }

    public static class Security {
        private boolean plaintext = ZeebeClientSpringConfiguration.DEFAULT.isPlaintextConnectionEnabled();
        private String certPath = ZeebeClientSpringConfiguration.DEFAULT.getCaCertificatePath();

        public boolean isPlaintext() {
            return this.plaintext;
        }

        public String getCertPath() {
            return this.certPath;
        }

        public void setPlaintext(boolean plaintext) {
            this.plaintext = plaintext;
        }

        public void setCertPath(String certPath) {
            this.certPath = certPath;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Security)) {
                return false;
            }
            Security other = (Security)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isPlaintext() != other.isPlaintext()) {
                return false;
            }
            String this$certPath = this.getCertPath();
            String other$certPath = other.getCertPath();
            return !(this$certPath == null ? other$certPath != null : !this$certPath.equals(other$certPath));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Security;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isPlaintext() ? 79 : 97);
            String $certPath = this.getCertPath();
            result = result * 59 + ($certPath == null ? 43 : $certPath.hashCode());
            return result;
        }

        public String toString() {
            return "ZeebeClientConfigurationProperties.Security(plaintext=" + this.isPlaintext() + ", certPath=" + this.getCertPath() + ")";
        }
    }

    public static class Message {
        private Duration timeToLive = ZeebeClientSpringConfiguration.DEFAULT.getDefaultMessageTimeToLive();

        public Duration getTimeToLive() {
            return this.timeToLive;
        }

        public void setTimeToLive(Duration timeToLive) {
            this.timeToLive = timeToLive;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Message)) {
                return false;
            }
            Message other = (Message)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Duration this$timeToLive = this.getTimeToLive();
            Duration other$timeToLive = other.getTimeToLive();
            return !(this$timeToLive == null ? other$timeToLive != null : !((Object)this$timeToLive).equals(other$timeToLive));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Message;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Duration $timeToLive = this.getTimeToLive();
            result = result * 59 + ($timeToLive == null ? 43 : ((Object)$timeToLive).hashCode());
            return result;
        }

        public String toString() {
            return "ZeebeClientConfigurationProperties.Message(timeToLive=" + this.getTimeToLive() + ")";
        }
    }

    public static class Job {
        private Duration timeout = ZeebeClientSpringConfiguration.DEFAULT.getDefaultJobTimeout();
        private Duration pollInterval = ZeebeClientSpringConfiguration.DEFAULT.getDefaultJobPollInterval();

        public Duration getTimeout() {
            return this.timeout;
        }

        public Duration getPollInterval() {
            return this.pollInterval;
        }

        public void setTimeout(Duration timeout) {
            this.timeout = timeout;
        }

        public void setPollInterval(Duration pollInterval) {
            this.pollInterval = pollInterval;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Job)) {
                return false;
            }
            Job other = (Job)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Duration this$timeout = this.getTimeout();
            Duration other$timeout = other.getTimeout();
            if (this$timeout == null ? other$timeout != null : !((Object)this$timeout).equals(other$timeout)) {
                return false;
            }
            Duration this$pollInterval = this.getPollInterval();
            Duration other$pollInterval = other.getPollInterval();
            return !(this$pollInterval == null ? other$pollInterval != null : !((Object)this$pollInterval).equals(other$pollInterval));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Job;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Duration $timeout = this.getTimeout();
            result = result * 59 + ($timeout == null ? 43 : ((Object)$timeout).hashCode());
            Duration $pollInterval = this.getPollInterval();
            result = result * 59 + ($pollInterval == null ? 43 : ((Object)$pollInterval).hashCode());
            return result;
        }

        public String toString() {
            return "ZeebeClientConfigurationProperties.Job(timeout=" + this.getTimeout() + ", pollInterval=" + this.getPollInterval() + ")";
        }
    }

    public static class Worker {
        private Integer maxJobsActive = ZeebeClientSpringConfiguration.DEFAULT.getDefaultJobWorkerMaxJobsActive();
        private Integer threads = ZeebeClientSpringConfiguration.DEFAULT.getNumJobWorkerExecutionThreads();
        private String defaultName = ZeebeClientSpringConfiguration.DEFAULT.getDefaultJobWorkerName();
        private String defaultType = null;

        public Integer getMaxJobsActive() {
            return this.maxJobsActive;
        }

        public Integer getThreads() {
            return this.threads;
        }

        public String getDefaultName() {
            return this.defaultName;
        }

        public String getDefaultType() {
            return this.defaultType;
        }

        public void setMaxJobsActive(Integer maxJobsActive) {
            this.maxJobsActive = maxJobsActive;
        }

        public void setThreads(Integer threads) {
            this.threads = threads;
        }

        public void setDefaultName(String defaultName) {
            this.defaultName = defaultName;
        }

        public void setDefaultType(String defaultType) {
            this.defaultType = defaultType;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Worker)) {
                return false;
            }
            Worker other = (Worker)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$maxJobsActive = this.getMaxJobsActive();
            Integer other$maxJobsActive = other.getMaxJobsActive();
            if (this$maxJobsActive == null ? other$maxJobsActive != null : !((Object)this$maxJobsActive).equals(other$maxJobsActive)) {
                return false;
            }
            Integer this$threads = this.getThreads();
            Integer other$threads = other.getThreads();
            if (this$threads == null ? other$threads != null : !((Object)this$threads).equals(other$threads)) {
                return false;
            }
            String this$defaultName = this.getDefaultName();
            String other$defaultName = other.getDefaultName();
            if (this$defaultName == null ? other$defaultName != null : !this$defaultName.equals(other$defaultName)) {
                return false;
            }
            String this$defaultType = this.getDefaultType();
            String other$defaultType = other.getDefaultType();
            return !(this$defaultType == null ? other$defaultType != null : !this$defaultType.equals(other$defaultType));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Worker;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $maxJobsActive = this.getMaxJobsActive();
            result = result * 59 + ($maxJobsActive == null ? 43 : ((Object)$maxJobsActive).hashCode());
            Integer $threads = this.getThreads();
            result = result * 59 + ($threads == null ? 43 : ((Object)$threads).hashCode());
            String $defaultName = this.getDefaultName();
            result = result * 59 + ($defaultName == null ? 43 : $defaultName.hashCode());
            String $defaultType = this.getDefaultType();
            result = result * 59 + ($defaultType == null ? 43 : $defaultType.hashCode());
            return result;
        }

        public String toString() {
            return "ZeebeClientConfigurationProperties.Worker(maxJobsActive=" + this.getMaxJobsActive() + ", threads=" + this.getThreads() + ", defaultName=" + this.getDefaultName() + ", defaultType=" + this.getDefaultType() + ")";
        }
    }

    public static class Cloud {
        private String clusterId;
        private String clientId;
        private String clientSecret;
        private String baseUrl = "zeebe.camunda.io";
        private String authUrl = "https://login.cloud.camunda.io/oauth/token";
        private int port = 443;
        private String credentialsCachePath;

        public String getAudience() {
            return this.clusterId + "." + this.baseUrl;
        }

        public boolean isConfigured() {
            return this.clusterId != null;
        }

        public String getBrokerContactPoint() {
            return this.clusterId + "." + this.baseUrl + ":" + this.port;
        }

        public String getClusterId() {
            return this.clusterId;
        }

        public String getClientId() {
            return this.clientId;
        }

        public String getClientSecret() {
            return this.clientSecret;
        }

        public String getBaseUrl() {
            return this.baseUrl;
        }

        public String getAuthUrl() {
            return this.authUrl;
        }

        public int getPort() {
            return this.port;
        }

        public String getCredentialsCachePath() {
            return this.credentialsCachePath;
        }

        public void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public void setClientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
        }

        public void setBaseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
        }

        public void setAuthUrl(String authUrl) {
            this.authUrl = authUrl;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public void setCredentialsCachePath(String credentialsCachePath) {
            this.credentialsCachePath = credentialsCachePath;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Cloud)) {
                return false;
            }
            Cloud other = (Cloud)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$clusterId = this.getClusterId();
            String other$clusterId = other.getClusterId();
            if (this$clusterId == null ? other$clusterId != null : !this$clusterId.equals(other$clusterId)) {
                return false;
            }
            String this$clientId = this.getClientId();
            String other$clientId = other.getClientId();
            if (this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId)) {
                return false;
            }
            String this$clientSecret = this.getClientSecret();
            String other$clientSecret = other.getClientSecret();
            if (this$clientSecret == null ? other$clientSecret != null : !this$clientSecret.equals(other$clientSecret)) {
                return false;
            }
            String this$baseUrl = this.getBaseUrl();
            String other$baseUrl = other.getBaseUrl();
            if (this$baseUrl == null ? other$baseUrl != null : !this$baseUrl.equals(other$baseUrl)) {
                return false;
            }
            String this$authUrl = this.getAuthUrl();
            String other$authUrl = other.getAuthUrl();
            if (this$authUrl == null ? other$authUrl != null : !this$authUrl.equals(other$authUrl)) {
                return false;
            }
            if (this.getPort() != other.getPort()) {
                return false;
            }
            String this$credentialsCachePath = this.getCredentialsCachePath();
            String other$credentialsCachePath = other.getCredentialsCachePath();
            return !(this$credentialsCachePath == null ? other$credentialsCachePath != null : !this$credentialsCachePath.equals(other$credentialsCachePath));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Cloud;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $clusterId = this.getClusterId();
            result = result * 59 + ($clusterId == null ? 43 : $clusterId.hashCode());
            String $clientId = this.getClientId();
            result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
            String $clientSecret = this.getClientSecret();
            result = result * 59 + ($clientSecret == null ? 43 : $clientSecret.hashCode());
            String $baseUrl = this.getBaseUrl();
            result = result * 59 + ($baseUrl == null ? 43 : $baseUrl.hashCode());
            String $authUrl = this.getAuthUrl();
            result = result * 59 + ($authUrl == null ? 43 : $authUrl.hashCode());
            result = result * 59 + this.getPort();
            String $credentialsCachePath = this.getCredentialsCachePath();
            result = result * 59 + ($credentialsCachePath == null ? 43 : $credentialsCachePath.hashCode());
            return result;
        }

        public String toString() {
            return "ZeebeClientConfigurationProperties.Cloud(clusterId=" + this.getClusterId() + ", clientId=" + this.getClientId() + ", clientSecret=" + this.getClientSecret() + ", baseUrl=" + this.getBaseUrl() + ", authUrl=" + this.getAuthUrl() + ", port=" + this.getPort() + ", credentialsCachePath=" + this.getCredentialsCachePath() + ")";
        }
    }

    public static class Broker {
        private String contactPoint = ZeebeClientSpringConfiguration.DEFAULT.getBrokerContactPoint();
        private Duration keepAlive = ZeebeClientSpringConfiguration.DEFAULT.getKeepAlive();

        public String getContactPoint() {
            return this.contactPoint;
        }

        public Duration getKeepAlive() {
            return this.keepAlive;
        }

        public void setContactPoint(String contactPoint) {
            this.contactPoint = contactPoint;
        }

        public void setKeepAlive(Duration keepAlive) {
            this.keepAlive = keepAlive;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Broker)) {
                return false;
            }
            Broker other = (Broker)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$contactPoint = this.getContactPoint();
            String other$contactPoint = other.getContactPoint();
            if (this$contactPoint == null ? other$contactPoint != null : !this$contactPoint.equals(other$contactPoint)) {
                return false;
            }
            Duration this$keepAlive = this.getKeepAlive();
            Duration other$keepAlive = other.getKeepAlive();
            return !(this$keepAlive == null ? other$keepAlive != null : !((Object)this$keepAlive).equals(other$keepAlive));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Broker;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $contactPoint = this.getContactPoint();
            result = result * 59 + ($contactPoint == null ? 43 : $contactPoint.hashCode());
            Duration $keepAlive = this.getKeepAlive();
            result = result * 59 + ($keepAlive == null ? 43 : ((Object)$keepAlive).hashCode());
            return result;
        }

        public String toString() {
            return "ZeebeClientConfigurationProperties.Broker(contactPoint=" + this.getContactPoint() + ", keepAlive=" + this.getKeepAlive() + ")";
        }
    }
}

