/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.spring.util;

import io.zeebe.spring.util.ZeebeObjectFactory;
import java.util.function.Supplier;
import org.springframework.context.SmartLifecycle;

public abstract class ZeebeAutoStartUpLifecycle<T extends AutoCloseable>
implements SmartLifecycle,
Supplier<T> {
    protected boolean autoStartup = true;
    protected boolean running = false;
    protected final int phase;
    protected final ZeebeObjectFactory<T> factory;
    protected T delegate;

    public ZeebeAutoStartUpLifecycle(int phase, ZeebeObjectFactory<T> factory) {
        this.phase = phase;
        this.factory = factory;
    }

    @Override
    public T get() {
        if (!this.isRunning()) {
            throw new IllegalStateException("delegate is not running!");
        }
        return this.delegate;
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    public void start() {
        try {
            this.delegate = (AutoCloseable)this.factory.getObject();
        }
        finally {
            this.running = true;
        }
    }

    public void stop(Runnable callback) {
        try {
            this.delegate.close();
            callback.run();
        }
        finally {
            this.running = false;
        }
    }

    public void stop() {
        this.stop(() -> {});
    }

    public boolean isRunning() {
        return this.running;
    }

    public int getPhase() {
        return this.phase;
    }
}

