package io.zeebe.gateway.protocol;

import static io.grpc.MethodDescriptor.generateFullMethodName;
import static io.grpc.stub.ClientCalls.asyncBidiStreamingCall;
import static io.grpc.stub.ClientCalls.asyncClientStreamingCall;
import static io.grpc.stub.ClientCalls.asyncServerStreamingCall;
import static io.grpc.stub.ClientCalls.asyncUnaryCall;
import static io.grpc.stub.ClientCalls.blockingServerStreamingCall;
import static io.grpc.stub.ClientCalls.blockingUnaryCall;
import static io.grpc.stub.ClientCalls.futureUnaryCall;
import static io.grpc.stub.ServerCalls.asyncBidiStreamingCall;
import static io.grpc.stub.ServerCalls.asyncClientStreamingCall;
import static io.grpc.stub.ServerCalls.asyncServerStreamingCall;
import static io.grpc.stub.ServerCalls.asyncUnaryCall;
import static io.grpc.stub.ServerCalls.asyncUnimplementedStreamingCall;
import static io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall;

/**
 */
@javax.annotation.Generated(
    value = "by gRPC proto compiler (version 1.22.1)",
    comments = "Source: gateway.proto")
public final class GatewayGrpc {

  private GatewayGrpc() {}

  public static final String SERVICE_NAME = "gateway_protocol.Gateway";

  // Static method descriptors that strictly reflect the proto.
  private static volatile io.grpc.MethodDescriptor<io.zeebe.gateway.protocol.GatewayOuterClass.ActivateJobsRequest,
      io.zeebe.gateway.protocol.GatewayOuterClass.ActivateJobsResponse> getActivateJobsMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "ActivateJobs",
      requestType = io.zeebe.gateway.protocol.GatewayOuterClass.ActivateJobsRequest.class,
      responseType = io.zeebe.gateway.protocol.GatewayOuterClass.ActivateJobsResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.SERVER_STREAMING)
  public static io.grpc.MethodDescriptor<io.zeebe.gateway.protocol.GatewayOuterClass.ActivateJobsRequest,
      io.zeebe.gateway.protocol.GatewayOuterClass.ActivateJobsResponse> getActivateJobsMethod() {
    io.grpc.MethodDescriptor<io.zeebe.gateway.protocol.GatewayOuterClass.ActivateJobsRequest, io.zeebe.gateway.protocol.GatewayOuterClass.ActivateJobsResponse> getActivateJobsMethod;
    if ((getActivateJobsMethod = GatewayGrpc.getActivateJobsMethod) == null) {
      synchronized (GatewayGrpc.class) {
        if ((getActivateJobsMethod = GatewayGrpc.getActivateJobsMethod) == null) {
          GatewayGrpc.getActivateJobsMethod = getActivateJobsMethod = 
              io.grpc.MethodDescriptor.<io.zeebe.gateway.protocol.GatewayOuterClass.ActivateJobsRequest, io.zeebe.gateway.protocol.GatewayOuterClass.ActivateJobsResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.SERVER_STREAMING)
              .setFullMethodName(generateFullMethodName(
                  "gateway_protocol.Gateway", "ActivateJobs"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.zeebe.gateway.protocol.GatewayOuterClass.ActivateJobsRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.zeebe.gateway.protocol.GatewayOuterClass.ActivateJobsResponse.getDefaultInstance()))
                  .setSchemaDescriptor(new GatewayMethodDescriptorSupplier("ActivateJobs"))
                  .build();
          }
        }
     }
     return getActivateJobsMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.zeebe.gateway.protocol.GatewayOuterClass.CancelWorkflowInstanceRequest,
      io.zeebe.gateway.protocol.GatewayOuterClass.CancelWorkflowInstanceResponse> getCancelWorkflowInstanceMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "CancelWorkflowInstance",
      requestType = io.zeebe.gateway.protocol.GatewayOuterClass.CancelWorkflowInstanceRequest.class,
      responseType = io.zeebe.gateway.protocol.GatewayOuterClass.CancelWorkflowInstanceResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.zeebe.gateway.protocol.GatewayOuterClass.CancelWorkflowInstanceRequest,
      io.zeebe.gateway.protocol.GatewayOuterClass.CancelWorkflowInstanceResponse> getCancelWorkflowInstanceMethod() {
    io.grpc.MethodDescriptor<io.zeebe.gateway.protocol.GatewayOuterClass.CancelWorkflowInstanceRequest, io.zeebe.gateway.protocol.GatewayOuterClass.CancelWorkflowInstanceResponse> getCancelWorkflowInstanceMethod;
    if ((getCancelWorkflowInstanceMethod = GatewayGrpc.getCancelWorkflowInstanceMethod) == null) {
      synchronized (GatewayGrpc.class) {
        if ((getCancelWorkflowInstanceMethod = GatewayGrpc.getCancelWorkflowInstanceMethod) == null) {
          GatewayGrpc.getCancelWorkflowInstanceMethod = getCancelWorkflowInstanceMethod = 
              io.grpc.MethodDescriptor.<io.zeebe.gateway.protocol.GatewayOuterClass.CancelWorkflowInstanceRequest, io.zeebe.gateway.protocol.GatewayOuterClass.CancelWorkflowInstanceResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(
                  "gateway_protocol.Gateway", "CancelWorkflowInstance"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.zeebe.gateway.protocol.GatewayOuterClass.CancelWorkflowInstanceRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.zeebe.gateway.protocol.GatewayOuterClass.CancelWorkflowInstanceResponse.getDefaultInstance()))
                  .setSchemaDescriptor(new GatewayMethodDescriptorSupplier("CancelWorkflowInstance"))
                  .build();
          }
        }
     }
     return getCancelWorkflowInstanceMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.zeebe.gateway.protocol.GatewayOuterClass.CompleteJobRequest,
      io.zeebe.gateway.protocol.GatewayOuterClass.CompleteJobResponse> getCompleteJobMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "CompleteJob",
      requestType = io.zeebe.gateway.protocol.GatewayOuterClass.CompleteJobRequest.class,
      responseType = io.zeebe.gateway.protocol.GatewayOuterClass.CompleteJobResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.zeebe.gateway.protocol.GatewayOuterClass.CompleteJobRequest,
      io.zeebe.gateway.protocol.GatewayOuterClass.CompleteJobResponse> getCompleteJobMethod() {
    io.grpc.MethodDescriptor<io.zeebe.gateway.protocol.GatewayOuterClass.CompleteJobRequest, io.zeebe.gateway.protocol.GatewayOuterClass.CompleteJobResponse> getCompleteJobMethod;
    if ((getCompleteJobMethod = GatewayGrpc.getCompleteJobMethod) == null) {
      synchronized (GatewayGrpc.class) {
        if ((getCompleteJobMethod = GatewayGrpc.getCompleteJobMethod) == null) {
          GatewayGrpc.getCompleteJobMethod = getCompleteJobMethod = 
              io.grpc.MethodDescriptor.<io.zeebe.gateway.protocol.GatewayOuterClass.CompleteJobRequest, io.zeebe.gateway.protocol.GatewayOuterClass.CompleteJobResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(
                  "gateway_protocol.Gateway", "CompleteJob"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.zeebe.gateway.protocol.GatewayOuterClass.CompleteJobRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.zeebe.gateway.protocol.GatewayOuterClass.CompleteJobResponse.getDefaultInstance()))
                  .setSchemaDescriptor(new GatewayMethodDescriptorSupplier("CompleteJob"))
                  .build();
          }
        }
     }
     return getCompleteJobMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.zeebe.gateway.protocol.GatewayOuterClass.CreateWorkflowInstanceRequest,
      io.zeebe.gateway.protocol.GatewayOuterClass.CreateWorkflowInstanceResponse> getCreateWorkflowInstanceMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "CreateWorkflowInstance",
      requestType = io.zeebe.gateway.protocol.GatewayOuterClass.CreateWorkflowInstanceRequest.class,
      responseType = io.zeebe.gateway.protocol.GatewayOuterClass.CreateWorkflowInstanceResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.zeebe.gateway.protocol.GatewayOuterClass.CreateWorkflowInstanceRequest,
      io.zeebe.gateway.protocol.GatewayOuterClass.CreateWorkflowInstanceResponse> getCreateWorkflowInstanceMethod() {
    io.grpc.MethodDescriptor<io.zeebe.gateway.protocol.GatewayOuterClass.CreateWorkflowInstanceRequest, io.zeebe.gateway.protocol.GatewayOuterClass.CreateWorkflowInstanceResponse> getCreateWorkflowInstanceMethod;
    if ((getCreateWorkflowInstanceMethod = GatewayGrpc.getCreateWorkflowInstanceMethod) == null) {
      synchronized (GatewayGrpc.class) {
        if ((getCreateWorkflowInstanceMethod = GatewayGrpc.getCreateWorkflowInstanceMethod) == null) {
          GatewayGrpc.getCreateWorkflowInstanceMethod = getCreateWorkflowInstanceMethod = 
              io.grpc.MethodDescriptor.<io.zeebe.gateway.protocol.GatewayOuterClass.CreateWorkflowInstanceRequest, io.zeebe.gateway.protocol.GatewayOuterClass.CreateWorkflowInstanceResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(
                  "gateway_protocol.Gateway", "CreateWorkflowInstance"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.zeebe.gateway.protocol.GatewayOuterClass.CreateWorkflowInstanceRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.zeebe.gateway.protocol.GatewayOuterClass.CreateWorkflowInstanceResponse.getDefaultInstance()))
                  .setSchemaDescriptor(new GatewayMethodDescriptorSupplier("CreateWorkflowInstance"))
                  .build();
          }
        }
     }
     return getCreateWorkflowInstanceMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.zeebe.gateway.protocol.GatewayOuterClass.DeployWorkflowRequest,
      io.zeebe.gateway.protocol.GatewayOuterClass.DeployWorkflowResponse> getDeployWorkflowMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "DeployWorkflow",
      requestType = io.zeebe.gateway.protocol.GatewayOuterClass.DeployWorkflowRequest.class,
      responseType = io.zeebe.gateway.protocol.GatewayOuterClass.DeployWorkflowResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.zeebe.gateway.protocol.GatewayOuterClass.DeployWorkflowRequest,
      io.zeebe.gateway.protocol.GatewayOuterClass.DeployWorkflowResponse> getDeployWorkflowMethod() {
    io.grpc.MethodDescriptor<io.zeebe.gateway.protocol.GatewayOuterClass.DeployWorkflowRequest, io.zeebe.gateway.protocol.GatewayOuterClass.DeployWorkflowResponse> getDeployWorkflowMethod;
    if ((getDeployWorkflowMethod = GatewayGrpc.getDeployWorkflowMethod) == null) {
      synchronized (GatewayGrpc.class) {
        if ((getDeployWorkflowMethod = GatewayGrpc.getDeployWorkflowMethod) == null) {
          GatewayGrpc.getDeployWorkflowMethod = getDeployWorkflowMethod = 
              io.grpc.MethodDescriptor.<io.zeebe.gateway.protocol.GatewayOuterClass.DeployWorkflowRequest, io.zeebe.gateway.protocol.GatewayOuterClass.DeployWorkflowResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(
                  "gateway_protocol.Gateway", "DeployWorkflow"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.zeebe.gateway.protocol.GatewayOuterClass.DeployWorkflowRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.zeebe.gateway.protocol.GatewayOuterClass.DeployWorkflowResponse.getDefaultInstance()))
                  .setSchemaDescriptor(new GatewayMethodDescriptorSupplier("DeployWorkflow"))
                  .build();
          }
        }
     }
     return getDeployWorkflowMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.zeebe.gateway.protocol.GatewayOuterClass.FailJobRequest,
      io.zeebe.gateway.protocol.GatewayOuterClass.FailJobResponse> getFailJobMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "FailJob",
      requestType = io.zeebe.gateway.protocol.GatewayOuterClass.FailJobRequest.class,
      responseType = io.zeebe.gateway.protocol.GatewayOuterClass.FailJobResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.zeebe.gateway.protocol.GatewayOuterClass.FailJobRequest,
      io.zeebe.gateway.protocol.GatewayOuterClass.FailJobResponse> getFailJobMethod() {
    io.grpc.MethodDescriptor<io.zeebe.gateway.protocol.GatewayOuterClass.FailJobRequest, io.zeebe.gateway.protocol.GatewayOuterClass.FailJobResponse> getFailJobMethod;
    if ((getFailJobMethod = GatewayGrpc.getFailJobMethod) == null) {
      synchronized (GatewayGrpc.class) {
        if ((getFailJobMethod = GatewayGrpc.getFailJobMethod) == null) {
          GatewayGrpc.getFailJobMethod = getFailJobMethod = 
              io.grpc.MethodDescriptor.<io.zeebe.gateway.protocol.GatewayOuterClass.FailJobRequest, io.zeebe.gateway.protocol.GatewayOuterClass.FailJobResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(
                  "gateway_protocol.Gateway", "FailJob"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.zeebe.gateway.protocol.GatewayOuterClass.FailJobRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.zeebe.gateway.protocol.GatewayOuterClass.FailJobResponse.getDefaultInstance()))
                  .setSchemaDescriptor(new GatewayMethodDescriptorSupplier("FailJob"))
                  .build();
          }
        }
     }
     return getFailJobMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.zeebe.gateway.protocol.GatewayOuterClass.PublishMessageRequest,
      io.zeebe.gateway.protocol.GatewayOuterClass.PublishMessageResponse> getPublishMessageMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "PublishMessage",
      requestType = io.zeebe.gateway.protocol.GatewayOuterClass.PublishMessageRequest.class,
      responseType = io.zeebe.gateway.protocol.GatewayOuterClass.PublishMessageResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.zeebe.gateway.protocol.GatewayOuterClass.PublishMessageRequest,
      io.zeebe.gateway.protocol.GatewayOuterClass.PublishMessageResponse> getPublishMessageMethod() {
    io.grpc.MethodDescriptor<io.zeebe.gateway.protocol.GatewayOuterClass.PublishMessageRequest, io.zeebe.gateway.protocol.GatewayOuterClass.PublishMessageResponse> getPublishMessageMethod;
    if ((getPublishMessageMethod = GatewayGrpc.getPublishMessageMethod) == null) {
      synchronized (GatewayGrpc.class) {
        if ((getPublishMessageMethod = GatewayGrpc.getPublishMessageMethod) == null) {
          GatewayGrpc.getPublishMessageMethod = getPublishMessageMethod = 
              io.grpc.MethodDescriptor.<io.zeebe.gateway.protocol.GatewayOuterClass.PublishMessageRequest, io.zeebe.gateway.protocol.GatewayOuterClass.PublishMessageResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(
                  "gateway_protocol.Gateway", "PublishMessage"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.zeebe.gateway.protocol.GatewayOuterClass.PublishMessageRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.zeebe.gateway.protocol.GatewayOuterClass.PublishMessageResponse.getDefaultInstance()))
                  .setSchemaDescriptor(new GatewayMethodDescriptorSupplier("PublishMessage"))
                  .build();
          }
        }
     }
     return getPublishMessageMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.zeebe.gateway.protocol.GatewayOuterClass.ResolveIncidentRequest,
      io.zeebe.gateway.protocol.GatewayOuterClass.ResolveIncidentResponse> getResolveIncidentMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "ResolveIncident",
      requestType = io.zeebe.gateway.protocol.GatewayOuterClass.ResolveIncidentRequest.class,
      responseType = io.zeebe.gateway.protocol.GatewayOuterClass.ResolveIncidentResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.zeebe.gateway.protocol.GatewayOuterClass.ResolveIncidentRequest,
      io.zeebe.gateway.protocol.GatewayOuterClass.ResolveIncidentResponse> getResolveIncidentMethod() {
    io.grpc.MethodDescriptor<io.zeebe.gateway.protocol.GatewayOuterClass.ResolveIncidentRequest, io.zeebe.gateway.protocol.GatewayOuterClass.ResolveIncidentResponse> getResolveIncidentMethod;
    if ((getResolveIncidentMethod = GatewayGrpc.getResolveIncidentMethod) == null) {
      synchronized (GatewayGrpc.class) {
        if ((getResolveIncidentMethod = GatewayGrpc.getResolveIncidentMethod) == null) {
          GatewayGrpc.getResolveIncidentMethod = getResolveIncidentMethod = 
              io.grpc.MethodDescriptor.<io.zeebe.gateway.protocol.GatewayOuterClass.ResolveIncidentRequest, io.zeebe.gateway.protocol.GatewayOuterClass.ResolveIncidentResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(
                  "gateway_protocol.Gateway", "ResolveIncident"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.zeebe.gateway.protocol.GatewayOuterClass.ResolveIncidentRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.zeebe.gateway.protocol.GatewayOuterClass.ResolveIncidentResponse.getDefaultInstance()))
                  .setSchemaDescriptor(new GatewayMethodDescriptorSupplier("ResolveIncident"))
                  .build();
          }
        }
     }
     return getResolveIncidentMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.zeebe.gateway.protocol.GatewayOuterClass.SetVariablesRequest,
      io.zeebe.gateway.protocol.GatewayOuterClass.SetVariablesResponse> getSetVariablesMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "SetVariables",
      requestType = io.zeebe.gateway.protocol.GatewayOuterClass.SetVariablesRequest.class,
      responseType = io.zeebe.gateway.protocol.GatewayOuterClass.SetVariablesResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.zeebe.gateway.protocol.GatewayOuterClass.SetVariablesRequest,
      io.zeebe.gateway.protocol.GatewayOuterClass.SetVariablesResponse> getSetVariablesMethod() {
    io.grpc.MethodDescriptor<io.zeebe.gateway.protocol.GatewayOuterClass.SetVariablesRequest, io.zeebe.gateway.protocol.GatewayOuterClass.SetVariablesResponse> getSetVariablesMethod;
    if ((getSetVariablesMethod = GatewayGrpc.getSetVariablesMethod) == null) {
      synchronized (GatewayGrpc.class) {
        if ((getSetVariablesMethod = GatewayGrpc.getSetVariablesMethod) == null) {
          GatewayGrpc.getSetVariablesMethod = getSetVariablesMethod = 
              io.grpc.MethodDescriptor.<io.zeebe.gateway.protocol.GatewayOuterClass.SetVariablesRequest, io.zeebe.gateway.protocol.GatewayOuterClass.SetVariablesResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(
                  "gateway_protocol.Gateway", "SetVariables"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.zeebe.gateway.protocol.GatewayOuterClass.SetVariablesRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.zeebe.gateway.protocol.GatewayOuterClass.SetVariablesResponse.getDefaultInstance()))
                  .setSchemaDescriptor(new GatewayMethodDescriptorSupplier("SetVariables"))
                  .build();
          }
        }
     }
     return getSetVariablesMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.zeebe.gateway.protocol.GatewayOuterClass.TopologyRequest,
      io.zeebe.gateway.protocol.GatewayOuterClass.TopologyResponse> getTopologyMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "Topology",
      requestType = io.zeebe.gateway.protocol.GatewayOuterClass.TopologyRequest.class,
      responseType = io.zeebe.gateway.protocol.GatewayOuterClass.TopologyResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.zeebe.gateway.protocol.GatewayOuterClass.TopologyRequest,
      io.zeebe.gateway.protocol.GatewayOuterClass.TopologyResponse> getTopologyMethod() {
    io.grpc.MethodDescriptor<io.zeebe.gateway.protocol.GatewayOuterClass.TopologyRequest, io.zeebe.gateway.protocol.GatewayOuterClass.TopologyResponse> getTopologyMethod;
    if ((getTopologyMethod = GatewayGrpc.getTopologyMethod) == null) {
      synchronized (GatewayGrpc.class) {
        if ((getTopologyMethod = GatewayGrpc.getTopologyMethod) == null) {
          GatewayGrpc.getTopologyMethod = getTopologyMethod = 
              io.grpc.MethodDescriptor.<io.zeebe.gateway.protocol.GatewayOuterClass.TopologyRequest, io.zeebe.gateway.protocol.GatewayOuterClass.TopologyResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(
                  "gateway_protocol.Gateway", "Topology"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.zeebe.gateway.protocol.GatewayOuterClass.TopologyRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.zeebe.gateway.protocol.GatewayOuterClass.TopologyResponse.getDefaultInstance()))
                  .setSchemaDescriptor(new GatewayMethodDescriptorSupplier("Topology"))
                  .build();
          }
        }
     }
     return getTopologyMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.zeebe.gateway.protocol.GatewayOuterClass.UpdateJobRetriesRequest,
      io.zeebe.gateway.protocol.GatewayOuterClass.UpdateJobRetriesResponse> getUpdateJobRetriesMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "UpdateJobRetries",
      requestType = io.zeebe.gateway.protocol.GatewayOuterClass.UpdateJobRetriesRequest.class,
      responseType = io.zeebe.gateway.protocol.GatewayOuterClass.UpdateJobRetriesResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.zeebe.gateway.protocol.GatewayOuterClass.UpdateJobRetriesRequest,
      io.zeebe.gateway.protocol.GatewayOuterClass.UpdateJobRetriesResponse> getUpdateJobRetriesMethod() {
    io.grpc.MethodDescriptor<io.zeebe.gateway.protocol.GatewayOuterClass.UpdateJobRetriesRequest, io.zeebe.gateway.protocol.GatewayOuterClass.UpdateJobRetriesResponse> getUpdateJobRetriesMethod;
    if ((getUpdateJobRetriesMethod = GatewayGrpc.getUpdateJobRetriesMethod) == null) {
      synchronized (GatewayGrpc.class) {
        if ((getUpdateJobRetriesMethod = GatewayGrpc.getUpdateJobRetriesMethod) == null) {
          GatewayGrpc.getUpdateJobRetriesMethod = getUpdateJobRetriesMethod = 
              io.grpc.MethodDescriptor.<io.zeebe.gateway.protocol.GatewayOuterClass.UpdateJobRetriesRequest, io.zeebe.gateway.protocol.GatewayOuterClass.UpdateJobRetriesResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(
                  "gateway_protocol.Gateway", "UpdateJobRetries"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.zeebe.gateway.protocol.GatewayOuterClass.UpdateJobRetriesRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.zeebe.gateway.protocol.GatewayOuterClass.UpdateJobRetriesResponse.getDefaultInstance()))
                  .setSchemaDescriptor(new GatewayMethodDescriptorSupplier("UpdateJobRetries"))
                  .build();
          }
        }
     }
     return getUpdateJobRetriesMethod;
  }

  /**
   * Creates a new async stub that supports all call types for the service
   */
  public static GatewayStub newStub(io.grpc.Channel channel) {
    return new GatewayStub(channel);
  }

  /**
   * Creates a new blocking-style stub that supports unary and streaming output calls on the service
   */
  public static GatewayBlockingStub newBlockingStub(
      io.grpc.Channel channel) {
    return new GatewayBlockingStub(channel);
  }

  /**
   * Creates a new ListenableFuture-style stub that supports unary calls on the service
   */
  public static GatewayFutureStub newFutureStub(
      io.grpc.Channel channel) {
    return new GatewayFutureStub(channel);
  }

  /**
   */
  public static abstract class GatewayImplBase implements io.grpc.BindableService {

    /**
     * <pre>
     *Iterates through all known partitions round-robin and activates up to the requested
     *maximum and streams them back to the client as they are activated.
     *Errors:
     *INVALID_ARGUMENT:
     *- type is blank (empty string, null)
     *- worker is blank (empty string, null)
     *- timeout less than 1
     *- maxJobsToActivate is less than 1
     * </pre>
     */
    public void activateJobs(io.zeebe.gateway.protocol.GatewayOuterClass.ActivateJobsRequest request,
        io.grpc.stub.StreamObserver<io.zeebe.gateway.protocol.GatewayOuterClass.ActivateJobsResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getActivateJobsMethod(), responseObserver);
    }

    /**
     * <pre>
     *Cancels a running workflow instance
     *Errors:
     *NOT_FOUND:
     *- no workflow instance exists with the given key
     * </pre>
     */
    public void cancelWorkflowInstance(io.zeebe.gateway.protocol.GatewayOuterClass.CancelWorkflowInstanceRequest request,
        io.grpc.stub.StreamObserver<io.zeebe.gateway.protocol.GatewayOuterClass.CancelWorkflowInstanceResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getCancelWorkflowInstanceMethod(), responseObserver);
    }

    /**
     * <pre>
     *Completes a job with the given variables, which allows completing the associated service task.
     *Errors:
     *NOT_FOUND:
     *- no job exists with the given job key. Note that since jobs are removed once completed,
     *it could be that this job did exist at some point.
     *FAILED_PRECONDITION:
     *- the job was marked as failed. In that case, the related incident must be resolved before
     *the job can be activated again and completed.
     * </pre>
     */
    public void completeJob(io.zeebe.gateway.protocol.GatewayOuterClass.CompleteJobRequest request,
        io.grpc.stub.StreamObserver<io.zeebe.gateway.protocol.GatewayOuterClass.CompleteJobResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getCompleteJobMethod(), responseObserver);
    }

    /**
     * <pre>
     *Creates and starts an instance of the specified workflow. The workflow definition to use to
     *create the instance can be specified either using its unique key (as returned by
     *DeployWorkflow), or using the BPMN process ID and a version. Pass -1 as the version to use the
     *latest deployed version. Note that only workflows with none start events can be started through
     *this command.
     *Errors:
     *NOT_FOUND:
     *- no workflow with the given key exists (if workflowKey was given)
     *- no workflow with the given process ID exists (if bpmnProcessId was given but version was -1)
     *- no workflow with the given process ID and version exists (if both bpmnProcessId and version were given)
     *FAILED_PRECONDITION:
     *- the workflow definition does not contain a none start event; only workflows with none
     *start event can be started manually.
     *INVALID_ARGUMENT:
     *- the given variables argument is not a valid JSON document; it is expected to be a valid
     *JSON document where the root node is an object.
     * </pre>
     */
    public void createWorkflowInstance(io.zeebe.gateway.protocol.GatewayOuterClass.CreateWorkflowInstanceRequest request,
        io.grpc.stub.StreamObserver<io.zeebe.gateway.protocol.GatewayOuterClass.CreateWorkflowInstanceResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getCreateWorkflowInstanceMethod(), responseObserver);
    }

    /**
     * <pre>
     *Deploys one or more workflows to Zeebe. Note that this is an atomic call,
     *i.e. either all workflows are deployed, or none of them are.
     *Errors:
     *INVALID_ARGUMENT:
     *- no resources given.
     *- if at least one resource is invalid. A resource is considered invalid if:
     *- it is not a BPMN or YAML file (currently detected through the file extension)
     *- the resource data is not deserializable (e.g. detected as BPMN, but it's broken XML)
     *- the workflow is invalid (e.g. an event-based gateway has an outgoing sequence flow to a task)
     * </pre>
     */
    public void deployWorkflow(io.zeebe.gateway.protocol.GatewayOuterClass.DeployWorkflowRequest request,
        io.grpc.stub.StreamObserver<io.zeebe.gateway.protocol.GatewayOuterClass.DeployWorkflowResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getDeployWorkflowMethod(), responseObserver);
    }

    /**
     * <pre>
     *Marks the job as failed; if the retries argument is positive, then the job will be immediately
     *activatable again, and a worker could try again to process it. If it is zero or negative however,
     *an incident will be raised, tagged with the given errorMessage, and the job will not be
     *activatable until the incident is resolved.
     *Errors:
     *NOT_FOUND:
     *- no job was found with the given key
     *FAILED_PRECONDITION:
     *- the job was not activated
     *- the job is already in a failed state, i.e. ran out of retries
     * </pre>
     */
    public void failJob(io.zeebe.gateway.protocol.GatewayOuterClass.FailJobRequest request,
        io.grpc.stub.StreamObserver<io.zeebe.gateway.protocol.GatewayOuterClass.FailJobResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getFailJobMethod(), responseObserver);
    }

    /**
     * <pre>
     *Publishes a single message. Messages are published to specific partitions computed from their
     *correlation keys.
     *Errors:
     *ALREADY_EXISTS:
     *- a message with the same ID was previously published (and is still alive)
     * </pre>
     */
    public void publishMessage(io.zeebe.gateway.protocol.GatewayOuterClass.PublishMessageRequest request,
        io.grpc.stub.StreamObserver<io.zeebe.gateway.protocol.GatewayOuterClass.PublishMessageResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getPublishMessageMethod(), responseObserver);
    }

    /**
     * <pre>
     *Resolves a given incident. This simply marks the incident as resolved; most likely a call to
     *UpdateJobRetries or SetVariables will be necessary to actually resolve the
     *problem, following by this call.
     *Errors:
     *NOT_FOUND:
     *- no incident with the given key exists
     * </pre>
     */
    public void resolveIncident(io.zeebe.gateway.protocol.GatewayOuterClass.ResolveIncidentRequest request,
        io.grpc.stub.StreamObserver<io.zeebe.gateway.protocol.GatewayOuterClass.ResolveIncidentResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getResolveIncidentMethod(), responseObserver);
    }

    /**
     * <pre>
     *Updates all the variables of a particular scope (e.g. workflow instance, flow element instance)
     *from the given JSON document.
     *Errors:
     *NOT_FOUND:
     *- no element with the given elementInstanceKey exists
     *INVALID_ARGUMENT:
     *- the given variables document is not a valid JSON document; valid documents are expected to
     *be JSON documents where the root node is an object.
     * </pre>
     */
    public void setVariables(io.zeebe.gateway.protocol.GatewayOuterClass.SetVariablesRequest request,
        io.grpc.stub.StreamObserver<io.zeebe.gateway.protocol.GatewayOuterClass.SetVariablesResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getSetVariablesMethod(), responseObserver);
    }

    /**
     * <pre>
     *Obtains the current topology of the cluster the gateway is part of.
     * </pre>
     */
    public void topology(io.zeebe.gateway.protocol.GatewayOuterClass.TopologyRequest request,
        io.grpc.stub.StreamObserver<io.zeebe.gateway.protocol.GatewayOuterClass.TopologyResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getTopologyMethod(), responseObserver);
    }

    /**
     * <pre>
     *Updates the number of retries a job has left. This is mostly useful for jobs that have run out of
     *retries, should the underlying problem be solved.
     *Errors:
     *NOT_FOUND:
     *- no job exists with the given key
     *INVALID_ARGUMENT:
     *- retries is not greater than 0
     * </pre>
     */
    public void updateJobRetries(io.zeebe.gateway.protocol.GatewayOuterClass.UpdateJobRetriesRequest request,
        io.grpc.stub.StreamObserver<io.zeebe.gateway.protocol.GatewayOuterClass.UpdateJobRetriesResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getUpdateJobRetriesMethod(), responseObserver);
    }

    @java.lang.Override public final io.grpc.ServerServiceDefinition bindService() {
      return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
          .addMethod(
            getActivateJobsMethod(),
            asyncServerStreamingCall(
              new MethodHandlers<
                io.zeebe.gateway.protocol.GatewayOuterClass.ActivateJobsRequest,
                io.zeebe.gateway.protocol.GatewayOuterClass.ActivateJobsResponse>(
                  this, METHODID_ACTIVATE_JOBS)))
          .addMethod(
            getCancelWorkflowInstanceMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.zeebe.gateway.protocol.GatewayOuterClass.CancelWorkflowInstanceRequest,
                io.zeebe.gateway.protocol.GatewayOuterClass.CancelWorkflowInstanceResponse>(
                  this, METHODID_CANCEL_WORKFLOW_INSTANCE)))
          .addMethod(
            getCompleteJobMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.zeebe.gateway.protocol.GatewayOuterClass.CompleteJobRequest,
                io.zeebe.gateway.protocol.GatewayOuterClass.CompleteJobResponse>(
                  this, METHODID_COMPLETE_JOB)))
          .addMethod(
            getCreateWorkflowInstanceMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.zeebe.gateway.protocol.GatewayOuterClass.CreateWorkflowInstanceRequest,
                io.zeebe.gateway.protocol.GatewayOuterClass.CreateWorkflowInstanceResponse>(
                  this, METHODID_CREATE_WORKFLOW_INSTANCE)))
          .addMethod(
            getDeployWorkflowMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.zeebe.gateway.protocol.GatewayOuterClass.DeployWorkflowRequest,
                io.zeebe.gateway.protocol.GatewayOuterClass.DeployWorkflowResponse>(
                  this, METHODID_DEPLOY_WORKFLOW)))
          .addMethod(
            getFailJobMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.zeebe.gateway.protocol.GatewayOuterClass.FailJobRequest,
                io.zeebe.gateway.protocol.GatewayOuterClass.FailJobResponse>(
                  this, METHODID_FAIL_JOB)))
          .addMethod(
            getPublishMessageMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.zeebe.gateway.protocol.GatewayOuterClass.PublishMessageRequest,
                io.zeebe.gateway.protocol.GatewayOuterClass.PublishMessageResponse>(
                  this, METHODID_PUBLISH_MESSAGE)))
          .addMethod(
            getResolveIncidentMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.zeebe.gateway.protocol.GatewayOuterClass.ResolveIncidentRequest,
                io.zeebe.gateway.protocol.GatewayOuterClass.ResolveIncidentResponse>(
                  this, METHODID_RESOLVE_INCIDENT)))
          .addMethod(
            getSetVariablesMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.zeebe.gateway.protocol.GatewayOuterClass.SetVariablesRequest,
                io.zeebe.gateway.protocol.GatewayOuterClass.SetVariablesResponse>(
                  this, METHODID_SET_VARIABLES)))
          .addMethod(
            getTopologyMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.zeebe.gateway.protocol.GatewayOuterClass.TopologyRequest,
                io.zeebe.gateway.protocol.GatewayOuterClass.TopologyResponse>(
                  this, METHODID_TOPOLOGY)))
          .addMethod(
            getUpdateJobRetriesMethod(),
            asyncUnaryCall(
              new MethodHandlers<
                io.zeebe.gateway.protocol.GatewayOuterClass.UpdateJobRetriesRequest,
                io.zeebe.gateway.protocol.GatewayOuterClass.UpdateJobRetriesResponse>(
                  this, METHODID_UPDATE_JOB_RETRIES)))
          .build();
    }
  }

  /**
   */
  public static final class GatewayStub extends io.grpc.stub.AbstractStub<GatewayStub> {
    private GatewayStub(io.grpc.Channel channel) {
      super(channel);
    }

    private GatewayStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected GatewayStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new GatewayStub(channel, callOptions);
    }

    /**
     * <pre>
     *Iterates through all known partitions round-robin and activates up to the requested
     *maximum and streams them back to the client as they are activated.
     *Errors:
     *INVALID_ARGUMENT:
     *- type is blank (empty string, null)
     *- worker is blank (empty string, null)
     *- timeout less than 1
     *- maxJobsToActivate is less than 1
     * </pre>
     */
    public void activateJobs(io.zeebe.gateway.protocol.GatewayOuterClass.ActivateJobsRequest request,
        io.grpc.stub.StreamObserver<io.zeebe.gateway.protocol.GatewayOuterClass.ActivateJobsResponse> responseObserver) {
      asyncServerStreamingCall(
          getChannel().newCall(getActivateJobsMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     *Cancels a running workflow instance
     *Errors:
     *NOT_FOUND:
     *- no workflow instance exists with the given key
     * </pre>
     */
    public void cancelWorkflowInstance(io.zeebe.gateway.protocol.GatewayOuterClass.CancelWorkflowInstanceRequest request,
        io.grpc.stub.StreamObserver<io.zeebe.gateway.protocol.GatewayOuterClass.CancelWorkflowInstanceResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getCancelWorkflowInstanceMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     *Completes a job with the given variables, which allows completing the associated service task.
     *Errors:
     *NOT_FOUND:
     *- no job exists with the given job key. Note that since jobs are removed once completed,
     *it could be that this job did exist at some point.
     *FAILED_PRECONDITION:
     *- the job was marked as failed. In that case, the related incident must be resolved before
     *the job can be activated again and completed.
     * </pre>
     */
    public void completeJob(io.zeebe.gateway.protocol.GatewayOuterClass.CompleteJobRequest request,
        io.grpc.stub.StreamObserver<io.zeebe.gateway.protocol.GatewayOuterClass.CompleteJobResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getCompleteJobMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     *Creates and starts an instance of the specified workflow. The workflow definition to use to
     *create the instance can be specified either using its unique key (as returned by
     *DeployWorkflow), or using the BPMN process ID and a version. Pass -1 as the version to use the
     *latest deployed version. Note that only workflows with none start events can be started through
     *this command.
     *Errors:
     *NOT_FOUND:
     *- no workflow with the given key exists (if workflowKey was given)
     *- no workflow with the given process ID exists (if bpmnProcessId was given but version was -1)
     *- no workflow with the given process ID and version exists (if both bpmnProcessId and version were given)
     *FAILED_PRECONDITION:
     *- the workflow definition does not contain a none start event; only workflows with none
     *start event can be started manually.
     *INVALID_ARGUMENT:
     *- the given variables argument is not a valid JSON document; it is expected to be a valid
     *JSON document where the root node is an object.
     * </pre>
     */
    public void createWorkflowInstance(io.zeebe.gateway.protocol.GatewayOuterClass.CreateWorkflowInstanceRequest request,
        io.grpc.stub.StreamObserver<io.zeebe.gateway.protocol.GatewayOuterClass.CreateWorkflowInstanceResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getCreateWorkflowInstanceMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     *Deploys one or more workflows to Zeebe. Note that this is an atomic call,
     *i.e. either all workflows are deployed, or none of them are.
     *Errors:
     *INVALID_ARGUMENT:
     *- no resources given.
     *- if at least one resource is invalid. A resource is considered invalid if:
     *- it is not a BPMN or YAML file (currently detected through the file extension)
     *- the resource data is not deserializable (e.g. detected as BPMN, but it's broken XML)
     *- the workflow is invalid (e.g. an event-based gateway has an outgoing sequence flow to a task)
     * </pre>
     */
    public void deployWorkflow(io.zeebe.gateway.protocol.GatewayOuterClass.DeployWorkflowRequest request,
        io.grpc.stub.StreamObserver<io.zeebe.gateway.protocol.GatewayOuterClass.DeployWorkflowResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getDeployWorkflowMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     *Marks the job as failed; if the retries argument is positive, then the job will be immediately
     *activatable again, and a worker could try again to process it. If it is zero or negative however,
     *an incident will be raised, tagged with the given errorMessage, and the job will not be
     *activatable until the incident is resolved.
     *Errors:
     *NOT_FOUND:
     *- no job was found with the given key
     *FAILED_PRECONDITION:
     *- the job was not activated
     *- the job is already in a failed state, i.e. ran out of retries
     * </pre>
     */
    public void failJob(io.zeebe.gateway.protocol.GatewayOuterClass.FailJobRequest request,
        io.grpc.stub.StreamObserver<io.zeebe.gateway.protocol.GatewayOuterClass.FailJobResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getFailJobMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     *Publishes a single message. Messages are published to specific partitions computed from their
     *correlation keys.
     *Errors:
     *ALREADY_EXISTS:
     *- a message with the same ID was previously published (and is still alive)
     * </pre>
     */
    public void publishMessage(io.zeebe.gateway.protocol.GatewayOuterClass.PublishMessageRequest request,
        io.grpc.stub.StreamObserver<io.zeebe.gateway.protocol.GatewayOuterClass.PublishMessageResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getPublishMessageMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     *Resolves a given incident. This simply marks the incident as resolved; most likely a call to
     *UpdateJobRetries or SetVariables will be necessary to actually resolve the
     *problem, following by this call.
     *Errors:
     *NOT_FOUND:
     *- no incident with the given key exists
     * </pre>
     */
    public void resolveIncident(io.zeebe.gateway.protocol.GatewayOuterClass.ResolveIncidentRequest request,
        io.grpc.stub.StreamObserver<io.zeebe.gateway.protocol.GatewayOuterClass.ResolveIncidentResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getResolveIncidentMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     *Updates all the variables of a particular scope (e.g. workflow instance, flow element instance)
     *from the given JSON document.
     *Errors:
     *NOT_FOUND:
     *- no element with the given elementInstanceKey exists
     *INVALID_ARGUMENT:
     *- the given variables document is not a valid JSON document; valid documents are expected to
     *be JSON documents where the root node is an object.
     * </pre>
     */
    public void setVariables(io.zeebe.gateway.protocol.GatewayOuterClass.SetVariablesRequest request,
        io.grpc.stub.StreamObserver<io.zeebe.gateway.protocol.GatewayOuterClass.SetVariablesResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getSetVariablesMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     *Obtains the current topology of the cluster the gateway is part of.
     * </pre>
     */
    public void topology(io.zeebe.gateway.protocol.GatewayOuterClass.TopologyRequest request,
        io.grpc.stub.StreamObserver<io.zeebe.gateway.protocol.GatewayOuterClass.TopologyResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getTopologyMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     *Updates the number of retries a job has left. This is mostly useful for jobs that have run out of
     *retries, should the underlying problem be solved.
     *Errors:
     *NOT_FOUND:
     *- no job exists with the given key
     *INVALID_ARGUMENT:
     *- retries is not greater than 0
     * </pre>
     */
    public void updateJobRetries(io.zeebe.gateway.protocol.GatewayOuterClass.UpdateJobRetriesRequest request,
        io.grpc.stub.StreamObserver<io.zeebe.gateway.protocol.GatewayOuterClass.UpdateJobRetriesResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getUpdateJobRetriesMethod(), getCallOptions()), request, responseObserver);
    }
  }

  /**
   */
  public static final class GatewayBlockingStub extends io.grpc.stub.AbstractStub<GatewayBlockingStub> {
    private GatewayBlockingStub(io.grpc.Channel channel) {
      super(channel);
    }

    private GatewayBlockingStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected GatewayBlockingStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new GatewayBlockingStub(channel, callOptions);
    }

    /**
     * <pre>
     *Iterates through all known partitions round-robin and activates up to the requested
     *maximum and streams them back to the client as they are activated.
     *Errors:
     *INVALID_ARGUMENT:
     *- type is blank (empty string, null)
     *- worker is blank (empty string, null)
     *- timeout less than 1
     *- maxJobsToActivate is less than 1
     * </pre>
     */
    public java.util.Iterator<io.zeebe.gateway.protocol.GatewayOuterClass.ActivateJobsResponse> activateJobs(
        io.zeebe.gateway.protocol.GatewayOuterClass.ActivateJobsRequest request) {
      return blockingServerStreamingCall(
          getChannel(), getActivateJobsMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     *Cancels a running workflow instance
     *Errors:
     *NOT_FOUND:
     *- no workflow instance exists with the given key
     * </pre>
     */
    public io.zeebe.gateway.protocol.GatewayOuterClass.CancelWorkflowInstanceResponse cancelWorkflowInstance(io.zeebe.gateway.protocol.GatewayOuterClass.CancelWorkflowInstanceRequest request) {
      return blockingUnaryCall(
          getChannel(), getCancelWorkflowInstanceMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     *Completes a job with the given variables, which allows completing the associated service task.
     *Errors:
     *NOT_FOUND:
     *- no job exists with the given job key. Note that since jobs are removed once completed,
     *it could be that this job did exist at some point.
     *FAILED_PRECONDITION:
     *- the job was marked as failed. In that case, the related incident must be resolved before
     *the job can be activated again and completed.
     * </pre>
     */
    public io.zeebe.gateway.protocol.GatewayOuterClass.CompleteJobResponse completeJob(io.zeebe.gateway.protocol.GatewayOuterClass.CompleteJobRequest request) {
      return blockingUnaryCall(
          getChannel(), getCompleteJobMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     *Creates and starts an instance of the specified workflow. The workflow definition to use to
     *create the instance can be specified either using its unique key (as returned by
     *DeployWorkflow), or using the BPMN process ID and a version. Pass -1 as the version to use the
     *latest deployed version. Note that only workflows with none start events can be started through
     *this command.
     *Errors:
     *NOT_FOUND:
     *- no workflow with the given key exists (if workflowKey was given)
     *- no workflow with the given process ID exists (if bpmnProcessId was given but version was -1)
     *- no workflow with the given process ID and version exists (if both bpmnProcessId and version were given)
     *FAILED_PRECONDITION:
     *- the workflow definition does not contain a none start event; only workflows with none
     *start event can be started manually.
     *INVALID_ARGUMENT:
     *- the given variables argument is not a valid JSON document; it is expected to be a valid
     *JSON document where the root node is an object.
     * </pre>
     */
    public io.zeebe.gateway.protocol.GatewayOuterClass.CreateWorkflowInstanceResponse createWorkflowInstance(io.zeebe.gateway.protocol.GatewayOuterClass.CreateWorkflowInstanceRequest request) {
      return blockingUnaryCall(
          getChannel(), getCreateWorkflowInstanceMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     *Deploys one or more workflows to Zeebe. Note that this is an atomic call,
     *i.e. either all workflows are deployed, or none of them are.
     *Errors:
     *INVALID_ARGUMENT:
     *- no resources given.
     *- if at least one resource is invalid. A resource is considered invalid if:
     *- it is not a BPMN or YAML file (currently detected through the file extension)
     *- the resource data is not deserializable (e.g. detected as BPMN, but it's broken XML)
     *- the workflow is invalid (e.g. an event-based gateway has an outgoing sequence flow to a task)
     * </pre>
     */
    public io.zeebe.gateway.protocol.GatewayOuterClass.DeployWorkflowResponse deployWorkflow(io.zeebe.gateway.protocol.GatewayOuterClass.DeployWorkflowRequest request) {
      return blockingUnaryCall(
          getChannel(), getDeployWorkflowMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     *Marks the job as failed; if the retries argument is positive, then the job will be immediately
     *activatable again, and a worker could try again to process it. If it is zero or negative however,
     *an incident will be raised, tagged with the given errorMessage, and the job will not be
     *activatable until the incident is resolved.
     *Errors:
     *NOT_FOUND:
     *- no job was found with the given key
     *FAILED_PRECONDITION:
     *- the job was not activated
     *- the job is already in a failed state, i.e. ran out of retries
     * </pre>
     */
    public io.zeebe.gateway.protocol.GatewayOuterClass.FailJobResponse failJob(io.zeebe.gateway.protocol.GatewayOuterClass.FailJobRequest request) {
      return blockingUnaryCall(
          getChannel(), getFailJobMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     *Publishes a single message. Messages are published to specific partitions computed from their
     *correlation keys.
     *Errors:
     *ALREADY_EXISTS:
     *- a message with the same ID was previously published (and is still alive)
     * </pre>
     */
    public io.zeebe.gateway.protocol.GatewayOuterClass.PublishMessageResponse publishMessage(io.zeebe.gateway.protocol.GatewayOuterClass.PublishMessageRequest request) {
      return blockingUnaryCall(
          getChannel(), getPublishMessageMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     *Resolves a given incident. This simply marks the incident as resolved; most likely a call to
     *UpdateJobRetries or SetVariables will be necessary to actually resolve the
     *problem, following by this call.
     *Errors:
     *NOT_FOUND:
     *- no incident with the given key exists
     * </pre>
     */
    public io.zeebe.gateway.protocol.GatewayOuterClass.ResolveIncidentResponse resolveIncident(io.zeebe.gateway.protocol.GatewayOuterClass.ResolveIncidentRequest request) {
      return blockingUnaryCall(
          getChannel(), getResolveIncidentMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     *Updates all the variables of a particular scope (e.g. workflow instance, flow element instance)
     *from the given JSON document.
     *Errors:
     *NOT_FOUND:
     *- no element with the given elementInstanceKey exists
     *INVALID_ARGUMENT:
     *- the given variables document is not a valid JSON document; valid documents are expected to
     *be JSON documents where the root node is an object.
     * </pre>
     */
    public io.zeebe.gateway.protocol.GatewayOuterClass.SetVariablesResponse setVariables(io.zeebe.gateway.protocol.GatewayOuterClass.SetVariablesRequest request) {
      return blockingUnaryCall(
          getChannel(), getSetVariablesMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     *Obtains the current topology of the cluster the gateway is part of.
     * </pre>
     */
    public io.zeebe.gateway.protocol.GatewayOuterClass.TopologyResponse topology(io.zeebe.gateway.protocol.GatewayOuterClass.TopologyRequest request) {
      return blockingUnaryCall(
          getChannel(), getTopologyMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     *Updates the number of retries a job has left. This is mostly useful for jobs that have run out of
     *retries, should the underlying problem be solved.
     *Errors:
     *NOT_FOUND:
     *- no job exists with the given key
     *INVALID_ARGUMENT:
     *- retries is not greater than 0
     * </pre>
     */
    public io.zeebe.gateway.protocol.GatewayOuterClass.UpdateJobRetriesResponse updateJobRetries(io.zeebe.gateway.protocol.GatewayOuterClass.UpdateJobRetriesRequest request) {
      return blockingUnaryCall(
          getChannel(), getUpdateJobRetriesMethod(), getCallOptions(), request);
    }
  }

  /**
   */
  public static final class GatewayFutureStub extends io.grpc.stub.AbstractStub<GatewayFutureStub> {
    private GatewayFutureStub(io.grpc.Channel channel) {
      super(channel);
    }

    private GatewayFutureStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected GatewayFutureStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new GatewayFutureStub(channel, callOptions);
    }

    /**
     * <pre>
     *Cancels a running workflow instance
     *Errors:
     *NOT_FOUND:
     *- no workflow instance exists with the given key
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.zeebe.gateway.protocol.GatewayOuterClass.CancelWorkflowInstanceResponse> cancelWorkflowInstance(
        io.zeebe.gateway.protocol.GatewayOuterClass.CancelWorkflowInstanceRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getCancelWorkflowInstanceMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     *Completes a job with the given variables, which allows completing the associated service task.
     *Errors:
     *NOT_FOUND:
     *- no job exists with the given job key. Note that since jobs are removed once completed,
     *it could be that this job did exist at some point.
     *FAILED_PRECONDITION:
     *- the job was marked as failed. In that case, the related incident must be resolved before
     *the job can be activated again and completed.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.zeebe.gateway.protocol.GatewayOuterClass.CompleteJobResponse> completeJob(
        io.zeebe.gateway.protocol.GatewayOuterClass.CompleteJobRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getCompleteJobMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     *Creates and starts an instance of the specified workflow. The workflow definition to use to
     *create the instance can be specified either using its unique key (as returned by
     *DeployWorkflow), or using the BPMN process ID and a version. Pass -1 as the version to use the
     *latest deployed version. Note that only workflows with none start events can be started through
     *this command.
     *Errors:
     *NOT_FOUND:
     *- no workflow with the given key exists (if workflowKey was given)
     *- no workflow with the given process ID exists (if bpmnProcessId was given but version was -1)
     *- no workflow with the given process ID and version exists (if both bpmnProcessId and version were given)
     *FAILED_PRECONDITION:
     *- the workflow definition does not contain a none start event; only workflows with none
     *start event can be started manually.
     *INVALID_ARGUMENT:
     *- the given variables argument is not a valid JSON document; it is expected to be a valid
     *JSON document where the root node is an object.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.zeebe.gateway.protocol.GatewayOuterClass.CreateWorkflowInstanceResponse> createWorkflowInstance(
        io.zeebe.gateway.protocol.GatewayOuterClass.CreateWorkflowInstanceRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getCreateWorkflowInstanceMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     *Deploys one or more workflows to Zeebe. Note that this is an atomic call,
     *i.e. either all workflows are deployed, or none of them are.
     *Errors:
     *INVALID_ARGUMENT:
     *- no resources given.
     *- if at least one resource is invalid. A resource is considered invalid if:
     *- it is not a BPMN or YAML file (currently detected through the file extension)
     *- the resource data is not deserializable (e.g. detected as BPMN, but it's broken XML)
     *- the workflow is invalid (e.g. an event-based gateway has an outgoing sequence flow to a task)
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.zeebe.gateway.protocol.GatewayOuterClass.DeployWorkflowResponse> deployWorkflow(
        io.zeebe.gateway.protocol.GatewayOuterClass.DeployWorkflowRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getDeployWorkflowMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     *Marks the job as failed; if the retries argument is positive, then the job will be immediately
     *activatable again, and a worker could try again to process it. If it is zero or negative however,
     *an incident will be raised, tagged with the given errorMessage, and the job will not be
     *activatable until the incident is resolved.
     *Errors:
     *NOT_FOUND:
     *- no job was found with the given key
     *FAILED_PRECONDITION:
     *- the job was not activated
     *- the job is already in a failed state, i.e. ran out of retries
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.zeebe.gateway.protocol.GatewayOuterClass.FailJobResponse> failJob(
        io.zeebe.gateway.protocol.GatewayOuterClass.FailJobRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getFailJobMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     *Publishes a single message. Messages are published to specific partitions computed from their
     *correlation keys.
     *Errors:
     *ALREADY_EXISTS:
     *- a message with the same ID was previously published (and is still alive)
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.zeebe.gateway.protocol.GatewayOuterClass.PublishMessageResponse> publishMessage(
        io.zeebe.gateway.protocol.GatewayOuterClass.PublishMessageRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getPublishMessageMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     *Resolves a given incident. This simply marks the incident as resolved; most likely a call to
     *UpdateJobRetries or SetVariables will be necessary to actually resolve the
     *problem, following by this call.
     *Errors:
     *NOT_FOUND:
     *- no incident with the given key exists
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.zeebe.gateway.protocol.GatewayOuterClass.ResolveIncidentResponse> resolveIncident(
        io.zeebe.gateway.protocol.GatewayOuterClass.ResolveIncidentRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getResolveIncidentMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     *Updates all the variables of a particular scope (e.g. workflow instance, flow element instance)
     *from the given JSON document.
     *Errors:
     *NOT_FOUND:
     *- no element with the given elementInstanceKey exists
     *INVALID_ARGUMENT:
     *- the given variables document is not a valid JSON document; valid documents are expected to
     *be JSON documents where the root node is an object.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.zeebe.gateway.protocol.GatewayOuterClass.SetVariablesResponse> setVariables(
        io.zeebe.gateway.protocol.GatewayOuterClass.SetVariablesRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getSetVariablesMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     *Obtains the current topology of the cluster the gateway is part of.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.zeebe.gateway.protocol.GatewayOuterClass.TopologyResponse> topology(
        io.zeebe.gateway.protocol.GatewayOuterClass.TopologyRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getTopologyMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     *Updates the number of retries a job has left. This is mostly useful for jobs that have run out of
     *retries, should the underlying problem be solved.
     *Errors:
     *NOT_FOUND:
     *- no job exists with the given key
     *INVALID_ARGUMENT:
     *- retries is not greater than 0
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.zeebe.gateway.protocol.GatewayOuterClass.UpdateJobRetriesResponse> updateJobRetries(
        io.zeebe.gateway.protocol.GatewayOuterClass.UpdateJobRetriesRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getUpdateJobRetriesMethod(), getCallOptions()), request);
    }
  }

  private static final int METHODID_ACTIVATE_JOBS = 0;
  private static final int METHODID_CANCEL_WORKFLOW_INSTANCE = 1;
  private static final int METHODID_COMPLETE_JOB = 2;
  private static final int METHODID_CREATE_WORKFLOW_INSTANCE = 3;
  private static final int METHODID_DEPLOY_WORKFLOW = 4;
  private static final int METHODID_FAIL_JOB = 5;
  private static final int METHODID_PUBLISH_MESSAGE = 6;
  private static final int METHODID_RESOLVE_INCIDENT = 7;
  private static final int METHODID_SET_VARIABLES = 8;
  private static final int METHODID_TOPOLOGY = 9;
  private static final int METHODID_UPDATE_JOB_RETRIES = 10;

  private static final class MethodHandlers<Req, Resp> implements
      io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {
    private final GatewayImplBase serviceImpl;
    private final int methodId;

    MethodHandlers(GatewayImplBase serviceImpl, int methodId) {
      this.serviceImpl = serviceImpl;
      this.methodId = methodId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_ACTIVATE_JOBS:
          serviceImpl.activateJobs((io.zeebe.gateway.protocol.GatewayOuterClass.ActivateJobsRequest) request,
              (io.grpc.stub.StreamObserver<io.zeebe.gateway.protocol.GatewayOuterClass.ActivateJobsResponse>) responseObserver);
          break;
        case METHODID_CANCEL_WORKFLOW_INSTANCE:
          serviceImpl.cancelWorkflowInstance((io.zeebe.gateway.protocol.GatewayOuterClass.CancelWorkflowInstanceRequest) request,
              (io.grpc.stub.StreamObserver<io.zeebe.gateway.protocol.GatewayOuterClass.CancelWorkflowInstanceResponse>) responseObserver);
          break;
        case METHODID_COMPLETE_JOB:
          serviceImpl.completeJob((io.zeebe.gateway.protocol.GatewayOuterClass.CompleteJobRequest) request,
              (io.grpc.stub.StreamObserver<io.zeebe.gateway.protocol.GatewayOuterClass.CompleteJobResponse>) responseObserver);
          break;
        case METHODID_CREATE_WORKFLOW_INSTANCE:
          serviceImpl.createWorkflowInstance((io.zeebe.gateway.protocol.GatewayOuterClass.CreateWorkflowInstanceRequest) request,
              (io.grpc.stub.StreamObserver<io.zeebe.gateway.protocol.GatewayOuterClass.CreateWorkflowInstanceResponse>) responseObserver);
          break;
        case METHODID_DEPLOY_WORKFLOW:
          serviceImpl.deployWorkflow((io.zeebe.gateway.protocol.GatewayOuterClass.DeployWorkflowRequest) request,
              (io.grpc.stub.StreamObserver<io.zeebe.gateway.protocol.GatewayOuterClass.DeployWorkflowResponse>) responseObserver);
          break;
        case METHODID_FAIL_JOB:
          serviceImpl.failJob((io.zeebe.gateway.protocol.GatewayOuterClass.FailJobRequest) request,
              (io.grpc.stub.StreamObserver<io.zeebe.gateway.protocol.GatewayOuterClass.FailJobResponse>) responseObserver);
          break;
        case METHODID_PUBLISH_MESSAGE:
          serviceImpl.publishMessage((io.zeebe.gateway.protocol.GatewayOuterClass.PublishMessageRequest) request,
              (io.grpc.stub.StreamObserver<io.zeebe.gateway.protocol.GatewayOuterClass.PublishMessageResponse>) responseObserver);
          break;
        case METHODID_RESOLVE_INCIDENT:
          serviceImpl.resolveIncident((io.zeebe.gateway.protocol.GatewayOuterClass.ResolveIncidentRequest) request,
              (io.grpc.stub.StreamObserver<io.zeebe.gateway.protocol.GatewayOuterClass.ResolveIncidentResponse>) responseObserver);
          break;
        case METHODID_SET_VARIABLES:
          serviceImpl.setVariables((io.zeebe.gateway.protocol.GatewayOuterClass.SetVariablesRequest) request,
              (io.grpc.stub.StreamObserver<io.zeebe.gateway.protocol.GatewayOuterClass.SetVariablesResponse>) responseObserver);
          break;
        case METHODID_TOPOLOGY:
          serviceImpl.topology((io.zeebe.gateway.protocol.GatewayOuterClass.TopologyRequest) request,
              (io.grpc.stub.StreamObserver<io.zeebe.gateway.protocol.GatewayOuterClass.TopologyResponse>) responseObserver);
          break;
        case METHODID_UPDATE_JOB_RETRIES:
          serviceImpl.updateJobRetries((io.zeebe.gateway.protocol.GatewayOuterClass.UpdateJobRetriesRequest) request,
              (io.grpc.stub.StreamObserver<io.zeebe.gateway.protocol.GatewayOuterClass.UpdateJobRetriesResponse>) responseObserver);
          break;
        default:
          throw new AssertionError();
      }
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public io.grpc.stub.StreamObserver<Req> invoke(
        io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        default:
          throw new AssertionError();
      }
    }
  }

  private static abstract class GatewayBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoFileDescriptorSupplier, io.grpc.protobuf.ProtoServiceDescriptorSupplier {
    GatewayBaseDescriptorSupplier() {}

    @java.lang.Override
    public com.google.protobuf.Descriptors.FileDescriptor getFileDescriptor() {
      return io.zeebe.gateway.protocol.GatewayOuterClass.getDescriptor();
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.ServiceDescriptor getServiceDescriptor() {
      return getFileDescriptor().findServiceByName("Gateway");
    }
  }

  private static final class GatewayFileDescriptorSupplier
      extends GatewayBaseDescriptorSupplier {
    GatewayFileDescriptorSupplier() {}
  }

  private static final class GatewayMethodDescriptorSupplier
      extends GatewayBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoMethodDescriptorSupplier {
    private final String methodName;

    GatewayMethodDescriptorSupplier(String methodName) {
      this.methodName = methodName;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.MethodDescriptor getMethodDescriptor() {
      return getServiceDescriptor().findMethodByName(methodName);
    }
  }

  private static volatile io.grpc.ServiceDescriptor serviceDescriptor;

  public static io.grpc.ServiceDescriptor getServiceDescriptor() {
    io.grpc.ServiceDescriptor result = serviceDescriptor;
    if (result == null) {
      synchronized (GatewayGrpc.class) {
        result = serviceDescriptor;
        if (result == null) {
          serviceDescriptor = result = io.grpc.ServiceDescriptor.newBuilder(SERVICE_NAME)
              .setSchemaDescriptor(new GatewayFileDescriptorSupplier())
              .addMethod(getActivateJobsMethod())
              .addMethod(getCancelWorkflowInstanceMethod())
              .addMethod(getCompleteJobMethod())
              .addMethod(getCreateWorkflowInstanceMethod())
              .addMethod(getDeployWorkflowMethod())
              .addMethod(getFailJobMethod())
              .addMethod(getPublishMessageMethod())
              .addMethod(getResolveIncidentMethod())
              .addMethod(getSetVariablesMethod())
              .addMethod(getTopologyMethod())
              .addMethod(getUpdateJobRetriesMethod())
              .build();
        }
      }
    }
    return result;
  }
}
